/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.E;
import com.supermap.data.GeoPoint3DNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.Point3D;
import com.supermap.data.Toolkit;
import com.supermap.imb.jsonlib.SiJsonObject;

public class GeoPoint3D
extends Geometry3D {
    public GeoPoint3D() {
        long l2 = GeoPoint3DNative.jni_New();
        this.setHandle(l2, true);
        this.a();
    }

    public GeoPoint3D(double d2, double d3, double d4) {
        long l2 = GeoPoint3DNative.jni_New();
        this.setHandle(l2, true);
        this.setX(d2);
        this.setY(d3);
        this.setZ(d4);
    }

    public GeoPoint3D(GeoPoint3D geoPoint3D) {
        if (geoPoint3D.getHandle() == 0L) {
            String string = E.a("geoPoint3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoPoint3DNative.jni_Clone(geoPoint3D.getHandle());
        this.setHandle(l2, true);
    }

    public GeoPoint3D(Point3D point3D) {
        this();
        this.setX(point3D.getX());
        this.setY(point3D.getY());
        this.setZ(point3D.getZ());
    }

    GeoPoint3D(long l2) {
        this.setHandle(l2, false);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoPoint3DNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            super.clearHandle();
        }
    }

    public double getX() {
        if (this.getHandle() == 0L) {
            String string = E.a("getX", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPoint3DNative.jni_GetX(this.getHandle());
    }

    public void setX(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setX(value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoPoint3DNative.jni_SetX(this.getHandle(), d2);
    }

    public double getY() {
        if (this.getHandle() == 0L) {
            String string = E.a("getY()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPoint3DNative.jni_GetY(this.getHandle());
    }

    public void setY(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setY(value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoPoint3DNative.jni_SetY(this.getHandle(), d2);
    }

    public double getZ() {
        if (this.getHandle() == 0L) {
            String string = E.a("getZ()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoPoint3DNative.jni_GetZ(this.getHandle());
    }

    public void setZ(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setZ(value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoPoint3DNative.jni_SetZ(this.getHandle(), d2);
    }

    private void a() {
        this.setX(-1.7976931348623157E308);
        this.setY(-1.7976931348623157E308);
        this.setZ(-1.7976931348623157E308);
    }

    @Override
    public GeoPoint3D clone() {
        if (this.getHandle() == 0L) {
            String string = E.a("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoPoint3D(this);
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = E.a("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = Toolkit.isZero(this.getX() - -1.7976931348623157E308, -1.0E-10, 1.0E-10) && Toolkit.isZero(this.getY() - -1.7976931348623157E308, -1.0E-10, 1.0E-10) && Toolkit.isZero(this.getZ() - -1.7976931348623157E308, -1.0E-10, 1.0E-10);
        return bl;
    }

    @Override
    public boolean fromJson(String string) {
        SiJsonObject siJsonObject = new SiJsonObject(string);
        boolean bl = this.fromJson(siJsonObject);
        siJsonObject.dispose();
        return bl;
    }

    @Override
    public boolean fromJson(SiJsonObject siJsonObject) {
        if (super.fromJson(siJsonObject)) {
            double d2 = siJsonObject.getJsonArray("points").getJsonObject(0).getDouble("x");
            double d3 = siJsonObject.getJsonArray("points").getJsonObject(0).getDouble("y");
            double d4 = siJsonObject.getJsonArray("points").getJsonObject(0).getDouble("z");
            this.setX(d2);
            this.setY(d3);
            this.setZ(d4);
            return true;
        }
        return false;
    }

    @Override
    public String toJson() {
        StringBuilder stringBuilder = new StringBuilder(super.toJson());
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(",");
        stringBuilder.append(" \"parts\" :[1],");
        stringBuilder.append(" \"type\" :\"POINT3D\",");
        stringBuilder.append(" \"points\" : [" + new Point3D(this.getX(), this.getY(), this.getZ()).toJson() + "]");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

