/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.E;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRectangleNative;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.Point2D;
import com.supermap.data.Rectangle2D;

public class GeoRectangle
extends Geometry {
    public GeoRectangle() {
        long l2 = GeoRectangleNative.jni_New();
        this.setHandle(l2, true);
    }

    public GeoRectangle(GeoRectangle geoRectangle) {
        if (geoRectangle == null) {
            String string = E.a("geoRectangle", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(geoRectangle);
        if (l2 == 0L) {
            String string = E.a("GeoRectangle geoRectangle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l3 = GeoRectangleNative.jni_Clone(l2);
        this.setHandle(l3, true);
    }

    public GeoRectangle(Point2D point2D, double d2, double d3, double d4) {
        if (d2 <= 0.0) {
            String string = E.a("width", "GeoRectangleWidthShouldPositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d3 <= 0.0) {
            String string = E.a("height", "GeoRectangleHeightShouldPositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoRectangleNative.jni_New1(point2D.getX(), point2D.getY(), d2, d3, d4);
        this.setHandle(l2, true);
    }

    public GeoRectangle(Rectangle2D rectangle2D, double d2) {
        if (rectangle2D.getWidth() <= 0.0) {
            String string = E.a("rectangle width", "GeoRectangleWidthShouldPositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.getHeight() <= 0.0) {
            String string = E.a("rectangle height", "GeoRectangleWidthShouldPositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoRectangleNative.jni_New2(rectangle2D.getLeft(), rectangle2D.getRight(), rectangle2D.getTop(), rectangle2D.getBottom(), d2);
        this.setHandle(l2, true);
    }

    GeoRectangle(long l2) {
        this.setHandle(l2, false);
    }

    public GeoLine convertToLine() {
        if (this.getHandle() == 0L) {
            String string = E.a("convertToLine()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l2 = GeoRectangleNative.jni_ConvertToLine(this.getHandle());
        GeoLine geoLine = null;
        if (l2 != 0L) {
            geoLine = new GeoLine(l2);
            geoLine.setIsDisposable(true);
        }
        return geoLine;
    }

    public GeoRegion convertToRegion() {
        if (this.getHandle() == 0L) {
            String string = E.a("convertToRegion()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l2 = GeoRectangleNative.jni_ConvertToRegion(this.getHandle());
        GeoRegion geoRegion = null;
        if (l2 != 0L) {
            geoRegion = new GeoRegion(l2);
            geoRegion.setIsDisposable(true);
        }
        return geoRegion;
    }

    public Point2D getCenter() {
        if (this.getHandle() == 0L) {
            String string = E.a("getCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoRectangleNative.jni_GetCenter(this.getHandle(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = E.a("setCenter(Point2D value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoRectangleNative.jni_SetCenter(this.getHandle(), point2D.getX(), point2D.getY());
    }

    public double getWidth() {
        if (this.getHandle() == 0L) {
            String string = E.a("getWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRectangleNative.jni_GetWidth(this.getHandle());
    }

    public void setWidth(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setWidth(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= 0.0) {
            String string = E.a("value", "GeoRectangleWidthShouldPositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRectangleNative.jni_SetWidth(this.getHandle(), d2);
    }

    public double getHeight() {
        if (this.getHandle() == 0L) {
            String string = E.a("getHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRectangleNative.jni_GetHeight(this.getHandle());
    }

    public void setHeight(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= 0.0) {
            String string = E.a("value", "GeoRectangleHeightShouldPositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoRectangleNative.jni_SetHeight(this.getHandle(), d2);
    }

    public double getRotation() {
        if (this.getHandle() == 0L) {
            String string = E.a("getRotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRectangleNative.jni_GetAngle(this.getHandle());
    }

    public void setRotation(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setRotation(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoRectangleNative.jni_SetAngle(this.getHandle(), d2);
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = E.a("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRectangleNative.jni_getArea(this.getHandle());
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = E.a("getPerimeter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRectangleNative.jni_getPerimeter(this.getHandle());
    }

    @Override
    public GeoRectangle clone() {
        if (this.getHandle() == 0L) {
            String string = E.a("Clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoRectangle(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoRectangleNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
    }

    @Override
    public boolean fromJson(String string) {
        return false;
    }

    @Override
    public String toJson() {
        return null;
    }
}

