/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import android.util.Log;
import com.supermap.data.E;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegionNative;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.imb.jsonlib.SiJsonArray;
import com.supermap.imb.jsonlib.SiJsonObject;
import java.util.ArrayList;

public class GeoRegion
extends Geometry {
    private ArrayList a;

    public GeoRegion() {
        super.setHandle(GeoRegionNative.jni_New(), true);
        this.a = new ArrayList();
    }

    public GeoRegion(GeoRegion geoRegion) {
        if (geoRegion == null) {
            String string = E.a("region", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRegion.getHandle() == 0L) {
            String string = E.a("region", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoRegionNative.jni_Clone(geoRegion.getHandle());
        super.setHandle(l2, true);
        this.a = new ArrayList(geoRegion.getPartsList().size());
        for (int i2 = 0; i2 < geoRegion.getPartsList().size(); ++i2) {
            Point2Ds point2Ds = (Point2Ds)geoRegion.getPartsList().get(i2);
            this.a.add(point2Ds.clone());
        }
    }

    public GeoRegion(Point2Ds point2Ds) {
        this();
        if (point2Ds.getCount() < 3) {
            String string = E.a("convertToRegion", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.addPart(point2Ds);
    }

    public int addPart(Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = E.a("addPart(Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = point2Ds.getCount();
        if (n2 < 3) {
            String string = E.a("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = point2Ds.getItem(i2).getX();
            dArray2[i2] = point2Ds.getItem(i2).getY();
        }
        int n3 = GeoRegionNative.jni_AddPart(this.getHandle(), dArray, dArray2);
        Point2Ds point2Ds2 = new Point2Ds(this.getPartFromUGC(n3));
        Point2Ds point2Ds3 = new Point2Ds(point2Ds2, this);
        this.a.add(point2Ds3);
        return n3;
    }

    public GeoLine convertToLine() {
        if (this.getHandle() == 0L) {
            String string = E.a("convertToLine()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l2 = GeoRegionNative.jni_ConvertToLine(this.getHandle());
        if (l2 != 0L) {
            GeoLine geoLine = new GeoLine(l2);
            geoLine.setIsDisposable(true);
            return geoLine;
        }
        return null;
    }

    public Point2Ds getPart(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("getPart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return (Point2Ds)this.a.get(n2);
    }

    public boolean insertPart(int n2, Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = E.a("insertPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n3 = point2Ds.getCount();
        if (n3 < 3) {
            String string = E.a("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0 || n2 > this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray[i2] = point2Ds.getItem(i2).getX();
            dArray2[i2] = point2Ds.getItem(i2).getY();
        }
        if (n2 == this.getPartCount()) {
            int n4 = GeoRegionNative.jni_AddPart(this.getHandle(), dArray, dArray2);
            Point2Ds point2Ds2 = new Point2Ds(this.getPartFromUGC(n4));
            Point2Ds point2Ds3 = new Point2Ds(point2Ds2, this);
            this.a.add(n2, point2Ds3);
            return n4 != -1;
        }
        boolean bl = GeoRegionNative.jni_InsertPart(this.getHandle(), n2, dArray, dArray2);
        Point2Ds point2Ds4 = new Point2Ds(this.getPartFromUGC(n2));
        Point2Ds point2Ds5 = new Point2Ds(point2Ds4, this);
        this.a.add(n2, point2Ds5);
        return bl;
    }

    public boolean removePart(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("removePart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeoRegionNative.jni_RemovePart(this.getHandle(), n2);
        if (bl) {
            this.a.remove(n2);
        }
        return bl;
    }

    public boolean setPart(int n2, Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = E.a("setPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point2Ds.getCount() < 3) {
            String string = E.a("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = point2Ds.getCount();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray[i2] = point2Ds.getItem(i2).getX();
            dArray2[i2] = point2Ds.getItem(i2).getY();
        }
        boolean bl = GeoRegionNative.jni_SetPart(this.getHandle(), n2, dArray, dArray2);
        if (bl) {
            Point2Ds point2Ds2 = new Point2Ds(this.getPartFromUGC(n2));
            Point2Ds point2Ds3 = new Point2Ds(point2Ds2, this);
            this.a.set(n2, point2Ds3);
        }
        return bl;
    }

    boolean setPartJustToUGC(int n2, Point2Ds point2Ds) {
        if (this.getHandle() == 0L) {
            String string = E.a("setPart(int index, Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point2Ds.getCount() < 3) {
            String string = E.a("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = point2Ds.getCount();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray[i2] = point2Ds.getItem(i2).getX();
            dArray2[i2] = point2Ds.getItem(i2).getY();
        }
        boolean bl = GeoRegionNative.jni_SetPart(this.getHandle(), n2, dArray, dArray2);
        return bl;
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = E.a("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegionNative.jni_GetArea(this.getHandle());
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = E.a("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegionNative.jni_GetPartCount(this.getHandle());
    }

    public double getPerimeter() {
        if (this.getHandle() == 0L) {
            String string = E.a("getPerimeter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegionNative.jni_GetPerimeter(this.getHandle());
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
        this.setHandle(0L);
    }

    protected static void clearHandle(GeoRegion geoRegion) {
        geoRegion.clearHandle();
    }

    protected void changeHandle(long l2) {
        if (l2 == 0L) {
            String string = E.a("regionHandle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setIsDisposable(true);
        this.dispose();
        this.setHandle(l2, false);
    }

    protected static void changeHandle(GeoRegion geoRegion, long l2) {
        geoRegion.changeHandle(l2);
    }

    ArrayList getPartsList() {
        return this.a;
    }

    private Point2D[] getPartFromUGC(int n2) {
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = GeoRegionNative.jni_GetPartPointCount(this.getHandle(), n2);
        if (n3 > 2) {
            Point2D[] point2DArray = new Point2D[n3];
            double[] dArray = new double[n3];
            double[] dArray2 = new double[n3];
            GeoRegionNative.jni_GetPart(this.getHandle(), n2, dArray, dArray2);
            for (int i2 = 0; i2 < n3; ++i2) {
                point2DArray[i2] = new Point2D(dArray[i2], dArray2[i2]);
            }
            return point2DArray;
        }
        return null;
    }

    private void refreshFromUGC() {
        int n2 = this.getPartCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Point2Ds point2Ds = (Point2Ds)this.a.get(i2);
            point2Ds.a(Point2Ds.a.a);
            point2Ds.clear();
            point2Ds.addRange(this.getPartFromUGC(i2));
            point2Ds.a(Point2Ds.a.c);
        }
    }

    void refrashPartsList() {
        int n2 = this.getPartCount();
        this.a.clear();
        for (int i2 = 0; i2 < n2; ++i2) {
            Point2Ds point2Ds = new Point2Ds(this.getPartFromUGC(i2));
            Point2Ds point2Ds2 = new Point2Ds(point2Ds, this);
            this.a.add(point2Ds2);
        }
    }

    @Override
    public GeoRegion clone() {
        if (this.getHandle() == 0L) {
            String string = E.a("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoRegion(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoRegionNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = E.a("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    GeoRegion(long l2) {
        this.setHandle(l2, false);
        this.a = new ArrayList();
        this.refrashPartsList();
    }

    protected void refreshHandle(long l2) {
        if (l2 == 0L) {
            String string = E.a("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l2, false);
    }

    protected static void refreshHandle(GeoRegion geoRegion, long l2) {
        geoRegion.refreshHandle(l2);
    }

    @Override
    public boolean fromJson(String string) {
        SiJsonObject siJsonObject = new SiJsonObject(string);
        boolean bl = this.fromJson(siJsonObject);
        siJsonObject.dispose();
        return bl;
    }

    @Override
    public boolean fromJson(SiJsonObject siJsonObject) {
        if (super.fromJson(siJsonObject)) {
            SiJsonArray siJsonArray = siJsonObject.getJsonArray("parts");
            SiJsonArray siJsonArray2 = siJsonObject.getJsonArray("points");
            int n2 = siJsonArray.getArraySize();
            int n3 = 0;
            int n4 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 = siJsonArray.getInt(i2);
                Point2Ds point2Ds = new Point2Ds();
                for (int i3 = 0; i3 < n3; ++i3) {
                    SiJsonObject siJsonObject2;
                    Point2D point2D = new Point2D();
                    if (!point2D.fromJson(siJsonObject2 = siJsonArray2.getJsonObject(n4++))) {
                        siJsonObject2.dispose();
                        continue;
                    }
                    siJsonObject2.dispose();
                    point2Ds.add(point2D);
                }
                this.addPart(point2Ds);
            }
            siJsonArray.dispose();
            siJsonArray2.dispose();
            return true;
        }
        return false;
    }

    @Override
    public String toJson() {
        StringBuilder stringBuilder = new StringBuilder(super.toJson());
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(",");
        String string = "";
        int n2 = this.getPartCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + this.getPart(i2).getCount();
            if (i2 == n2 - 1) continue;
            string = string + ",";
        }
        stringBuilder.append(" \"parts\": [" + string + "]" + ",");
        stringBuilder.append(" \"type\": \"REGION\",");
        String string2 = "";
        int n3 = 0;
        for (int i3 = 0; i3 < n2; ++i3) {
            Point2Ds point2Ds = this.getPart(i3);
            n3 = point2Ds.getCount();
            for (int i4 = 0; i4 < n3; ++i4) {
                string2 = string2 + point2Ds.getItem(i4).toJson();
                if (i3 == n2 - 1 && i4 == n3 - 1) continue;
                string2 = string2 + ",";
            }
        }
        stringBuilder.append(" \"points\" :[" + string2 + "]");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public String toGeoJSON() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.getPartCount();
        stringBuilder.append("{\"type\": \"Polygon\",");
        stringBuilder.append("\"coordinates\":[");
        this.getCoordinatesString(stringBuilder, n2);
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    @Override
    public boolean fromGeoJSON(String string) {
        if (!string.contains("Polygon")) {
            Log.e((String)"GeoRegion", (String)"Not match the type of Polygon");
            return false;
        }
        ArrayList<Point2Ds> arrayList = this.getPointsFromGeoJSON(string);
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.addPart(arrayList.get(i2));
        }
        return true;
    }

    private void getCoordinatesString(StringBuilder stringBuilder, int n2) {
        String string = "";
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (n2 > 1) {
                string = "[";
            }
            Point2Ds point2Ds = this.getPart(i2);
            n3 = point2Ds.getCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                string = string + "[" + point2Ds.getItem(i3).getX() + "," + point2Ds.getItem(i3).getY() + "]";
                if (i3 >= n3 - 1) continue;
                string = string + ",";
            }
            if (n2 > 1) {
                string = string + "]";
            }
            if (i2 < n2 - 1) {
                string = string + ",";
            }
            stringBuilder.append(string);
        }
    }
}

