/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.E;
import com.supermap.data.GeoLine3D;
import com.supermap.data.GeoRegion3DNative;
import com.supermap.data.Geometry3D;
import com.supermap.data.Point3D;
import com.supermap.data.Point3Ds;
import com.supermap.imb.jsonlib.SiJsonArray;
import com.supermap.imb.jsonlib.SiJsonObject;
import java.util.ArrayList;

public class GeoRegion3D
extends Geometry3D {
    private ArrayList<Point3Ds> a;

    public GeoRegion3D() {
        super.setHandle(GeoRegion3DNative.jni_New(), true);
        this.a = new ArrayList();
    }

    public GeoRegion3D(Point3Ds point3Ds) {
        this();
        this.addPart(point3Ds);
    }

    public GeoRegion3D(GeoRegion3D geoRegion3D) {
        if (geoRegion3D == null) {
            String string = E.a("region3D", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRegion3D.getHandle() == 0L) {
            String string = E.a("region3D", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoRegion3DNative.jni_Clone(geoRegion3D.getHandle());
        super.setHandle(l2, true);
        this.a = new ArrayList();
        for (int i2 = 0; i2 < geoRegion3D.a().size(); ++i2) {
            Point3Ds point3Ds = geoRegion3D.a().get(i2);
            this.a.add(point3Ds.clone());
        }
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoRegion3DNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public double getArea() {
        if (this.getHandle() == 0L) {
            String string = E.a("getArea()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegion3DNative.jni_GetArea(this.getHandle());
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = E.a("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoRegion3DNative.jni_GetPartCount(this.getHandle());
    }

    public int addPart(Point3Ds point3Ds) {
        if (this.getHandle() == 0L) {
            String string = E.a("addPart(points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = point3Ds.getCount();
        if (n2 < 3) {
            String string = E.a("points", "GeoRegion3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        double[] dArray3 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = point3Ds.getItem(i2).getX();
            dArray2[i2] = point3Ds.getItem(i2).getY();
            dArray3[i2] = point3Ds.getItem(i2).getZ();
        }
        int n3 = GeoRegion3DNative.jni_AddPart(this.getHandle(), dArray, dArray2, dArray3);
        Point3Ds point3Ds2 = new Point3Ds(this.a(n3));
        Point3Ds point3Ds3 = new Point3Ds(point3Ds2, this);
        this.a.add(point3Ds3);
        return n3;
    }

    public GeoLine3D convertToLine() {
        if (this.getHandle() == 0L) {
            String string = E.a("convertToLine()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoLine3D geoLine3D = new GeoLine3D();
        for (int i2 = 0; i2 < this.getPartCount(); ++i2) {
            geoLine3D.addPart(this.getPart(i2));
        }
        geoLine3D.setIsDisposable(true);
        return geoLine3D;
    }

    public Point3Ds getPart(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("getPart(index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return this.a.get(n2);
    }

    boolean a(int n2, Point3Ds point3Ds) {
        if (this.getHandle() == 0L) {
            String string = E.a("setPart(index, points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (point3Ds.getCount() < 3) {
            String string = E.a("points", "GeoRegion3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n3 = point3Ds.getCount();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray[i2] = point3Ds.getItem(i2).getX();
            dArray2[i2] = point3Ds.getItem(i2).getY();
            dArray3[i2] = point3Ds.getItem(i2).getZ();
        }
        boolean bl = GeoRegion3DNative.jni_SetPart(this.getHandle(), n2, dArray, dArray2, dArray3);
        if (bl) {
            Point3Ds point3Ds2 = new Point3Ds(this.a(n2));
            Point3Ds point3Ds3 = new Point3Ds(point3Ds2, this);
            this.a.set(n2, point3Ds3);
        }
        return bl;
    }

    boolean b(int n2, Point3Ds point3Ds) {
        if (this.getHandle() == 0L) {
            String string = E.a("setPart(index, points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (point3Ds.getCount() < 3) {
            String string = E.a("points", "GeoRegion3D_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n3 = point3Ds.getCount();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            dArray[i2] = point3Ds.getItem(i2).getX();
            dArray2[i2] = point3Ds.getItem(i2).getY();
            dArray3[i2] = point3Ds.getItem(i2).getZ();
        }
        boolean bl = GeoRegion3DNative.jni_SetPart(this.getHandle(), n2, dArray, dArray2, dArray3);
        return bl;
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
        this.setHandle(0L);
    }

    ArrayList<Point3Ds> a() {
        return this.a;
    }

    private Point3D[] a(int n2) {
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n3 = GeoRegion3DNative.jni_GetPartPointCount(this.getHandle(), n2);
        if (n3 > 2) {
            Point3D[] point3DArray = new Point3D[n3];
            double[] dArray = new double[n3];
            double[] dArray2 = new double[n3];
            double[] dArray3 = new double[n3];
            GeoRegion3DNative.jni_GetPart(this.getHandle(), n2, dArray, dArray2, dArray3);
            for (int i2 = 0; i2 < n3; ++i2) {
                point3DArray[i2] = new Point3D(dArray[i2], dArray2[i2], dArray3[i2]);
            }
            return point3DArray;
        }
        return null;
    }

    @Override
    public GeoRegion3D clone() {
        if (this.getHandle() == 0L) {
            String string = E.a("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoRegion3D(this);
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = E.a("isEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.getPartCount() == 0;
    }

    GeoRegion3D(long l2) {
        this.setHandle(l2, false);
        this.a = new ArrayList();
        this.a();
    }

    private void a() {
        int n2 = this.getPartCount();
        this.a.clear();
        for (int i2 = 0; i2 < n2; ++i2) {
            Point3Ds point3Ds = new Point3Ds(this.a(i2));
            Point3Ds point3Ds2 = new Point3Ds(point3Ds, this);
            this.a.add(point3Ds2);
        }
    }

    @Override
    public boolean fromJson(String string) {
        SiJsonObject siJsonObject = new SiJsonObject(string);
        boolean bl = this.fromJson(siJsonObject);
        siJsonObject.dispose();
        return bl;
    }

    @Override
    public boolean fromJson(SiJsonObject siJsonObject) {
        if (super.fromJson(siJsonObject)) {
            SiJsonArray siJsonArray = siJsonObject.getJsonArray("parts");
            SiJsonArray siJsonArray2 = siJsonObject.getJsonArray("points");
            int n2 = siJsonArray.getArraySize();
            int n3 = 0;
            int n4 = 0;
            for (int i2 = 0; i2 < n2; ++i2) {
                n3 = siJsonArray.getInt(i2);
                Point3Ds point3Ds = new Point3Ds();
                for (int i3 = 0; i3 < n3; ++i3) {
                    SiJsonObject siJsonObject2;
                    Point3D point3D = new Point3D();
                    if (!point3D.fromJson(siJsonObject2 = siJsonArray2.getJsonObject(n4++))) {
                        siJsonObject2.dispose();
                        continue;
                    }
                    siJsonObject2.dispose();
                    point3Ds.add(point3D);
                }
                this.addPart(point3Ds);
            }
            siJsonArray.dispose();
            siJsonArray2.dispose();
            return true;
        }
        return false;
    }

    @Override
    public String toJson() {
        StringBuilder stringBuilder = new StringBuilder(super.toJson());
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(",");
        String string = "";
        int n2 = this.getPartCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            string = string + this.getPart(i2).getCount();
            if (i2 == n2 - 1) continue;
            string = string + ",";
        }
        stringBuilder.append(" \"parts\": [" + string + "]" + ",");
        stringBuilder.append(" \"type\": \"REGION3D\",");
        String string2 = "";
        int n3 = 0;
        for (int i3 = 0; i3 < n2; ++i3) {
            Point3Ds point3Ds = this.getPart(i3);
            n3 = point3Ds.getCount();
            for (int i4 = 0; i4 < n3; ++i4) {
                string2 = string2 + point3Ds.getItem(i4).toJson();
                if (i3 == n2 - 1 && i4 == n3 - 1) continue;
                string2 = string2 + ",";
            }
        }
        stringBuilder.append(" \"points\" :[" + string2 + "]");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

