/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Color;
import com.supermap.data.E;
import com.supermap.data.Enum;
import com.supermap.data.FillGradientMode;
import com.supermap.data.GeoStyleNative;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Size2D;

public class GeoStyle
extends InternalHandleDisposable {
    public GeoStyle() {
        super.setHandle(GeoStyleNative.jni_New(), true);
        this.reset();
    }

    public GeoStyle(GeoStyle geoStyle) {
        if (geoStyle.getHandle() == 0L) {
            String string = E.a("style", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoStyleNative.jni_Clone(geoStyle.getHandle());
        super.setHandle(l2, true);
    }

    GeoStyle(long l2) {
        if (l2 == 0L) {
            String string = E.a("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l2, false);
    }

    public Color getFillBackColor() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(GeoStyleNative.jni_GetFillBackColor(this.getHandle()));
        return color;
    }

    public void setFillBackColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyleNative.jni_SetFillBackColor(this.getHandle(), color.getRGB());
    }

    public boolean getFillBackOpaque() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyleNative.jni_GetIsBackTransparent(this.getHandle());
    }

    public void setFillBackOpaque(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyleNative.jni_SetIsBackTransparent(this.getHandle(), bl);
    }

    public Color getFillForeColor() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(GeoStyleNative.jni_GetFillForeColor(this.getHandle()));
        return color;
    }

    public void setFillForeColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyleNative.jni_SetFillForeColor(this.getHandle(), color.getRGB());
    }

    public double getFillGradientAngle() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyleNative.jni_GetFillAngle(this.getHandle());
    }

    public void setFillGradientAngle(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyleNative.jni_SetFillAngle(this.getHandle(), d2);
    }

    public double getFillGradientOffsetRatioX() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyleNative.jni_GetFillCenterOffsetX(this.getHandle());
    }

    public void setFillGradientOffsetRatioX(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyleNative.jni_SetFillCenterOffsetX(this.getHandle(), d2);
    }

    public double getFillGradientOffsetRatioY() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyleNative.jni_GetFillCenterOffsetY(this.getHandle());
    }

    public void setFillGradientOffsetRatioY(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyleNative.jni_SetFillCenterOffsetY(this.getHandle(), d2);
    }

    public FillGradientMode getFillGradientMode() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = GeoStyleNative.jni_GetFillGradientType(this.getHandle());
        return (FillGradientMode)Enum.parseUGCValue(FillGradientMode.class, n2);
    }

    public void setFillGradientMode(FillGradientMode fillGradientMode) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (fillGradientMode == null) {
            String string = E.a("fillGradientMode", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = fillGradientMode.getUGCValue();
        GeoStyleNative.jni_SetFillGradientType(this.getHandle(), n2);
    }

    public int getFillOpaqueRate() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyleNative.jni_GetFillOpaqueRate(this.getHandle());
    }

    public void setFillOpaqueRate(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        n2 = n2 < 0 ? 0 : n2;
        n2 = n2 > 100 ? 100 : n2;
        GeoStyleNative.jni_SetFillOpaqueRate(this.getHandle(), n2);
    }

    public int getFillSymbolID() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyleNative.jni_GetFillStyle(this.getHandle());
    }

    public void setFillSymbolID(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0) {
            String string = E.a("value", "GeoStyle_TheValueOfSymbolIDShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyleNative.jni_SetFillStyle(this.getHandle(), n2);
    }

    public Color getLineColor() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Color color = new Color(GeoStyleNative.jni_GetLineColor(this.getHandle()));
        return color;
    }

    public void setLineColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyleNative.jni_SetLineColor(this.getHandle(), color.getRGB());
    }

    public int getLineSymbolID() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyleNative.jni_GetLineStyle(this.getHandle());
    }

    public void setLineSymbolID(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0) {
            String string = E.a("value", "GeoStyle_TheValueOfSymbolIDShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyleNative.jni_SetLineStyle(this.getHandle(), n2);
    }

    public double getLineWidth() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyleNative.jni_GetLineWidth(this.getHandle());
    }

    public void setLineWidth(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 < 0.0) {
            String string = E.a("value", "GeoStyle_TheArgumentOfLineWidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyleNative.jni_SetLineWidth(this.getHandle(), d2);
    }

    public double getMarkerAngle() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyleNative.jni_GetMarkerAngle(this.getHandle());
    }

    public void setMarkerAngle(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyleNative.jni_SetMarkerAngle(this.getHandle(), d2);
    }

    public Size2D getMarkerSize() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[2];
        GeoStyleNative.jni_GetMarkerSize(this.getHandle(), dArray);
        if (dArray[0] < 0.0 || dArray[1] < 0.0) {
            dArray[0] = 0.0;
            dArray[1] = 0.0;
        }
        return new Size2D(dArray[0], dArray[1]);
    }

    public void setMarkerSize(Size2D size2D) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (size2D.getWidth() < 0.0 && size2D.getHeight() < 0.0) {
            String string = E.a("value", "GeoStyleTheValueOfMarkerSize_IsNotValid", "data_resources");
            throw new IllegalStateException(string);
        }
        GeoStyleNative.jni_SetMarkerSize(this.getHandle(), size2D.getWidth(), size2D.getHeight());
    }

    public int getMarkerSymbolID() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoStyleNative.jni_GetMarkerStyle(this.getHandle());
    }

    public void setMarkerSymbolID(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0) {
            String string = E.a("value", "GeoStyle_TheValueOfSymbolIDShouldNotBeNegative", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoStyleNative.jni_SetMarkerStyle(this.getHandle(), n2);
    }

    public GeoStyle clone() {
        if (this.getHandle() == 0L) {
            String string = E.a("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoStyle(this);
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            GeoStyleNative.jni_Delete(super.getHandle());
            this.setHandle(0L);
        }
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = E.a("toString()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{FillBackColor = ");
        stringBuffer.append(this.getFillBackColor().toString());
        stringBuffer.append(",FillForeColor = ");
        stringBuffer.append(this.getFillForeColor().toString());
        stringBuffer.append(",FillGradientAngle = ");
        stringBuffer.append(this.getFillGradientAngle());
        stringBuffer.append(",FillGradientOffsetRatioX = ");
        stringBuffer.append(this.getFillGradientOffsetRatioX());
        stringBuffer.append(",FillGradientOffsetRatioY = ");
        stringBuffer.append(this.getFillGradientOffsetRatioY());
        stringBuffer.append(",FillGradientMode = ");
        stringBuffer.append(this.getFillGradientMode().name());
        stringBuffer.append(",FillOpaqueRate = ");
        stringBuffer.append(this.getFillOpaqueRate());
        stringBuffer.append(",FillSymbolID = ");
        stringBuffer.append(this.getFillSymbolID());
        stringBuffer.append(",LineColor = ");
        stringBuffer.append(this.getLineColor().toString());
        stringBuffer.append(",LineSymbolID = ");
        stringBuffer.append(this.getLineSymbolID());
        stringBuffer.append(",LineWidth = ");
        stringBuffer.append(this.getLineWidth());
        stringBuffer.append(",MarkerAngle = ");
        stringBuffer.append(this.getMarkerAngle());
        stringBuffer.append(",MarkerSize = ");
        stringBuffer.append(this.getMarkerSize());
        stringBuffer.append(",MarkerSymbolID = ");
        stringBuffer.append(this.getMarkerSymbolID());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    public boolean fromXML(String string) {
        if (this.getHandle() == 0L) {
            String string2 = E.a("getSymbolFill()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        if (string != null && string.trim().length() != 0) {
            bl = GeoStyleNative.jni_FromXML(this.getHandle(), string);
        }
        return bl;
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = E.a("getSymbolFill()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        String string = GeoStyleNative.jni_ToXML(this.getHandle());
        return string;
    }

    protected static GeoStyle createInstance(long l2) {
        if (l2 == 0L) {
            String string = E.a("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoStyle(l2);
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
    }

    protected static void clearHandle(GeoStyle geoStyle) {
        geoStyle.clearHandle();
    }

    private void changeHandle(long l2) {
        if (l2 == 0L) {
            String string = E.a("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() != 0L) {
            GeoStyleNative.jni_Delete(this.getHandle());
        }
        this.setHandle(l2, false);
    }

    protected static void changeHandle(GeoStyle geoStyle, long l2) {
        geoStyle.changeHandle(l2);
    }

    protected static void reset(GeoStyle geoStyle) {
        geoStyle.reset();
    }

    private void refreshHandle(long l2) {
        if (l2 == 0L) {
            String string = E.a("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l2, false);
    }

    protected static void refreshHandle(GeoStyle geoStyle, long l2) {
        geoStyle.refreshHandle(l2);
    }

    void reset() {
        if (this.getHandle() != 0L) {
            GeoStyleNative.jni_Reset(this.getHandle());
        }
    }

    public String toJson() {
        return "";
    }

    public boolean fromJson(String string) {
        return false;
    }
}

