/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.E;
import com.supermap.data.GeoTextNative;
import com.supermap.data.Geometry;
import com.supermap.data.Point2D;
import com.supermap.data.TextPart;
import com.supermap.data.TextStyle;
import com.supermap.imb.jsonlib.SiJsonArray;
import com.supermap.imb.jsonlib.SiJsonObject;
import java.util.ArrayList;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GeoText
extends Geometry {
    private ArrayList a;
    private TextStyle a = null;

    public GeoText() {
        long l2 = GeoTextNative.jni_New();
        this.setHandle(l2, true);
        this.reset();
        this.a = new ArrayList();
    }

    public GeoText(GeoText geoText) {
        if (geoText == null) {
            String string = E.a("geoText", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoText.getHandle() == 0L) {
            String string = E.a("geoText", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoTextNative.jni_Clone(geoText.getHandle());
        this.setHandle(l2, true);
        this.a = new ArrayList();
        int n2 = geoText.getTextPartsList().size();
        for (int i2 = 0; i2 < n2; ++i2) {
            TextPart textPart = new TextPart(this, i2);
            this.a.add(textPart);
        }
    }

    public GeoText(TextPart textPart) {
        if (textPart == null) {
            String string = E.a("part", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (textPart.getHandle() == 0L) {
            String string = E.a("part", "Handle_UndisposableObject", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoTextNative.jni_New();
        this.setHandle(l2, true);
        this.reset();
        this.a = new ArrayList();
        this.addPart(textPart);
    }

    public GeoText(TextPart textPart, TextStyle textStyle) {
        if (textPart == null) {
            String string = E.a("part", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (textStyle == null) {
            String string = E.a("textStyle", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (textPart.getHandle() == 0L) {
            String string = E.a("part", "Handle_UndisposableObject", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (textStyle.getHandle() == 0L) {
            String string = E.a("textStyle", "Handle_UndisposableObject", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeoTextNative.jni_New();
        this.setHandle(l2, true);
        this.a = new ArrayList();
        this.addPart(textPart);
        this.setTextStyle(textStyle);
    }

    @Override
    public boolean isEmpty() {
        if (this.getHandle() == 0L) {
            String string = E.a("getIsEmpty()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoTextNative.jni_GetPartCount(this.getHandle()) == 0;
    }

    GeoText(long l2) {
        this.setHandle(l2, false);
        this.a = new ArrayList();
        this.refreshTextPartsList();
    }

    protected static GeoText creatInstance(long l2) {
        if (l2 == 0L) {
            String string = E.a("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new GeoText(l2);
    }

    public String getText() {
        if (this.getHandle() == 0L) {
            String string = E.a("getText()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoTextNative.jni_GetContent(this.getHandle());
    }

    public int getPartCount() {
        if (this.getHandle() == 0L) {
            String string = E.a("getPartCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return GeoTextNative.jni_GetPartCount(this.getHandle());
    }

    public TextStyle getTextStyle() {
        long l2;
        if (this.getHandle() == 0L) {
            String string = E.a("getTextStyle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null && (l2 = GeoTextNative.jni_GetTextStyle(this.getHandle())) != 0L) {
            this.a = TextStyle.createInstance(l2);
        }
        return this.a;
    }

    public void setTextStyle(TextStyle textStyle) {
        if (this.getHandle() == 0L) {
            String string = E.a("setTextStyle(TextStyle textStyle)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textStyle.getHandle() == 0L) {
            String string = E.a("textStyle", "Handle_UndisposableObject", "data_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyle textStyle2 = textStyle.clone();
        GeoTextNative.jni_SetTextStyle(this.getHandle(), textStyle2.getHandle());
    }

    public int addPart(TextPart textPart) {
        if (this.getHandle() == 0L) {
            String string = E.a("addPart(TextPart part)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textPart == null) {
            String string = E.a("part", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (textPart.getHandle() == 0L) {
            String string = E.a("part", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = GeoTextNative.jni_AddPart(this.getHandle(), textPart.getHandle(), textPart.getX(), textPart.getY());
        TextPart textPart2 = new TextPart(this, n2);
        this.a.add(textPart2);
        return n2;
    }

    public TextPart getPart(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("getPart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        TextPart textPart = (TextPart)this.a.get(n2);
        return textPart;
    }

    public boolean insertPart(int n2, TextPart textPart) {
        if (this.getHandle() == 0L) {
            String string = E.a("insertPart(int index, TextPart part)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textPart == null) {
            String string = E.a("part", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0 || n2 > this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (textPart.getHandle() == 0L) {
            String string = E.a("part", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = GeoTextNative.jni_InsertPart(this.getHandle(), n2, textPart.getHandle(), textPart.getX(), textPart.getY());
        if (bl) {
            TextPart textPart2 = new TextPart(this, n2);
            this.a.add(n2, textPart2);
        }
        return bl;
    }

    public boolean removePart(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("removePart(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        boolean bl = GeoTextNative.jni_RemovePart(this.getHandle(), n2);
        if (bl) {
            this.a.remove(n2);
        }
        return bl;
    }

    public boolean setPart(int n2, TextPart textPart) {
        if (this.getHandle() == 0L) {
            String string = E.a("setPart(int index, TextPart part)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textPart == null) {
            String string = E.a("part", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n2 < 0 || n2 >= this.getPartCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (textPart.getHandle() == 0L) {
            String string = E.a("part", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeoTextNative.jni_SetPart(this.getHandle(), n2, textPart.getHandle(), textPart.getX(), textPart.getY());
        if (bl) {
            TextPart textPart2 = new TextPart(this, n2);
            this.a.set(n2, textPart2);
        }
        return bl;
    }

    @Override
    public GeoText clone() {
        if (this.getHandle() == 0L) {
            String string = E.a("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new GeoText(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            GeoTextNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        super.clearHandle();
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
    }

    ArrayList getTextPartsList() {
        return this.a;
    }

    void reset() {
        this.getTextStyle().a();
    }

    private void refreshTextPartsList() {
        this.a.clear();
        int n2 = this.getPartCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            TextPart textPart = new TextPart(this, i2);
            this.a.add(textPart);
        }
    }

    @Override
    public boolean fromJson(String string) {
        SiJsonObject siJsonObject = new SiJsonObject(string);
        boolean bl = this.fromJson(siJsonObject);
        siJsonObject.dispose();
        return bl;
    }

    @Override
    public boolean fromJson(SiJsonObject siJsonObject) {
        if (super.fromJson(siJsonObject)) {
            SiJsonArray siJsonArray = siJsonObject.getJsonArray("points");
            SiJsonArray siJsonArray2 = siJsonObject.getJsonArray("texts");
            int n2 = siJsonArray.getArraySize();
            for (int i2 = 0; i2 < n2; ++i2) {
                TextPart textPart = new TextPart();
                Point2D point2D = new Point2D();
                SiJsonObject siJsonObject2 = siJsonArray.getJsonObject(i2);
                if (point2D.fromJson(siJsonObject2)) {
                    textPart.setAnchorPoint(point2D);
                    textPart.setText(siJsonArray2.getString(i2));
                }
                this.addPart(textPart);
                siJsonObject2.dispose();
            }
            siJsonArray.dispose();
            siJsonArray2.dispose();
            return true;
        }
        return false;
    }

    @Override
    public String toJson() {
        StringBuilder stringBuilder = new StringBuilder(super.toJson());
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(",");
        String string = "";
        stringBuilder.append(" \"parts\": [" + string + "]" + ",");
        stringBuilder.append(" \"type\": \"TEXT\",");
        String string2 = "";
        int n2 = this.getPartCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            string2 = string2 + this.getPart(i2).getAnchorPoint().toJson();
            if (i2 == n2 - 1) continue;
            string2 = string2 + ",";
        }
        stringBuilder.append(" \"points\" :[" + string2 + "]" + ",");
        String string3 = "";
        for (int i3 = 0; i3 < n2; ++i3) {
            string3 = string3 + this.getPart(i3).getText();
            if (i3 == n2 - 1) continue;
            string2 = string2 + ",";
        }
        stringBuilder.append(" \"texts\" :[" + string3 + "]");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

