/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.E;
import com.supermap.data.Environment;
import com.supermap.data.GeoArc;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoRegion;
import com.supermap.data.GeometristNative;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.Rectangle2D;
import com.supermap.data.ResampleType;

public class Geometrist {
    private Geometrist() {
    }

    public static boolean isIdentical(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsIdentical(geometry.getHandle(), geometry2.getHandle());
    }

    public static boolean isDisjointed(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = E.a("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsDisjointed(geometry.getHandle(), geometry2.getHandle());
    }

    public static boolean hasIntersection(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = E.a("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION, GeometryType.GEOTEXT)) {
            String string = E.a("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION, GeometryType.GEOTEXT)) {
            String string = E.a("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType() != GeometryType.GEOREGION && geometry2.getType() != GeometryType.GEOREGION) {
            String string = E.a("geometrySearch&geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_HasIntersection(geometry.getHandle(), geometry2.getHandle());
    }

    public static boolean hasTouch(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = E.a("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_HasTouch(geometry.getHandle(), geometry2.getHandle());
    }

    public static boolean hasOverlap(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = E.a("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2.getType() != geometry2.getType()) {
            String string = E.a("geometrySearch&geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_HasOverlap(geometry.getHandle(), geometry2.getHandle());
    }

    public static boolean hasCross(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = E.a("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOLINE)) {
            String string = E.a("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_HasCross(geometry.getHandle(), geometry2.getHandle());
    }

    public static boolean isWithin(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = E.a("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsWithin(geometry.getHandle(), geometry2.getHandle());
    }

    public static boolean canContain(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = E.a("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_CanContain(geometry.getHandle(), geometry2.getHandle());
    }

    public static boolean hasCommonPoint(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = E.a("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_HasCommonPoint(geometry.getHandle(), geometry2.getHandle());
    }

    public static boolean hasCommonLine(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometrySearch", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = E.a("geometryTarget", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometrySearch", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometryTarget", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_HasCommonLine(geometry.getHandle(), geometry2.getHandle());
    }

    public static Geometry clip(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = E.a("clipGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOREGION)) {
            String string = E.a("clipGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeometristNative.jni_Clip(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l2 != 0L) {
            geometry3 = Geometry.createInstance(l2);
        }
        return geometry3;
    }

    public static Geometry clip(Geometry geometry, Rectangle2D rectangle2D) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D == null) {
            String string = E.a("clipRectangle", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (rectangle2D.isEmpty()) {
            String string = E.a("clipRectangle", "GeometryShouldNotBeEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeometristNative.jni_ClipRect(geometry.getHandle(), rectangle2D.getLeft(), rectangle2D.getTop(), rectangle2D.getRight(), rectangle2D.getBottom());
        Geometry geometry2 = null;
        if (l2 != 0L) {
            geometry2 = Geometry.createInstance(l2);
        }
        return geometry2;
    }

    public static boolean hasHollow(Geometry geometry) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOREGION)) {
            String string = E.a("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_HasHollow(geometry.getHandle());
    }

    @Deprecated
    public static boolean HasHollow(Geometry geometry) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOREGION)) {
            String string = E.a("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_HasHollow(geometry.getHandle());
    }

    public static Geometry intersect(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometry1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = E.a("geometry2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometry1", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOREGION)) {
            String string = E.a("geometry2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!geometry.getType().equals(geometry2.getType())) {
            String string = E.a("", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeometristNative.jni_Intersect(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l2 != 0L) {
            geometry3 = Geometry.createInstance(l2);
        }
        return geometry3;
    }

    public static Geometry erase(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = E.a("eraseGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOREGION)) {
            String string = E.a("eraseGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeometristNative.jni_Erase(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l2 != 0L) {
            geometry3 = Geometry.createInstance(l2);
        }
        return geometry3;
    }

    public static Geometry union(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometry1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = E.a("geometry2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOREGION)) {
            String string = E.a("geometry1", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOREGION)) {
            String string = E.a("geometry2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeometristNative.jni_Union(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l2 != 0L) {
            geometry3 = Geometry.createInstance(l2);
        }
        return geometry3;
    }

    public static Geometry xOR(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometry1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = E.a("geometry2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometry1", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometry2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType() != geometry2.getType()) {
            String string = E.a("geometry1&geometry2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeometristNative.jni_XOR(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l2 != 0L) {
            geometry3 = Geometry.createInstance(l2);
        }
        return geometry3;
    }

    public static Geometry update(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = E.a("updateGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOREGION)) {
            String string = E.a("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOREGION)) {
            String string = E.a("updateGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeometristNative.jni_Update(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l2 != 0L) {
            geometry3 = Geometry.createInstance(l2);
        }
        return geometry3;
    }

    public static Geometry identity(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = E.a("identityGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry2, GeometryType.GEOREGION)) {
            String string = E.a("identityGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeometristNative.jni_Identity(geometry.getHandle(), geometry2.getHandle());
        Geometry geometry3 = null;
        if (l2 != 0L) {
            geometry3 = Geometry.createInstance(l2);
        }
        return geometry3;
    }

    @Deprecated
    public static Geometry resample(Geometry geometry, double d2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = E.a("tolerance", "Global_ToleranceShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeometristNative.jni_Resample(geometry.getHandle(), d2);
        Geometry geometry2 = null;
        if (l2 != 0L) {
            geometry2 = Geometry.createInstance(l2);
        }
        return geometry2;
    }

    public static Geometry resample(Geometry geometry, ResampleType resampleType, double d2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = E.a("tolerance", "Global_ToleranceShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = resampleType.getUGCValue();
        long l2 = GeometristNative.jni_Resample1(geometry.getHandle(), n2, d2);
        Geometry geometry2 = null;
        if (l2 != 0L) {
            geometry2 = Geometry.createInstance(l2);
        }
        return geometry2;
    }

    public static double distance(Geometry geometry, Geometry geometry2) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometry1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry2 == null || geometry2.getHandle() == 0L) {
            String string = E.a("geometry2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d2 = GeometristNative.jni_Distance(geometry.getHandle(), geometry2.getHandle());
        return d2;
    }

    public static GeoRegion computeConvexHull(Point2Ds point2Ds) {
        int n2 = point2Ds.getCount();
        if (n2 < 3) {
            String string = E.a("points", "GeoRegion_InvalidPointsLength", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = point2Ds.getItem(i2).getX();
            dArray2[i2] = point2Ds.getItem(i2).getY();
        }
        long l2 = GeometristNative.jni_ComputeConvexHullPoints(dArray, dArray2, n2);
        Geometry geometry = null;
        if (l2 != 0L) {
            geometry = Geometry.createInstance(l2);
        }
        return (GeoRegion)geometry;
    }

    public static GeoRegion computeConvexHull(Geometry geometry) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeometristNative.jni_ComputeConvexHull(geometry.getHandle());
        Geometry geometry2 = null;
        geometry2 = l2 != 0L ? Geometry.createInstance(l2) : Geometry.createInstance(geometry.getType());
        return (GeoRegion)geometry2;
    }

    public static boolean splitRegion(GeoRegion geoRegion, Geometry geometry, GeoRegion geoRegion2, GeoRegion geoRegion3) {
        if (geoRegion == null || geoRegion.getHandle() == 0L) {
            String string = E.a("soureRegion", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("splitGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRegion2 == null || geoRegion2.getHandle() == 0L) {
            String string = E.a("targetGeoRegion1", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geoRegion3 == null || geoRegion3.getHandle() == 0L) {
            String string = E.a("targetGeoRegion2", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geoRegion, GeometryType.GEOREGION)) {
            String string = E.a("soureRegion", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("splitGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geoRegion2, GeometryType.GEOREGION)) {
            String string = E.a("targetGeoRegion1", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geoRegion3, GeometryType.GEOREGION)) {
            String string = E.a("targetGeoRegion2", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType().equals(GeometryType.GEOPOINT)) {
            String string = E.a("splitGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = GeometristNative.jni_SplitRegion(geoRegion.getHandle(), geometry.getHandle(), geoRegion2.getHandle(), geoRegion3.getHandle());
        if (bl) {
            geoRegion2.refrashPartsList();
            geoRegion3.refrashPartsList();
        }
        return bl;
    }

    public static GeoArc computeFillet(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4, double d2) {
        if (d2 <= 0.0) {
            String string = E.a("radius", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2D.equals(point2D2)) {
            String string = E.a("startPoint1,endPoint1", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2D3.equals(point2D4)) {
            String string = E.a("startPoint2,endPoint2", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeometristNative.jni_ComputeFillet(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), point2D4.getX(), point2D4.getY(), d2);
        Geometry geometry = null;
        if (l2 != 0L) {
            geometry = Geometry.createInstance(l2);
        }
        return (GeoArc)geometry;
    }

    public static boolean isParallel(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        if (point2D.equals(point2D2)) {
            String string = E.a("startPoint1,endPoint1", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2D3.equals(point2D4)) {
            String string = E.a("startPoint2,endPoint2", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsParallel(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), point2D4.getX(), point2D4.getY());
    }

    public static GeoLine computeParallel(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        if (point2D2.equals(point2D3)) {
            String string = E.a("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2Ds point2Ds = new Point2Ds();
        point2Ds.add(point2D2);
        point2Ds.add(point2D3);
        GeoLine geoLine = new GeoLine(point2Ds);
        if (!Geometrist.isPointOnLine(point2D, point2D2, point2D3, true)) {
            geoLine = Geometrist.computePerpendicular(point2D, point2D2, point2D3);
            geoLine.rotate(point2D, -90.0);
        }
        return geoLine;
    }

    public static GeoLine computeParallel(GeoLine geoLine, double d2) {
        if (geoLine == null || geoLine.getHandle() == 0L) {
            String string = E.a("geoLine", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = GeometristNative.jni_ComputeParallel(geoLine.getHandle(), d2);
        Geometry geometry = null;
        if (l2 != 0L) {
            geometry = Geometry.createInstance(l2);
        }
        return (GeoLine)geometry;
    }

    public static boolean isPerpendicular(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        if (point2D.equals(point2D2)) {
            String string = E.a("startPoint1,endPoint1", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2D3.equals(point2D4)) {
            String string = E.a("startPoint2,endPoint2", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsPerpendicular(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), point2D4.getX(), point2D4.getY());
    }

    public static GeoLine computePerpendicular(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        if (point2D2.equals(point2D3)) {
            String string = E.a("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        Point2Ds point2Ds = new Point2Ds();
        point2Ds.add(point2D2);
        point2Ds.add(point2D3);
        GeoLine geoLine = new GeoLine(point2Ds);
        Point2D point2D4 = Geometrist.computePerpendicularPosition(point2D, point2D2, point2D3);
        geoLine.rotate(point2D4, 90.0);
        return geoLine;
    }

    public static Point2D computePerpendicularPosition(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        if (point2D2.equals(point2D3)) {
            String string = E.a("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        GeometristNative.jni_ComputePerpendicularPosition(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), dArray);
        return new Point2D(dArray[0], dArray[1]);
    }

    public static boolean isPointOnLine(Point2D point2D, Point2D point2D2, Point2D point2D3, boolean bl) {
        if (point2D2.equals(point2D3)) {
            String string = E.a("startPoint,endPoint", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_IsPointOnLine(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), bl);
    }

    public static Point2D intersectLine(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4, boolean bl) {
        if (point2D.equals(point2D2)) {
            String string = E.a("startPoint1,endPoint1", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2D3.equals(point2D4)) {
            String string = E.a("startPoint2,endPoint2", "TwoPoints_ShouldNotBeEqual", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[2];
        boolean bl2 = GeometristNative.jni_IntersectLine(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), point2D4.getX(), point2D4.getY(), bl, dArray);
        if (bl2) {
            return new Point2D(dArray[0], dArray[1]);
        }
        return null;
    }

    public static double computeGeodesicDistance(Point2Ds point2Ds, double d2, double d3) {
        if (point2Ds.getCount() < 2) {
            String string = E.a("points", "Point2Ds_PointCountShouldMoreThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = E.a("majorAxis", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d3 <= 0.0) {
            String string = E.a("flatten", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d3 >= 1.0) {
            String string = E.a("flatten", "Global_ArgumentOutOfBounds", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[point2Ds.getCount()];
        double[] dArray2 = new double[point2Ds.getCount()];
        for (int i2 = 0; i2 < point2Ds.getCount(); ++i2) {
            dArray[i2] = point2Ds.getItem(i2).getX();
            dArray2[i2] = point2Ds.getItem(i2).getY();
        }
        return GeometristNative.jni_ComputeGeodesicDistance(dArray, dArray2, d2, d3);
    }

    public static double computeGeodesicArea(Geometry geometry, PrjCoordSys prjCoordSys) {
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("geometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (prjCoordSys == null || prjCoordSys.getHandle() == 0L) {
            String string = E.a("prjCoordSys", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType() != GeometryType.GEOREGION) {
            String string = E.a("geometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return GeometristNative.jni_ComputeGeodesicArea(geometry.getHandle(), prjCoordSys.getHandle());
    }

    public static Point2D[] intersectPolyLine(Point2Ds point2Ds, Point2Ds point2Ds2) {
        int n2 = point2Ds.getCount();
        if (n2 < 2) {
            String string = E.a("points1", "Point2Ds_PointCountShouldMoreThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n3 = point2Ds2.getCount();
        if (n3 < 2) {
            String string = E.a("points2", "Point2Ds_PointCountShouldMoreThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            dArray[i2] = point2Ds.getItem(i2).getX();
            dArray2[i2] = point2Ds.getItem(i2).getY();
        }
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        for (int i3 = 0; i3 < n3; ++i3) {
            dArray3[i3] = point2Ds2.getItem(i3).getX();
            dArray4[i3] = point2Ds2.getItem(i3).getY();
        }
        double[][] dArray5 = GeometristNative.jni_IntersectPolyLine(dArray, dArray2, n2, dArray3, dArray4, n3);
        double[] dArray6 = dArray5[0];
        double[] dArray7 = dArray5[1];
        Point2D[] point2DArray = new Point2D[dArray6.length];
        for (int i4 = 0; i4 < point2DArray.length; ++i4) {
            Point2D point2D = new Point2D();
            point2D.setX(dArray6[i4]);
            point2D.setY(dArray7[i4]);
            point2DArray[i4] = point2D;
        }
        return point2DArray;
    }

    public static Point2Ds smooth(Point2Ds point2Ds, int n2) {
        if (point2Ds == null) {
            String string = E.a("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2Ds.getCount() < 4) {
            String string = E.a("points", "Geometrist_SmoothPointsCountShouldNotSmallThanFour", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n2 < 2) {
            String string = E.a("smoothness", "Global_ArgumentShouldNotSmallerThanTwo", "data_resources");
            throw new IllegalArgumentException(string);
        }
        GeoLine geoLine = new GeoLine(point2Ds);
        InternalHandleDisposable.setIsDisposable(geoLine, false);
        long l2 = geoLine.getHandle();
        long l3 = GeometristNative.jni_Smooth(l2, n2);
        Point2Ds point2Ds2 = null;
        if (l3 != 0L) {
            GeoLine geoLine2 = new GeoLine(l3);
            int n3 = geoLine2.getPart(0).getCount();
            Point2D[] point2DArray = new Point2D[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                Point2D point2D;
                point2DArray[i2] = point2D = geoLine2.getPart(0).getItem(i2);
            }
            point2Ds2 = new Point2Ds(point2DArray);
            InternalHandleDisposable.setIsDisposable(geoLine2, true);
            geoLine2.dispose();
        }
        return point2Ds2;
    }

    public static GeoLine[] splitLine(GeoLine geoLine, Geometry geometry, double d2) {
        if (geoLine == null || geoLine.getHandle() == 0L) {
            String string = E.a("sourceLine", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry == null || geometry.getHandle() == 0L) {
            String string = E.a("splitGeometry", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geoLine, GeometryType.GEOLINE)) {
            String string = E.a("sourceLine", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geometry, GeometryType.GEOPOINT, GeometryType.GEOLINE, GeometryType.GEOREGION)) {
            String string = E.a("splitGeometry", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.getType().equals(GeometryType.GEOPOINT) && d2 <= 0.0) {
            String string = E.a("tolerance", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long[] lArray = GeometristNative.jni_SplitLine(geoLine.getHandle(), geometry.getHandle(), d2);
        if (lArray == null) {
            return null;
        }
        int n2 = lArray.length;
        GeoLine[] geoLineArray = new GeoLine[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            geoLineArray[i2] = (GeoLine)Geometry.createInstance(lArray[i2]);
        }
        return geoLineArray;
    }

    private static boolean hasAssignedGeometryTypes(Geometry geometry, GeometryType ... geometryTypeArray) {
        boolean bl = false;
        for (GeometryType geometryType : geometryTypeArray) {
            bl = bl || geometry.getType() == geometryType;
        }
        return bl;
    }

    private static boolean nearestPointToVertex(Point2D point2D, GeoLine geoLine, double[] dArray) {
        if (geoLine == null || geoLine.getHandle() == 0L) {
            String string = E.a("geoLine", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!Geometrist.hasAssignedGeometryTypes(geoLine, GeometryType.GEOLINE)) {
            String string = E.a("sourceLine", "Global_ArgumentTypeInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = GeometristNative.jni_NearestPointToVertex(point2D.getX(), point2D.getY(), geoLine.getHandle(), dArray);
        return bl;
    }

    private static double GetSpheroidDistance(Point2D point2D, Point2D point2D2) {
        double d2 = 0.0;
        d2 = GeometristNative.jni_GetSpheroidDistance(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY());
        return d2;
    }

    public static boolean isSelfIntersect(Geometry geometry) {
        if (geometry != null && geometry.getHandle() != 0L) {
            return GeometristNative.jni_IsSelfIntersect(geometry.getHandle());
        }
        return false;
    }

    static {
        Environment.LoadWrapJ();
    }
}

