/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.E;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.JoinItem;
import com.supermap.data.JoinItemsNative;
import java.util.ArrayList;

public class JoinItems
extends InternalHandleDisposable {
    private ArrayList a = null;

    public JoinItems() {
        this.a = new ArrayList();
        this.setHandle(JoinItemsNative.jni_New(), true);
    }

    public JoinItems(JoinItem[] joinItemArray) {
        if (joinItemArray == null) {
            String string = E.a("joinItems", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        this.a = new ArrayList();
        this.setHandle(JoinItemsNative.jni_New(), true);
        for (int i2 = 0; i2 < joinItemArray.length; ++i2) {
            this.add(joinItemArray[i2]);
        }
    }

    public JoinItems(JoinItems joinItems) {
        if (joinItems == null) {
            String string = E.a("joinItems", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (joinItems.getHandle() == 0L) {
            String string = E.a("joinItems", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = JoinItemsNative.jni_Clone(joinItems.getHandle());
        this.a = new ArrayList();
        this.setHandle(l2, true);
        int n2 = joinItems.getCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.add(joinItems.get(i2));
        }
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a.size();
    }

    public JoinItem get(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        return (JoinItem)this.a.get(n2);
    }

    public void set(int n2, JoinItem joinItem) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (joinItem.getHandle() == 0L) {
            String string = E.a("value", "JoinItems_SetJoinItemDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        JoinItemsNative.jni_Set(this.get(n2).getHandle(), joinItem.getHandle());
    }

    public JoinItems clone() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new JoinItems(this);
    }

    public int add(JoinItem joinItem) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (joinItem.getHandle() == 0L) {
            String string = E.a("joinItem", "JoinItems_SetJoinItemDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = JoinItemsNative.jni_Add(this.getHandle(), joinItem.getHandle());
        if (l2 != 0L) {
            JoinItem joinItem2 = new JoinItem(l2);
            this.a.add(joinItem2);
            return this.getCount() - 1;
        }
        return -1;
    }

    public int addRange(JoinItem[] joinItemArray) {
        int n2;
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n3 = 0;
        int n4 = joinItemArray.length;
        for (n2 = 0; n2 < n4; ++n2) {
            JoinItem joinItem = joinItemArray[n2];
            if (joinItem == null) {
                String string = E.a("joinItems[" + n2 + "]", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (joinItem.getHandle() != 0L) continue;
            String string = E.a("joinItems[" + n2 + "]", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            this.add(joinItemArray[n2]);
            ++n3;
        }
        return n3;
    }

    public boolean insert(int n2, JoinItem joinItem) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 > this.getCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (joinItem.getHandle() == 0L) {
            String string = E.a("insert(int index, JoinItem joinItem)", "JoinItems_SetJoinItemDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (n2 == this.getCount()) {
            return this.add(joinItem) != -1;
        }
        long l2 = JoinItemsNative.jni_Insert(this.getHandle(), n2, joinItem.getHandle());
        if (l2 == 0L) {
            return false;
        }
        JoinItem joinItem2 = new JoinItem(l2);
        this.a.add(n2, joinItem2);
        return true;
    }

    public int insertRange(int n2, JoinItem[] joinItemArray) {
        int n3;
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 > this.getCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        int n4 = joinItemArray.length;
        for (n3 = 0; n3 < n4; ++n3) {
            JoinItem joinItem = joinItemArray[n3];
            if (joinItem == null) {
                String string = E.a("joinItems[" + n3 + "]", "Global_ArgumentNull", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (joinItem.getHandle() != 0L) continue;
            String string = E.a("joinItems[" + n3 + "]", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        n3 = 0;
        boolean bl = false;
        for (int i2 = 0; i2 < n4; ++i2) {
            bl = this.insert(n2 + n3, joinItemArray[i2]);
            if (!bl) continue;
            ++n3;
        }
        return n3;
    }

    public boolean remove(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        JoinItemsNative.jni_Remove(this.getHandle(), n2);
        JoinItem joinItem = this.get(n2);
        joinItem.clearHandle();
        this.a.remove(n2);
        return true;
    }

    public int removeRange(int n2, int n3) {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.getCount()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (n3 < 0 || n3 > this.getCount() - n2) {
            String string = E.a("count", "JoinItems_RemoveRangeCountInvalid", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n4 = 0;
        boolean bl = false;
        for (int i2 = n2 + n3 - 1; i2 >= n2; --i2) {
            try {
                bl = this.remove(i2);
                if (!bl) continue;
                ++n4;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n4;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = this.getCount();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            this.remove(i2);
        }
    }

    public JoinItem[] toArray() {
        if (this.getHandle() == 0L) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = this.a.size();
        JoinItem[] joinItemArray = new JoinItem[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            joinItemArray[i2] = new JoinItem(this.get(i2));
        }
        return joinItemArray;
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (super.getHandle() != 0L) {
            JoinItemsNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    @Override
    protected void clearHandle() {
        if (this.a != null) {
            int n2 = this.a.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                JoinItem joinItem = this.get(i2);
                joinItem.clearHandle();
            }
            this.a.clear();
            this.a = null;
        }
        this.setHandle(0L);
    }
}

