/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.E;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.ProjectionNative;
import com.supermap.data.ProjectionType;

public class Projection
extends InternalHandleDisposable {
    public Projection() {
        long l2 = ProjectionNative.jni_New();
        this.setHandle(l2, true);
    }

    public Projection(ProjectionType projectionType) {
        if (projectionType == null) {
            String string = E.a("type", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = Enum.internalGetUGCValue(projectionType);
        long l2 = ProjectionNative.jni_New2(n2);
        this.setHandle(l2, true);
    }

    public Projection(Projection projection) {
        if (projection == null || projection.getHandle() == 0L) {
            String string = E.a("projection", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = ProjectionNative.jni_Clone(projection.getHandle());
        this.setHandle(l2, true);
    }

    Projection(long l2, boolean bl) {
        this.setHandle(l2, bl);
    }

    public Projection clone() {
        if (this.getHandle() == 0L) {
            String string = E.a("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new Projection(this);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            ProjectionNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = E.a("getName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ProjectionNative.jni_GetName(this.getHandle());
    }

    public ProjectionType getType() {
        if (this.getHandle() == 0L) {
            String string = E.a("getType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = ProjectionNative.jni_GetType(this.getHandle());
        return (ProjectionType)Enum.parseUGCValue(ProjectionType.class, n2);
    }

    public void setType(ProjectionType projectionType) {
        if (this.getHandle() == 0L) {
            String string = E.a("setType(ProjectionType value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (projectionType == null) {
            String string = E.a("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = Enum.internalGetUGCValue(projectionType);
        ProjectionNative.jni_SetType(this.getHandle(), n2);
    }

    public boolean fromXML(String string) {
        if (this.getHandle() == 0L) {
            String string2 = E.a("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        if (string != null && string.trim().length() != 0) {
            bl = ProjectionNative.jni_FromXML(this.getHandle(), string);
        }
        return bl;
    }

    public String toXML() {
        if (this.getHandle() == 0L) {
            String string = E.a("toXML()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return ProjectionNative.jni_ToXML(this.getHandle());
    }
}

