/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import android.util.Log;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.Datasource;
import com.supermap.data.E;
import com.supermap.data.EngineType;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.H;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.QueryParameter;
import com.supermap.data.RecordsetNative;
import com.supermap.data.Rectangle2D;
import com.supermap.data.SpatialQueryMode;
import com.supermap.data.StatisticMode;
import com.supermap.data.SteppedEvent;
import com.supermap.data.SteppedListener;
import com.supermap.data.Toolkit;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Recordset
extends InternalHandleDisposable {
    private DatasetVector a;
    private Object a;
    private SpatialQueryMode a;
    private BatchEditor a;
    private boolean a;
    private int a;
    private boolean b;
    private FieldInfos a;
    private boolean[] a;
    transient Vector a = new boolean[]{false};
    protected long m_selfEventHandle;

    protected Recordset() {
    }

    Recordset(long l2, DatasetVector datasetVector) {
        this.setHandle(l2, true);
        this.a = datasetVector;
        this.b = RecordsetNative.jni_IsCursorTypeStatic(this.getHandle());
        this.a = new FieldInfos(RecordsetNative.jni_GetFieldInfos(this.getHandle()));
        this.a = this.a.getCount();
    }

    public Rectangle2D getBounds() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[4];
        RecordsetNative.jni_GetBounds(this.getHandle(), dArray);
        Rectangle2D rectangle2D = new Rectangle2D(dArray[0], dArray[1], dArray[2], dArray[3]);
        return rectangle2D;
    }

    public DatasetVector getDataset() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public QueryParameter getQueryParameter() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l2 = RecordsetNative.jni_GetQueryParameter(this.getHandle());
        QueryParameter queryParameter = new QueryParameter(l2, this.a, this.a);
        queryParameter.setIsDisposable(true);
        return queryParameter;
    }

    public FieldInfos getFieldInfos() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new FieldInfos(this.a);
    }

    public int getFieldCount() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.a = RecordsetNative.jni_GetFieldCount(this.getHandle());
        return this.a;
    }

    public boolean isClosed() {
        boolean bl = false;
        bl = this.a != null ? this.getHandle() == 0L || this.a.getHandle() == 0L || !this.a.isOpen() : true;
        if (bl) {
            this.setHandle(0L);
        }
        return bl;
    }

    public boolean isBOF() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetIsBOF(this.getHandle());
    }

    public boolean isEOF() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetIsEOF(this.getHandle());
    }

    public boolean isEmpty() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetIsEmpty(this.getHandle());
    }

    public boolean isReadOnly() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.b || this.a.isReadOnly();
    }

    public int getRecordCount() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetRecordCount(this.getHandle());
    }

    public boolean addNew(Geometry geometry) {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = E.a("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            this.enableEditBulk(true);
        }
        Geometry geometry2 = geometry;
        boolean bl = false;
        if (!this.a) {
            if (geometry2 == null) {
                if (this.a.getType() == DatasetType.TABULAR) {
                    bl = RecordsetNative.jni_AddNew(this.getHandle(), 0L);
                }
            } else {
                long l2 = geometry2.getHandle();
                if (l2 == 0L) {
                    String string = E.a("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                if (geometry2.isEmpty()) {
                    String string = E.a("geometry", "Recordset_GeometryIsEmpty", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                if (this.a.getType() != DatasetType.TABULAR) {
                    bl = RecordsetNative.jni_AddNew(this.getHandle(), l2);
                }
            }
        } else if (geometry2 == null) {
            if (this.a.getType() == DatasetType.TABULAR) {
                bl = RecordsetNative.jni_AddNew1(this.getHandle(), 0L);
            }
        } else {
            long l3 = geometry2.getHandle();
            if (l3 == 0L) {
                String string = E.a("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry2.isEmpty()) {
                String string = E.a("geometry", "Recordset_GeometryIsEmpty", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (this.a.getType() != DatasetType.TABULAR) {
                bl = RecordsetNative.jni_AddNew1(this.getHandle(), l3);
            }
        }
        this.makeSureNativeObjectLive(geometry2);
        return bl;
    }

    public boolean addNew(Geometry geometry, Map<String, Object> map) {
        long l2;
        int n2;
        if (map == null) {
            return this.addNew(geometry);
        }
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = E.a("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        Geometry geometry2 = geometry;
        Object[] objectArray = map.keySet().toArray();
        int n3 = objectArray.length;
        String[] stringArray = new String[n3];
        long[] lArray = new long[n3];
        H[] hArray = new H[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = (String)objectArray[n2];
            if (stringArray[n2].equalsIgnoreCase("smid")) {
                String string = E.a("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (map.get(stringArray[n2]) != null) {
                if (!H.a(map.get(stringArray[n2]))) {
                    String string = E.a("value", "Global_ArgumentTypeInvalid", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                hArray[n2] = new H(map.get(stringArray[n2]));
            } else {
                hArray[n2] = new H();
            }
            hArray[n2].setIsDisposable(false);
            lArray[n2] = hArray[n2].getHandle();
        }
        n2 = 0;
        if (!this.a) {
            if (geometry2 == null) {
                if (this.a.getType() == DatasetType.TABULAR) {
                    n2 = RecordsetNative.jni_AddNew2(this.getHandle(), 0L, stringArray, lArray) ? 1 : 0;
                }
            } else {
                l2 = geometry2.getHandle();
                if (l2 == 0L) {
                    String string = E.a("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                if (geometry2.isEmpty()) {
                    String string = E.a("geometry", "Recordset_GeometryIsEmpty", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                if (this.a.getType() != DatasetType.TABULAR) {
                    n2 = RecordsetNative.jni_AddNew2(this.getHandle(), l2, stringArray, lArray) ? 1 : 0;
                }
            }
        } else if (geometry2 == null) {
            if (this.a.getType() == DatasetType.TABULAR) {
                n2 = RecordsetNative.jni_AddNew3(this.getHandle(), 0L, stringArray, lArray) ? 1 : 0;
            }
        } else {
            l2 = geometry2.getHandle();
            if (l2 == 0L) {
                String string = E.a("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (geometry2.isEmpty()) {
                String string = E.a("geometry", "Recordset_GeometryIsEmpty", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (this.a.getType() != DatasetType.TABULAR) {
                n2 = RecordsetNative.jni_AddNew3(this.getHandle(), l2, stringArray, lArray) ? 1 : 0;
            }
        }
        for (int i2 = 0; i2 < hArray.length; ++i2) {
            hArray[i2].setIsDisposable(true);
            hArray[i2].dispose();
            hArray[i2] = null;
        }
        this.makeSureNativeObjectLive(geometry2);
        return n2 != 0;
    }

    public boolean edit() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = E.a("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_Edit(this.getHandle());
    }

    public boolean update() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = E.a("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a) {
            String string = E.a("", "Recordset_BatchEditorIsBeginning", "data_resources");
            throw new IllegalStateException(string);
        }
        this.enableEditBulk(false);
        boolean bl = RecordsetNative.jni_Update(this.getHandle());
        return bl;
    }

    public boolean cancelUpdate() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = E.a("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_CancelUpdate(this.getHandle());
    }

    public void close() {
        if (!this.isClosed()) {
            RecordsetNative.jni_Close(this.getHandle());
            this.clearHandle();
            if (this.a != null) {
                this.a.setIsDisposable(true);
                this.a.dispose();
                this.a = null;
            }
        }
    }

    public boolean delete() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = E.a("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_Delete(this.getHandle());
    }

    public boolean deleteAll() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = E.a("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_DeleteAll(this.getHandle());
    }

    private void checkExceptionForGetFieldValueByIndex(int n2) {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.a) {
            String string = E.a("" + n2, "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
    }

    public Object getFieldValue(int n2) {
        this.checkExceptionForGetFieldValueByIndex(n2);
        FieldType fieldType = this.a.get(n2).getType();
        if (fieldType.equals(FieldType.INT32)) {
            Integer n3 = this.getInt32(n2);
            if (this.a[0]) {
                return null;
            }
            return n3;
        }
        if (fieldType.equals(FieldType.INT64)) {
            Long l2 = this.getInt64(n2);
            if (this.a[0]) {
                return null;
            }
            return l2;
        }
        if (fieldType.equals(FieldType.INT16)) {
            Short s2 = this.getInt16(n2);
            if (this.a[0]) {
                return null;
            }
            return s2;
        }
        if (fieldType.equals(FieldType.BOOLEAN)) {
            Boolean bl = this.getBoolean(n2);
            if (this.a[0]) {
                return null;
            }
            return bl;
        }
        if (fieldType.equals(FieldType.BYTE)) {
            Byte by = this.getByte(n2);
            if (this.a[0]) {
                return null;
            }
            return by;
        }
        if (fieldType.equals(FieldType.CHAR)) {
            String string = this.getString(n2);
            if (this.a[0]) {
                return null;
            }
            return string;
        }
        if (fieldType.equals(FieldType.DATETIME)) {
            Date date = this.getDateTime(n2);
            if (this.a[0]) {
                return null;
            }
            return date;
        }
        if (fieldType.equals(FieldType.DOUBLE)) {
            Double d2 = this.getDouble(n2);
            if (this.a[0]) {
                return null;
            }
            return d2;
        }
        if (fieldType.equals(FieldType.LONGBINARY)) {
            byte[] byArray = this.getLongBinary(n2);
            if (this.a[0]) {
                return null;
            }
            return byArray;
        }
        if (fieldType.equals(FieldType.SINGLE)) {
            Float f2 = Float.valueOf(this.getSingle(n2));
            if (this.a[0]) {
                return null;
            }
            return f2;
        }
        if (fieldType.equals(FieldType.TEXT)) {
            String string = this.getString(n2);
            if (this.a[0]) {
                return null;
            }
            return string;
        }
        return null;
    }

    public int getInt32(int n2) {
        this.checkExceptionForGetFieldValueByIndex(n2);
        int n3 = RecordsetNative.jni_GetFieldValueIntByIndex(this.getHandle(), n2, this.a);
        return n3;
    }

    public int getInt32(String string) {
        return this.getInt32(this.a.indexOf(string));
    }

    public short getInt16(int n2) {
        this.checkExceptionForGetFieldValueByIndex(n2);
        short s2 = RecordsetNative.jni_GetFieldValueShortByIndex(this.getHandle(), n2, this.a);
        return s2;
    }

    public short getInt16(String string) {
        return this.getInt16(this.a.indexOf(string));
    }

    public long getInt64(int n2) {
        this.checkExceptionForGetFieldValueByIndex(n2);
        long l2 = RecordsetNative.jni_GetFieldValueLongByIndex(this.getHandle(), n2, this.a);
        return l2;
    }

    public long getInt64(String string) {
        return this.getInt64(this.a.indexOf(string));
    }

    public boolean getBoolean(int n2) {
        this.checkExceptionForGetFieldValueByIndex(n2);
        boolean bl = RecordsetNative.jni_GetFieldValueBooleanByIndex(this.getHandle(), n2, this.a);
        return bl;
    }

    public boolean getBoolean(String string) {
        return this.getBoolean(this.a.indexOf(string));
    }

    public String getString(int n2) {
        this.checkExceptionForGetFieldValueByIndex(n2);
        String string = RecordsetNative.jni_GetFieldValueTextByIndex(this.getHandle(), n2, this.a);
        return string;
    }

    public String getString(String string) {
        return this.getString(this.a.indexOf(string));
    }

    public Date getDateTime(int n2) {
        this.checkExceptionForGetFieldValueByIndex(n2);
        Date date = this.getFieldValueDateTimeByIndex(n2, this.a);
        return date;
    }

    public Date getDateTime(String string) {
        int n2 = this.a.indexOf(string);
        return this.getDateTime(n2);
    }

    Date getFieldValueDateTimeByIndex(int n2, boolean[] blArray) {
        Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
        String string = RecordsetNative.jni_GetFieldValueDateByIndex(this.getHandle(), n2, blArray);
        if (string == null) {
            return null;
        }
        Date date = null;
        String string2 = System.getProperty("os.name").toLowerCase();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            try {
                SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd");
                date = simpleDateFormat2.parse(string);
            }
            catch (ParseException parseException2) {
                // empty catch block
            }
        }
        return date;
    }

    public double getDouble(int n2) {
        this.checkExceptionForGetFieldValueByIndex(n2);
        double d2 = RecordsetNative.jni_GetFieldValueDoubleByIndex(this.getHandle(), n2, this.a);
        return d2;
    }

    public double getDouble(String string) {
        int n2 = this.a.indexOf(string);
        return this.getDouble(n2);
    }

    public float getSingle(int n2) {
        this.checkExceptionForGetFieldValueByIndex(n2);
        float f2 = RecordsetNative.jni_GetFieldValueFloatByIndex(this.getHandle(), n2, this.a);
        return f2;
    }

    public float getSingle(String string) {
        int n2 = this.a.indexOf(string);
        return this.getSingle(n2);
    }

    public byte getByte(int n2) {
        this.checkExceptionForGetFieldValueByIndex(n2);
        byte by = RecordsetNative.jni_GetFieldValueByteByIndex(this.getHandle(), n2, this.a);
        return by;
    }

    public byte getByte(String string) {
        int n2 = this.a.indexOf(string);
        return this.getByte(n2);
    }

    public byte[] getLongBinary(int n2) {
        this.checkExceptionForGetFieldValueByIndex(n2);
        byte[] byArray = RecordsetNative.jni_GetFieldValueLongBinaryByIndex(this.getHandle(), n2, this.a);
        return byArray;
    }

    public byte[] getLongBinary(String string) {
        int n2 = this.a.indexOf(string);
        return this.getLongBinary(n2);
    }

    private void checkExceptionForGetFieldValueByName(String string) {
        if (this.isClosed()) {
            String string2 = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = E.a("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
    }

    public Object getFieldValue(String string) {
        this.checkExceptionForGetFieldValueByName(string);
        int n2 = this.a.indexOf(string);
        if (n2 < 0) {
            String string2 = E.a(string, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        return this.getFieldValue(n2);
    }

    public Geometry getGeometry() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        long l2 = RecordsetNative.jni_GetGeometry(this.getHandle());
        if (l2 == 0L) {
            return null;
        }
        Geometry geometry = Geometry.createInstance2(l2, this.getDataset().getDatasource().getWorkspace());
        if (geometry != null) {
            geometry.setIsDisposable(true);
        }
        return geometry;
    }

    public int getID() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_GetID(this.getHandle());
    }

    public boolean move(int n2) {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_Move(this.getHandle(), n2);
    }

    public boolean moveFirst() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_MoveFirst(this.getHandle());
    }

    public boolean moveLast() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_MoveLast(this.getHandle());
    }

    public boolean moveNext() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_MoveNext(this.getHandle());
    }

    public boolean movePrev() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_MovePrev(this.getHandle());
    }

    public boolean moveTo(int n2) {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_MoveTo(this.getHandle(), n2);
    }

    public boolean refresh() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_Refresh(this.getHandle());
    }

    public boolean seekID(int n2) {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        bl = n2 < 0 ? false : RecordsetNative.jni_SeekID(this.getHandle(), n2);
        return bl;
    }

    private void enableEditBulk(boolean bl) {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        DatasetVector datasetVector = this.getDataset();
        Datasource datasource = datasetVector.getDatasource();
        if (datasource.getDatasets().contains(datasetVector.getName() + "_Table")) {
            RecordsetNative.jni_SetEditBulk(this.getHandle(), bl);
        }
    }

    private void checkExcepitonForSetFieldValueByIndex(int n2) {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = E.a("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.a) {
            String string = E.a("" + n2, "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
    }

    public boolean setFieldValue(int n2, Object object) {
        this.checkExcepitonForSetFieldValueByIndex(n2);
        if (this.a.get(n2).isSystemField()) {
            String string = E.a("index", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        bl = object == null ? this.setFieldValueNull(n2) : this.setFieldValue(this.a.get(n2).getName(), object);
        return bl;
    }

    private void checkExceptionForSetFieldValueByName(String string) {
        if (this.isClosed()) {
            String string2 = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.isReadOnly()) {
            String string3 = E.a("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = E.a("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
    }

    public boolean setFieldValue(String string, Object object) {
        FieldInfo fieldInfo = this.a.get(string);
        if (fieldInfo == null) {
            String string2 = E.a(string, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string2);
        }
        if (fieldInfo.isSystemField()) {
            String string3 = E.a("name", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        boolean bl = false;
        FieldType fieldType = fieldInfo.getType();
        if (object == null) {
            bl = this.setFieldValueNull(string);
        } else {
            String string4 = object.toString();
            if (fieldType.equals(FieldType.BOOLEAN)) {
                bl = this.setBoolean(string, (boolean)((Boolean)object));
            } else if (fieldType.equals(FieldType.BYTE)) {
                bl = this.setByte(string, (byte)((Byte)object));
            } else if (fieldType.equals(FieldType.CHAR)) {
                bl = this.setFieldValueChar(string, (String)object);
            } else if (fieldType.equals(FieldType.DATETIME)) {
                Date date = null;
                if (object instanceof String) {
                    String string5;
                    Pattern pattern = Pattern.compile("^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))(\\s(((0?[0-9])|([1-2][0-3]))\\:([0-5]?[0-9])((\\s)|(\\:([0-5]?[0-9])))))?$");
                    if (pattern.matcher(string5 = (String)object).matches()) {
                        String string6 = System.getProperty("os.name").toLowerCase();
                        if (string6.equals("aix")) {
                            try {
                                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                                date = simpleDateFormat.parse(string5);
                            }
                            catch (ParseException parseException) {
                                try {
                                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                                    date = simpleDateFormat.parse(string5);
                                }
                                catch (ParseException parseException2) {}
                            }
                        } else {
                            try {
                                date = DateFormat.getDateInstance().parse(string5);
                            }
                            catch (ParseException parseException) {}
                        }
                    }
                } else {
                    date = (Date)object;
                }
                bl = this.setDateTime(string, date);
            } else {
                bl = fieldType.equals(FieldType.DOUBLE) ? (string4.length() == 0 ? this.setDouble(string, 0.0) : this.setDouble(string, (double)Double.valueOf(string4))) : (fieldType.equals(FieldType.INT16) ? (string4.length() == 0 ? this.setDouble(string, 0.0) : this.setInt16(string, (short)Short.valueOf(string4))) : (fieldType.equals(FieldType.INT32) ? (string4.length() == 0 ? this.setDouble(string, 0.0) : this.setInt32(string, (int)Integer.valueOf(string4))) : (fieldType.equals(FieldType.INT64) ? (string4.length() == 0 ? this.setDouble(string, 0.0) : this.setInt64(string, (long)Long.valueOf(string4))) : (fieldType.equals(FieldType.LONGBINARY) ? (string4.length() == 0 ? this.setDouble(string, 0.0) : this.setLongBinary(string, (byte[])object)) : (fieldType.equals(FieldType.SINGLE) ? (string4.length() == 0 ? this.setDouble(string, 0.0) : this.setSingle(string, Float.valueOf(string4).floatValue())) : (fieldType.equals(FieldType.TEXT) ? (string4.length() == 0 && !fieldInfo.isZeroLengthAllowed() ? false : this.setString(string, String.valueOf(string4))) : false))))));
            }
        }
        return bl;
    }

    public boolean setByte(int n2, byte by) {
        this.checkExcepitonForSetFieldValueByIndex(n2);
        String string = this.a.get(n2).getName();
        return this.setByte(string, by);
    }

    public boolean setByte(String string, byte by) {
        this.checkExceptionForSetFieldValueByName(string);
        return RecordsetNative.jni_setFieldValueByteByName(this.getHandle(), string, by);
    }

    public boolean setInt32(String string, int n2) {
        this.checkExceptionForSetFieldValueByName(string);
        return RecordsetNative.jni_setFieldValueIntByName(this.getHandle(), string, n2);
    }

    public boolean setInt32(int n2, int n3) {
        this.checkExcepitonForSetFieldValueByIndex(n2);
        String string = this.a.get(n2).getName();
        return RecordsetNative.jni_setFieldValueIntByName(this.getHandle(), string, n3);
    }

    public boolean setInt16(String string, short s2) {
        this.checkExceptionForSetFieldValueByName(string);
        return RecordsetNative.jni_setFieldValueShortByName2(this.getHandle(), string, s2);
    }

    public boolean setInt16(int n2, short s2) {
        this.checkExcepitonForSetFieldValueByIndex(n2);
        String string = this.a.get(n2).getName();
        return RecordsetNative.jni_setFieldValueShortByName2(this.getHandle(), string, s2);
    }

    public boolean setInt64(String string, long l2) {
        this.checkExceptionForSetFieldValueByName(string);
        return RecordsetNative.jni_setFieldValueLongByName(this.getHandle(), string, l2);
    }

    public boolean setInt64(int n2, long l2) {
        this.checkExcepitonForSetFieldValueByIndex(n2);
        String string = this.a.get(n2).getName();
        return RecordsetNative.jni_setFieldValueLongByName(this.getHandle(), string, l2);
    }

    public boolean setDouble(String string, double d2) {
        this.checkExceptionForSetFieldValueByName(string);
        return RecordsetNative.jni_setFieldValueDoubleByName(this.getHandle(), string, d2);
    }

    public boolean setDouble(int n2, double d2) {
        this.checkExcepitonForSetFieldValueByIndex(n2);
        String string = this.a.get(n2).getName();
        return RecordsetNative.jni_setFieldValueDoubleByName(this.getHandle(), string, d2);
    }

    public boolean setSingle(String string, float f2) {
        this.checkExceptionForSetFieldValueByName(string);
        return RecordsetNative.jni_setFieldValueFloatByname(this.getHandle(), string, f2);
    }

    public boolean setSingle(int n2, float f2) {
        this.checkExcepitonForSetFieldValueByIndex(n2);
        String string = this.a.get(n2).getName();
        return RecordsetNative.jni_setFieldValueFloatByname(this.getHandle(), string, f2);
    }

    public boolean setBoolean(String string, boolean bl) {
        this.checkExceptionForGetFieldValueByName(string);
        return RecordsetNative.jni_setFieldValueBooleanByName(this.getHandle(), string, bl);
    }

    public boolean setBoolean(int n2, boolean bl) {
        this.checkExcepitonForSetFieldValueByIndex(n2);
        String string = this.a.get(n2).getName();
        return RecordsetNative.jni_setFieldValueBooleanByName(this.getHandle(), string, bl);
    }

    private boolean setFieldValueChar(String string, String string2) {
        return RecordsetNative.jni_setFieldValueCharByName(this.getHandle(), string, string2);
    }

    public boolean setString(String string, String string2) {
        this.checkExceptionForSetFieldValueByName(string);
        return RecordsetNative.jni_setFieldValueTextByName(this.getHandle(), string, string2);
    }

    public boolean setString(int n2, String string) {
        this.checkExcepitonForSetFieldValueByIndex(n2);
        String string2 = this.a.get(n2).getName();
        return RecordsetNative.jni_setFieldValueTextByName(this.getHandle(), string2, string);
    }

    public boolean setLongBinary(String string, byte[] byArray) {
        this.checkExceptionForSetFieldValueByName(string);
        return RecordsetNative.jni_setFieldValueLongBinaryByName(this.getHandle(), string, byArray);
    }

    public boolean setLongBinary(int n2, byte[] byArray) {
        this.checkExcepitonForSetFieldValueByIndex(n2);
        String string = this.a.get(n2).getName();
        return RecordsetNative.jni_setFieldValueLongBinaryByName(this.getHandle(), string, byArray);
    }

    public boolean setDateTime(String string, Date date) {
        this.checkExceptionForSetFieldValueByName(string);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(Locale.getDefault());
        gregorianCalendar.setTime(date);
        int n2 = gregorianCalendar.get(1);
        int n3 = gregorianCalendar.get(2) + 1;
        int n4 = gregorianCalendar.get(5);
        int n5 = gregorianCalendar.get(11);
        int n6 = gregorianCalendar.get(12);
        int n7 = gregorianCalendar.get(13);
        return RecordsetNative.jni_setFieldValueDateTimeByName(this.getHandle(), string, n2, n3, n4, n5, n6, n7);
    }

    public boolean setDateTime(int n2, Date date) {
        this.checkExcepitonForSetFieldValueByIndex(n2);
        String string = this.a.get(n2).getName();
        return this.setDateTime(string, date);
    }

    public boolean setFieldValueNull(int n2) {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = E.a("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.a) {
            String string = E.a("" + n2, "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (this.a.get(n2).isSystemField()) {
            String string = E.a("index", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.a.get(n2).isRequired()) {
            String string = E.a("", "Recordset_RequiredFieldShouldNotBeNull", "data_resources");
            throw new IllegalStateException(string);
        }
        return RecordsetNative.jni_SetFieldValueNullByIndex(this.getHandle(), n2);
    }

    public boolean setFieldValueNull(String string) {
        if (this.isClosed()) {
            String string2 = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (this.isReadOnly()) {
            String string3 = E.a("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = E.a("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string4);
        }
        int n2 = RecordsetNative.jni_GetFieldIndex(this.getHandle(), string);
        if (n2 < 0) {
            String string5 = E.a(string, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        if (this.a.get(n2).isSystemField()) {
            String string6 = E.a("name", "Recordset_SystemFieldIsReadOnly", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        if (this.a.get(n2).isRequired()) {
            String string7 = E.a("", "Recordset_RequiredFieldShouldNotBeNull", "data_resources");
            throw new IllegalStateException(string7);
        }
        return RecordsetNative.jni_SetFieldValueNullByName(this.getHandle(), string);
    }

    public boolean setGeometry(Geometry geometry) {
        GeometryType geometryType;
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = E.a("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = E.a("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (geometry.getHandle() == 0L) {
            String string = E.a("geometry", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        DatasetType datasetType = this.getDataset().getType();
        if (!Recordset.checkDatasetAndGeometryType(datasetType, geometryType = geometry.getType())) {
            String string = E.a("geometry", "Recordset_DatasetTypeAndGeometryTypeIsDifferent", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (geometry.isEmpty()) {
            String string = E.a("geometry", "Recordset_GeometryIsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return RecordsetNative.jni_SetGeometry(this.getHandle(), geometry.getHandle());
    }

    public double statistic(int n2, StatisticMode statisticMode) {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.a) {
            String string = E.a("fieldIndex", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        if (statisticMode == null) {
            String string = E.a("mode", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        FieldType fieldType = this.a.get(n2).getType();
        if (fieldType != FieldType.BOOLEAN && fieldType != FieldType.BYTE && fieldType != FieldType.DOUBLE && fieldType != FieldType.SINGLE && fieldType != FieldType.INT16 && fieldType != FieldType.INT32) {
            String string = E.a("FieldType", "Recordset_StatisticUnsupprotFieldType", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return RecordsetNative.jni_StatisticByIndex(this.getHandle(), n2, statisticMode.getUGCValue());
    }

    public double statistic(String string, StatisticMode statisticMode) {
        if (this.isClosed()) {
            String string2 = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = E.a("name", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        if (statisticMode == null) {
            String string4 = E.a("mode", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string4);
        }
        int n2 = RecordsetNative.jni_GetFieldIndex(this.getHandle(), string);
        if (n2 < 0) {
            String string5 = E.a(string, "Recordset_FieldIsNotExsit", "data_resources");
            throw new IllegalArgumentException(string5);
        }
        FieldType fieldType = this.a.get(n2).getType();
        if (fieldType != FieldType.BOOLEAN && fieldType != FieldType.BYTE && fieldType != FieldType.DOUBLE && fieldType != FieldType.SINGLE && fieldType != FieldType.INT16 && fieldType != FieldType.INT32) {
            String string6 = E.a("FieldType", "Recordset_StatisticUnsupprotFieldType", "data_resources");
            throw new IllegalArgumentException(string6);
        }
        return RecordsetNative.jni_StatisticByName(this.getHandle(), string, statisticMode.getUGCValue());
    }

    @Override
    public void dispose() {
        if (!super.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            this.close();
        }
    }

    public BatchEditor getBatch() {
        if (this.getHandle() == 0L) {
            String string = E.a("GetBatchEdit()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null) {
            this.a = new BatchEditor(this.getHandle());
        }
        return this.a;
    }

    void setQueryParameter(QueryParameter queryParameter) {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (queryParameter.getHandle() == 0L) {
            String string = E.a("queryParameter", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (queryParameter.getSpatialQueryObject() != null) {
            this.a = queryParameter.getSpatialQueryObject();
            this.a = queryParameter.getSpatialQueryMode();
        }
        RecordsetNative.jni_SetQueryParameter(this.getHandle(), queryParameter.getHandle());
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
        this.a = null;
        this.a = null;
        this.a = null;
    }

    protected static Recordset createInstance(long l2, DatasetVector datasetVector) {
        return new Recordset(l2, datasetVector);
    }

    static boolean checkDatasetAndGeometryType(DatasetType datasetType, GeometryType geometryType) {
        boolean bl = false;
        if (datasetType != null && geometryType != null) {
            if (datasetType == DatasetType.CAD) {
                bl = true;
            }
            if (datasetType == DatasetType.POINT && geometryType == GeometryType.GEOPOINT || datasetType == DatasetType.LINE && geometryType == GeometryType.GEOLINE || datasetType == DatasetType.REGION && geometryType == GeometryType.GEOREGION || datasetType == DatasetType.TEXT && geometryType == GeometryType.GEOTEXT) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean wasNull() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a[0];
    }

    public boolean setValues(Map<String, Object> map) {
        int n2;
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = E.a("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.a) {
            int n3 = 0;
            Set<Map.Entry<String, Object>> set = map.entrySet();
            for (Map.Entry<String, Object> entry : set) {
                String string = entry.getKey();
                int n4 = this.a.indexOf(string);
                if (n4 == -1) continue;
                Object object = entry.getValue();
                this.setFieldValue(n4, object);
                ++n3;
            }
            return n3 > 0;
        }
        Object[] objectArray = map.keySet().toArray();
        int n5 = objectArray.length;
        String[] stringArray = new String[n5];
        long[] lArray = new long[n5];
        H[] hArray = new H[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            stringArray[n2] = (String)objectArray[n2];
            if (stringArray[n2].equalsIgnoreCase("smid")) {
                String string = E.a("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (map.get(stringArray[n2]) != null) {
                if (!H.a(map.get(stringArray[n2]))) {
                    String string = E.a("value", "Global_ArgumentTypeInvalid", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                hArray[n2] = new H(map.get(stringArray[n2]));
            } else {
                hArray[n2] = new H();
            }
            hArray[n2].setIsDisposable(false);
            lArray[n2] = hArray[n2].getHandle();
        }
        n2 = 0;
        n2 = RecordsetNative.jni_SetGeometry1(this.getHandle(), 0L, false, stringArray, lArray) ? 1 : 0;
        for (int i2 = 0; i2 < hArray.length; ++i2) {
            hArray[i2].setIsDisposable(true);
            hArray[i2].dispose();
            hArray[i2] = null;
        }
        return n2 != 0;
    }

    public boolean setValues(Map<String, Object> map, Geometry geometry) {
        int n2;
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = E.a("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = E.a("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (!this.a) {
            this.setGeometry(geometry);
            int n3 = 0;
            Set<Map.Entry<String, Object>> set = map.entrySet();
            for (Map.Entry<String, Object> entry : set) {
                String string = entry.getKey();
                int n4 = this.a.indexOf(string);
                if (n4 == -1) continue;
                Object object = entry.getValue();
                this.setFieldValue(n4, object);
                ++n3;
            }
            return n3 > 0;
        }
        if (!this.a.getDatasource().getConnectionInfo().getEngineType().equals(EngineType.UDB)) {
            return false;
        }
        Geometry geometry2 = geometry;
        long l2 = 0L;
        if (geometry2 != null) {
            l2 = geometry2.getHandle();
        }
        Object[] objectArray = map.keySet().toArray();
        int n5 = objectArray.length;
        String[] stringArray = new String[n5];
        long[] lArray = new long[n5];
        H[] hArray = new H[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            stringArray[n2] = (String)objectArray[n2];
            if (stringArray[n2].equalsIgnoreCase("smid")) {
                String string = E.a("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            if (map.get(stringArray[n2]) != null) {
                if (!H.a(map.get(stringArray[n2]))) {
                    String string = E.a("value", "Global_ArgumentTypeInvalid", "data_resources");
                    throw new IllegalArgumentException(string);
                }
                hArray[n2] = new H(map.get(stringArray[n2]));
            } else {
                hArray[n2] = new H();
            }
            hArray[n2].setIsDisposable(false);
            lArray[n2] = hArray[n2].getHandle();
        }
        n2 = 0;
        n2 = RecordsetNative.jni_SetGeometry1(this.getHandle(), l2, true, stringArray, lArray) ? 1 : 0;
        for (int i2 = 0; i2 < hArray.length; ++i2) {
            hArray[i2].setIsDisposable(true);
            hArray[i2].dispose();
            hArray[i2] = null;
        }
        this.makeSureNativeObjectLive(geometry2);
        return n2 != 0;
    }

    public boolean setValues(Object[] objectArray) {
        int n2;
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = E.a("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (objectArray.length != this.a) {
            String string = E.a("", "Recordset_ValuesLengthShouldEqualsFieldCount", "data_resources");
            throw new IllegalStateException(string);
        }
        if (!this.a) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                boolean bl;
                if (this.a.get(i2).isSystemField() || (bl = this.setFieldValue(i2, objectArray[i2]))) continue;
                return false;
            }
            return true;
        }
        if (!this.a.getDatasource().getConnectionInfo().getEngineType().equals(EngineType.UDB)) {
            return false;
        }
        String[] stringArray = new String[objectArray.length];
        long[] lArray = new long[objectArray.length];
        H[] hArray = new H[objectArray.length];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (this.a.get(n2).isSystemField()) continue;
            stringArray[n2] = this.a.get(n2).getName();
            if (stringArray[n2].equalsIgnoreCase("smid")) {
                String string = E.a("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            hArray[n2] = new H(objectArray[n2]);
            hArray[n2].setIsDisposable(false);
            lArray[n2] = hArray[n2].getHandle();
        }
        n2 = RecordsetNative.jni_SetGeometry1(this.getHandle(), 0L, false, stringArray, lArray) ? 1 : 0;
        for (int i3 = 0; i3 < hArray.length; ++i3) {
            hArray[i3].setIsDisposable(true);
            hArray[i3].dispose();
            hArray[i3] = null;
        }
        return n2 != 0;
    }

    public boolean setValues(Object[] objectArray, Geometry geometry) {
        int n2;
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.isReadOnly()) {
            String string = E.a("", "Recordset_RecordsetIsReadOnly", "data_resources");
            throw new IllegalStateException(string);
        }
        if (objectArray.length != this.a) {
            String string = E.a("", "Recordset_ValuesLengthShouldEqualsFieldCount", "data_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = E.a("geometry", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (!this.a) {
            this.setGeometry(geometry);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                boolean bl;
                if (this.a.get(i2).isSystemField() || (bl = this.setFieldValue(i2, objectArray[i2]))) continue;
                return false;
            }
            return true;
        }
        if (!this.a.getDatasource().getConnectionInfo().getEngineType().equals(EngineType.UDB)) {
            return false;
        }
        Geometry geometry2 = geometry;
        long l2 = geometry2.getHandle();
        String[] stringArray = new String[objectArray.length];
        long[] lArray = new long[objectArray.length];
        H[] hArray = new H[objectArray.length];
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (this.a.get(n2).isSystemField()) continue;
            stringArray[n2] = this.a.get(n2).getName();
            if (stringArray[n2].equalsIgnoreCase("smid")) {
                String string = E.a("map", "MAPCannotContainSMID", "data_resources");
                throw new IllegalArgumentException(string);
            }
            hArray[n2] = new H(objectArray[n2]);
            hArray[n2].setIsDisposable(false);
            lArray[n2] = hArray[n2].getHandle();
        }
        n2 = RecordsetNative.jni_SetGeometry1(this.getHandle(), l2, true, stringArray, lArray) ? 1 : 0;
        for (int i3 = 0; i3 < hArray.length; ++i3) {
            hArray[i3].setIsDisposable(true);
            hArray[i3].dispose();
            hArray[i3] = null;
        }
        this.makeSureNativeObjectLive(geometry2);
        return n2 != 0;
    }

    public Object[] getValues() {
        if (this.isClosed()) {
            String string = E.a("", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Object[] objectArray = new Object[this.a];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = this.getFieldValue(i2);
        }
        return objectArray;
    }

    public boolean setObject(int n2, Object object) {
        return this.setFieldValue(n2, object);
    }

    public boolean setObject(String string, Object object) {
        return this.setFieldValue(string, object);
    }

    public Object getObject(int n2) {
        return this.getFieldValue(n2);
    }

    public Object getObject(String string) {
        return this.getFieldValue(string);
    }

    private void makeSureNativeObjectLive(InternalHandleDisposable internalHandleDisposable) {
        if (internalHandleDisposable != null) {
            internalHandleDisposable.getHandle();
        }
    }

    public synchronized void addSteppedListener(SteppedListener steppedListener) {
        if (this.a == null) {
            this.a = new Vector();
        }
        if (!this.a.contains(steppedListener)) {
            this.a.add(steppedListener);
        }
    }

    public synchronized void removeSteppedListener(SteppedListener steppedListener) {
        if (this.a != null && this.a.contains(steppedListener)) {
            this.a.remove(steppedListener);
        }
    }

    protected void fireStepped(SteppedEvent steppedEvent) {
        if (this.a != null) {
            Vector vector = this.a;
            int n2 = vector.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((SteppedListener)vector.elementAt(i2)).stepped(steppedEvent);
            }
        }
    }

    static void steppedCallBack(Recordset recordset, int n2, long l2, String string, String string2, long l3) {
        if (recordset != null) {
            boolean bl = Toolkit.getHandleBooleanValue(l3);
            SteppedEvent steppedEvent = new SteppedEvent(recordset, n2, l2, string, string2, null, bl);
            recordset.fireStepped(steppedEvent);
            Toolkit.setHandleBooleanValue(l3, steppedEvent.getCancel());
        }
    }

    protected void clearSelfEventHandle() {
        if (this.m_selfEventHandle != 0L) {
            RecordsetNative.jni_DeleteSelfEventHandle(this.m_selfEventHandle);
            this.m_selfEventHandle = 0L;
        }
    }

    public boolean fromGeoJSON(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            Object object = jSONObject.get("type");
            if (object.equals("FeatureCollection")) {
                bl = this.fromFeatureCollectionGeoJSON(string);
            } else if (object.equals("Feature")) {
                bl = this.fromFeatureGeoJSON(string);
            } else if (object.equals("GeometryCollection")) {
                bl = this.fromGeometryCollectionGeoJSON(string);
            } else if (object.equals("Point") || object.equals("LineString") || object.equals("Polygon")) {
                bl = this.fromGeometryGeoJSON(string);
            } else {
                Log.e((String)"Recordset", (String)("Unsupported GeoJSON Object type: " + object));
                bl = false;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = false;
        }
        return bl;
    }

    public String toGeoJSON(boolean bl, int n2) {
        String string = null;
        if (bl) {
            if (n2 == 1) {
                string = this.toFeatureGeoJSON();
            }
            if (n2 > 1) {
                string = this.toFeatureCollectionGeoJSON(n2, -1);
            }
        } else {
            if (n2 == 1) {
                string = this.toGeometryGeoJSON();
            }
            if (n2 > 1) {
                string = this.toGeometryCollectionGeoJSON(n2, -1);
            }
        }
        return string;
    }

    String toGeoJSON(boolean bl, int n2, int n3) {
        String string = null;
        int n4 = n3 - n2;
        if (bl) {
            if (n4 == 1) {
                string = this.toFeatureGeoJSON();
            }
            if (n4 > 1) {
                string = this.toFeatureCollectionGeoJSON(n4, n3);
            }
        } else {
            if (n4 == 1) {
                string = this.toGeometryGeoJSON();
            }
            if (n4 > 1) {
                string = this.toGeometryCollectionGeoJSON(n4, n3);
            }
        }
        return string;
    }

    private boolean fromGeometryGeoJSON(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            Geometry geometry = null;
            geometry = this.getGeometryFromJSON(jSONObject);
            bl = this.addNew(geometry);
            geometry.dispose();
            geometry = null;
        }
        catch (Exception exception) {
            Log.e((String)"Recordset", (String)("The geometry is " + exception.toString()));
            return false;
        }
        bl = this.update();
        return bl;
    }

    private String toGeometryGeoJSON() {
        String string = null;
        Geometry geometry = null;
        geometry = this.getGeometry();
        if (geometry != null) {
            string = geometry.toGeoJSON();
            if (string.isEmpty()) {
                Log.e((String)"Recordset", (String)("SmID=" + this.getFieldValue("SmID").toString() + ", Unsupported geometry type: " + geometry.getType()));
            }
            geometry.dispose();
            geometry = null;
        }
        return string;
    }

    private String toGeometryCollectionGeoJSON(int n2, int n3) {
        int n4;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"type\":\"GeometryCollection\",");
        stringBuilder.append("\"geometries\":[");
        Geometry geometry = null;
        int n5 = 0;
        int n6 = n4 = n2 > 10 ? 10 : n2;
        if (n4 < 0) {
            n4 = 0;
        }
        while (!this.isEOF() && n5 < n4) {
            geometry = this.getGeometry();
            if (geometry != null) {
                String string = geometry.toGeoJSON();
                if (!string.isEmpty()) {
                    stringBuilder.append(string);
                    stringBuilder.append(",");
                } else {
                    Log.e((String)"Recordset", (String)("SmID=" + this.getFieldValue("SmID").toString() + ", Unsupported geometry type: " + geometry.getType()));
                }
                geometry.dispose();
                geometry = null;
            }
            if (n3 > 0 && this.getID() >= n3) break;
            this.moveNext();
            ++n5;
        }
        if (stringBuilder.lastIndexOf(",") == stringBuilder.length() - 1) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append("]}");
        return stringBuilder.toString();
    }

    private boolean fromGeometryCollectionGeoJSON(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        this.getBatch().begin();
        try {
            JSONObject jSONObject = new JSONObject(string);
            Object object = jSONObject.get("type");
            if (!object.equals("GeometryCollection")) {
                Log.e((String)"Recordset", (String)"Not match the type of GeometryCollection");
                return false;
            }
            JSONArray jSONArray = jSONObject.getJSONArray("geometries");
            Geometry geometry = null;
            boolean bl2 = false;
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                try {
                    geometry = this.getGeometryFromJSON((JSONObject)jSONArray.get(i2));
                }
                catch (Exception exception) {
                    Log.e((String)"Recordset", (String)("The " + i2 + "th geometry, " + exception.toString()));
                    bl = false;
                }
                if (geometry != null) {
                    bl2 = this.addNew(geometry);
                    geometry.dispose();
                    geometry = null;
                }
                bl = i2 == 0 ? bl2 : bl && bl2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.getBatch().update();
            return false;
        }
        this.getBatch().update();
        return bl;
    }

    private String toFeatureGeoJSON() {
        StringBuilder stringBuilder = new StringBuilder();
        Geometry geometry = this.getGeometry();
        if (geometry == null) {
            return null;
        }
        String string = geometry.toGeoJSON();
        geometry.dispose();
        if (string != null) {
            stringBuilder.append("{\"type\":\"Feature\",");
            stringBuilder.append("\"geometry\":");
            stringBuilder.append(string);
            stringBuilder.append(",");
            stringBuilder.append("\"properties\":{");
            int n2 = this.getFieldCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string2 = this.a.get(i2).getName();
                if (i2 == 0) {
                    string2 = "SmID";
                }
                if (this.a.get(i2).getType() == FieldType.TEXT) {
                    stringBuilder.append("\"" + string2 + "\":");
                    stringBuilder.append("\"" + this.getFieldValue(string2) + "\"");
                } else {
                    stringBuilder.append("\"" + string2 + "\":");
                    stringBuilder.append(this.getFieldValue(string2));
                }
                stringBuilder.append(",");
            }
            if (stringBuilder.lastIndexOf(",") == stringBuilder.length() - 1) {
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            }
            stringBuilder.append("}}");
            string = null;
        } else {
            Log.e((String)"Recordset", (String)("SmID=" + this.getFieldValue("SmID").toString() + ", can not get geometry."));
        }
        if (stringBuilder.toString().isEmpty()) {
            return null;
        }
        return stringBuilder.toString();
    }

    private String toFeatureCollectionGeoJSON(int n2, int n3) {
        int n4;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{\"type\":\"FeatureCollection\",");
        stringBuilder.append("\"features\":[");
        int n5 = 0;
        int n6 = n4 = n2 > 10 ? 10 : n2;
        if (n4 < 0) {
            n4 = 0;
        }
        String string = null;
        while (!this.isEOF() && n5 < n4) {
            string = this.toFeatureGeoJSON();
            if (string != null) {
                stringBuilder.append(string);
                stringBuilder.append(",");
            }
            string = null;
            if (n3 > 0 && this.getID() >= n3) break;
            this.moveNext();
            ++n5;
        }
        if (stringBuilder.lastIndexOf(",") == stringBuilder.length() - 1) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        stringBuilder.append("]}");
        if (stringBuilder.toString().isEmpty()) {
            return null;
        }
        return stringBuilder.toString();
    }

    private boolean fromFeatureGeoJSON(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        int n2 = -1;
        try {
            JSONObject jSONObject = new JSONObject(string);
            Object object = jSONObject.get("type");
            if (!object.equals("Feature")) {
                Log.e((String)"Recordset", (String)"Not match the type of Feature");
                return false;
            }
            JSONObject jSONObject2 = (JSONObject)jSONObject.get("geometry");
            JSONObject jSONObject3 = (JSONObject)jSONObject.get("properties");
            try {
                n2 = (Integer)jSONObject3.get("SmID");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                n2 = -1;
            }
            Geometry geometry = null;
            try {
                geometry = this.getGeometryFromJSON(jSONObject2);
            }
            catch (Exception exception) {
                Log.e((String)"Recordset", (String)("SMID=" + n2 + ", the geometry is " + exception.toString()));
                bl = false;
            }
            if (n2 > 0) {
                bl = this.seekID(n2);
                if (!bl) {
                    bl = this.addNew(geometry);
                } else {
                    this.edit();
                    bl = this.setGeometry(geometry);
                }
            } else {
                bl = this.addNew(geometry);
            }
            if (bl) {
                JSONArray jSONArray = jSONObject3.names();
                String string2 = null;
                int n3 = jSONArray.length();
                for (int i2 = 0; i2 < n3; ++i2) {
                    string2 = jSONArray.get(i2).toString();
                    if (this.a.indexOf(string2) <= -1 || this.a.get(string2).isSystemField()) continue;
                    this.setFieldValue(string2, jSONObject3.get(string2));
                }
                bl = this.update();
                geometry.dispose();
                geometry = null;
            } else {
                Log.e((String)"Recordset", (String)("\u6dfb\u52a0\u6216\u8bbe\u7f6egeometry\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5SmID\u548cgeometry\u7684\u503c\uff0cinput GeoJSON:" + string));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return bl;
    }

    private boolean fromFeatureCollectionGeoJSON(String string) {
        boolean bl = false;
        if (string == null) {
            return false;
        }
        try {
            JSONObject jSONObject = new JSONObject(string);
            Object object = jSONObject.get("type");
            if (!object.equals("FeatureCollection")) {
                Log.e((String)"Recordset", (String)"Not match the type of FeatureCollection");
                return false;
            }
            JSONArray jSONArray = jSONObject.getJSONArray("features");
            boolean bl2 = false;
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                bl2 = this.fromFeatureGeoJSON(jSONArray.get(i2).toString());
                bl = i2 == 0 ? bl2 : bl && bl2;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return bl;
    }

    private Geometry getGeometryFromJSON(JSONObject jSONObject) throws Exception {
        Geometry geometry = null;
        if (jSONObject != null) {
            Object object = jSONObject.get("type");
            if (object.equals("Point")) {
                geometry = new GeoPoint();
            }
            if (object.equals("LineString") || object.equals("MultiLineString")) {
                geometry = new GeoLine();
            }
            if (object.equals("Polygon")) {
                geometry = new GeoRegion();
            }
            if (geometry != null) {
                ((Geometry)geometry).fromGeoJSON(jSONObject.toString());
            } else {
                throw new Exception("Unsupported GeoJSON Object type: " + object);
            }
        }
        return geometry;
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class BatchEditor {
        private int a;
        long a = 0L;

        private BatchEditor(long l2) {
            this.a = l2;
        }

        public void begin() {
            if (this.a == 0L) {
                String string = E.a("Begin()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            boolean bl = RecordsetNative.jni_setMaxRecordCount(this.a, this.a);
            boolean bl2 = RecordsetNative.jni_begin(this.a, true);
            Recordset.this.a = true;
        }

        public void update() {
            if (this.a == 0L) {
                String string = E.a("Update()", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            boolean bl = RecordsetNative.jni_Update1(this.a);
            if (bl) {
                Recordset.this.a = false;
                RecordsetNative.jni_begin(this.a, false);
            }
        }

        public void setMaxRecordCount(int n2) {
            if (this.a == 0L) {
                String string = E.a("SetMaxRecordCount(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
                throw new IllegalStateException(string);
            }
            if (n2 < 0) {
                String string = E.a("value", "Global_ArgumentShouldNotBeNegative", "data_resources");
                throw new IllegalStateException(string);
            }
            if (Recordset.this.a) {
                String string = E.a("SetMaxRecordCount(int value)", "SetMaxRecordCount_Must_BeforeBegin", "data_resources");
                throw new IllegalStateException(string);
            }
            this.a = n2;
        }

        public int getMaxRecordCount() {
            return this.a;
        }
    }
}

