/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.E;
import com.supermap.data.Point2D;
import com.supermap.data.Size2D;
import com.supermap.data.Toolkit;

public class Rectangle2D {
    private double a;
    private double b;
    private double c;
    private double d;

    public Rectangle2D() {
        this.a = -1.7976931348623157E308;
        this.b = -1.7976931348623157E308;
        this.c = -1.7976931348623157E308;
        this.d = -1.7976931348623157E308;
    }

    public Rectangle2D(Rectangle2D rectangle2D) {
        this(rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
    }

    public Rectangle2D(Point2D point2D, double d2, double d3) {
        this.a = point2D.getX();
        this.d = point2D.getY();
        this.b = this.a + d2;
        this.c = this.d + d3;
    }

    public Rectangle2D(Point2D point2D, Point2D point2D2) {
        this.a = point2D.getX();
        this.d = point2D.getY();
        this.b = point2D2.getX();
        this.c = point2D2.getY();
    }

    public Rectangle2D(double d2, double d3, double d4, double d5) {
        this.a = d2;
        this.d = d3;
        this.b = d4;
        this.c = d5;
    }

    public Rectangle2D(Point2D point2D, Size2D size2D) {
        if (size2D.getWidth() < 0.0 || size2D.getHeight() < 0.0) {
            String string = E.a("size", "Rectangle2DWidthAndHeightShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double d2 = point2D.getX() - size2D.getWidth() / 2.0;
        double d3 = point2D.getY() - size2D.getHeight() / 2.0;
        double d4 = point2D.getX() + size2D.getWidth() / 2.0;
        double d5 = point2D.getY() + size2D.getHeight() / 2.0;
        this.a = d2;
        this.d = d3;
        this.b = d4;
        this.c = d5;
    }

    public static final Rectangle2D getEMPTY() {
        return new Rectangle2D(-1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308, -1.7976931348623157E308);
    }

    public boolean isEmpty() {
        return Toolkit.isZero(this.a - -1.7976931348623157E308, -1.0E-10, 1.0E-10) && Toolkit.isZero(this.c - -1.7976931348623157E308, -1.0E-10, 1.0E-10) && Toolkit.isZero(this.b - -1.7976931348623157E308, -1.0E-10, 1.0E-10) && Toolkit.isZero(this.d - -1.7976931348623157E308, -1.0E-10, 1.0E-10);
    }

    public Point2D getCenter() {
        Point2D point2D = new Point2D();
        point2D.setX((this.a + this.b) / 2.0);
        point2D.setY((this.c + this.d) / 2.0);
        return point2D;
    }

    public double getTop() {
        return this.c;
    }

    public void setTop(double d2) {
        this.c = d2;
    }

    public double getBottom() {
        return this.d;
    }

    public void setBottom(double d2) {
        this.d = d2;
    }

    public double getLeft() {
        return this.a;
    }

    public void setLeft(double d2) {
        this.a = d2;
    }

    public double getRight() {
        return this.b;
    }

    public void setRight(double d2) {
        this.b = d2;
    }

    public double getWidth() {
        return Math.abs(this.b - this.a);
    }

    public double getHeight() {
        return Math.abs(this.c - this.d);
    }

    public Rectangle2D clone() {
        return new Rectangle2D(this);
    }

    public static Rectangle2D ceiling(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = new Rectangle2D(Math.ceil(rectangle2D.getLeft()), Math.ceil(rectangle2D.getBottom()), Math.ceil(rectangle2D.getRight()), Math.ceil(rectangle2D.getTop()));
        return rectangle2D2;
    }

    public static Rectangle2D floor(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = new Rectangle2D(Math.floor(rectangle2D.getLeft()), Math.floor(rectangle2D.getBottom()), Math.floor(rectangle2D.getRight()), Math.floor(rectangle2D.getTop()));
        return rectangle2D2;
    }

    public static Rectangle2D round(Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = new Rectangle2D(Math.round(rectangle2D.getLeft()), Math.round(rectangle2D.getBottom()), Math.round(rectangle2D.getRight()), Math.round(rectangle2D.getTop()));
        return rectangle2D2;
    }

    public boolean contains(Point2D point2D) {
        return point2D.getX() >= this.a && point2D.getX() <= this.b && point2D.getY() <= this.c && point2D.getY() >= this.d;
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return !(!(rectangle2D.a > this.a) && !Toolkit.isZero(rectangle2D.a - this.a) || !(rectangle2D.c < this.c) && !Toolkit.isZero(rectangle2D.c - this.c) || !(rectangle2D.b < this.b) && !Toolkit.isZero(rectangle2D.b - this.b) || !(rectangle2D.d > this.d) && !Toolkit.isZero(rectangle2D.d - this.d));
    }

    public boolean contains(double d2, double d3) {
        Point2D point2D = new Point2D(d2, d3);
        return this.contains(point2D);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Rectangle2D)) {
            return false;
        }
        Rectangle2D rectangle2D = (Rectangle2D)object;
        return Toolkit.isZero(this.a - rectangle2D.getLeft()) && Toolkit.isZero(this.b - rectangle2D.getRight()) && Toolkit.isZero(this.c - rectangle2D.getTop()) && Toolkit.isZero(this.d - rectangle2D.getBottom());
    }

    public boolean equals(Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            return false;
        }
        return Toolkit.isZero(this.a - rectangle2D.getLeft()) && Toolkit.isZero(this.b - rectangle2D.getRight()) && Toolkit.isZero(this.c - rectangle2D.getTop()) && Toolkit.isZero(this.d - rectangle2D.getBottom());
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.getLeft());
        l2 += Double.doubleToLongBits(this.getBottom()) * 37L;
        l2 += Double.doubleToLongBits(this.getRight()) * 43L;
        return (int)(l2 += Double.doubleToLongBits(this.getTop()) * 47L) ^ (int)(l2 >> 32);
    }

    public void inflate(double d2, double d3) {
        this.a -= d2;
        this.b += d2;
        this.c += d3;
        this.d -= d3;
    }

    public void intersect(Rectangle2D rectangle2D) {
        if (this.hasIntersection(rectangle2D)) {
            this.a = Math.max(this.a, rectangle2D.a);
            this.c = Math.min(this.c, rectangle2D.c);
            this.b = Math.min(this.b, rectangle2D.b);
            this.d = Math.max(this.d, rectangle2D.d);
        } else {
            this.a();
        }
    }

    public boolean hasIntersection(Rectangle2D rectangle2D) {
        return this.b >= rectangle2D.a && this.a <= rectangle2D.b && this.c >= rectangle2D.d && this.d <= rectangle2D.c;
    }

    public void offset(double d2, double d3) {
        this.a += d2;
        this.b += d2;
        this.c += d3;
        this.d += d3;
    }

    public String toString() {
        return "Left=" + this.a + ",Bottom=" + this.d + ",Right=" + this.b + ",Top=" + this.c;
    }

    public void union(Rectangle2D rectangle2D) {
        this.a = Math.min(this.a, rectangle2D.getLeft());
        this.c = Math.max(this.c, rectangle2D.getTop());
        this.b = Math.max(this.b, rectangle2D.getRight());
        this.d = Math.min(this.d, rectangle2D.getBottom());
    }

    private void a() {
        this.a = -1.7976931348623157E308;
        this.b = -1.7976931348623157E308;
        this.c = -1.7976931348623157E308;
        this.d = -1.7976931348623157E308;
    }

    public String toJson() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        stringBuilder.append(" \"leftBottom\" :{ \"x\" : " + this.a + "," + " \"y\" : " + this.d + "},");
        stringBuilder.append(" \"rightTop\" : {  \"x\" : " + this.b + "," + " \"y\" : " + this.c + "}");
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

