/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.E;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point2D;
import com.supermap.data.SpatialIndexInfoNative;
import com.supermap.data.SpatialIndexType;

public class SpatialIndexInfo
extends InternalHandleDisposable {
    public SpatialIndexInfo() {
        long l2 = SpatialIndexInfoNative.jni_New();
        this.setHandle(l2, true);
    }

    public SpatialIndexInfo(SpatialIndexType spatialIndexType) {
        if (spatialIndexType == null) {
            String string = E.a("type", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l2 = SpatialIndexInfoNative.jni_New2(spatialIndexType.getUGCValue());
        this.setHandle(l2, true);
    }

    public SpatialIndexInfo(int n2) {
        long l2 = SpatialIndexInfoNative.jni_New3(n2);
        this.setHandle(l2, true);
    }

    public SpatialIndexInfo(String string) {
        long l2 = SpatialIndexInfoNative.jni_New4(string);
        this.setHandle(l2, true);
    }

    public SpatialIndexInfo(double d2, double d3) {
        if (d2 <= 0.0) {
            String string = E.a("tileWidth", "SpatialIndexInfo_TileWidthShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d3 <= 0.0) {
            String string = E.a("tileHeight", "SpatialIndexInfo_TileHeightShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = SpatialIndexInfoNative.jni_New5(d2, d3);
        this.setHandle(l2, true);
    }

    public SpatialIndexInfo(Point2D point2D, double d2, double d3, double d4) {
        if (point2D == null) {
            String string = E.a("gridCenter", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (point2D.isEmpty()) {
            String string = E.a("gridCenter", "Point2D_IsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d2 <= 0.0) {
            String string = E.a("gridSize0", "SpatialIndexInfo_GridSizeShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d3 <= 0.0) {
            String string = E.a("gridSize1", "SpatialIndexInfo_GridSizeShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (d4 <= 0.0) {
            String string = E.a("gridSize2", "SpatialIndexInfo_GridSizeShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = SpatialIndexInfoNative.jni_New6(point2D.getX(), point2D.getY(), d2, d3, d4);
        this.setHandle(l2, true);
    }

    public SpatialIndexInfo(SpatialIndexInfo spatialIndexInfo) {
        if (spatialIndexInfo == null || spatialIndexInfo.getHandle() == 0L) {
            String string = E.a("gridCenter", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l2 = SpatialIndexInfoNative.jni_New7(spatialIndexInfo.getHandle());
        this.setHandle(l2, true);
    }

    SpatialIndexInfo(long l2) {
        this.setHandle(l2, false);
    }

    protected static SpatialIndexInfo createInstance(long l2) {
        if (l2 == 0L) {
            return null;
        }
        return new SpatialIndexInfo(l2);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SpatialIndexInfoNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    public SpatialIndexInfo clone() {
        if (this.getHandle() == 0L) {
            String string = E.a("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new SpatialIndexInfo(this);
    }

    public SpatialIndexType getType() {
        if (this.getHandle() == 0L) {
            String string = E.a("getType()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = SpatialIndexInfoNative.jni_GetType(this.getHandle());
        return (SpatialIndexType)Enum.parseUGCValue(SpatialIndexType.class, n2);
    }

    public void setType(SpatialIndexType spatialIndexType) {
        if (this.getHandle() == 0L) {
            String string = E.a("setType(SpatialIndexType value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (spatialIndexType == null) {
            String string = E.a("type", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        SpatialIndexInfoNative.jni_SetType(this.getHandle(), spatialIndexType.getUGCValue());
    }

    public int getLeafObjectCount() {
        if (this.getHandle() == 0L) {
            String string = E.a("getLeafObjectCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SpatialIndexInfoNative.jni_GetLeafObjectCount(this.getHandle());
    }

    public void setLeafObjectCount(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setLeafObjectCount(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SpatialIndexInfoNative.jni_SetLeafObjectCount(this.getHandle(), n2);
    }

    public String getTileField() {
        if (this.getHandle() == 0L) {
            String string = E.a("getTileField()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SpatialIndexInfoNative.jni_GetTileField(this.getHandle());
    }

    public void setTileField(String string) {
        if (this.getHandle() == 0L) {
            String string2 = E.a("setTileField(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = E.a("value", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        SpatialIndexInfoNative.jni_SetTileField(this.getHandle(), string);
    }

    public double getTileWidth() {
        if (this.getHandle() == 0L) {
            String string = E.a("getTileWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SpatialIndexInfoNative.jni_GetTileWidth(this.getHandle());
    }

    public void setTileWidth(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setTileWidth(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= 0.0) {
            String string = E.a("value", "SpatialIndexInfo_TileWidthShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SpatialIndexInfoNative.jni_SetTileWidth(this.getHandle(), d2);
    }

    public double getTileHeight() {
        if (this.getHandle() == 0L) {
            String string = E.a("getTileHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SpatialIndexInfoNative.jni_GetTileHeight(this.getHandle());
    }

    public void setTileHeight(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setTileHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= 0.0) {
            String string = E.a("value", "SpatialIndexInfo_TileHeightShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SpatialIndexInfoNative.jni_SetTileHeight(this.getHandle(), d2);
    }

    public Point2D getGridCenter() {
        if (this.getHandle() == 0L) {
            String string = E.a("getGridCenter()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = SpatialIndexInfoNative.jni_GetGridCenter(this.getHandle());
        return new Point2D(dArray[0], dArray[1]);
    }

    public void setGridCenter(Point2D point2D) {
        if (this.getHandle() == 0L) {
            String string = E.a("setGridCenter(Point2D value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point2D == null) {
            String string = E.a("value", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (point2D.isEmpty()) {
            String string = E.a("value", "Point2D_IsEmpty", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SpatialIndexInfoNative.jni_SetGridCenter(this.getHandle(), point2D.getX(), point2D.getY());
    }

    public double getGridSize0() {
        if (this.getHandle() == 0L) {
            String string = E.a("getGridSize0()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SpatialIndexInfoNative.jni_GetGridSize0(this.getHandle());
    }

    public void setGridSize0(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setGridSize0(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= 0.0) {
            String string = E.a("value", "SpatialIndexInfo_GridSizeShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SpatialIndexInfoNative.jni_SetGridSize0(this.getHandle(), d2);
    }

    public double getGridSize1() {
        if (this.getHandle() == 0L) {
            String string = E.a("getGridSize1()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SpatialIndexInfoNative.jni_GetGridSize1(this.getHandle());
    }

    public void setGridSize1(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setGridSize1(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= 0.0) {
            String string = E.a("value", "SpatialIndexInfo_GridSizeShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SpatialIndexInfoNative.jni_SetGridSize1(this.getHandle(), d2);
    }

    public double getGridSize2() {
        if (this.getHandle() == 0L) {
            String string = E.a("getGridSize2()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SpatialIndexInfoNative.jni_GetGridSize2(this.getHandle());
    }

    public void setGridSize2(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setGridSize2(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= 0.0) {
            String string = E.a("value", "SpatialIndexInfo_GridSizeShouldGreaterThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SpatialIndexInfoNative.jni_SetGridSize2(this.getHandle(), d2);
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = E.a("toString()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Type = ");
        stringBuffer.append(this.getType().name());
        stringBuffer.append(",LeafObjectCount=");
        stringBuffer.append(this.getLeafObjectCount());
        stringBuffer.append(",TileField=\"");
        stringBuffer.append(this.getTileField());
        stringBuffer.append("\",TileWidth=");
        stringBuffer.append(this.getTileWidth());
        stringBuffer.append(",TileHeight=");
        stringBuffer.append(this.getTileHeight());
        stringBuffer.append(",GridCenter=");
        stringBuffer.append(this.getGridCenter());
        stringBuffer.append(",GridSize0=");
        stringBuffer.append(this.getGridSize0());
        stringBuffer.append(",GridSize1=");
        stringBuffer.append(this.getGridSize1());
        stringBuffer.append(",=GridSize2=");
        stringBuffer.append(this.getGridSize2());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

