/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.E;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolFill;
import com.supermap.data.SymbolFillLibrary;
import com.supermap.data.SymbolGroup;
import com.supermap.data.SymbolLibraryNative;
import com.supermap.data.SymbolLine;
import com.supermap.data.SymbolLineLibrary;

public abstract class SymbolLibrary
extends InternalHandleDisposable {
    private SymbolGroup a;

    protected SymbolLibrary() {
    }

    public SymbolGroup findGroup(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("findGroup(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolGroup symbolGroup = null;
        if (this.getRootGroup() != null) {
            symbolGroup = this.a.a(n2);
        }
        return symbolGroup;
    }

    public boolean contains(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("contains(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return SymbolLibraryNative.jni_Contains(this.getHandle(), n2);
    }

    public Symbol findSymbol(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("findSymbol(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        Symbol symbol = null;
        if (this.getRootGroup() != null) {
            symbol = this.a.a(n2);
        }
        return symbol;
    }

    public Symbol findSymbol(String string) {
        if (this.getHandle() == 0L) {
            String string2 = E.a("findSymbol(String name)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        Symbol symbol = null;
        if (this.getRootGroup() != null) {
            symbol = this.a.a(string);
        }
        return symbol;
    }

    public boolean fromFile(String string) {
        if (this.getHandle() == 0L) {
            String string2 = E.a("fromFile(String filename, boolean overWrite)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        boolean bl = false;
        if (string != null && string.trim().length() != 0) {
            bl = SymbolLibraryNative.jni_fromFile(this.getHandle(), string, false);
        }
        if (bl && this.getRootGroup() != null) {
            this.a.a();
        }
        return bl;
    }

    public boolean remove(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("remove(int id)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        if (this.getRootGroup() != null) {
            bl = this.a.a(n2);
        }
        return bl;
    }

    public int add(Symbol symbol, SymbolGroup symbolGroup) {
        if (this.getHandle() == 0L) {
            String string = E.a("add(Symbol symbol, SymbolGroup desGroup)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (symbol == null) {
            String string = E.a("symbol", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(symbol);
        if (l2 == 0L) {
            String string = E.a("symbol", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (symbolGroup == null) {
            String string = E.a("desGroup", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = InternalHandle.getHandle(symbolGroup);
        if (l3 == 0L) {
            String string = E.a("desGroup", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (!this.a.getChildGroups().contains(symbolGroup.getName())) {
            String string = E.a("desGroup", "SymbolGroups_NotContainTheSymbolGroup", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = this.add(symbol);
        if (n2 != -1) {
            this.moveTo(n2, symbolGroup);
        }
        return n2;
    }

    public int add(Symbol symbol) {
        if (this.getHandle() == 0L) {
            String string = E.a("Add(Symbol symbol)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (symbol == null) {
            String string = E.a("symbol", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = InternalHandle.getHandle(symbol);
        if (l2 == 0L) {
            String string = E.a("symbol", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this instanceof SymbolFillLibrary && !(symbol instanceof SymbolFill)) {
            String string = E.a("symbol", "SymbolLibrary_Unsupported_Add", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this instanceof SymbolLineLibrary && !(symbol instanceof SymbolLine)) {
            String string = E.a("symbol", "SymbolLibrary_Unsupported_Add", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l3 = SymbolLibraryNative.jni_add(this.getHandle(), l2);
        int n2 = -1;
        if (l3 != 0L) {
            Symbol symbol2 = Symbol.createInstance(l3);
            n2 = symbol2.getID();
            symbol2.setIsDisposable(false);
            if (this.a != null) {
                this.a.a().add(symbol2);
            }
            symbol2.a(this);
            symbol2.setGroup(this.a);
        }
        return n2;
    }

    public boolean moveTo(int n2, SymbolGroup symbolGroup) {
        if (this.getHandle() == 0L) {
            String string = E.a("moveTo(int index, SymbolGroup group)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (symbolGroup == null) {
            String string = E.a("group", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle(symbolGroup);
        if (l2 == 0L) {
            String string = E.a("group", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        boolean bl = false;
        Symbol symbol = this.findSymbol(n2);
        SymbolGroup symbolGroup2 = symbol.getGroup();
        int n3 = symbolGroup2.indexOf(n2);
        bl = symbolGroup2.moveTo(n3, symbolGroup);
        return bl;
    }

    public void clear() {
        if (this.getHandle() == 0L) {
            String string = E.a("clear()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        SymbolLibraryNative.jni_clear(this.getHandle());
        if (this.a != null) {
            this.a.a();
        }
    }

    public SymbolGroup getRootGroup() {
        long l2;
        if (this.getHandle() == 0L) {
            String string = E.a("getRootGroup()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null && (l2 = SymbolLibraryNative.jni_GetRootGroup(this.getHandle())) != 0L) {
            this.a = new SymbolGroup(this, l2);
        }
        return this.a;
    }

    String a() {
        return SymbolLibraryNative.jni_GetLibPath(this.getHandle());
    }

    @Override
    protected void clearHandle() {
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        this.setHandle(0L);
    }
}

