/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import android.graphics.Bitmap;
import com.supermap.data.Color;
import com.supermap.data.E;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoStyle;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolLineNative;
import com.supermap.data.SymbolType;

public class SymbolLine
extends Symbol {
    protected SymbolLine(long l2) {
        this.setHandle(l2, false);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SymbolLineNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    public boolean draw(Bitmap bitmap) {
        if (this.getHandle() == 0L) {
            String string = E.a("draw(Graphics graphics, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (bitmap == null) {
            String string = E.a("draw", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = bitmap.getWidth();
        int n3 = bitmap.getHeight();
        GeoLine geoLine = new GeoLine();
        Point2Ds point2Ds = new Point2Ds();
        point2Ds.add(new Point2D((double)n2 * 0.1, n3 / 2));
        point2Ds.add(new Point2D((double)n2 * 0.9, n3 / 2));
        geoLine.addPart(point2Ds);
        GeoStyle geoStyle = new GeoStyle();
        geoStyle.setLineColor(new Color(13, 80, 143));
        geoStyle.setLineWidth(0.5);
        geoStyle.setLineSymbolID(this.getID());
        geoLine.setStyle(geoStyle);
        boolean bl = SymbolLineNative.jni_Draw(this.getHandle(), bitmap, geoLine.getHandle());
        geoStyle.dispose();
        geoLine.dispose();
        return bl;
    }

    @Override
    public SymbolType getType() {
        return SymbolType.LINE;
    }
}

