/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import android.graphics.Bitmap;
import com.supermap.data.E;
import com.supermap.data.GeoPoint;
import com.supermap.data.GeoStyle;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.Point;
import com.supermap.data.Size2D;
import com.supermap.data.Symbol;
import com.supermap.data.SymbolMarkerNative;
import com.supermap.data.SymbolMarkerStroke;
import com.supermap.data.SymbolType;
import java.util.ArrayList;

public class SymbolMarker
extends Symbol {
    private ArrayList<SymbolMarkerStroke> a;

    SymbolMarker(long l2) {
        this.setHandle(l2, false);
        this.a(l2);
    }

    @Override
    public boolean draw(Bitmap bitmap) {
        if (this.getHandle() == 0L) {
            String string = E.a("draw(Graphics graphics, Geometry geometry)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (bitmap == null) {
            String string = E.a("draw", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = bitmap.getWidth();
        int n3 = bitmap.getHeight();
        GeoPoint geoPoint = new GeoPoint(n2 / 2, n3 / 2);
        GeoStyle geoStyle = new GeoStyle();
        geoStyle.setMarkerSymbolID(this.getID());
        geoStyle.setMarkerSize(new Size2D((double)n2 * 0.9, (double)n3 * 0.9));
        geoPoint.setStyle(geoStyle);
        boolean bl = SymbolMarkerNative.jni_Draw(this.getHandle(), bitmap, geoPoint.getHandle());
        geoStyle.dispose();
        ((Geometry)geoPoint).dispose();
        return bl;
    }

    private void a(long l2) {
        Object object;
        int n2;
        if (this.a != null) {
            for (n2 = 0; n2 < this.a.size(); ++n2) {
                object = this.a.get(n2);
                ((InternalHandle)object).clearHandle();
            }
            this.a.clear();
        } else {
            this.a = new ArrayList();
        }
        n2 = SymbolMarkerNative.jni_GetStrokesCount(l2);
        if (n2 > 0) {
            object = new long[n2];
            SymbolMarkerNative.jni_GetStrokeHandle(l2, (long[])object);
            for (int i2 = 0; i2 < n2; ++i2) {
                if (object[i2] == 0L) continue;
                SymbolMarkerStroke symbolMarkerStroke = new SymbolMarkerStroke((long)object[i2]);
                this.a.add(symbolMarkerStroke);
            }
        }
    }

    SymbolMarker() {
        long l2 = SymbolMarkerNative.jni_New();
        this.setHandle(l2, true);
        this.a(null);
        this.a(l2);
    }

    public int computeDisplaySize(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("computeDisplaySize(int symbolSize)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 <= 0) {
            String string = E.a("computeDisplaySize(int symbolSize)", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return SymbolMarkerNative.jni_ComputeDisplaySize(this.getHandle(), n2);
    }

    public int computeSymbolSize(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("computeSymbolSize(int displaySize)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 <= 0) {
            String string = E.a("computeSymbolSize(int displaySize)", "Global_ArgumentShouldMoreThanZero", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return SymbolMarkerNative.jni_ComputeSymbolSize(this.getHandle(), n2);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SymbolMarkerNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
            this.clearHandle();
        }
    }

    @Override
    public SymbolType getType() {
        return SymbolType.MARKER;
    }

    public Point getOrigin() {
        if (this.getHandle() == 0L) {
            String string = E.a("getOrigin()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int[] nArray = new int[2];
        SymbolMarkerNative.jni_GetOrigin(this.getHandle(), nArray);
        return new Point(nArray[0], nArray[1]);
    }

    public void setOrigin(Point point) {
        if (this.getHandle() == 0L) {
            String string = E.a("setOrigin(Point value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point == null) {
            String string = E.a("value", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        SymbolMarkerNative.jni_SetOrigin(this.getHandle(), point.getX(), point.getY());
    }

    public SymbolMarkerStroke get(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("get(int index)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 < 0 || n2 >= this.a.size()) {
            String string = E.a("index", "Global_IndexOutOfBounds", "data_resources");
            throw new IndexOutOfBoundsException(string);
        }
        this.a(n2);
        return this.a.get(n2);
    }

    private void a(int n2) {
        SymbolMarkerNative.jni_GetMatrialStream(this.getHandle(), this.getLibrary().a(), n2);
    }

    public int getCount() {
        if (this.getHandle() == 0L) {
            String string = E.a("getCount()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a.size();
    }

    @Override
    protected void clearHandle() {
        if (this.a != null) {
            for (int i2 = 0; i2 < this.a.size(); ++i2) {
                SymbolMarkerStroke symbolMarkerStroke = this.a.get(i2);
                symbolMarkerStroke.clearHandle();
            }
            this.a.clear();
        }
        this.setHandle(0L);
    }
}

