/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Color;
import com.supermap.data.E;
import com.supermap.data.Enum;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.TextAlignment;
import com.supermap.data.TextStyleNative;

public class TextStyle
extends InternalHandleDisposable {
    public TextStyle() {
        long l2 = TextStyleNative.jni_New();
        this.setHandle(l2, true);
        this.a();
    }

    public TextStyle(TextStyle textStyle) {
        if (textStyle.getHandle() == 0L) {
            String string = E.a("textStyle", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = TextStyleNative.jni_Clone(textStyle.getHandle());
        this.setHandle(l2, true);
    }

    TextStyle(long l2) {
        this.setHandle(l2, false);
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            TextStyleNative.jni_Delete(this.getHandle());
            this.setHandle(0L);
        }
    }

    public TextAlignment getAlignment() {
        if (this.getHandle() == 0L) {
            String string = E.a("getAlignment()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = TextStyleNative.jni_GetTextAlignment(this.getHandle());
        return (TextAlignment)Enum.parseUGCValue(TextAlignment.class, n2);
    }

    public void setAlignment(TextAlignment textAlignment) {
        if (this.getHandle() == 0L) {
            String string = E.a("setAlignment(TextAlignment value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (textAlignment == null) {
            String string = E.a("textAlignment", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = textAlignment.getUGCValue();
        TextStyleNative.jni_SetTextAlignment(this.getHandle(), n2);
    }

    public Color getBackColor() {
        if (this.getHandle() == 0L) {
            String string = E.a("getBackColor()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = TextStyleNative.jni_GetBackColor(this.getHandle());
        return new Color(n2);
    }

    public void setBackColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = E.a("setBackColor(Color value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetBackColor(this.getHandle(), color.getRGB());
    }

    public boolean isBold() {
        if (this.getHandle() == 0L) {
            String string = E.a("getBold()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetBold(this.getHandle());
    }

    public void setBold(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = E.a("setBold(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetBold(this.getHandle(), bl);
    }

    public Color getForeColor() {
        if (this.getHandle() == 0L) {
            String string = E.a("getForeColor()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        int n2 = TextStyleNative.jni_GetForeColor(this.getHandle());
        return new Color(n2);
    }

    public void setForeColor(Color color) {
        if (this.getHandle() == 0L) {
            String string = E.a("setForeColor(Color value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetForeColor(this.getHandle(), color.getRGB());
    }

    public boolean isSizeFixed() {
        if (this.getHandle() == 0L) {
            String string = E.a("getIsSizeFixed()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetIsSizeFixed(this.getHandle());
    }

    public void setSizeFixed(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = E.a("setIsSizeFixed(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetSizeFixed(this.getHandle(), bl);
    }

    public double getFontHeight() {
        if (this.getHandle() == 0L) {
            String string = E.a("getFontHeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetFontHeight(this.getHandle());
    }

    public void setFontHeight(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setFontHeight(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 <= 0.0) {
            String string = E.a("value", "TextStyle_TheValueOfFontHeightShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyleNative.jni_SetFontHeight(this.getHandle(), d2);
    }

    public double getFontWidth() {
        if (this.getHandle() == 0L) {
            String string = E.a("getFontWidth()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetFontWidth(this.getHandle());
    }

    public void setFontWidth(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setFontWidth(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (d2 < 0.0) {
            String string = E.a("value", "TextStyle_TheValueOfFontWidthShouldBePositive", "data_resources");
            throw new IllegalArgumentException(string);
        }
        TextStyleNative.jni_SetFontWidth(this.getHandle(), d2);
    }

    public String getFontName() {
        if (this.getHandle() == 0L) {
            String string = E.a("getFontName()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetFontName(this.getHandle());
    }

    public void setFontName(String string) {
        if (this.getHandle() == 0L) {
            String string2 = E.a("setFontName(String value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        TextStyleNative.jni_SetFontName(this.getHandle(), string);
    }

    public boolean getItalic() {
        if (this.getHandle() == 0L) {
            String string = E.a("getItalic()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetItalic(this.getHandle());
    }

    public void setItalic(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = E.a("setItalic(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetItalic(this.getHandle(), bl);
    }

    public double getItalicAngle() {
        if (this.getHandle() == 0L) {
            String string = E.a("getItalicAngle()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetItalicAngle(this.getHandle());
    }

    public void setItalicAngle(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setItalicAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetItalicAngle(this.getHandle(), d2);
    }

    public void setBackTransparency(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setItalicAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 >= 0 && n2 <= 255) {
            TextStyleNative.jni_SetBackTransparency(this.getHandle(), n2);
        }
    }

    public int getBackTransparency() {
        if (this.getHandle() == 0L) {
            String string = E.a("setItalicAngle(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetBackTransparency(this.getHandle());
    }

    public boolean getOutline() {
        if (this.getHandle() == 0L) {
            String string = E.a("getOutline()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetOutline(this.getHandle());
    }

    public TextStyle clone() {
        if (this.getHandle() == 0L) {
            String string = E.a("clone()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return new TextStyle(this);
    }

    public void setOutline(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = E.a("setOutline(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetOutline(this.getHandle(), bl);
    }

    public double getRotation() {
        if (this.getHandle() == 0L) {
            String string = E.a("getRotation()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetRotation(this.getHandle());
    }

    public void setRotation(double d2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setRotation(double value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetRotation(this.getHandle(), d2);
    }

    public boolean getShadow() {
        if (this.getHandle() == 0L) {
            String string = E.a("getShadow()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetShadow(this.getHandle());
    }

    public void setShadow(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = E.a("setShadow(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetShadow(this.getHandle(), bl);
    }

    public boolean getStrikeout() {
        if (this.getHandle() == 0L) {
            String string = E.a("getStrikeout()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetStrikeout(this.getHandle());
    }

    public void setStrikeout(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = E.a("setStrikeout(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetStrikeout(this.getHandle(), bl);
    }

    public boolean isBackOpaque() {
        if (this.getHandle() == 0L) {
            String string = E.a("getBackOpaque()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetBackOpaque(this.getHandle());
    }

    public void setBackOpaque(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = E.a("setBackOpaque(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetBackOpaque(this.getHandle(), bl);
    }

    public boolean getUnderline() {
        if (this.getHandle() == 0L) {
            String string = E.a("getUnderline()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetUnderLine(this.getHandle());
    }

    public void setUnderline(boolean bl) {
        if (this.getHandle() == 0L) {
            String string = E.a("setUnderline(boolean value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_SetUnderLine(this.getHandle(), bl);
    }

    @Deprecated
    public int getWeight() {
        if (this.getHandle() == 0L) {
            String string = E.a("getWeight()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return TextStyleNative.jni_GetWeight(this.getHandle());
    }

    @Deprecated
    public void setWeight(int n2) {
        if (this.getHandle() == 0L) {
            String string = E.a("setWeight(int value)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        TextStyleNative.jni_setWeight(this.getHandle(), n2);
    }

    public String toString() {
        if (this.getHandle() == 0L) {
            String string = E.a("toString()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{Alignment = ");
        stringBuffer.append(this.getAlignment().name());
        stringBuffer.append(",BackColor = ");
        stringBuffer.append(this.getBackColor().toString());
        stringBuffer.append(",BackOpaque = ");
        stringBuffer.append(this.isBackOpaque());
        stringBuffer.append(",Bold = ");
        stringBuffer.append(this.isBold());
        stringBuffer.append(",FontName = ");
        stringBuffer.append(this.getFontName());
        stringBuffer.append(",FontHeight = ");
        stringBuffer.append(this.getFontHeight());
        stringBuffer.append(",FontWidth = ");
        stringBuffer.append(this.getFontWidth());
        stringBuffer.append(",FontColor = ");
        stringBuffer.append(this.getForeColor().toString());
        stringBuffer.append(",IsSizeFixed = ");
        stringBuffer.append(this.isSizeFixed());
        stringBuffer.append(",Italic = ");
        stringBuffer.append(this.getItalic());
        stringBuffer.append(",Outline = ");
        stringBuffer.append(this.getOutline());
        stringBuffer.append(",Rotation = ");
        stringBuffer.append(this.getRotation());
        stringBuffer.append(",Shadow = ");
        stringBuffer.append(this.getShadow());
        stringBuffer.append(",Strikeout = ");
        stringBuffer.append(this.getStrikeout());
        stringBuffer.append(",Underline = ");
        stringBuffer.append(this.getUnderline());
        stringBuffer.append(",Weight = ");
        stringBuffer.append(this.getWeight());
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }

    protected static TextStyle createInstance(long l2) {
        if (l2 == 0L) {
            String string = E.a("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        return new TextStyle(l2);
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
    }

    protected static void changeHandle(TextStyle textStyle, long l2) {
        textStyle.a(l2);
    }

    protected static void clearHandle(TextStyle textStyle) {
        textStyle.clearHandle();
    }

    private void a(long l2) {
        if (l2 == 0L) {
            String string = E.a("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (this.getHandle() != 0L) {
            TextStyleNative.jni_Delete(this.getHandle());
        }
        this.setHandle(l2, false);
    }

    protected static void refreshHandle(TextStyle textStyle, long l2) {
        textStyle.b(l2);
    }

    private void b(long l2) {
        if (l2 == 0L) {
            String string = E.a("handle", "Global_InvalidConstructorArgument", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.setHandle(l2, false);
    }

    void a() {
        TextStyleNative.jni_Reset(this.getHandle());
    }
}

