/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.E;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point2D;
import com.supermap.data.Point2Ds;
import com.supermap.data.TransformationMode;
import com.supermap.data.TransformationNative;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Transformation
extends InternalHandleDisposable {
    private Point2Ds a;
    private Point2Ds b = null;
    private TransformationMode a = TransformationMode.RECT;

    public Transformation() {
        long l2 = TransformationNative.jni_New();
        this.setHandle(l2, true);
        this.a = new Point2Ds();
        this.b = new Point2Ds();
    }

    public Transformation(Transformation transformation) {
        if (transformation == null) {
            String string = E.a("transformation", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (transformation.getHandle() == 0L) {
            String string = E.a("transformation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = TransformationNative.jni_New();
        this.setHandle(l2, true);
        this.a = new Point2Ds();
        this.b = new Point2Ds();
    }

    public Transformation(Point2Ds point2Ds, Point2Ds point2Ds2, TransformationMode transformationMode) {
        if (point2Ds == null) {
            String string = E.a("originalControlPoints", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (point2Ds2 == null) {
            String string = E.a("targetControlPoints", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        if (transformationMode == null) {
            String string = E.a("transformationMode", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        long l2 = TransformationNative.jni_New();
        this.setHandle(l2, true);
        this.a = new Point2Ds();
        this.b = new Point2Ds();
        this.setOriginalControlPoints(point2Ds);
        this.setTargetControlPoints(point2Ds2);
        this.a = transformationMode;
    }

    public Point2Ds getOriginalControlPoints() {
        if (this.getHandle() == 0L) {
            String string = E.a("getOriginalControlPoints()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public boolean transform(Point2Ds point2Ds) {
        int n2;
        if (point2Ds == null) {
            String string = E.a("transformPoint2Ds", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.a();
        int n3 = point2Ds.getCount();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = point2Ds.getItem(n2).getX();
            dArray2[n2] = point2Ds.getItem(n2).getY();
        }
        n2 = TransformationNative.jni_TransformPoint2Ds(this.getHandle(), dArray, dArray2, this.a.value()) ? 1 : 0;
        if (n2 != 0) {
            point2Ds.clear();
            for (int i2 = 0; i2 < n3; ++i2) {
                Point2D point2D = new Point2D(dArray[i2], dArray2[i2]);
                point2Ds.add(point2D);
            }
        }
        return n2 != 0;
    }

    public boolean setOriginalControlPoints(Point2Ds point2Ds) {
        int n2;
        if (this.getHandle() == 0L) {
            String string = E.a("setOriginalControlPoints(Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point2Ds == null) {
            String string = E.a("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n3 = point2Ds.getCount();
        if (n3 < 1) {
            String string = E.a("Point2Ds", "Transformation_ControlPointsShouldNotSmallerThanOne", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = point2Ds.getItem(n2).getX();
            dArray2[n2] = point2Ds.getItem(n2).getY();
        }
        n2 = TransformationNative.jni_SetOriginalControlPoints(this.getHandle(), dArray, dArray2) ? 1 : 0;
        if (n2 == 1) {
            this.a.clear();
            this.a.addRange(point2Ds.toArray());
        }
        return n2 != 0;
    }

    public Point2Ds getTargetControlPoints() {
        if (this.getHandle() == 0L) {
            String string = E.a("getTargetControlPoints()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.b;
    }

    public boolean setTargetControlPoints(Point2Ds point2Ds) {
        int n2;
        if (this.getHandle() == 0L) {
            String string = E.a("setTargetControlPoints(Point2Ds points)", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (point2Ds == null) {
            String string = E.a("points", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n3 = point2Ds.getCount();
        if (n3 < 1) {
            String string = E.a("Point2Ds", "Transformation_ControlPointsShouldNotSmallerThanOne", "data_resources");
            throw new IllegalArgumentException(string);
        }
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = point2Ds.getItem(n2).getX();
            dArray2[n2] = point2Ds.getItem(n2).getY();
        }
        n2 = TransformationNative.jni_SetTargetControlPoints(this.getHandle(), dArray, dArray2) ? 1 : 0;
        if (n2 == 1) {
            this.b.clear();
            this.b.addRange(point2Ds.toArray());
        }
        return n2 != 0;
    }

    public TransformationMode getTransformMode() {
        if (this.getHandle() == 0L) {
            String string = E.a("getTransformMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public void setTransformMode(TransformationMode transformationMode) {
        if (this.getHandle() == 0L) {
            String string = E.a("setTransformMode()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (transformationMode == null) {
            String string = E.a("transformMode", "Global_ArgumentNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.a = transformationMode;
    }

    @Override
    protected void clearHandle() {
        this.setHandle(0L);
        if (this.a != null) {
            this.a.clear();
            this.a = null;
        }
        if (this.b != null) {
            this.b.clear();
            this.b = null;
        }
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            TransformationNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    private void a() {
        if (this.getHandle() == 0L) {
            String string = E.a("Transformmation", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null || this.b == null) {
            String string = E.a("ControlPoints", "Transformation_ControlPointsNull", "data_resources");
            throw new IllegalArgumentException(string);
        }
        int n2 = this.a.getCount();
        int n3 = this.b.getCount();
        if (n2 == 0 || n3 == 0) {
            String string = E.a("Transformmation", "Transformation_ControlPointsShouldNotBeZero", "data_resources");
            throw new IllegalStateException(string);
        }
        if (n2 != n3) {
            String string = E.a("Transformmation", "Transformation_OriginalAndTargetControlPointsCountMustEqual", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == TransformationMode.RECT && n2 < 2) {
            String string = E.a("Transformmation", "Transformation_RectModeNeedLeastTwoControlPoints", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == TransformationMode.LINEAR && n2 < 4) {
            String string = E.a("Transformmation", "Transformation_LinearModeNeedLeastFourControlPoints", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == TransformationMode.SQUARE && n2 < 7) {
            String string = E.a("Transformmation", "Transformation_SquareModeNeedLeastSevenControlPoints", "data_resources");
            throw new IllegalStateException(string);
        }
    }
}

