/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.data;

import com.supermap.data.Datasources;
import com.supermap.data.E;
import com.supermap.data.Environment;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.MapSaveListener;
import com.supermap.data.Maps;
import com.supermap.data.Resources;
import com.supermap.data.Scenes;
import com.supermap.data.WorkspaceConnectionInfo;
import com.supermap.data.WorkspaceNative;
import com.supermap.data.WorkspaceType;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Workspace
extends InternalHandleDisposable {
    private WorkspaceConnectionInfo a;
    private WorkspaceConnectionInfo b;
    private Datasources a;
    private Resources a;
    private Maps a;
    private Scenes a;
    private Vector<MapSaveListener> a;

    public Workspace() {
        long l2 = WorkspaceNative.jni_New();
        this.setHandle(l2, true);
        this.a();
        l2 = WorkspaceNative.jni_GetConnectionInfo(this.getHandle());
        this.a = new WorkspaceConnectionInfo(l2, false, true);
        this.b = new WorkspaceConnectionInfo();
        this.b.setIsDisposable(false);
        this.a.a();
        this.a = new Maps(this);
        this.a = new Datasources(this);
        this.a = new Scenes(this);
        this.a = new Vector();
    }

    public WorkspaceConnectionInfo getConnectionInfo() {
        if (this.getHandle() == 0L) {
            String string = E.a("getConnectionInfo()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.b;
    }

    public String getCaption() {
        if (this.getHandle() == 0L) {
            String string = E.a("getCaption()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return WorkspaceNative.jni_GetCaption(this.getHandle());
    }

    public void setCaption(String string) {
        if (this.getHandle() == 0L) {
            String string2 = E.a("setCaption()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null || string.trim().length() == 0) {
            String string3 = E.a("caption", "Global_StringIsNullOrEmpty", "data_resources");
            throw new IllegalArgumentException(string3);
        }
        WorkspaceNative.jni_SetCaption(this.getHandle(), string);
    }

    public Datasources getDatasources() {
        if (this.getHandle() == 0L) {
            String string = E.a("getDatasources()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public Maps getMaps() {
        if (this.getHandle() == 0L) {
            String string = E.a("getMaps()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public boolean isModified() {
        if (this.getHandle() == 0L) {
            String string = E.a("isModified()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return WorkspaceNative.jni_GetIsModified(this.getHandle());
    }

    public Resources getResources() {
        long l2;
        if (this.getHandle() == 0L) {
            String string = E.a("getResources()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null && (l2 = WorkspaceNative.jni_GetResources(this.getHandle())) != 0L) {
            this.a = new Resources(this, l2);
        }
        return this.a;
    }

    public String getDescription() {
        if (this.getHandle() == 0L) {
            String string = E.a("getDescription()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return WorkspaceNative.jni_GetDescription(this.getHandle());
    }

    public void setDescription(String string) {
        if (this.getHandle() == 0L) {
            String string2 = E.a("setDescription()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            string = "";
        }
        WorkspaceNative.jni_SetDescription(this.getHandle(), string);
    }

    public boolean open(WorkspaceConnectionInfo workspaceConnectionInfo) {
        if (this.getHandle() == 0L) {
            String string = E.a("open()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        if (workspaceConnectionInfo == null) {
            String string = E.a("connectionInfo", "Global_ArgumentNull", "data_resources");
            throw new NullPointerException(string);
        }
        if (workspaceConnectionInfo.getHandle() == 0L) {
            String string = E.a("connectionInfo", "GlobalArgument_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalArgumentException(string);
        }
        this.close();
        boolean bl = WorkspaceNative.jni_Open(this.getHandle(), workspaceConnectionInfo.getHandle());
        if (!bl && !Environment.getLicenseStatus().isLicenseValid()) {
            throw new IllegalStateException(Environment.getLicenseStatus().toString());
        }
        this.getDatasources().a();
        if (bl) {
            this.a(this.b, this.a);
        }
        return bl;
    }

    public void close() {
        if (this.getHandle() == 0L) {
            String string = E.a("close()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        this.getMaps().clear();
        WorkspaceNative.jni_Close(this.getHandle());
        this.a();
    }

    @Override
    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = E.a("dispose()", "Handle_UndisposableObject", "data_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            this.close();
            WorkspaceNative.jni_Delete(this.getHandle());
            this.clearHandle();
            ((Vector)((Object)this.a)).clear();
        }
    }

    public boolean save() throws Exception {
        if (this.getHandle() == 0L) {
            String string = E.a("save()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        boolean bl = false;
        String string = this.b.getServer();
        String string2 = this.a.getServer();
        this.b();
        if (string2.isEmpty()) {
            if (string.isEmpty()) {
                String string3 = "This is a new workspace, please set file path before saving.";
                throw new Exception(string3);
            }
            bl = this.a(this.b);
        } else {
            bl = string.isEmpty() ? WorkspaceNative.jni_Save(this.getHandle()) : (string2.equals(string) ? WorkspaceNative.jni_Save(this.getHandle()) : this.a(this.b));
        }
        return bl;
    }

    void a() {
        WorkspaceNative.jni_Reset(this.getHandle());
    }

    public Scenes getScenes() {
        if (this.getHandle() == 0L) {
            String string = E.a("getScenes()", "Handle_ObjectHasBeenDisposed", "data_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    private boolean a(WorkspaceConnectionInfo workspaceConnectionInfo) throws Exception {
        String string = null;
        if (this.getHandle() == 0L) {
            string = "This workspace was disposed.";
            throw new Exception(string);
        }
        this.a(workspaceConnectionInfo);
        boolean bl = WorkspaceNative.jni_SaveAs(this.getHandle(), workspaceConnectionInfo.getHandle());
        return bl;
    }

    private void a(WorkspaceConnectionInfo workspaceConnectionInfo) throws Exception {
        if (workspaceConnectionInfo == null) {
            String string = "The WorkspaceConnectionInfo parameter is null";
            throw new Exception(string);
        }
        if (workspaceConnectionInfo.getHandle() == 0L) {
            String string = "The WorkspaceConnectionInfo parameter was disposed.";
            throw new Exception(string);
        }
        String string = workspaceConnectionInfo.getServer();
        WorkspaceType workspaceType = workspaceConnectionInfo.getType();
        String string2 = string;
        WorkspaceType workspaceType2 = this.a(string2);
        WorkspaceType workspaceType3 = workspaceType;
        if (workspaceType2 == null && workspaceType3 == WorkspaceType.DEFAULT) {
            String string3 = "The WorkspaceType is invalid, please check the parameter again.";
            throw new Exception(string3);
        }
        if (workspaceType3 != WorkspaceType.DEFAULT && workspaceType2 != workspaceType3) {
            string2 = string2 + "." + this.a(workspaceType3).toLowerCase();
            workspaceConnectionInfo.setServer(string2);
        } else if (workspaceType2 != workspaceType3) {
            workspaceConnectionInfo.setType(workspaceType2);
        }
        File file = new File(string2);
        File file2 = file.getParentFile();
        if (file2 == null) {
            String string4 = "The workspace's path is wrong. File path: " + file.toString();
            throw new Exception(string4);
        }
        if (file.exists()) {
            String string5 = "The workspace file has existed. File path: " + file.toString();
            throw new Exception(string5);
        }
        if (!file2.exists() && !file2.mkdirs()) {
            String string6 = "Creating the directories failed. File path: " + file.toString();
            throw new Exception(string6);
        }
        int n2 = string2.lastIndexOf(47) + 1;
        int n3 = string2.lastIndexOf(46);
        String string7 = null;
        string7 = n2 < 0 || n3 < 0 || n2 >= n3 ? "" : string2.substring(n2, n3);
        String string8 = workspaceConnectionInfo.getName();
        String string9 = this.getCaption();
        if ((string8.isEmpty() || string8.equals("UntitledWorkspace")) && !string9.isEmpty() && !string9.equals("UntitledWorkspace")) {
            workspaceConnectionInfo.setName(string9);
        } else if ((string8.isEmpty() || string8.equals("UntitledWorkspace")) && !string7.isEmpty()) {
            workspaceConnectionInfo.setName(string7);
            this.setCaption(string7);
        }
    }

    private WorkspaceType a(String string) {
        WorkspaceType workspaceType = null;
        if (string == null) {
            return null;
        }
        String string2 = string.toUpperCase();
        if (string2.endsWith(".SMW")) {
            workspaceType = WorkspaceType.SMW;
        } else if (string2.endsWith(".SMWU")) {
            workspaceType = WorkspaceType.SMWU;
        } else if (string2.endsWith(".SXW")) {
            workspaceType = WorkspaceType.SXW;
        } else if (string2.endsWith(".SXWU")) {
            workspaceType = WorkspaceType.SXWU;
        }
        return workspaceType;
    }

    private String a(WorkspaceType workspaceType) {
        String string = null;
        if (workspaceType == null) {
            return null;
        }
        if (workspaceType == WorkspaceType.SMW) {
            string = "SMW";
        } else if (workspaceType == WorkspaceType.SMWU) {
            string = "SMWU";
        } else if (workspaceType == WorkspaceType.SXW) {
            string = "SXW";
        } else if (workspaceType == WorkspaceType.SXWU) {
            string = "SXWU";
        }
        return string;
    }

    public boolean addMapSaveListener(MapSaveListener mapSaveListener) {
        if (mapSaveListener == null) {
            return false;
        }
        return ((Vector)((Object)this.a)).add(mapSaveListener);
    }

    public boolean removeMapSaveListener(MapSaveListener mapSaveListener) {
        if (mapSaveListener == null) {
            return true;
        }
        return ((Vector)((Object)this.a)).remove(mapSaveListener);
    }

    private void b() {
        Iterator iterator = ((Vector)((Object)this.a)).iterator();
        while (iterator.hasNext()) {
            MapSaveListener mapSaveListener = (MapSaveListener)iterator.next();
            mapSaveListener.saveMap();
        }
    }

    private void a(WorkspaceConnectionInfo workspaceConnectionInfo, WorkspaceConnectionInfo workspaceConnectionInfo2) {
        if (workspaceConnectionInfo == null || workspaceConnectionInfo2 == null) {
            return;
        }
        workspaceConnectionInfo.setName(workspaceConnectionInfo2.getName());
        workspaceConnectionInfo.setServer(workspaceConnectionInfo2.getServer());
        workspaceConnectionInfo.setType(workspaceConnectionInfo2.getType());
        workspaceConnectionInfo.setUser(workspaceConnectionInfo2.getUser());
        workspaceConnectionInfo.setVersion(workspaceConnectionInfo2.getVersion());
    }
}

