/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping;

import com.supermap.data.Color;
import com.supermap.data.ColorSpaceType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetImage;
import com.supermap.data.DatasetType;
import com.supermap.data.InternalHandle;
import com.supermap.mapping.ImageDisplayMode;
import com.supermap.mapping.ImageStretchOption;
import com.supermap.mapping.Layer;
import com.supermap.mapping.LayerNative;
import com.supermap.mapping.LayerSetting;
import com.supermap.mapping.LayerSettingType;
import com.supermap.mapping.Layers;
import com.supermap.mapping.d;
import com.supermap.mapping.k;
import com.supermap.mapping.t;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class LayerSettingImage
extends LayerSetting {
    private Layer a;
    private Layers a;
    private Color a;
    private boolean a;
    private boolean b = false;
    private int[] a;
    private String[] a;
    private int a;
    private ImageDisplayMode a;
    private ImageStretchOption a;
    private String a;
    private ColorSpaceType a = ColorSpaceType.RGB;

    public LayerSettingImage() {
    }

    public LayerSettingImage(LayerSettingImage layerSettingImage) {
        if (layerSettingImage == null) {
            String string2 = t.a(this.a, "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string2);
        }
        if (layerSettingImage.a) {
            long l2 = k.getHandle(layerSettingImage.a);
            if (l2 == 0L) {
                this.a = false;
            } else {
                this.a = true;
                this.a = layerSettingImage.a;
                this.a = layerSettingImage.a;
            }
            this.a = new Color(layerSettingImage.getTransparentColor().getRGB());
            this.b = layerSettingImage.isTransparent();
            this.a = layerSettingImage.getTransparentColorTolerance();
            this.a = (int[])layerSettingImage.getDisplayBandIndexes().clone();
            this.a = layerSettingImage.getDisplayMode();
            this.a = layerSettingImage.getDisplayColorSpace();
        }
    }

    LayerSettingImage(Layer layer, Layers layers) {
        this.a = layer;
        this.a = layers;
        this.a = true;
    }

    public String[] getAllSubLayers() {
        String[] stringArray = null;
        if (this.a) {
            long l2 = k.getHandle(this.a);
            if (l2 == 0L) {
                String string2 = t.a("getAllSubLayers()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string2);
            }
            String string3 = null;
            string3 = LayerNative.jni_getAllSubLayers(l2);
            stringArray = string3.split(",");
        }
        return stringArray;
    }

    public String[] getVisibleSubLayers() {
        if (this.a) {
            long l2 = k.getHandle(this.a);
            if (l2 == 0L) {
                String string2 = t.a("getVisibleSubLayers()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string2);
            }
            String string3 = null;
            string3 = LayerNative.jni_getVisibleSubLayers(l2);
            this.a = string3.split(",");
        }
        return this.a;
    }

    public void setVisibleSubLayers(String[] stringArray) {
        if (stringArray == null || stringArray.length <= 0) {
            return;
        }
        if (this.a) {
            long l2 = k.getHandle(this.a);
            if (l2 == 0L) {
                String string2 = t.a("setVisibleSubLayers()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string2);
            }
            String string3 = null;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                string3 = string3 + stringArray[i2];
                string3 = string3 + ",";
            }
            LayerNative.jni_setVisibleSubLayers(l2, string3);
        }
        this.a = stringArray;
    }

    public void setMapLayersID(String string2) {
        if (string2 == null) {
            return;
        }
        long l2 = k.getHandle(this.a);
        if (l2 == 0L) {
            String string3 = t.a("setMapLayersID()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string3);
        }
        LayerNative.jni_setMapLayersID(l2, string2);
    }

    public String getMapLayersID() {
        long l2 = k.getHandle(this.a);
        if (l2 == 0L) {
            String string2 = t.a("getMapLayersID()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        return LayerNative.jni_getMapLayersID(l2);
    }

    @Override
    public LayerSettingType getType() {
        if (this.a) {
            long l2 = k.getHandle(this.a);
            if (l2 != 0L && this.a.getDataset().getType() == DatasetType.IMAGE) {
                return LayerSettingType.IMAGE;
            }
            return null;
        }
        return LayerSettingType.IMAGE;
    }

    public boolean isTransparent() {
        long l2;
        if (this.a && (l2 = k.getHandle(this.a)) != 0L) {
            return LayerNative.jni_GetRasterIsBackTransparent(l2);
        }
        return this.b;
    }

    public void setTransparent(boolean bl) {
        long l2 = 0L;
        if (this.a && this.a != null && (l2 = k.getHandle(this.a)) != 0L) {
            LayerNative.jni_SetRasterBackTransparent(l2, bl);
        }
        this.b = bl;
    }

    public Color getTransparentColor() {
        long l2;
        if (this.a && (l2 = k.getHandle(this.a)) != 0L) {
            int n2 = LayerNative.jni_GetRasterBackTransparentColor(l2);
            return new Color(n2);
        }
        return this.a;
    }

    public void setTransparentColor(Color color) {
        long l2 = 0L;
        if (color == null) {
            return;
        }
        if (this.a && this.a != null && (l2 = k.getHandle(this.a)) != 0L) {
            LayerNative.jni_SetRasterBackTransparentColor(l2, color.getRGB());
        }
        this.a = new Color(color.getRGB());
    }

    public int getTransparentColorTolerance() {
        long l2;
        if (this.a && (l2 = k.getHandle(this.a)) != 0L) {
            return LayerNative.jni_GetTransparentColorTolerance(l2);
        }
        return this.a;
    }

    public void setTransparentColorTolerance(int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        long l2 = 0L;
        if (this.a && this.a != null && (l2 = k.getHandle(this.a)) != 0L) {
            LayerNative.jni_SetTransparentColorTolerance(l2, n2);
        }
        this.a = n2;
    }

    public int[] getDisplayBandIndexes() {
        if (this.a) {
            long l2 = k.getHandle(this.a);
            if (l2 == 0L) {
                String string2 = t.a("getDisplayBandIndexes()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string2);
            }
            return LayerNative.jni_GetDisplayBandIndexes(l2);
        }
        return this.a;
    }

    public void setDisplayBandIndexes(int[] nArray) {
        if (this.a) {
            long l2 = k.getHandle(this.a);
            if (l2 == 0L) {
                String string2 = t.a("setDisplayBandIndexes(int[] bandIndexes)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string2);
            }
            if (nArray == null) {
                String string3 = t.a("", "Global_ArgumentNull", "mapping_resources");
                throw new IllegalArgumentException(string3);
            }
            int n2 = nArray.length;
            if (!(this.a.getDataset() instanceof DatasetImage) || ((DatasetImage)this.a.getDataset()).getBandCount() <= 1) {
                String string4 = t.a("setDisplayBandIndexes(int[] bandIndexes)", "LayerSettingImage_ThisOperationIsAvailableForMultibandsDataOnly", "mapping_resources");
                throw new IllegalStateException(string4);
            }
            int n3 = 0;
            ColorSpaceType colorSpaceType = this.getDisplayColorSpace();
            int n4 = colorSpaceType.value();
            switch (n4) {
                case 2: 
                case 4: {
                    n3 = 4;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    n3 = 3;
                    break;
                }
            }
            if (nArray.length != n3) {
                String string5 = t.a("indexes", "GlobalArgument_OutOfBounds", "mapping_resources");
                throw new IllegalArgumentException(string5);
            }
            int n5 = ((DatasetImage)this.a.getDataset()).getBandCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (0 <= nArray[i2] && n5 > nArray[i2]) continue;
                String string6 = t.a("indexes", "Global_IndexOutOfBounds", "mapping_resources");
                throw new IllegalArgumentException(string6);
            }
            LayerNative.jni_SetDisplayBandIndexes(l2, nArray);
        } else {
            this.a = (int[])nArray.clone();
        }
    }

    public ImageDisplayMode getDisplayMode() {
        if (this.a) {
            long l2 = k.getHandle(this.a);
            if (l2 == 0L) {
                String string2 = t.a("getDisplayColorSpace()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string2);
            }
            int n2 = LayerNative.jni_GetImageDisplayMode(l2);
            return (ImageDisplayMode)d.a(ImageDisplayMode.class, n2);
        }
        return this.a;
    }

    public void setDisplayMode(ImageDisplayMode imageDisplayMode) {
        if (this.a) {
            long l2 = k.getHandle(this.a);
            if (l2 == 0L) {
                String string2 = t.a("setDisplayMode(ImageDisplayMode displayMode)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string2);
            }
            if (!(this.a.getDataset() instanceof DatasetImage)) {
                String string3 = t.a("setDisplayMode(ImageDisplayMode displayMode)", "LayerSettingImage_ThisOperationIsAvailableForMultibandsDataOnly", "mapping_resources");
                throw new IllegalStateException(string3);
            }
            if (((DatasetImage)this.a.getDataset()).getBandCount() < 2 && imageDisplayMode == ImageDisplayMode.COMPOSITE) {
                String string4 = t.a("setDisplayMode(ImageDisplayMode displayMode)", "LayerSettingImage_ThisOperationIsAvailableForMultibandsDataOnly", "mapping_resources");
                throw new IllegalStateException(string4);
            }
            int n2 = imageDisplayMode.value();
            LayerNative.jni_SetImageDisplayMode(l2, n2);
        }
        this.a = imageDisplayMode;
    }

    public ColorSpaceType getDisplayColorSpace() {
        if (this.a) {
            long l2 = k.getHandle(this.a);
            if (l2 == 0L) {
                String string2 = t.a("getDisplayColorSpace()", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string2);
            }
            int n2 = LayerNative.jni_GetDispalayColorSpaceType(l2);
            return (ColorSpaceType)d.a(ColorSpaceType.class, n2);
        }
        return this.a;
    }

    public void setDisplayColorSpace(ColorSpaceType colorSpaceType) {
        if (this.a) {
            long l2 = k.getHandle(this.a);
            if (l2 == 0L) {
                String string2 = t.a("setDisplayColorSpace(ColorSpaceType colorSpace)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
                throw new IllegalStateException(string2);
            }
            if (!(this.a.getDataset() instanceof DatasetImage) || ((DatasetImage)this.a.getDataset()).getBandCount() <= 1) {
                String string3 = t.a("setDisplayColorSpace(ColorSpaceType colorSpace)", "LayerSettingImage_ThisOperationIsAvailableForMultibandsDataOnly", "mapping_resources");
                throw new IllegalStateException(string3);
            }
            if (colorSpaceType != ColorSpaceType.RGB && colorSpaceType != ColorSpaceType.RGBA) {
                String string4 = t.a("setDisplayColorSpace(ColorSpaceType colorSpace)", "Global_EnumValueIsError", "mapping_resources");
                throw new IllegalStateException(string4);
            }
            int n2 = 0;
            int n3 = colorSpaceType.value();
            switch (n3) {
                case 2: 
                case 4: {
                    n2 = 4;
                    break;
                }
                case 1: 
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            int n4 = colorSpaceType.value();
            LayerNative.jni_SetDispalayColorSpaceType(l2, n4);
            if (this.getDisplayBandIndexes() != null) {
                int[] nArray = this.getDisplayBandIndexes();
                if (nArray.length > n2) {
                    int[] nArray2 = new int[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        nArray2[i2] = nArray[i2];
                    }
                    this.setDisplayBandIndexes(nArray2);
                } else if (nArray.length < n2) {
                    int[] nArray3 = new int[n2];
                    for (int i3 = 0; i3 < n2; ++i3) {
                        nArray3[i3] = i3 < nArray.length ? nArray[i3] : (nArray.length > 1 ? nArray[nArray.length - 1] : 0);
                    }
                    this.setDisplayBandIndexes(nArray3);
                }
            }
        }
        this.a = colorSpaceType;
    }

    public ImageStretchOption getImageStretchOption() {
        if (this.a) {
            Class<?> clazz;
            Dataset dataset;
            if (this.a == null && this.a != null && this.a != null && (dataset = this.a.getDataset()) != null && k.getHandle((InternalHandle)dataset) != 0L && (clazz = dataset.getClass()).equals(DatasetImage.class)) {
                this.a = new ImageStretchOption(this.a, this.a);
            }
            return this.a;
        }
        if (this.a == null) {
            String string2 = t.a("getImageStretchOption", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string2);
        }
        return this.a;
    }

    public void setImageStretchOption(ImageStretchOption imageStretchOption) {
        if (this.a == null || this.a == null) {
            String string2 = t.a("setImageStretchOption(ImageStretchOption imageStretchOption)", "Handle_ObjectHasBeenDisposed", "mapping_resources");
            throw new IllegalStateException(string2);
        }
        if (this.getImageStretchOption() == null) {
            String string3 = t.a("setImageStretchOption(ImageStretchOption imageStretchOption)", "Layer_UnsupportedOperationOfSetAdditionalSetting", "mapping_resources");
            throw new UnsupportedOperationException(string3);
        }
        if (imageStretchOption == null) {
            String string4 = t.a("imageStretchOption", "Global_ArgumentNull", "mapping_resources");
            throw new IllegalArgumentException(string4);
        }
        this.a.setStretchType(imageStretchOption.getStretchType());
        this.a.setStandardDeviationStretchFactor(imageStretchOption.getStandardDeviationStretchFactor());
        this.a.setGaussianStretchRatioFactor(imageStretchOption.getGaussianStretchRatioFactor());
        this.a.setGaussianStretchMiddleFactor(imageStretchOption.isGaussianStretchMiddleFactor());
        this.a.setStandardHistograms(imageStretchOption.getStandardHistograms());
    }
}

