/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.mapping.dyn;

import com.supermap.data.GeoRegion;
import com.supermap.data.Geometry;
import com.supermap.data.GeometryType;
import com.supermap.data.Point2Ds;
import com.supermap.mapping.dyn.DynamicElement;

public class DynamicPolygon
extends DynamicElement {
    public DynamicPolygon() {
        this.mType = DynamicElement.ElementType.POLYGON;
    }

    @Override
    public boolean fromGeometry(Geometry geometry) {
        if (geometry == null) {
            return false;
        }
        if (geometry.getType() != GeometryType.GEOREGION) {
            return false;
        }
        if (geometry instanceof GeoRegion) {
            this.mPoints.clear();
            this.mParts.clear();
            GeoRegion geoRegion = (GeoRegion)geometry;
            int n2 = geoRegion.getPartCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                Point2Ds point2Ds = geoRegion.getPart(i2);
                int n3 = point2Ds.getCount();
                for (int i3 = 0; i3 < n3; ++i3) {
                    this.mPoints.add(point2Ds.getItem(i3));
                }
                this.mParts.add(n3);
            }
            this.updateBounds();
            return true;
        }
        return false;
    }
}

