/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.os.Handler;
import android.view.MotionEvent;
import android.view.View;
import java.io.InputStream;
import org.achartengine.ITouchHandler;
import org.achartengine.TouchHandler;
import org.achartengine.TouchHandlerOld;
import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.RoundChart;
import org.achartengine.chart.XYChart;
import org.achartengine.model.Point;
import org.achartengine.model.SeriesSelection;
import org.achartengine.renderer.DefaultRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.tools.FitZoom;
import org.achartengine.tools.PanListener;
import org.achartengine.tools.Zoom;
import org.achartengine.tools.ZoomListener;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GraphicalView
extends View {
    private AbstractChart a;
    private DefaultRenderer a;
    private Rect a;
    private Handler a;
    private RectF a;
    private Bitmap a;
    private Bitmap b;
    private Bitmap c;
    private int a;
    private static final int b = Color.argb((int)175, (int)150, (int)150, (int)150);
    private Zoom a;
    private Zoom b;
    private FitZoom a;
    private Paint a;
    private ITouchHandler a;
    private float a;
    private float b;
    private boolean a = new Paint();

    public GraphicalView(Context context, AbstractChart abstractChart) {
        super(context);
        this.a = abstractChart;
        this.a = new Handler();
        this.a = this.a instanceof XYChart ? ((XYChart)this.a).getRenderer() : ((RoundChart)this.a).getRenderer();
        if (this.a.isZoomButtonsVisible()) {
            this.a = BitmapFactory.decodeStream((InputStream)GraphicalView.class.getResourceAsStream("image/zoom_in.png"));
            this.b = BitmapFactory.decodeStream((InputStream)GraphicalView.class.getResourceAsStream("image/zoom_out.png"));
            this.c = BitmapFactory.decodeStream((InputStream)GraphicalView.class.getResourceAsStream("image/zoom-1.png"));
        }
        if (this.a instanceof XYMultipleSeriesRenderer && ((XYMultipleSeriesRenderer)this.a).getMarginsColor() == 0) {
            ((XYMultipleSeriesRenderer)this.a).setMarginsColor(this.a.getColor());
        }
        if (this.a.isZoomEnabled() && this.a.isZoomButtonsVisible() || this.a.isExternalZoomEnabled()) {
            this.a = new Zoom(this.a, true, this.a.getZoomRate());
            this.b = new Zoom(this.a, false, this.a.getZoomRate());
            this.a = new FitZoom(this.a);
        }
        int n2 = 7;
        try {
            n2 = Integer.valueOf(Build.VERSION.SDK);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.a = n2 < 7 ? new TouchHandlerOld(this, this.a) : new TouchHandler(this, this.a);
    }

    public SeriesSelection getCurrentSeriesAndPoint() {
        return this.a.getSeriesAndPointForScreenCoordinate(new Point(this.a, this.b));
    }

    public double[] toRealPoint(int n2) {
        if (this.a instanceof XYChart) {
            XYChart xYChart = (XYChart)this.a;
            return xYChart.toRealPoint(this.a, this.b, n2);
        }
        return null;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.getClipBounds(this.a);
        int n2 = this.a.top;
        int n3 = this.a.left;
        int n4 = this.a.width();
        int n5 = this.a.height();
        if (this.a.isInScroll()) {
            n2 = 0;
            n3 = 0;
            n4 = this.getMeasuredWidth();
            n5 = this.getMeasuredHeight();
        }
        this.a.draw(canvas, n3, n2, n4, n5, this.a);
        if (this.a != null && this.a.isZoomEnabled() && this.a.isZoomButtonsVisible()) {
            this.a.setColor(b);
            this.a = Math.max(this.a, Math.min(n4, n5) / 7);
            this.a.set((float)(n3 + n4 - this.a * 3), (float)(n2 + n5) - (float)this.a * 0.775f, (float)(n3 + n4), (float)(n2 + n5));
            canvas.drawRoundRect(this.a, (float)(this.a / 3), (float)(this.a / 3), this.a);
            float f2 = (float)(n2 + n5) - (float)this.a * 0.625f;
            canvas.drawBitmap(this.a, (float)(n3 + n4) - (float)this.a * 2.75f, f2, null);
            canvas.drawBitmap(this.b, (float)(n3 + n4) - (float)this.a * 1.75f, f2, null);
            canvas.drawBitmap(this.c, (float)(n3 + n4) - (float)this.a * 0.75f, f2, null);
        }
        this.a = true;
    }

    public void setZoomRate(float f2) {
        if (this.a != null && this.b != null) {
            this.a.setZoomRate(f2);
            this.b.setZoomRate(f2);
        }
    }

    public void zoomIn() {
        if (this.a != null) {
            this.a.apply(0);
            this.repaint();
        }
    }

    public void zoomOut() {
        if (this.b != null) {
            this.b.apply(0);
            this.repaint();
        }
    }

    public void zoomReset() {
        if (this.a != null) {
            this.a.apply();
            this.a.notifyZoomResetListeners();
            this.repaint();
        }
    }

    public void addZoomListener(ZoomListener zoomListener, boolean bl, boolean bl2) {
        if (bl) {
            if (this.a != null) {
                this.a.addZoomListener(zoomListener);
                this.b.addZoomListener(zoomListener);
            }
            if (bl2) {
                this.a.addZoomListener(zoomListener);
            }
        }
    }

    public synchronized void removeZoomListener(ZoomListener zoomListener) {
        if (this.a != null) {
            this.a.removeZoomListener(zoomListener);
            this.b.removeZoomListener(zoomListener);
        }
        this.a.removeZoomListener(zoomListener);
    }

    public void addPanListener(PanListener panListener) {
        this.a.addPanListener(panListener);
    }

    public void removePanListener(PanListener panListener) {
        this.a.removePanListener(panListener);
    }

    protected RectF getZoomRectangle() {
        return this.a;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 0) {
            this.a = motionEvent.getX();
            this.b = motionEvent.getY();
        }
        if (this.a != null && this.a && (this.a.isPanEnabled() || this.a.isZoomEnabled()) && this.a.handleTouch(motionEvent)) {
            return true;
        }
        return super.onTouchEvent(motionEvent);
    }

    public void repaint() {
        this.a.post(new Runnable(){

            @Override
            public void run() {
                GraphicalView.this.invalidate();
            }
        });
    }

    public void repaint(final int n2, final int n3, final int n4, final int n5) {
        this.a.post(new Runnable(){

            @Override
            public void run() {
                GraphicalView.this.invalidate(n2, n3, n4, n5);
            }
        });
    }

    public Bitmap toBitmap() {
        this.setDrawingCacheEnabled(false);
        if (!this.isDrawingCacheEnabled()) {
            this.setDrawingCacheEnabled(true);
        }
        if (this.a.isApplyBackgroundColor()) {
            this.setDrawingCacheBackgroundColor(this.a.getBackgroundColor());
        }
        this.setDrawingCacheQuality(0x100000);
        return this.getDrawingCache(true);
    }
}

