/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.GradientDrawable;
import java.util.List;
import org.achartengine.chart.ClickableArea;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

public class BarChart
extends XYChart {
    public static final String TYPE = "Bar";
    protected Type mType = Type.DEFAULT;

    BarChart() {
    }

    BarChart(Type type) {
        this.mType = type;
    }

    public BarChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, Type type) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        this.mType = type;
    }

    @Override
    protected ClickableArea[] clickableAreasForPoints(List<Float> list, List<Double> list2, float f2, int n2, int n3) {
        int n4 = this.mDataset.getSeriesCount();
        int n5 = list.size();
        ClickableArea[] clickableAreaArray = new ClickableArea[n5 / 2];
        float f3 = this.getHalfDiffX(list, n5, n4);
        for (int i2 = 0; i2 < n5; i2 += 2) {
            float f4 = list.get(i2).floatValue();
            float f5 = list.get(i2 + 1).floatValue();
            if (this.mType == Type.STACKED) {
                clickableAreaArray[i2 / 2] = new ClickableArea(new RectF(f4 - f3, Math.min(f5, f2), f4 + f3, Math.max(f5, f2)), list2.get(i2), list2.get(i2 + 1));
                continue;
            }
            float f6 = f4 - (float)n4 * f3 + (float)(n2 * 2) * f3;
            clickableAreaArray[i2 / 2] = new ClickableArea(new RectF(f6, Math.min(f5, f2), f6 + 2.0f * f3, Math.max(f5, f2)), list2.get(i2), list2.get(i2 + 1));
        }
        return clickableAreaArray;
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, List<Float> list, SimpleSeriesRenderer simpleSeriesRenderer, float f2, int n2, int n3) {
        int n4 = this.mDataset.getSeriesCount();
        int n5 = list.size();
        paint.setColor(simpleSeriesRenderer.getColor());
        paint.setStyle(Paint.Style.FILL);
        float f3 = this.getHalfDiffX(list, n5, n4);
        for (int i2 = 0; i2 < n5; i2 += 2) {
            float f4 = list.get(i2).floatValue();
            float f5 = list.get(i2 + 1).floatValue();
            this.drawBar(canvas, f4, f2, f4, f5, f3, n4, n2, paint);
        }
        paint.setColor(simpleSeriesRenderer.getColor());
    }

    protected void drawBar(Canvas canvas, float f2, float f3, float f4, float f5, float f6, int n2, int n3, Paint paint) {
        int n4 = this.mDataset.getSeriesAt(n3).getScaleNumber();
        if (this.mType == Type.STACKED) {
            this.a(canvas, f2 - f6, f5, f4 + f6, f3, n4, n3, paint);
        } else {
            float f7 = f2 - (float)n2 * f6 + (float)(n3 * 2) * f6;
            this.a(canvas, f7, f5, f7 + 2.0f * f6, f3, n4, n3, paint);
        }
    }

    private void a(Canvas canvas, float f2, float f3, float f4, float f5, int n2, int n3, Paint paint) {
        SimpleSeriesRenderer simpleSeriesRenderer = this.mRenderer.getSeriesRendererAt(n3);
        if (simpleSeriesRenderer.isGradientEnabled()) {
            int n4;
            float f6 = (float)this.toScreenPoint(new double[]{0.0, simpleSeriesRenderer.getGradientStopValue()}, n2)[1];
            float f7 = (float)this.toScreenPoint(new double[]{0.0, simpleSeriesRenderer.getGradientStartValue()}, n2)[1];
            float f8 = Math.max(f6, Math.min(f3, f5));
            float f9 = Math.min(f7, Math.max(f3, f5));
            int n5 = simpleSeriesRenderer.getGradientStopColor();
            int n6 = n4 = simpleSeriesRenderer.getGradientStartColor();
            int n7 = n5;
            if (f3 < f6) {
                paint.setColor(n5);
                canvas.drawRect((float)Math.round(f2), (float)Math.round(f3), (float)Math.round(f4), (float)Math.round(f8), paint);
            } else {
                n7 = this.a(n5, n4, (f7 - f8) / (f7 - f6));
            }
            if (f5 > f7) {
                paint.setColor(n4);
                canvas.drawRect((float)Math.round(f2), (float)Math.round(f9), (float)Math.round(f4), (float)Math.round(f5), paint);
            } else {
                n6 = this.a(n4, n5, (f9 - f6) / (f7 - f6));
            }
            GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{n6, n7});
            gradientDrawable.setBounds(Math.round(f2), Math.round(f8), Math.round(f4), Math.round(f9));
            gradientDrawable.draw(canvas);
        } else {
            if (Math.abs(f3 - f5) < 1.0f) {
                f5 = f3 < f5 ? f3 + 1.0f : f3 - 1.0f;
            }
            canvas.drawRect((float)Math.round(f2), (float)Math.round(f3), (float)Math.round(f4), (float)Math.round(f5), paint);
        }
    }

    private int a(int n2, int n3, float f2) {
        int n4 = Math.round(f2 * (float)Color.alpha((int)n2) + (1.0f - f2) * (float)Color.alpha((int)n3));
        int n5 = Math.round(f2 * (float)Color.red((int)n2) + (1.0f - f2) * (float)Color.red((int)n3));
        int n6 = Math.round(f2 * (float)Color.green((int)n2) + (1.0f - f2) * (float)Color.green((int)n3));
        int n7 = Math.round(f2 * (float)Color.blue((int)n2) + (1.0f - f2) * (float)Color.blue((int)n3));
        return Color.argb((int)n4, (int)n5, (int)n6, (int)n7);
    }

    @Override
    protected void drawChartValuesText(Canvas canvas, XYSeries xYSeries, SimpleSeriesRenderer simpleSeriesRenderer, Paint paint, List<Float> list, int n2, int n3) {
        int n4 = this.mDataset.getSeriesCount();
        int n5 = list.size();
        float f2 = this.getHalfDiffX(list, n5, n4);
        for (int i2 = 0; i2 < n5; i2 += 2) {
            int n6 = n3 + i2 / 2;
            double d2 = xYSeries.getY(n6);
            if (this.isNullValue(d2)) continue;
            float f3 = list.get(i2).floatValue();
            if (this.mType == Type.DEFAULT) {
                f3 += (float)(n2 * 2) * f2 - ((float)n4 - 1.5f) * f2;
            }
            if (d2 >= 0.0) {
                this.drawText(canvas, this.getLabel(simpleSeriesRenderer.getChartValuesFormat(), d2), f3, list.get(i2 + 1).floatValue() - simpleSeriesRenderer.getChartValuesSpacing(), paint, 0.0f);
                continue;
            }
            this.drawText(canvas, this.getLabel(simpleSeriesRenderer.getChartValuesFormat(), d2), f3, list.get(i2 + 1).floatValue() + simpleSeriesRenderer.getChartValuesTextSize() + simpleSeriesRenderer.getChartValuesSpacing() - 3.0f, paint, 0.0f);
        }
    }

    @Override
    public int getLegendShapeWidth(int n2) {
        return 12;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f2, float f3, int n2, Paint paint) {
        float f4 = 6.0f;
        canvas.drawRect(f2, f3 - f4, f2 + 12.0f, f3 + f4, paint);
    }

    protected float getHalfDiffX(List<Float> list, int n2, int n3) {
        float f2;
        float f3 = this.mRenderer.getBarWidth();
        if (f3 > 0.0f) {
            return f3 / 2.0f;
        }
        int n4 = n2;
        if (n2 > 2) {
            n4 = n2 - 2;
        }
        if ((f2 = (list.get(n2 - 2).floatValue() - list.get(0).floatValue()) / (float)n4) == 0.0f) {
            f2 = 10.0f;
        }
        if (this.mType != Type.STACKED) {
            f2 /= (float)n3;
        }
        return (float)((double)f2 / ((double)this.getCoeficient() * (1.0 + this.mRenderer.getBarSpacing())));
    }

    protected float getCoeficient() {
        return 1.0f;
    }

    @Override
    protected boolean isRenderNullValues() {
        return true;
    }

    @Override
    public double getDefaultMinimum() {
        return 0.0;
    }

    @Override
    public String getChartType() {
        return TYPE;
    }

    public static enum Type {
        DEFAULT,
        STACKED;

    }
}

