/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import java.util.List;
import org.achartengine.chart.ClickableArea;
import org.achartengine.chart.XYChart;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYValueSeries;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.renderer.XYSeriesRenderer;

public class BubbleChart
extends XYChart {
    public static final String TYPE = "Bubble";

    BubbleChart() {
    }

    public BubbleChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
    }

    @Override
    public void drawSeries(Canvas canvas, Paint paint, List<Float> list, SimpleSeriesRenderer simpleSeriesRenderer, float f2, int n2, int n3) {
        XYSeriesRenderer xYSeriesRenderer = (XYSeriesRenderer)simpleSeriesRenderer;
        paint.setColor(xYSeriesRenderer.getColor());
        paint.setStyle(Paint.Style.FILL);
        int n4 = list.size();
        XYValueSeries xYValueSeries = (XYValueSeries)this.mDataset.getSeriesAt(n2);
        double d2 = xYValueSeries.getMaxValue();
        double d3 = 20.0 / d2;
        for (int i2 = 0; i2 < n4; i2 += 2) {
            double d4 = xYValueSeries.getValue(n3 + i2 / 2) * d3 + 2.0;
            this.a(canvas, paint, list.get(i2).floatValue(), list.get(i2 + 1).floatValue(), (float)d4);
        }
    }

    @Override
    protected ClickableArea[] clickableAreasForPoints(List<Float> list, List<Double> list2, float f2, int n2, int n3) {
        int n4 = list.size();
        XYValueSeries xYValueSeries = (XYValueSeries)this.mDataset.getSeriesAt(n2);
        double d2 = xYValueSeries.getMaxValue();
        double d3 = 20.0 / d2;
        ClickableArea[] clickableAreaArray = new ClickableArea[n4 / 2];
        for (int i2 = 0; i2 < n4; i2 += 2) {
            double d4 = xYValueSeries.getValue(n3 + i2 / 2) * d3 + 2.0;
            clickableAreaArray[i2 / 2] = new ClickableArea(new RectF(list.get(i2).floatValue() - (float)d4, list.get(i2 + 1).floatValue() - (float)d4, list.get(i2).floatValue() + (float)d4, list.get(i2 + 1).floatValue() + (float)d4), list2.get(i2), list2.get(i2 + 1));
        }
        return clickableAreaArray;
    }

    @Override
    public int getLegendShapeWidth(int n2) {
        return 10;
    }

    @Override
    public void drawLegendShape(Canvas canvas, SimpleSeriesRenderer simpleSeriesRenderer, float f2, float f3, int n2, Paint paint) {
        paint.setStyle(Paint.Style.FILL);
        this.a(canvas, paint, f2 + 10.0f, f3, 3.0f);
    }

    private void a(Canvas canvas, Paint paint, float f2, float f3, float f4) {
        canvas.drawCircle(f2, f3, f4, paint);
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

