/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import java.util.List;
import org.achartengine.chart.LineChart;
import org.achartengine.model.Point;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.renderer.XYMultipleSeriesRenderer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class CubicLineChart
extends LineChart {
    public static final String TYPE = "Cubic";
    private float a;
    private float b;
    private Point a = new Point();
    private Point b = new Point();
    private Point c = new Point();

    public CubicLineChart() {
        this.a = 0.33f;
        this.b = 1.0f - this.a;
    }

    public CubicLineChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer, float f2) {
        super(xYMultipleSeriesDataset, xYMultipleSeriesRenderer);
        this.a = f2;
        this.b = 1.0f - this.a;
    }

    @Override
    protected void drawPath(Canvas canvas, List<Float> list, Paint paint, boolean bl) {
        int n2;
        Path path = new Path();
        float f2 = list.get(0).floatValue();
        float f3 = list.get(1).floatValue();
        path.moveTo(f2, f3);
        int n3 = list.size();
        if (bl) {
            n3 -= 4;
        }
        for (n2 = 0; n2 < n3; n2 += 2) {
            int n4 = n2 + 2 < n3 ? n2 + 2 : n2;
            int n5 = n2 + 4 < n3 ? n2 + 4 : n4;
            this.a(list, this.a, n2, n4, this.b);
            this.b.setX(list.get(n4).floatValue());
            this.b.setY(list.get(n4 + 1).floatValue());
            this.a(list, this.c, n4, n5, this.a);
            path.cubicTo(this.a.getX(), this.a.getY(), this.b.getX(), this.b.getY(), this.c.getX(), this.c.getY());
        }
        if (bl) {
            for (n2 = n3; n2 < n3 + 4; n2 += 2) {
                path.lineTo(list.get(n2).floatValue(), list.get(n2 + 1).floatValue());
            }
            path.lineTo(list.get(0).floatValue(), list.get(1).floatValue());
        }
        canvas.drawPath(path, paint);
    }

    private void a(List<Float> list, Point point, int n2, int n3, float f2) {
        float f3 = list.get(n2).floatValue();
        float f4 = list.get(n2 + 1).floatValue();
        float f5 = list.get(n3).floatValue();
        float f6 = list.get(n3 + 1).floatValue();
        float f7 = f5 - f3;
        float f8 = f6 - f4;
        point.setX(f3 + f7 * f2);
        point.setY(f4 + f8 * f2);
    }

    @Override
    public String getChartType() {
        return TYPE;
    }
}

