/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.Paint;
import org.achartengine.chart.RoundChart;
import org.achartengine.model.CategorySeries;
import org.achartengine.renderer.DialRenderer;

public class DialChart
extends RoundChart {
    private DialRenderer a;

    public DialChart(CategorySeries categorySeries, DialRenderer dialRenderer) {
        super(categorySeries, dialRenderer);
        this.a = dialRenderer;
    }

    @Override
    public void draw(Canvas canvas, int n2, int n3, int n4, int n5, Paint paint) {
        double d2;
        int n6;
        paint.setAntiAlias(this.a.isAntialiasing());
        paint.setStyle(Paint.Style.FILL);
        paint.setTextSize(this.a.getLabelsTextSize());
        int n7 = this.getLegendSize(this.a, n5 / 5, 0.0f);
        int n8 = n2;
        int n9 = n3;
        int n10 = n2 + n4;
        int n11 = this.mDataset.getItemCount();
        String[] stringArray = new String[n11];
        for (n6 = 0; n6 < n11; ++n6) {
            stringArray[n6] = this.mDataset.getCategory(n6);
        }
        if (this.a.isFitLegend()) {
            n7 = this.drawLegend(canvas, this.a, stringArray, n8, n10, n3, n4, n5, n7, paint, true);
        }
        n6 = n3 + n5 - n7;
        this.drawBackground(this.a, canvas, n2, n3, n4, n5, paint, false, 0);
        int n12 = Math.min(Math.abs(n10 - n8), Math.abs(n6 - n9));
        int n13 = (int)((double)n12 * 0.35 * (double)this.a.getScale());
        if (this.mCenterX == Integer.MAX_VALUE) {
            this.mCenterX = (n8 + n10) / 2;
        }
        if (this.mCenterY == Integer.MAX_VALUE) {
            this.mCenterY = (n6 + n9) / 2;
        }
        float f2 = (float)n13 * 0.9f;
        float f3 = (float)n13 * 1.1f;
        double d3 = this.a.getMinValue();
        double d4 = this.a.getMaxValue();
        double d5 = this.a.getAngleMin();
        double d6 = this.a.getAngleMax();
        if (!this.a.isMinValueSet() || !this.a.isMaxValueSet()) {
            int n14 = this.a.getSeriesRendererCount();
            for (int i2 = 0; i2 < n14; ++i2) {
                d2 = this.mDataset.getValue(i2);
                if (!this.a.isMinValueSet()) {
                    d3 = Math.min(d3, d2);
                }
                if (this.a.isMaxValueSet()) continue;
                d4 = Math.max(d4, d2);
            }
        }
        if (d3 == d4) {
            d3 *= 0.5;
            d4 *= 1.5;
        }
        paint.setColor(this.a.getLabelsColor());
        double d7 = this.a.getMinorTicksSpacing();
        d2 = this.a.getMajorTicksSpacing();
        if (d7 == Double.MAX_VALUE) {
            d7 = (d4 - d3) / 30.0;
        }
        if (d2 == Double.MAX_VALUE) {
            d2 = (d4 - d3) / 10.0;
        }
        this.a(canvas, d3, d4, d5, d6, this.mCenterX, this.mCenterY, f3, n13, d7, paint, false);
        this.a(canvas, d3, d4, d5, d6, this.mCenterX, this.mCenterY, f3, f2, d2, paint, true);
        int n15 = this.a.getSeriesRendererCount();
        for (int i3 = 0; i3 < n15; ++i3) {
            double d8 = this.a(this.mDataset.getValue(i3), d5, d6, d3, d4);
            paint.setColor(this.a.getSeriesRendererAt(i3).getColor());
            boolean bl = this.a.getVisualTypeForIndex(i3) == DialRenderer.Type.ARROW;
            this.a(canvas, d8, this.mCenterX, this.mCenterY, f2, bl, paint);
        }
        this.drawLegend(canvas, this.a, stringArray, n8, n10, n3, n4, n5, n7, paint, false);
        this.drawTitle(canvas, n2, n3, n4, paint);
    }

    private double a(double d2, double d3, double d4, double d5, double d6) {
        double d7 = d4 - d3;
        double d8 = d6 - d5;
        return Math.toRadians(d3 + (d2 - d5) * d7 / d8);
    }

    private void a(Canvas canvas, double d2, double d3, double d4, double d5, int n2, int n3, double d6, double d7, double d8, Paint paint, boolean bl) {
        for (double d9 = d2; d9 <= d3; d9 += d8) {
            double d10 = this.a(d9, d4, d5, d2, d3);
            double d11 = Math.sin(d10);
            double d12 = Math.cos(d10);
            int n4 = Math.round((float)n2 + (float)(d7 * d11));
            int n5 = Math.round((float)n3 + (float)(d7 * d12));
            int n6 = Math.round((float)n2 + (float)(d6 * d11));
            int n7 = Math.round((float)n3 + (float)(d6 * d12));
            canvas.drawLine((float)n4, (float)n5, (float)n6, (float)n7, paint);
            if (!bl) continue;
            paint.setTextAlign(Paint.Align.LEFT);
            if (n4 <= n6) {
                paint.setTextAlign(Paint.Align.RIGHT);
            }
            String string2 = d9 + "";
            if (Math.round(d9) == (long)d9) {
                string2 = (long)d9 + "";
            }
            canvas.drawText(string2, (float)n4, (float)n5, paint);
        }
    }

    private void a(Canvas canvas, double d2, int n2, int n3, double d3, boolean bl, Paint paint) {
        float[] fArray;
        double d4 = Math.toRadians(90.0);
        int n4 = (int)(10.0 * Math.sin(d2 - d4));
        int n5 = (int)(10.0 * Math.cos(d2 - d4));
        int n6 = (int)(d3 * Math.sin(d2));
        int n7 = (int)(d3 * Math.cos(d2));
        int n8 = n2 + n6;
        int n9 = n3 + n7;
        if (bl) {
            int n10 = n2 + (int)(d3 * 0.85 * Math.sin(d2));
            int n11 = n3 + (int)(d3 * 0.85 * Math.cos(d2));
            fArray = new float[]{n10 - n4, n11 - n5, n8, n9, n10 + n4, n11 + n5};
            float f2 = paint.getStrokeWidth();
            paint.setStrokeWidth(5.0f);
            canvas.drawLine((float)n2, (float)n3, (float)n8, (float)n9, paint);
            paint.setStrokeWidth(f2);
        } else {
            fArray = new float[]{n2 - n4, n3 - n5, n8, n9, n2 + n4, n3 + n5};
        }
        this.drawPath(canvas, fArray, paint, true);
    }
}

