/*
 * Decompiled with CFR 0.152.
 */
package org.achartengine.chart;

import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.achartengine.chart.AbstractChart;
import org.achartengine.chart.ClickableArea;
import org.achartengine.chart.ScatterChart;
import org.achartengine.model.Point;
import org.achartengine.model.SeriesSelection;
import org.achartengine.model.XYMultipleSeriesDataset;
import org.achartengine.model.XYSeries;
import org.achartengine.renderer.BasicStroke;
import org.achartengine.renderer.SimpleSeriesRenderer;
import org.achartengine.renderer.XYMultipleSeriesRenderer;
import org.achartengine.util.MathHelper;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class XYChart
extends AbstractChart {
    protected XYMultipleSeriesDataset mDataset;
    protected XYMultipleSeriesRenderer mRenderer;
    private float a;
    private float b;
    private Point a;
    private Rect a;
    private final Map<Integer, double[]> a = (float)new HashMap();
    private Map<Integer, List<ClickableArea>> b = (float)new HashMap();

    protected XYChart() {
    }

    public XYChart(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        this.mDataset = xYMultipleSeriesDataset;
        this.mRenderer = xYMultipleSeriesRenderer;
    }

    protected void setDatasetRenderer(XYMultipleSeriesDataset xYMultipleSeriesDataset, XYMultipleSeriesRenderer xYMultipleSeriesRenderer) {
        this.mDataset = xYMultipleSeriesDataset;
        this.mRenderer = xYMultipleSeriesRenderer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(Canvas canvas, int n2, int n3, int n4, int n5, Paint paint) {
        Paint.Align align;
        Paint.Align align2;
        Object object;
        Object object2;
        int n6;
        int n7;
        int n8;
        XYMultipleSeriesRenderer.Orientation orientation;
        int n9;
        paint.setAntiAlias(this.mRenderer.isAntialiasing());
        int n10 = this.getLegendSize(this.mRenderer, n5 / 5, this.mRenderer.getAxisTitleTextSize());
        int[] nArray = this.mRenderer.getMargins();
        int n11 = n2 + nArray[1];
        int n12 = n3 + nArray[0];
        int n13 = n2 + n4 - nArray[3];
        int n14 = this.mDataset.getSeriesCount();
        String[] stringArray = new String[n14];
        for (n9 = 0; n9 < n14; ++n9) {
            stringArray[n9] = this.mDataset.getSeriesAt(n9).getTitle();
        }
        if (this.mRenderer.isFitLegend() && this.mRenderer.isShowLegend()) {
            n10 = this.drawLegend(canvas, this.mRenderer, stringArray, n11, n13, n3, n4, n5, n10, paint, true);
        }
        n9 = n3 + n5 - nArray[2] - n10;
        if (this.a == null) {
            this.a = new Rect();
        }
        this.a.set(n11, n12, n13, n9);
        this.drawBackground(this.mRenderer, canvas, n2, n3, n4, n5, paint, false, 0);
        if (paint.getTypeface() == null || this.mRenderer.getTextTypeface() != null && paint.getTypeface().equals(this.mRenderer.getTextTypeface()) || !paint.getTypeface().toString().equals(this.mRenderer.getTextTypefaceName()) || paint.getTypeface().getStyle() != this.mRenderer.getTextTypefaceStyle()) {
            if (this.mRenderer.getTextTypeface() != null) {
                paint.setTypeface(this.mRenderer.getTextTypeface());
            } else {
                paint.setTypeface(Typeface.create((String)this.mRenderer.getTextTypefaceName(), (int)this.mRenderer.getTextTypefaceStyle()));
            }
        }
        if ((orientation = this.mRenderer.getOrientation()) == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
            n13 -= n10;
            n9 += n10 - 20;
        }
        boolean bl = (n8 = orientation.getAngle()) == 90;
        this.a = (float)n5 / (float)n4;
        this.b = Math.abs(n4 - n5) / 2;
        if (this.a < 1.0f) {
            this.b *= -1.0f;
        }
        this.a = new Point((n2 + n4) / 2, (n3 + n5) / 2);
        if (bl) {
            this.a(canvas, n8, false);
        }
        int n15 = -2147483647;
        for (int i2 = 0; i2 < n14; ++i2) {
            n15 = Math.max(n15, this.mDataset.getSeriesAt(i2).getScaleNumber());
        }
        if (++n15 < 0) {
            return;
        }
        double[] dArray = new double[n15];
        double[] dArray2 = new double[n15];
        double[] dArray3 = new double[n15];
        double[] dArray4 = new double[n15];
        boolean[] blArray = new boolean[n15];
        boolean[] blArray2 = new boolean[n15];
        boolean[] blArray3 = new boolean[n15];
        boolean[] blArray4 = new boolean[n15];
        for (int i3 = 0; i3 < n15; ++i3) {
            dArray[i3] = this.mRenderer.getXAxisMin(i3);
            dArray2[i3] = this.mRenderer.getXAxisMax(i3);
            dArray3[i3] = this.mRenderer.getYAxisMin(i3);
            dArray4[i3] = this.mRenderer.getYAxisMax(i3);
            blArray[i3] = this.mRenderer.isMinXSet(i3);
            blArray2[i3] = this.mRenderer.isMaxXSet(i3);
            blArray3[i3] = this.mRenderer.isMinYSet(i3);
            blArray4[i3] = this.mRenderer.isMaxYSet(i3);
            if (this.a.get(i3) != null) continue;
            this.a.put(i3, new double[4]);
        }
        double[] dArray5 = new double[n15];
        double[] dArray6 = new double[n15];
        for (n7 = 0; n7 < n14; ++n7) {
            double d2;
            XYSeries xYSeries = this.mDataset.getSeriesAt(n7);
            int n16 = xYSeries.getScaleNumber();
            if (xYSeries.getItemCount() == 0) continue;
            if (!blArray[n16]) {
                d2 = xYSeries.getMinX();
                dArray[n16] = Math.min(dArray[n16], d2);
                ((double[])this.a.get((Object)Integer.valueOf((int)n16)))[0] = dArray[n16];
            }
            if (!blArray2[n16]) {
                d2 = xYSeries.getMaxX();
                dArray2[n16] = Math.max(dArray2[n16], d2);
                ((double[])this.a.get((Object)Integer.valueOf((int)n16)))[1] = dArray2[n16];
            }
            if (!blArray3[n16]) {
                d2 = xYSeries.getMinY();
                dArray3[n16] = Math.min(dArray3[n16], (double)((float)d2));
                ((double[])this.a.get((Object)Integer.valueOf((int)n16)))[2] = dArray3[n16];
            }
            if (blArray4[n16]) continue;
            d2 = xYSeries.getMaxY();
            dArray4[n16] = Math.max(dArray4[n16], (double)((float)d2));
            ((double[])this.a.get((Object)Integer.valueOf((int)n16)))[3] = dArray4[n16];
        }
        for (n7 = 0; n7 < n15; ++n7) {
            if (dArray2[n7] - dArray[n7] != 0.0) {
                dArray5[n7] = (double)(n13 - n11) / (dArray2[n7] - dArray[n7]);
            }
            if (dArray4[n7] - dArray3[n7] == 0.0) continue;
            dArray6[n7] = (float)((double)(n9 - n12) / (dArray4[n7] - dArray3[n7]));
        }
        n7 = 0;
        this.b = (float)new HashMap();
        for (n6 = 0; n6 < n14; ++n6) {
            Paint.Align align3 = this.mDataset.getSeriesAt(n6);
            int n17 = align3.getScaleNumber();
            if (align3.getItemCount() == 0) continue;
            n7 = 1;
            object2 = this.mRenderer.getSeriesRendererAt(n6);
            object = new ArrayList();
            ArrayList<Double> arrayList = new ArrayList<Double>();
            float f2 = Math.min((float)n9, (float)((double)n9 + dArray6[n17] * dArray3[n17]));
            align2 = new LinkedList();
            this.b.put(n6, align2);
            align = align3;
            synchronized (align) {
                Paint.Align align4 = align3.getRange(dArray[n17], dArray2[n17], ((SimpleSeriesRenderer)object2).isDisplayBoundingPoints());
                int n18 = -1;
                for (Map.Entry<Double, Double> entry : align4.entrySet()) {
                    double d2 = entry.getKey();
                    double d3 = entry.getValue();
                    if (n18 < 0 && (!this.isNullValue(d3) || this.isRenderNullValues())) {
                        n18 = align3.getIndexForKey(d2);
                    }
                    arrayList.add(entry.getKey());
                    arrayList.add(entry.getValue());
                    if (!this.isNullValue(d3)) {
                        object.add(Float.valueOf((float)((double)n11 + dArray5[n17] * (d2 - dArray[n17]))));
                        object.add(Float.valueOf((float)((double)n9 - dArray6[n17] * (d3 - dArray3[n17]))));
                        continue;
                    }
                    if (this.isRenderNullValues()) {
                        object.add(Float.valueOf((float)((double)n11 + dArray5[n17] * (d2 - dArray[n17]))));
                        object.add(Float.valueOf((float)((double)n9 - dArray6[n17] * -dArray3[n17])));
                        continue;
                    }
                    if (object.size() > 0) {
                        this.drawSeries((XYSeries)align3, canvas, paint, (List<Float>)object, (SimpleSeriesRenderer)object2, f2, n6, orientation, n18);
                        ClickableArea[] clickableAreaArray = this.clickableAreasForPoints((List<Float>)object, arrayList, f2, n6, n18);
                        align2.addAll(Arrays.asList(clickableAreaArray));
                        object.clear();
                        arrayList.clear();
                        n18 = -1;
                    }
                    align2.add(null);
                }
                int n19 = align3.getAnnotationCount();
                if (n19 > 0) {
                    paint.setColor(this.mRenderer.getLabelsColor());
                    Rect rect = new Rect();
                    for (int i2 = 0; i2 < n19; ++i2) {
                        float f3 = (float)((double)n11 + dArray5[n17] * (align3.getAnnotationX(i2) - dArray[n17]));
                        float f4 = (float)((double)n9 - dArray6[n17] * (align3.getAnnotationY(i2) - dArray3[n17]));
                        paint.getTextBounds(align3.getAnnotationAt(i2), 0, align3.getAnnotationAt(i2).length(), rect);
                        if (!(f3 < f3 + (float)rect.width()) || !(f4 < (float)canvas.getHeight())) continue;
                        this.drawString(canvas, align3.getAnnotationAt(i2), f3, f4, paint);
                    }
                }
                if (object.size() > 0) {
                    this.drawSeries((XYSeries)align3, canvas, paint, (List<Float>)object, (SimpleSeriesRenderer)object2, f2, n6, orientation, n18);
                    ClickableArea[] clickableAreaArray = this.clickableAreasForPoints((List<Float>)object, arrayList, f2, n6, n18);
                    align2.addAll(Arrays.asList(clickableAreaArray));
                }
                continue;
            }
        }
        this.drawBackground(this.mRenderer, canvas, n2, n9, n4, n5 - n9, paint, true, this.mRenderer.getMarginsColor());
        this.drawBackground(this.mRenderer, canvas, n2, n3, n4, nArray[0], paint, true, this.mRenderer.getMarginsColor());
        if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
            this.drawBackground(this.mRenderer, canvas, n2, n3, n11 - n2, n5 - n3, paint, true, this.mRenderer.getMarginsColor());
            this.drawBackground(this.mRenderer, canvas, n13, n3, nArray[3], n5 - n3, paint, true, this.mRenderer.getMarginsColor());
        } else if (orientation == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
            this.drawBackground(this.mRenderer, canvas, n13, n3, n4 - n13, n5 - n3, paint, true, this.mRenderer.getMarginsColor());
            this.drawBackground(this.mRenderer, canvas, n2, n3, n11 - n2, n5 - n3, paint, true, this.mRenderer.getMarginsColor());
        }
        n6 = this.mRenderer.isShowLabels() && n7 != 0 ? 1 : 0;
        boolean bl2 = this.mRenderer.isShowGridX();
        boolean bl3 = this.mRenderer.isShowCustomTextGrid();
        if (n6 != 0 || bl2) {
            object2 = this.a(this.getXLabels(dArray[0], dArray2[0], this.mRenderer.getXLabels()));
            object = this.getYLabels(dArray3, dArray4, n15);
            int n20 = n11;
            if (n6 != 0) {
                paint.setColor(this.mRenderer.getXLabelsColor());
                paint.setTextSize(this.mRenderer.getLabelsTextSize());
                paint.setTextAlign(this.mRenderer.getXLabelsAlign());
            }
            this.drawXLabels((List<Double>)object2, this.mRenderer.getXTextLabelLocations(), canvas, paint, n20, n12, n9, dArray5[0], dArray[0], dArray2[0]);
            this.drawYLabels((Map<Integer, List<Double>>)object, canvas, paint, n15, n11, n13, n9, dArray6, dArray3);
            if (n6 != 0) {
                paint.setColor(this.mRenderer.getLabelsColor());
                for (int i5 = 0; i5 < n15; ++i5) {
                    align2 = this.mRenderer.getYAxisAlign(i5);
                    for (Double d4 : align = this.mRenderer.getYTextLabelLocations(i5)) {
                        if (!(dArray3[i5] <= d4) || !(d4 <= dArray4[i5])) continue;
                        float f5 = (float)((double)n9 - dArray6[i5] * (d4 - dArray3[i5]));
                        String string2 = this.mRenderer.getYTextLabel(d4, i5);
                        paint.setColor(this.mRenderer.getYLabelsColor(i5));
                        paint.setTextAlign(this.mRenderer.getYLabelsAlign(i5));
                        if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                            if (align2 == Paint.Align.LEFT) {
                                canvas.drawLine((float)(n11 + this.a(align2)), f5, (float)n11, f5, paint);
                                this.drawText(canvas, string2, n11, f5 - this.mRenderer.getYLabelsVerticalPadding(), paint, this.mRenderer.getYLabelsAngle());
                            } else {
                                canvas.drawLine((float)n13, f5, (float)(n13 + this.a(align2)), f5, paint);
                                this.drawText(canvas, string2, n13, f5 - this.mRenderer.getYLabelsVerticalPadding(), paint, this.mRenderer.getYLabelsAngle());
                            }
                            if (!bl3) continue;
                            paint.setColor(this.mRenderer.getGridColor());
                            canvas.drawLine((float)n11, f5, (float)n13, f5, paint);
                            continue;
                        }
                        canvas.drawLine((float)(n13 - this.a(align2)), f5, (float)n13, f5, paint);
                        this.drawText(canvas, string2, n13 + 10, f5 - this.mRenderer.getYLabelsVerticalPadding(), paint, this.mRenderer.getYLabelsAngle());
                        if (!bl3) continue;
                        paint.setColor(this.mRenderer.getGridColor());
                        canvas.drawLine((float)n13, f5, (float)n11, f5, paint);
                    }
                }
            }
            if (n6 != 0) {
                paint.setColor(this.mRenderer.getLabelsColor());
                float f6 = this.mRenderer.getAxisTitleTextSize();
                paint.setTextSize(f6);
                paint.setTextAlign(Paint.Align.CENTER);
                if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                    this.drawText(canvas, this.mRenderer.getXTitle(), n2 + n4 / 2, (float)n9 + this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f + this.mRenderer.getXLabelsPadding() + f6, paint, 0.0f);
                    for (int i6 = 0; i6 < n15; ++i6) {
                        align = this.mRenderer.getYAxisAlign(i6);
                        if (align == Paint.Align.LEFT) {
                            this.drawText(canvas, this.mRenderer.getYTitle(i6), (float)n2 + f6, n3 + n5 / 2, paint, -90.0f);
                            continue;
                        }
                        this.drawText(canvas, this.mRenderer.getYTitle(i6), n2 + n4, n3 + n5 / 2, paint, -90.0f);
                    }
                    paint.setTextSize(this.mRenderer.getChartTitleTextSize());
                    this.drawText(canvas, this.mRenderer.getChartTitle(), n2 + n4 / 2, (float)n3 + this.mRenderer.getChartTitleTextSize(), paint, 0.0f);
                } else if (orientation == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
                    this.drawText(canvas, this.mRenderer.getXTitle(), n2 + n4 / 2, (float)(n3 + n5) - f6 + this.mRenderer.getXLabelsPadding(), paint, -90.0f);
                    this.drawText(canvas, this.mRenderer.getYTitle(), n13 + 20, n3 + n5 / 2, paint, 0.0f);
                    paint.setTextSize(this.mRenderer.getChartTitleTextSize());
                    this.drawText(canvas, this.mRenderer.getChartTitle(), (float)n2 + f6, n12 + n5 / 2, paint, 0.0f);
                }
            }
        }
        if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
            this.drawLegend(canvas, this.mRenderer, stringArray, n11, n13, n3 + (int)this.mRenderer.getXLabelsPadding(), n4, n5, n10, paint, false);
        } else if (orientation == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
            this.a(canvas, n8, true);
            this.drawLegend(canvas, this.mRenderer, stringArray, n11, n13, n3 + (int)this.mRenderer.getXLabelsPadding(), n4, n5, n10, paint, false);
            this.a(canvas, n8, false);
        }
        if (this.mRenderer.isShowAxes()) {
            paint.setColor(this.mRenderer.getAxesColor());
            canvas.drawLine((float)n11, (float)n9, (float)n13, (float)n9, paint);
            boolean bl4 = false;
            for (int i7 = 0; i7 < n15 && !bl4; ++i7) {
                bl4 = this.mRenderer.getYAxisAlign(i7) == Paint.Align.RIGHT;
            }
            if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                canvas.drawLine((float)n11, (float)n12, (float)n11, (float)n9, paint);
                if (bl4) {
                    canvas.drawLine((float)n13, (float)n12, (float)n13, (float)n9, paint);
                }
            } else if (orientation == XYMultipleSeriesRenderer.Orientation.VERTICAL) {
                canvas.drawLine((float)n13, (float)n12, (float)n13, (float)n9, paint);
            }
        }
        if (bl) {
            this.a(canvas, n8, true);
        }
    }

    protected List<Double> getXLabels(double d2, double d3, int n2) {
        return MathHelper.getLabels(d2, d3, n2);
    }

    protected Map<Integer, List<Double>> getYLabels(double[] dArray, double[] dArray2, int n2) {
        HashMap<Integer, List<Double>> hashMap = new HashMap<Integer, List<Double>>();
        for (int i2 = 0; i2 < n2; ++i2) {
            hashMap.put(i2, this.a(MathHelper.getLabels(dArray[i2], dArray2[i2], this.mRenderer.getYLabels())));
        }
        return hashMap;
    }

    protected Rect getScreenR() {
        return this.a;
    }

    protected void setScreenR(Rect rect) {
        this.a = rect;
    }

    private List<Double> a(List<Double> list) {
        ArrayList<Double> arrayList = new ArrayList<Double>(list);
        for (Double d2 : list) {
            if (!d2.isNaN()) continue;
            arrayList.remove(d2);
        }
        return arrayList;
    }

    protected void drawSeries(XYSeries xYSeries, Canvas canvas, Paint paint, List<Float> list, SimpleSeriesRenderer simpleSeriesRenderer, float f2, int n2, XYMultipleSeriesRenderer.Orientation orientation, int n3) {
        Object object;
        BasicStroke basicStroke = simpleSeriesRenderer.getStroke();
        Paint.Cap cap = paint.getStrokeCap();
        Paint.Join join = paint.getStrokeJoin();
        float f3 = paint.getStrokeMiter();
        PathEffect pathEffect = paint.getPathEffect();
        Paint.Style style = paint.getStyle();
        if (basicStroke != null) {
            object = null;
            if (basicStroke.getIntervals() != null) {
                object = new DashPathEffect(basicStroke.getIntervals(), basicStroke.getPhase());
            }
            this.a(basicStroke.getCap(), basicStroke.getJoin(), basicStroke.getMiter(), Paint.Style.FILL_AND_STROKE, (PathEffect)object, paint);
        }
        this.drawSeries(canvas, paint, list, simpleSeriesRenderer, f2, n2, n3);
        if (this.isRenderPoints(simpleSeriesRenderer) && (object = this.getPointsChart()) != null) {
            ((ScatterChart)object).drawSeries(canvas, paint, list, simpleSeriesRenderer, f2, n2, n3);
        }
        paint.setTextSize(simpleSeriesRenderer.getChartValuesTextSize());
        if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
            paint.setTextAlign(Paint.Align.CENTER);
        } else {
            paint.setTextAlign(Paint.Align.LEFT);
        }
        if (simpleSeriesRenderer.isDisplayChartValues()) {
            paint.setTextAlign(simpleSeriesRenderer.getChartValuesTextAlign());
            this.drawChartValuesText(canvas, xYSeries, simpleSeriesRenderer, paint, list, n2, n3);
        }
        if (basicStroke != null) {
            this.a(cap, join, f3, style, pathEffect, paint);
        }
    }

    private void a(Paint.Cap cap, Paint.Join join, float f2, Paint.Style style, PathEffect pathEffect, Paint paint) {
        paint.setStrokeCap(cap);
        paint.setStrokeJoin(join);
        paint.setStrokeMiter(f2);
        paint.setPathEffect(pathEffect);
        paint.setStyle(style);
    }

    protected void drawChartValuesText(Canvas canvas, XYSeries xYSeries, SimpleSeriesRenderer simpleSeriesRenderer, Paint paint, List<Float> list, int n2, int n3) {
        if (list.size() > 1) {
            float f2 = list.get(0).floatValue();
            float f3 = list.get(1).floatValue();
            for (int i2 = 0; i2 < list.size(); i2 += 2) {
                if (i2 == 2) {
                    if (!(Math.abs(list.get(2).floatValue() - list.get(0).floatValue()) > (float)simpleSeriesRenderer.getDisplayChartValuesDistance()) && !(Math.abs(list.get(3).floatValue() - list.get(1).floatValue()) > (float)simpleSeriesRenderer.getDisplayChartValuesDistance())) continue;
                    this.drawText(canvas, this.getLabel(simpleSeriesRenderer.getChartValuesFormat(), xYSeries.getY(n3)), list.get(0).floatValue(), list.get(1).floatValue() - simpleSeriesRenderer.getChartValuesSpacing(), paint, 0.0f);
                    this.drawText(canvas, this.getLabel(simpleSeriesRenderer.getChartValuesFormat(), xYSeries.getY(n3 + 1)), list.get(2).floatValue(), list.get(3).floatValue() - simpleSeriesRenderer.getChartValuesSpacing(), paint, 0.0f);
                    f2 = list.get(2).floatValue();
                    f3 = list.get(3).floatValue();
                    continue;
                }
                if (i2 <= 2 || !(Math.abs(list.get(i2).floatValue() - f2) > (float)simpleSeriesRenderer.getDisplayChartValuesDistance()) && !(Math.abs(list.get(i2 + 1).floatValue() - f3) > (float)simpleSeriesRenderer.getDisplayChartValuesDistance())) continue;
                this.drawText(canvas, this.getLabel(simpleSeriesRenderer.getChartValuesFormat(), xYSeries.getY(n3 + i2 / 2)), list.get(i2).floatValue(), list.get(i2 + 1).floatValue() - simpleSeriesRenderer.getChartValuesSpacing(), paint, 0.0f);
                f2 = list.get(i2).floatValue();
                f3 = list.get(i2 + 1).floatValue();
            }
        } else {
            for (int i3 = 0; i3 < list.size(); i3 += 2) {
                this.drawText(canvas, this.getLabel(simpleSeriesRenderer.getChartValuesFormat(), xYSeries.getY(n3 + i3 / 2)), list.get(i3).floatValue(), list.get(i3 + 1).floatValue() - simpleSeriesRenderer.getChartValuesSpacing(), paint, 0.0f);
            }
        }
    }

    protected void drawText(Canvas canvas, String string2, float f2, float f3, Paint paint, float f4) {
        float f5 = (float)(-this.mRenderer.getOrientation().getAngle()) + f4;
        if (f5 != 0.0f) {
            canvas.rotate(f5, f2, f3);
        }
        this.drawString(canvas, string2, f2, f3, paint);
        if (f5 != 0.0f) {
            canvas.rotate(-f5, f2, f3);
        }
    }

    private void a(Canvas canvas, float f2, boolean bl) {
        if (bl) {
            canvas.scale(1.0f / this.a, this.a);
            canvas.translate(this.b, -this.b);
            canvas.rotate(-f2, this.a.getX(), this.a.getY());
        } else {
            canvas.rotate(f2, this.a.getX(), this.a.getY());
            canvas.translate(-this.b, this.b);
            canvas.scale(this.a, 1.0f / this.a);
        }
    }

    protected void drawXLabels(List<Double> list, Double[] doubleArray, Canvas canvas, Paint paint, int n2, int n3, int n4, double d2, double d3, double d4) {
        int n5 = list.size();
        boolean bl = this.mRenderer.isShowLabels();
        boolean bl2 = this.mRenderer.isShowGridY();
        for (int i2 = 0; i2 < n5; ++i2) {
            double d5 = list.get(i2);
            float f2 = (float)((double)n2 + d2 * (d5 - d3));
            if (bl) {
                paint.setColor(this.mRenderer.getXLabelsColor());
                canvas.drawLine(f2, (float)n4, f2, (float)n4 + this.mRenderer.getLabelsTextSize() / 3.0f, paint);
                this.drawText(canvas, this.getLabel(this.mRenderer.getLabelFormat(), d5), f2, (float)n4 + this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f + this.mRenderer.getXLabelsPadding(), paint, this.mRenderer.getXLabelsAngle());
            }
            if (!bl2) continue;
            paint.setColor(this.mRenderer.getGridColor());
            canvas.drawLine(f2, (float)n4, f2, (float)n3, paint);
        }
        this.drawXTextLabels(doubleArray, canvas, paint, bl, n2, n3, n4, d2, d3, d4);
    }

    protected void drawYLabels(Map<Integer, List<Double>> map, Canvas canvas, Paint paint, int n2, int n3, int n4, int n5, double[] dArray, double[] dArray2) {
        XYMultipleSeriesRenderer.Orientation orientation = this.mRenderer.getOrientation();
        boolean bl = this.mRenderer.isShowGridX();
        boolean bl2 = this.mRenderer.isShowLabels();
        for (int i2 = 0; i2 < n2; ++i2) {
            paint.setTextAlign(this.mRenderer.getYLabelsAlign(i2));
            List<Double> list = map.get(i2);
            int n6 = list.size();
            for (int i3 = 0; i3 < n6; ++i3) {
                double d2 = list.get(i3);
                Paint.Align align = this.mRenderer.getYAxisAlign(i2);
                boolean bl3 = this.mRenderer.getYTextLabel(d2, i2) != null;
                float f2 = (float)((double)n5 - dArray[i2] * (d2 - dArray2[i2]));
                if (orientation == XYMultipleSeriesRenderer.Orientation.HORIZONTAL) {
                    if (bl2 && !bl3) {
                        paint.setColor(this.mRenderer.getYLabelsColor(i2));
                        if (align == Paint.Align.LEFT) {
                            canvas.drawLine((float)(n3 + this.a(align)), f2, (float)n3, f2, paint);
                            this.drawText(canvas, this.getLabel(this.mRenderer.getLabelFormat(), d2), (float)n3 - this.mRenderer.getYLabelsPadding(), f2 - this.mRenderer.getYLabelsVerticalPadding(), paint, this.mRenderer.getYLabelsAngle());
                        } else {
                            canvas.drawLine((float)n4, f2, (float)(n4 + this.a(align)), f2, paint);
                            this.drawText(canvas, this.getLabel(this.mRenderer.getLabelFormat(), d2), (float)n4 + this.mRenderer.getYLabelsPadding(), f2 - this.mRenderer.getYLabelsVerticalPadding(), paint, this.mRenderer.getYLabelsAngle());
                        }
                    }
                    if (!bl) continue;
                    paint.setColor(this.mRenderer.getGridColor());
                    canvas.drawLine((float)n3, f2, (float)n4, f2, paint);
                    continue;
                }
                if (orientation != XYMultipleSeriesRenderer.Orientation.VERTICAL) continue;
                if (bl2 && !bl3) {
                    paint.setColor(this.mRenderer.getYLabelsColor(i2));
                    canvas.drawLine((float)(n4 - this.a(align)), f2, (float)n4, f2, paint);
                    this.drawText(canvas, this.getLabel(this.mRenderer.getLabelFormat(), d2), (float)(n4 + 10) + this.mRenderer.getYLabelsPadding(), f2 - this.mRenderer.getYLabelsVerticalPadding(), paint, this.mRenderer.getYLabelsAngle());
                }
                if (!bl) continue;
                paint.setColor(this.mRenderer.getGridColor());
                canvas.drawLine((float)n4, f2, (float)n3, f2, paint);
            }
        }
    }

    protected void drawXTextLabels(Double[] doubleArray, Canvas canvas, Paint paint, boolean bl, int n2, int n3, int n4, double d2, double d3, double d4) {
        boolean bl2 = this.mRenderer.isShowCustomTextGrid();
        if (bl) {
            paint.setColor(this.mRenderer.getXLabelsColor());
            for (Double d5 : doubleArray) {
                if (!(d3 <= d5) || !(d5 <= d4)) continue;
                float f2 = (float)((double)n2 + d2 * (d5 - d3));
                paint.setColor(this.mRenderer.getXLabelsColor());
                canvas.drawLine(f2, (float)n4, f2, (float)n4 + this.mRenderer.getLabelsTextSize() / 3.0f, paint);
                this.drawText(canvas, this.mRenderer.getXTextLabel(d5), f2, (float)n4 + this.mRenderer.getLabelsTextSize() * 4.0f / 3.0f, paint, this.mRenderer.getXLabelsAngle());
                if (!bl2) continue;
                paint.setColor(this.mRenderer.getGridColor());
                canvas.drawLine(f2, (float)n4, f2, (float)n3, paint);
            }
        }
    }

    public XYMultipleSeriesRenderer getRenderer() {
        return this.mRenderer;
    }

    public XYMultipleSeriesDataset getDataset() {
        return this.mDataset;
    }

    public double[] getCalcRange(int n2) {
        return (double[])this.a.get(n2);
    }

    public void setCalcRange(double[] dArray, int n2) {
        this.a.put(n2, dArray);
    }

    public double[] toRealPoint(float f2, float f3) {
        return this.toRealPoint(f2, f3, 0);
    }

    public double[] toScreenPoint(double[] dArray) {
        return this.toScreenPoint(dArray, 0);
    }

    private int a(Paint.Align align) {
        int n2 = 4;
        if (align == Paint.Align.LEFT) {
            n2 = -n2;
        }
        return n2;
    }

    public double[] toRealPoint(float f2, float f3, int n2) {
        double d2 = this.mRenderer.getXAxisMin(n2);
        double d3 = this.mRenderer.getXAxisMax(n2);
        double d4 = this.mRenderer.getYAxisMin(n2);
        double d5 = this.mRenderer.getYAxisMax(n2);
        if (this.a != null) {
            return new double[]{(double)(f2 - (float)this.a.left) * (d3 - d2) / (double)this.a.width() + d2, (double)((float)(this.a.top + this.a.height()) - f3) * (d5 - d4) / (double)this.a.height() + d4};
        }
        return new double[]{f2, f3};
    }

    public double[] toScreenPoint(double[] dArray, int n2) {
        double d2 = this.mRenderer.getXAxisMin(n2);
        double d3 = this.mRenderer.getXAxisMax(n2);
        double d4 = this.mRenderer.getYAxisMin(n2);
        double d5 = this.mRenderer.getYAxisMax(n2);
        if (!(this.mRenderer.isMinXSet(n2) && this.mRenderer.isMaxXSet(n2) && this.mRenderer.isMinXSet(n2) && this.mRenderer.isMaxYSet(n2))) {
            double[] dArray2 = this.getCalcRange(n2);
            d2 = dArray2[0];
            d3 = dArray2[1];
            d4 = dArray2[2];
            d5 = dArray2[3];
        }
        if (this.a != null) {
            return new double[]{(dArray[0] - d2) * (double)this.a.width() / (d3 - d2) + (double)this.a.left, (d5 - dArray[1]) * (double)this.a.height() / (d5 - d4) + (double)this.a.top};
        }
        return dArray;
    }

    @Override
    public SeriesSelection getSeriesAndPointForScreenCoordinate(Point point) {
        if (this.b != null) {
            for (int i2 = this.b.size() - 1; i2 >= 0; --i2) {
                int n2 = 0;
                if (this.b.get(i2) == null) continue;
                for (ClickableArea clickableArea : (List)this.b.get(i2)) {
                    RectF rectF;
                    if (clickableArea != null && (rectF = clickableArea.getRect()) != null && rectF.contains(point.getX(), point.getY())) {
                        return new SeriesSelection(i2, n2, clickableArea.getX(), clickableArea.getY());
                    }
                    ++n2;
                }
            }
        }
        return super.getSeriesAndPointForScreenCoordinate(point);
    }

    public abstract void drawSeries(Canvas var1, Paint var2, List<Float> var3, SimpleSeriesRenderer var4, float var5, int var6, int var7);

    protected abstract ClickableArea[] clickableAreasForPoints(List<Float> var1, List<Double> var2, float var3, int var4, int var5);

    protected boolean isRenderNullValues() {
        return false;
    }

    public boolean isRenderPoints(SimpleSeriesRenderer simpleSeriesRenderer) {
        return false;
    }

    public double getDefaultMinimum() {
        return Double.MAX_VALUE;
    }

    public ScatterChart getPointsChart() {
        return null;
    }

    public abstract String getChartType();
}

