/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Random;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.HttpMultipart;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.message.BasicHeader;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class MultipartEntity
implements HttpEntity {
    private static final char[] a = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private final HttpMultipart a;
    private final Header a;
    private long a;
    private volatile boolean a;

    public MultipartEntity(HttpMultipartMode httpMultipartMode, String string, Charset charset) {
        if (string == null) {
            string = this.generateBoundary();
        }
        if (httpMultipartMode == null) {
            httpMultipartMode = HttpMultipartMode.STRICT;
        }
        this.a = new HttpMultipart("form-data", charset, string, httpMultipartMode);
        this.a = new BasicHeader("Content-Type", this.generateContentType(string, charset));
        this.a = true;
    }

    public MultipartEntity(HttpMultipartMode httpMultipartMode) {
        this(httpMultipartMode, null, null);
    }

    public MultipartEntity() {
        this(HttpMultipartMode.STRICT, null, null);
    }

    protected String generateContentType(String string, Charset charset) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("multipart/form-data; boundary=");
        stringBuilder.append(string);
        if (charset != null) {
            stringBuilder.append("; charset=");
            stringBuilder.append(charset.name());
        }
        return stringBuilder.toString();
    }

    protected String generateBoundary() {
        StringBuilder stringBuilder = new StringBuilder();
        Random random = new Random();
        int n = random.nextInt(11) + 30;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(a[random.nextInt(a.length)]);
        }
        return stringBuilder.toString();
    }

    public void addPart(FormBodyPart formBodyPart) {
        this.a.addBodyPart(formBodyPart);
        this.a = true;
    }

    public void addPart(String string, ContentBody contentBody) {
        this.addPart(new FormBodyPart(string, contentBody));
    }

    public boolean isRepeatable() {
        for (FormBodyPart formBodyPart : this.a.getBodyParts()) {
            ContentBody contentBody = formBodyPart.getBody();
            if (contentBody.getContentLength() >= 0L) continue;
            return false;
        }
        return true;
    }

    public boolean isChunked() {
        return !this.isRepeatable();
    }

    public boolean isStreaming() {
        return !this.isRepeatable();
    }

    public long getContentLength() {
        if (this.a) {
            this.a = this.a.getTotalLength();
            this.a = false;
        }
        return this.a;
    }

    public Header getContentType() {
        return this.a;
    }

    public Header getContentEncoding() {
        return null;
    }

    public void consumeContent() throws IOException, UnsupportedOperationException {
        if (this.isStreaming()) {
            throw new UnsupportedOperationException("Streaming entity does not implement #consumeContent()");
        }
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Multipart form entity does not implement #getContent()");
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.a.writeTo(outputStream);
    }
}

