/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime.content;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.mime.content.AbstractContentBody;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class FileBody
extends AbstractContentBody {
    private final File a;
    private final String a;
    private final String b;

    public FileBody(File file, String string, String string2, String string3) {
        super(string2);
        if (file == null) {
            throw new IllegalArgumentException("File may not be null");
        }
        this.a = file;
        this.a = string != null ? string : file.getName();
        this.b = string3;
    }

    public FileBody(File file, String string, String string2) {
        this(file, null, string, string2);
    }

    public FileBody(File file, String string) {
        this(file, string, null);
    }

    public FileBody(File file) {
        this(file, "application/octet-stream");
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.a);
    }

    @Deprecated
    public void writeTo(OutputStream outputStream, int n) throws IOException {
        this.writeTo(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        FileInputStream fileInputStream = new FileInputStream(this.a);
        try {
            int n;
            byte[] byArray = new byte[4096];
            while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
            outputStream.flush();
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public String getTransferEncoding() {
        return "binary";
    }

    public String getCharset() {
        return this.b;
    }

    public long getContentLength() {
        return this.a.length();
    }

    public String getFilename() {
        return this.a;
    }

    public File getFile() {
        return this.a;
    }
}

