/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.entity.mime.content;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.apache.http.entity.mime.content.AbstractContentBody;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class StringBody
extends AbstractContentBody {
    private final byte[] a;
    private final Charset a;

    public static StringBody create(String string, String string2, Charset charset) throws IllegalArgumentException {
        try {
            return new StringBody(string, string2, charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Charset " + charset + " is not supported", unsupportedEncodingException);
        }
    }

    public static StringBody create(String string, Charset charset) throws IllegalArgumentException {
        return StringBody.create(string, null, charset);
    }

    public static StringBody create(String string) throws IllegalArgumentException {
        return StringBody.create(string, null, null);
    }

    public StringBody(String string, String string2, Charset charset) throws UnsupportedEncodingException {
        super(string2);
        if (string == null) {
            throw new IllegalArgumentException("Text may not be null");
        }
        if (charset == null) {
            charset = Charset.forName("US-ASCII");
        }
        this.a = string.getBytes(charset.name());
        this.a = charset;
    }

    public StringBody(String string, Charset charset) throws UnsupportedEncodingException {
        this(string, "text/plain", charset);
    }

    public StringBody(String string) throws UnsupportedEncodingException {
        this(string, "text/plain", null);
    }

    public Reader getReader() {
        return new InputStreamReader((InputStream)new ByteArrayInputStream(this.a), this.a);
    }

    @Deprecated
    public void writeTo(OutputStream outputStream, int n) throws IOException {
        this.writeTo(outputStream);
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        int n;
        if (outputStream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.a);
        byte[] byArray = new byte[4096];
        while ((n = byteArrayInputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        outputStream.flush();
    }

    public String getTransferEncoding() {
        return "8bit";
    }

    public String getCharset() {
        return this.a.name();
    }

    public long getContentLength() {
        return this.a.length;
    }

    public String getFilename() {
        return null;
    }
}

