/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.navi;

import android.content.Context;
import android.location.LocationManager;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoStyle;
import com.supermap.data.InternalHandle;
import com.supermap.data.Point2D;
import com.supermap.navi.Encryption;
import com.supermap.navi.NaviInfo;
import com.supermap.navi.NaviListener;
import com.supermap.navi.NaviPath;
import com.supermap.navi.NaviStep;
import com.supermap.navi.NavigationNative;
import com.supermap.navi.b;
import com.supermap.navi.c;
import com.supermap.plugin.LocationChangedListener;
import com.supermap.plugin.LocationManagePlugin;
import com.supermap.plugin.SpeakPlugin;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Navigation {
    private long a;
    private LocationManagePlugin a;
    boolean a;
    Encryption a;
    boolean b = true;
    private int a;
    NaviInfo a;
    private Vector<NaviListener> a;
    private Handler a;
    private LocationChangedListener a = new LocationChangedListener(){

        public void locationChanged(LocationManagePlugin.GPSData gPSData, LocationManagePlugin.GPSData gPSData2) {
        }

        public void locationChanged(LocationManagePlugin.GPSData gPSData, LocationManagePlugin.GPSData gPSData2, boolean bl) {
            if (bl) {
                double d = gPSData2.dLongitude;
                double d2 = gPSData2.dLatitude;
                Point2D point2D = Navigation.this.encryptGPS(d, d2);
                gPSData2.dLongitude = point2D.getX();
                gPSData2.dLatitude = point2D.getY();
                NavigationNative.jni_SetGPSData(Navigation.this.a, gPSData2);
            }
        }
    };

    private Navigation(long l, Context context) {
        this.a = l;
        try {
            SpeakPlugin.getInstance().laugchPlugin();
        }
        catch (Exception exception) {
            Log.e((String)"Navigation", (String)exception.toString());
        }
        LocationManager locationManager = (LocationManager)context.getSystemService("location");
        this.a = new LocationManagePlugin();
        this.a.openGpsDevice(locationManager);
        this.a.addLocationChangedListener(this.a);
        NavigationNative.jni_RegisterCallback(l, this);
        this.a = new NaviInfo();
    }

    protected static Navigation createInstance(long l, Context context) {
        return new Navigation(l, context);
    }

    protected Navigation() {
    }

    public void setStartPoint(double d, double d2) {
        if (this.a != 0L) {
            NavigationNative.jni_SetStartPoint(this.a, d, d2);
        }
    }

    public void setDestinationPoint(double d, double d2) {
        if (this.a != 0L) {
            NavigationNative.jni_SetDestinationtPoint(this.a, d, d2);
        }
    }

    public boolean addWayPoint(double d, double d2) {
        if (this.a != 0L) {
            return NavigationNative.jni_AddWayPoint(this.a, d, d2);
        }
        return false;
    }

    public int routeAnalyst(int n) {
        if (this.a != 0L) {
            return NavigationNative.jni_RouteAnalyst(this.a, n);
        }
        return 0;
    }

    public GeoLine getRoute() {
        long l;
        GeoLine geoLine = null;
        if (this.a != 0L && (l = NavigationNative.jni_GetRoute(this.a)) != 0L) {
            geoLine = (GeoLine)com.supermap.navi.b.a(l);
        }
        return geoLine;
    }

    public NaviPath getNaviPath() {
        NaviPath naviPath = null;
        if (this.a != 0L) {
            NaviStep[] naviStepArray = NavigationNative.jni_GetPathInfo(this.a);
            if (naviStepArray == null) {
                return null;
            }
            ArrayList<NaviStep> arrayList = new ArrayList<NaviStep>();
            for (int i = 0; i < naviStepArray.length; ++i) {
                arrayList.add(naviStepArray[i]);
            }
            naviPath = new NaviPath(arrayList);
        }
        return naviPath;
    }

    public boolean startGuide(int n) {
        if (this.a != 0L) {
            this.a = n;
            NavigationNative.jni_ResumeGuide(this.a);
            return NavigationNative.jni_StartGuide(this.a, n);
        }
        return false;
    }

    public double getCarAngle() {
        if (this.a != 0L) {
            return NavigationNative.jni_GetCarAngle(this.a);
        }
        return 0.0;
    }

    public Point2D getCarPosition() {
        if (this.a != 0L) {
            double[] dArray = new double[2];
            NavigationNative.jni_GetCarPosition(this.a, dArray);
            Point2D point2D = new Point2D(dArray[0], dArray[1]);
            return point2D;
        }
        return null;
    }

    public boolean connectNaviData(String string) {
        if (this.a != 0L) {
            return NavigationNative.jni_ConnectNaviData(this.a, string);
        }
        return false;
    }

    public void enablePanOnGuide(boolean bl) {
        if (this.a != 0L) {
            NavigationNative.jni_EnablePanOnGuide(this.a, bl);
            this.b = bl;
        }
    }

    public boolean isGuiding() {
        if (this.a != 0L) {
            return NavigationNative.jni_IsGuiding(this.a);
        }
        return false;
    }

    public void cleanPath() {
        if (this.a != 0L) {
            NavigationNative.jni_CleanPath(this.a);
        }
    }

    public boolean stopGuide() {
        if (this.a != 0L) {
            return NavigationNative.jni_StopGuide(this.a);
        }
        return false;
    }

    public boolean setViewSize(int n, int n2) {
        if (this.a != 0L) {
            return NavigationNative.jni_SetViewSize(this.a, n, n2);
        }
        return false;
    }

    protected void playInfo(String string) {
        try {
            SpeakPlugin.getInstance().playSound(string);
            Message message = new Message();
            message.what = 65283;
            message.obj = string;
            this.a.sendMessage(message);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updataMessage(String string) {
        for (int i = 0; i < this.a.size(); ++i) {
            ((NaviListener)this.a.get(i)).onPlayNaviMessage(string);
        }
    }

    public void setPathVisible(boolean bl) {
        if (this.a != 0L) {
            NavigationNative.jni_SetPathView(this.a, bl);
        }
    }

    public Point2D encryptGPS(double d, double d2) {
        Point2D point2D = new Point2D(d, d2);
        if (this.a != null) {
            Point2D point2D2 = this.a.encryptGPS(point2D);
            return point2D2;
        }
        Point2D point2D3 = point2D;
        return point2D3;
    }

    public void setEncryption(Encryption encryption) {
        this.a = encryption;
    }

    public void setGPSData(LocationManagePlugin.GPSData gPSData) {
        if (gPSData == null) {
            return;
        }
        NavigationNative.jni_SetGPSData(this.a, gPSData);
    }

    public boolean setCarUpFront(boolean bl) {
        if (NavigationNative.jni_SetCarUpFront(this.a, bl)) {
            this.a = bl;
            return true;
        }
        Log.e((String)"Navigation2", (String)"\u8bbe\u7f6e\u8f66\u5934\u5411\u4e0a\u5931\u8d25\uff0c\u7f51\u7edc\u5730\u56fe\u4e0d\u652f\u6301\u5730\u56fe\u65cb\u8f6c\u3002");
        return false;
    }

    public boolean getCarUpFront() {
        return this.a;
    }

    protected void finalize() throws Throwable {
        this.a.closeGpsDevice();
        super.finalize();
    }

    public void setRouteStyle(GeoStyle geoStyle) {
        if (geoStyle == null) {
            NavigationNative.jni_SetRouteStyle(this.a, 0L);
        } else {
            long l = c.a((InternalHandle)geoStyle);
            if (l == 0L) {
                return;
            }
            GeoStyle geoStyle2 = geoStyle.clone();
            long l2 = c.a((InternalHandle)geoStyle2);
            NavigationNative.jni_SetRouteStyle(this.a, l2);
            geoStyle2.dispose();
        }
    }

    protected void naviInfoCallBack() {
        this.updateInfo();
    }

    public double getDisToDestination() {
        if (this.a != 0L) {
            return NavigationNative.jni_GetDisToDestination(this.a);
        }
        return 0.0;
    }

    public double getDisToSwerve() {
        if (this.a != 0L) {
            return NavigationNative.jni_GetDisToSwerve(this.a);
        }
        return 0.0;
    }

    public String getCurRoadName() {
        if (this.a != 0L) {
            return NavigationNative.jni_GetCurRoadName(this.a);
        }
        return "";
    }

    public String getNextRoadName() {
        if (this.a != 0L) {
            return NavigationNative.jni_GetNextRoadName(this.a);
        }
        return "";
    }

    public int getNaviAction() {
        if (this.a != 0L) {
            return NavigationNative.jni_GetNaviAction(this.a);
        }
        return 0;
    }

    private void updateInfo() {
        double d = NavigationNative.jni_GetDisToDestination(this.a);
        double d2 = NavigationNative.jni_GetDisToSwerve(this.a);
        String string = NavigationNative.jni_GetCurRoadName(this.a);
        String string2 = NavigationNative.jni_GetNextRoadName(this.a);
        int n = NavigationNative.jni_GetNaviAction(this.a);
        double d3 = NavigationNative.jni_GetCarAngle(this.a);
        double d4 = 0.0;
        if (this.a == 0 || this.a == 1) {
            d4 = d / 1000.0;
        }
        if (this.a == 3) {
            d4 = d / 80.0;
        }
        this.a.RouteRemainDis = (int)d;
        this.a.SegRemainDis = (int)d2;
        this.a.CurRoadName = string;
        this.a.NextRoadName = string2;
        this.a.IconType = n;
        this.a.Direction = d3;
        this.a.RouteRemainTime = d4;
        Message message = new Message();
        message.what = 65282;
        this.a.sendMessage(message);
    }

    private void naviInfoUpdate() {
        for (int i = 0; i < this.a.size(); ++i) {
            ((NaviListener)this.a.get(i)).onNaviInfoUpdate(this.a);
        }
    }

    public int getTimeToDestination(double d) {
        return NavigationNative.jni_GetTimeToDestination(this.a, d);
    }

    public int getPathRoadLevel() {
        return NavigationNative.jni_GetPathRoadLevel(this.a);
    }

    public int getSecondaryAction() {
        return NavigationNative.jni_GetSecondaryAction(this.a);
    }

    public boolean addBarrierPoint(double d, double d2) {
        return NavigationNative.jni_AddBarrierPoint(this.a, d, d2);
    }

    public boolean clearBarrierPoints() {
        return NavigationNative.jni_ClearBarrierPoints(this.a);
    }

    public boolean addBarrierBound(double d, double d2, double d3, double d4) {
        return NavigationNative.jni_AddBarrierBound(this.a, d, d2, d3, d4);
    }

    public boolean clearBarrierBound() {
        return NavigationNative.jni_ClearBarrierBound(this.a);
    }

    public int getAdjust() {
        return NavigationNative.jni_GetAdjustEX(this.a);
    }

    public boolean setSimulationSpeed(double d) {
        return NavigationNative.jni_SetSimulationSpeed(this.a, d);
    }

    public boolean setSimulationInterval(int n) {
        return NavigationNative.jni_SetSimulationInterval(this.a, n);
    }

    public boolean setSpeechParam(SpeechParam speechParam) {
        if (speechParam == null) {
            return false;
        }
        return NavigationNative.jni_SetSpeechParam(this.a, speechParam);
    }

    public void addNaviInfoListener(NaviListener naviListener) {
        if (naviListener != null) {
            this.a.add(naviListener);
        }
    }

    protected void naviStatusCallBack(int n, int n2) {
        Message message = new Message();
        message.what = 65281;
        message.arg1 = n;
        message.arg2 = n2;
        this.a.sendMessage(message);
    }

    private void naviStatusChange(int n, int n2) {
        switch (n2) {
            case 0: {
                for (int i = 0; i < this.a.size(); ++i) {
                    ((NaviListener)this.a.get(i)).onStartNavi();
                    if (n != 2) continue;
                    ((NaviListener)this.a.get(i)).onAdjustFailure();
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.a.size(); ++i) {
                    ((NaviListener)this.a.get(i)).onStopNavi();
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.a.size(); ++i) {
                    ((NaviListener)this.a.get(i)).onAarrivedDestination();
                }
                break;
            }
        }
    }

    public void resumeGuide() {
        NavigationNative.jni_ResumeGuide(this.a);
    }

    public void pauseGuide() {
        NavigationNative.jni_PauseGuide(this.a);
    }

    public void locateMap() {
        if (this.a != 0L) {
            NavigationNative.jni_LocateMap(this.a);
        }
    }

    protected static boolean isPanOnGuideInside(Navigation navigation) {
        return navigation.isPanOnGuideInside();
    }

    protected boolean isPanOnGuideInside() {
        return NavigationNative.jni_IsPanOnGuideInside(this.a) && this.b;
    }

    public static class SpeechParam
    implements Serializable {
        public boolean bRoadDirection;

        protected Object clone() {
            SpeechParam speechParam = new SpeechParam();
            speechParam.bRoadDirection = this.bRoadDirection;
            return speechParam;
        }

        public boolean equals(Object object) {
            if (object instanceof SpeechParam) {
                return false;
            }
            SpeechParam speechParam = (SpeechParam)object;
            if (this.bRoadDirection == speechParam.bRoadDirection) {
                return true;
            }
            return super.equals(object);
        }
    }
}

