/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.realspace;

import android.graphics.Bitmap;
import android.graphics.Point;
import android.os.Handler;
import android.os.SystemClock;
import com.supermap.data.AltitudeMode;
import com.supermap.data.Enum;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.InternalHandleDisposable;
import com.supermap.data.Point3D;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Workspace;
import com.supermap.realspace.Camera;
import com.supermap.realspace.FlyManager;
import com.supermap.realspace.Layer3D;
import com.supermap.realspace.Layer3Ds;
import com.supermap.realspace.PixelToGlobeMode;
import com.supermap.realspace.SceneControl;
import com.supermap.realspace.SceneNative;
import com.supermap.realspace.TerrainLayers;
import com.supermap.realspace.TrackingLayer3D;
import com.supermap.realspace.a;
import com.supermap.realspace.i;
import java.io.File;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Scene
extends InternalHandleDisposable {
    private Workspace a;
    private Layer3Ds a;
    private TrackingLayer3D a;
    private TerrainLayers a;
    SceneControl a;
    private FlyManager a;
    private String a;
    private boolean a = true;
    private boolean b = false;
    public Handler mhandler;

    public Scene() {
        this(null);
    }

    Scene(Workspace workspace) {
        long l2 = SceneNative.jni_New("");
        this.setHandle(l2, true);
        if (workspace != null) {
            long l3 = InternalHandle.getHandle((InternalHandle)workspace);
            if (l3 == 0L) {
                String string = i.a("workspace", "GlobalArgument_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalArgumentException(string);
            }
            this.setWorkspace(workspace);
        }
    }

    Scene(long l2, SceneControl sceneControl) {
        this.setHandle(l2, false);
        this.a = sceneControl;
        SceneNative.jni_NewSelfEventHandle(this.a.getHandle(), this);
        SceneNative.jni_SetDrawMode(this.getHandle());
    }

    public Camera getCamera() {
        if (this.getHandle() == 0L) {
            String string = i.a("getCamera()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[6];
        long l2 = SceneNative.jni_GetCamera(this.getHandle(), dArray);
        Camera camera = null;
        if (l2 != 0L) {
            camera = new Camera(dArray[0] * 57.29577951308232, dArray[1] * 57.29577951308232, Camera.computeAltitude(dArray[2], dArray[5] * 57.29577951308232), (AltitudeMode)com.supermap.realspace.a.parse(AltitudeMode.class, (int)((int)dArray[3])), dArray[4] * 57.29577951308232, dArray[5] * 57.29577951308232);
        }
        return camera;
    }

    public void setCamera(Camera camera) {
        if (this.getHandle() == 0L) {
            String string = i.a("setCamera(camera)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (camera == null) {
            String string = i.a("camera", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        SceneNative.jni_SetCameraValue(this.getHandle(), camera.getLongitude() * (Math.PI / 180), camera.getLatitude() * (Math.PI / 180), Camera.computeDistance(camera.getAltitude(), camera.getTilt()), camera.getHeading() * (Math.PI / 180), camera.getTilt() * (Math.PI / 180));
    }

    public TerrainLayers getTerrainLayers() {
        long l2;
        if (this.getHandle() == 0L) {
            String string = i.a("GetTerrainLayers()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null && (l2 = SceneNative.jni_getTerrainLayers(this.getHandle())) != 0L) {
            this.a = TerrainLayers.createInstance(this, l2);
        }
        return this.a;
    }

    public TrackingLayer3D getTrackingLayer() {
        long l2;
        if (this.getHandle() == 0L) {
            String string = i.a("getTrackingLayer()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null && (l2 = SceneNative.jni_GetTrackingLayer(this.getHandle())) != 0L) {
            this.a = TrackingLayer3D.createInstance(l2, this);
        }
        return this.a;
    }

    public Workspace getWorkspace() {
        if (this.getHandle() == 0L) {
            String string = i.a("getWorkspace()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return this.a;
    }

    public void setWorkspace(Workspace workspace) {
        long l2;
        if (this.getHandle() == 0L) {
            String string = i.a("setWorkspace(Workspace workspace)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.getWorkspace() != null && this.getWorkspace().equals(workspace)) {
            return;
        }
        String string = "";
        if (this.a != null) {
            l2 = InternalHandle.getHandle((InternalHandle)this.a);
            if (l2 == 0L) {
                String string2 = i.a("setWorkspace()", "Map_DontDisposeOldWorkspace", "realspace_resources");
                throw new IllegalStateException(string2);
            }
            string = this.a();
        }
        this.a = false;
        this.close();
        while (!this.a) {
            SystemClock.sleep((long)500L);
        }
        this.a = false;
        if (workspace == null) {
            this.a = null;
        } else {
            l2 = InternalHandle.getHandle((InternalHandle)workspace);
            if (l2 == 0L) {
                String string3 = i.a("workspace", "Handle_ObjectHasBeenDisposed", "realspace_resources");
                throw new IllegalArgumentException(string3);
            }
            SceneNative.jni_SetWorkspace(this.getHandle(), l2);
            this.a = workspace;
        }
        if (!string.trim().equals("")) {
            this.a(string);
        }
    }

    public Layer3Ds getLayers() {
        long l2;
        if (this.getHandle() == 0L) {
            String string = i.a("getLayers()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null && (l2 = SceneNative.jni_GetLayers(this.getHandle())) != 0L) {
            this.a = Layer3Ds.createInstance(l2, this);
        }
        return this.a;
    }

    public void flyToPoint(Point3D point3D) {
        if (this.getHandle() == 0L) {
            String string = i.a("flyTo(Object targetObject, FlyingMode flyingMode, boolean isDirect)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_FlyToPoint(this.getHandle(), point3D.getX(), point3D.getY(), point3D.getZ());
    }

    public void flyToPoint(Point3D point3D, int n) {
        if (this.getHandle() == 0L) {
            String string = i.a("flyToPoint(Point3D point,int milliseconds)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_FlyToPointTime(this.getHandle(), point3D.getX(), point3D.getY(), point3D.getZ(), n);
    }

    public void flyToCamera(Camera camera, int n, boolean bl) {
        if (this.getHandle() == 0L) {
            String string = i.a("flyToCamera(Camera camera,int altitudeMode,boolean isDirect)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_FlyToCamera(this.getHandle(), camera.getLongitude(), camera.getLatitude(), camera.getAltitude(), n, camera.getTilt(), camera.getHeading());
    }

    public void flyToCamera(Camera camera, int n, int n2) {
        if (this.getHandle() == 0L) {
            String string = i.a("flyToCamera(Camera camera,int altitudeMode,int milliseconds)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_FlyToBymillisecondsCameraDirect(this.getHandle(), camera.getLongitude(), camera.getLatitude(), camera.getAltitude(), n, camera.getTilt(), camera.getHeading(), n2, false);
    }

    public void dispose() {
        if (!this.getIsDisposable()) {
            String string = i.a("dispose()", "Handle_UndisposableObject", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        if (this.getHandle() != 0L) {
            SceneNative.jni_Delete(this.getHandle());
            this.clearHandle();
        }
    }

    public void viewEntire() {
        if (this.getHandle() == 0L) {
            String string = i.a("viewEntire()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_ViewEntire(this.getHandle());
    }

    public void refresh() {
        if (this.getHandle() == 0L) {
            String string = i.a("refresh()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_Refresh(this.getHandle());
    }

    String a() {
        String string;
        File file;
        if (this.getHandle() == 0L) {
            String string2 = i.a("toXML()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (!this.a()) {
            String string3 = i.a("toXML()", "Map_WorkspaceIsEmpty", "realspace_resources");
            throw new IllegalStateException(string3);
        }
        String string4 = "";
        if (this.getWorkspace() != null && (file = new File(string = this.getWorkspace().getConnectionInfo().getServer())).exists()) {
            string4 = file.getParent();
        }
        return SceneNative.jni_ToXML(this.getHandle(), string4);
    }

    boolean a(String string) {
        if (this.getHandle() == 0L) {
            String string2 = i.a("fromXML(String xml)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a == null || InternalHandle.getHandle((InternalHandle)this.a) == 0L) {
            String string3 = i.a("fromXML(String xml)", "Map_WorkspaceIsEmpty", "realspace_resources");
            throw new IllegalStateException(string3);
        }
        boolean bl = false;
        if (string != null && string.trim().length() != 0) {
            String string4;
            File file;
            String string5 = "";
            if (this.getWorkspace() != null && (file = new File(string4 = this.getWorkspace().getConnectionInfo().getServer())).exists()) {
                string5 = file.getParent();
            }
            long l2 = 0L;
            if (this.getWorkspace() != null) {
                l2 = InternalHandle.getHandle((InternalHandle)this.getWorkspace());
            }
            if (bl = SceneNative.jni_FromXML(this.getHandle(), string, string5, l2)) {
                this.a();
                this.getLayers();
                this.getTerrainLayers();
            }
        }
        return bl;
    }

    public boolean open(String string) {
        if (this.getHandle() == 0L) {
            String string2 = i.a("open()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string2);
        }
        if (this.a == null) {
            String string3 = i.a("workspace", "Global_ArgumentNull", "realspace_resources");
            throw new IllegalStateException(string3);
        }
        long l2 = InternalHandle.getHandle((InternalHandle)this.a);
        if (l2 == 0L) {
            String string4 = i.a("workspace", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = i.a("name", "Scene_NameIsInvalid", "realspace_resources");
            throw new IllegalStateException(string5);
        }
        int n = this.a.getScenes().indexOf(string);
        if (n == -1) {
            String string6 = i.a("name", "Scene_SpecifiedNameNotExists", "realspace_resources");
            throw new IllegalStateException(string6);
        }
        String string7 = this.a.getScenes().getSceneXML(n);
        this.a.a.b();
        boolean bl = this.a(string7);
        this.a.a.a();
        if (bl) {
            this.a = "";
        }
        return bl;
    }

    public boolean open(String string, String string2) {
        if (this.getHandle() == 0L) {
            String string3 = i.a("open()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string3);
        }
        if (string == null || string.trim().length() == 0) {
            String string4 = i.a("strServerUrl", "Scene_NameIsInvalid", "realspace_resources");
            throw new IllegalStateException(string4);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string5 = i.a("strSceneName", "Scene_NameIsInvalid", "realspace_resources");
            throw new IllegalStateException(string5);
        }
        this.a.a.b();
        boolean bl = SceneNative.jni_Open(this.getHandle(), string, string2);
        this.a.a.a();
        if (bl) {
            this.a = string;
        }
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        return bl;
    }

    public boolean open(String string, String string2, String string3) {
        if (this.getHandle() == 0L) {
            String string4 = i.a("open()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string4);
        }
        if (string == null || string.trim().length() == 0) {
            String string5 = i.a("strServerUrl", "Scene_NameIsInvalid", "realspace_resources");
            throw new IllegalStateException(string5);
        }
        if (string2 == null || string2.trim().length() == 0) {
            String string6 = i.a("strSceneName", "Scene_NameIsInvalid", "realspace_resources");
            throw new IllegalStateException(string6);
        }
        this.a.a.b();
        boolean bl = SceneNative.jni_Open2(this.getHandle(), string, string2, string3);
        this.a.a.a();
        if (bl) {
            this.a = string;
        }
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        return bl;
    }

    public void close() {
        if (this.getHandle() == 0L) {
            String string = i.a("close()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SceneNative.jni_Reset(Scene.this.getHandle());
                SceneNative.jni_SetDrawMode(Scene.this.getHandle());
                Scene.this.a = true;
            }
        };
        this.a.a.a.post(runnable);
    }

    public String getName() {
        if (this.getHandle() == 0L) {
            String string = i.a("getName()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        return SceneNative.jni_getName(this.getHandle());
    }

    public String getUrl() {
        return this.a;
    }

    public void ensureVisible(Rectangle2D rectangle2D) {
        if (this.getHandle() == 0L) {
            String string = i.a("ensureVisible(Rectangle2D visibleBounds)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_EnsureVisible(this.getHandle(), rectangle2D.getLeft(), rectangle2D.getBottom(), rectangle2D.getRight(), rectangle2D.getTop());
    }

    public void ensureVisible(Layer3D layer3D) {
        if (this.getHandle() == 0L) {
            String string = i.a("ensureVisible(Layer3D layer3d)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (layer3D == null) {
            String string = i.a("layer3d", "Global_ArgumentNull", "realspace_resources");
            throw new IndexOutOfBoundsException(string);
        }
        SceneNative.jni_EnsureVisible3(this.getHandle(), InternalHandle.getHandle((InternalHandle)layer3D));
    }

    static void flownCallBack(Scene scene) {
        if (scene != null) {
            // empty if block
        }
    }

    private boolean a() {
        boolean bl = true;
        if (this.a == null) {
            bl = false;
        } else {
            long l2 = InternalHandle.getHandle((InternalHandle)this.a);
            if (l2 == 0L) {
                bl = false;
            }
        }
        return bl;
    }

    protected static void clearHandle(Scene scene) {
        scene.clearHandle();
    }

    protected static Scene createInstance(long l2, SceneControl sceneControl) {
        return new Scene(l2, sceneControl);
    }

    private void a() {
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
        if (this.a != null) {
            this.a.clearHandle();
            this.a = null;
        }
    }

    protected void clearHandle() {
        if (this.a != null) {
            this.a.stop();
        }
        this.a = null;
        this.a = null;
        this.setHandle(0L);
    }

    protected static void InternalClearHandle(Scene scene) {
        Scene.clearHandle(scene);
    }

    public FlyManager getFlyManager() {
        if (this.getHandle() == 0L) {
            String string = i.a("setFirstPersonCamera(Camera camera)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null) {
            this.a = new FlyManager();
            this.a.setScene(this);
        }
        return this.a;
    }

    public Point3D pixelToGlobe(Point point) {
        if (this.getHandle() == 0L) {
            String string = i.a("pixelToGlobe(Point point)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Point3D point3D = new Point3D();
        double[] dArray = new double[]{Double.NaN, Double.NaN, Double.NaN};
        if (this.a != null) {
            double[] dArray2 = new double[]{point.x, point.y};
            SceneNative.jni_PixelToScene(this.getHandle(), this.a.getHandle(), dArray2, dArray);
        }
        point3D.setX(dArray[0] * 57.29577951308232);
        point3D.setY(dArray[1] * 57.29577951308232);
        point3D.setZ(dArray[2]);
        return point3D;
    }

    public Point3D pixelToGlobe(Point point, final PixelToGlobeMode pixelToGlobeMode) {
        if (this.getHandle() == 0L) {
            String string = i.a("pixelToGlobe(Point point, PixelToGlobeMode mode)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        Point3D point3D = new Point3D();
        final double[] dArray = new double[]{Double.NaN, Double.NaN, Double.NaN};
        if (this.a != null) {
            final double[] dArray2 = new double[]{point.x, point.y};
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SceneNative.jni_PixelToWorld(Scene.this.getHandle(), Scene.this.a.getHandle(), dArray2, pixelToGlobeMode.value(), dArray);
                    Scene.this.b = true;
                }
            };
            this.a.a.a.post(runnable);
        }
        while (!this.b) {
            try {
                Thread.sleep(30L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        point3D.setX(dArray[0] * 57.29577951308232);
        point3D.setY(dArray[1] * 57.29577951308232);
        point3D.setZ(dArray[2]);
        this.b = false;
        return point3D;
    }

    public Point globeToPixel(Point3D point3D) {
        if (this.getHandle() == 0L) {
            String string = i.a("globeToPixel(Point3D point)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[]{point3D.getX(), point3D.getY(), point3D.getZ()};
        double[] dArray2 = new double[2];
        if (this.a != null) {
            SceneNative.jni_SceneToPixel(this.getHandle(), this.a.getHandle(), dArray, dArray2);
        }
        Point point = new Point();
        point.x = (int)dArray2[0];
        point.y = (int)dArray2[1];
        return point;
    }

    public Bitmap outputSceneToBitmap() {
        if (this.getHandle() == 0L) {
            String string = i.a("outputMapToBitmap", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (this.a == null) {
            String string = i.a("outputMapToBitmap", "Scene_RenderEnvironmentInvalid", "realspace_resources");
            throw new UnsupportedOperationException(string);
        }
        int[] nArray = new int[2];
        SceneNative.jni_GetImageBounds(this.getHandle(), nArray);
        int n = nArray[0];
        int n2 = nArray[1];
        Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n2, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        SceneNative.jni_OutputSceneToBitmap(this.getHandle(), bitmap);
        return bitmap;
    }

    public void zoom(double d2) {
        if (this.getHandle() == 0L) {
            String string = i.a("zoom()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_Zoom(this.a.getHandle(), d2);
    }

    public void stopCameraInteria() {
        if (this.getHandle() == 0L) {
            String string = i.a("stopCameraInteria()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_StopCameraInteria(this.getHandle());
    }

    public void flyCircle(Geometry geometry, double d2) {
        if (this.getHandle() == 0L) {
            String string = i.a("FlyCircle(geometry,speedRatio)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (geometry == null) {
            String string = i.a("geometry", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        long l2 = InternalHandle.getHandle((InternalHandle)geometry);
        if (l2 == 0L) {
            String string = i.a("geometry", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalArgumentException(string);
        }
        Geometry geometry2 = geometry.clone();
        InternalHandleDisposable.setIsDisposable((InternalHandleDisposable)geometry2, (boolean)false);
        long l3 = InternalHandle.getHandle((InternalHandle)geometry2);
        SceneNative.jni_FlyCircle(this.getHandle(), l3, d2);
    }

    public void setHandler(Handler handler) {
        this.mhandler = handler;
    }

    public Camera getFirstPersonCamera() {
        if (this.getHandle() == 0L) {
            String string = i.a("getFirstPersonCamera()", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        double[] dArray = new double[6];
        long l2 = SceneNative.jni_GetFirstPersonCamera(this.getHandle(), dArray);
        Camera camera = null;
        if (l2 != 0L) {
            camera = new Camera(dArray[0] * 57.29577951308232, dArray[1] * 57.29577951308232, dArray[2], (AltitudeMode)com.supermap.realspace.a.parse(AltitudeMode.class, (int)((int)dArray[3])), dArray[4] * 57.29577951308232, dArray[5] * 57.29577951308232);
        }
        return camera;
    }

    public void setFirstPersonCamera(Camera camera) {
        if (this.getHandle() == 0L) {
            String string = i.a("setFirstPersonCamera(Camera camera)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        if (camera == null) {
            String string = i.a("camera", "Global_ArgumentNull", "realspace_resources");
            throw new NullPointerException(string);
        }
        SceneNative.jni_SetFirstPersonCameraValue(this.getHandle(), camera.getLongitude() * (Math.PI / 180), camera.getLatitude() * (Math.PI / 180), Camera.computeDistance(camera.getAltitude(), camera.getTilt()), com.supermap.realspace.a.a((Enum)camera.getAltitudeMode()), camera.getHeading() * (Math.PI / 180), camera.getTilt() * (Math.PI / 180), camera.getAltitude());
    }

    public void pan(double d2, double d3) {
        if (this.getHandle() == 0L) {
            String string = i.a("Pan(double offsetLongitude, double offsetLatitude)", "Handle_ObjectHasBeenDisposed", "realspace_resources");
            throw new IllegalStateException(string);
        }
        SceneNative.jni_Pan(this.getHandle(), d2, d3);
    }
}

