/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.services;

import android.os.Message;
import android.util.Log;
import com.supermap.data.CursorType;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.Datasource;
import com.supermap.data.EncodeType;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.Geometry;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.QueryParameter;
import com.supermap.data.Recordset;
import com.supermap.services.Feature;
import com.supermap.services.FeatureSet;
import com.supermap.services.ServiceBase;
import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DataDownloadService
extends ServiceBase {
    private int a = -1;

    public DataDownloadService(String string) {
        super(string);
    }

    public void download(final String string, final int n, final int n2) {
        if (string == null) {
            throw new NullPointerException(" The fullUrl is null.");
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
                defaultHttpClient.getParams().setIntParameter("http.socket.timeout", 60000);
                defaultHttpClient.getParams().setIntParameter("http.connection.timeout", 25000);
                HttpGet httpGet = new HttpGet();
                FieldInfos fieldInfos = new FieldInfos();
                FeatureSet featureSet = new FeatureSet(fieldInfos);
                FieldInfos fieldInfos2 = featureSet.getFieldInfos();
                try {
                    FieldInfo fieldInfo;
                    String string4;
                    URI uRI = new URI(string + "/fields.json?" + "fromIndex=" + n + "&toIndex=" + n2);
                    httpGet.setURI(uRI);
                    HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
                    String string2 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                    JSONObject jSONObject = new JSONObject(string2);
                    JSONArray jSONArray = jSONObject.getJSONArray("childUriList");
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        if (jSONArray.get(i) == null) continue;
                        string4 = jSONArray.get(i).toString();
                        fieldInfo = DataDownloadService.this.a(string4);
                        fieldInfos2.add(fieldInfo);
                    }
                    URI uRI2 = new URI(string + "/features.json?" + "fromIndex=" + n + "&toIndex=" + n2);
                    httpGet.setURI(uRI2);
                    httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
                    string2 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
                    string4 = new JSONObject(string2);
                    fieldInfo = string4.getJSONArray("childUriList");
                    for (int i = 0; i < fieldInfo.length(); ++i) {
                        if (fieldInfo.get(i) == null) continue;
                        String string3 = fieldInfo.get(i).toString();
                        Feature feature = DataDownloadService.this.a(string3);
                        FeatureSet.a a2 = DataDownloadService.this.a(feature, fieldInfos2);
                        featureSet.a(a2);
                    }
                    DataDownloadService.this.mHandle.obtainMessage(164).sendToTarget();
                    Message message = DataDownloadService.this.mHandle.obtainMessage(162);
                    message.obj = featureSet;
                    DataDownloadService.this.mHandle.sendMessage(message);
                    ServiceBase.a.a().b(this);
                }
                catch (Exception exception) {
                    Message message = DataDownloadService.this.mHandle.obtainMessage(163);
                    message.obj = exception;
                    DataDownloadService.this.mHandle.sendMessage(message);
                    ServiceBase.a.a().b(this);
                }
            }
        };
        ServiceBase.a.a().a(runnable);
    }

    public void downloadAll(String string) {
        this.download(string, 0, -1);
    }

    public void downloadAll(String string, String string2, String string3) {
        this.download(string, string2, string3, 0, -1);
    }

    public void download(String string, String string2, String string3, int n, int n2) {
        if (string == null || string2 == null || string3 == null) {
            throw new NullPointerException(" One or more params are null.");
        }
        String string4 = this.mUrl + "/services/" + string + "/data/datasources/" + string2 + "/datasets/" + string3;
        this.download(string4, n, n2);
    }

    private Feature a(String string) throws Exception {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        defaultHttpClient.getParams().setIntParameter("http.socket.timeout", 60000);
        defaultHttpClient.getParams().setIntParameter("http.connection.timeout", 25000);
        HttpPost httpPost = new HttpPost();
        Feature feature = null;
        Geometry geometry = null;
        URI uRI = new URI(string + ".json?_method=GET");
        httpPost.setURI(uRI);
        HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
        String string2 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        JSONObject jSONObject = new JSONObject(string2);
        JSONArray jSONArray = jSONObject.getJSONArray("fieldNames");
        String[] stringArray = new String[jSONArray.length()];
        for (int i = 0; i < jSONArray.length(); ++i) {
            if (jSONArray.get(i) == null) continue;
            stringArray[i] = jSONArray.get(i).toString();
        }
        JSONArray jSONArray2 = jSONObject.getJSONArray("fieldValues");
        String[] stringArray2 = new String[jSONArray2.length()];
        for (int i = 0; i < jSONArray2.length(); ++i) {
            if (jSONArray2.get(i) == null) continue;
            stringArray2[i] = jSONArray2.get(i).toString();
        }
        JSONObject jSONObject2 = jSONObject.getJSONObject("geometry");
        if (jSONObject2 != null && jSONObject2.has("type")) {
            String string3 = jSONObject2.getString("type");
            geometry = this.createGeoByType(string3);
            geometry.fromJson(jSONObject2.toString());
        }
        feature = new Feature(stringArray, stringArray2, geometry);
        return feature;
    }

    private FieldInfo a(String string) throws Exception {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        defaultHttpClient.getParams().setIntParameter("http.socket.timeout", 60000);
        defaultHttpClient.getParams().setIntParameter("http.connection.timeout", 25000);
        HttpPost httpPost = new HttpPost();
        FieldInfo fieldInfo = new FieldInfo();
        URI uRI = new URI(string + ".json?_method=GET");
        httpPost.setURI(uRI);
        HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
        String string2 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        JSONObject jSONObject = new JSONObject(string2);
        JSONObject jSONObject2 = jSONObject.getJSONObject("fieldInfo");
        fieldInfo.setName(jSONObject2.getString("name"));
        fieldInfo.setDefaultValue(jSONObject2.getString("defaultValue"));
        fieldInfo.setCaption(jSONObject2.getString("caption"));
        fieldInfo.setMaxLength(jSONObject2.getInt("maxLength"));
        fieldInfo.setRequired(jSONObject2.getBoolean("isRequired"));
        fieldInfo.setZeroLengthAllowed(jSONObject2.getBoolean("isZeroLengthAllowed"));
        String string3 = jSONObject2.getString("type");
        FieldType fieldType = (FieldType)FieldType.parse(FieldType.class, (String)string3);
        fieldInfo.setType(fieldType);
        return fieldInfo;
    }

    private FeatureSet.a a(Feature feature, FieldInfos fieldInfos) {
        if (feature == null || fieldInfos == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        FeatureSet.a a2 = new FeatureSet.a();
        String[] stringArray = feature.getFieldValues();
        for (int i = 0; i < fieldInfos.getCount(); ++i) {
            FieldInfo fieldInfo = fieldInfos.get(i);
            FieldType fieldType = fieldInfo.getType();
            Object object = stringArray[i];
            if (!object.toString().equals("")) {
                if (fieldType.equals((Object)FieldType.INT16)) {
                    object = Short.valueOf(object.toString());
                } else if (fieldType.equals((Object)FieldType.INT32)) {
                    object = Integer.valueOf(object.toString());
                } else if (fieldType.equals((Object)FieldType.INT64)) {
                    object = Long.valueOf(object.toString());
                } else if (fieldType.equals((Object)FieldType.SINGLE)) {
                    object = Float.valueOf(object.toString());
                } else if (fieldType.equals((Object)FieldType.DOUBLE)) {
                    object = Double.valueOf(object.toString());
                } else if (fieldType.equals((Object)FieldType.DATETIME)) {
                    try {
                        object = simpleDateFormat.parse(object.toString());
                    }
                    catch (ParseException parseException) {
                        parseException.printStackTrace();
                    }
                } else if (fieldType.equals((Object)FieldType.TEXT)) {
                    object = object.toString();
                } else if (fieldType.equals((Object)FieldType.BYTE)) {
                    object = Byte.valueOf(object.toString());
                } else if (fieldType.equals((Object)FieldType.BOOLEAN)) {
                    object = Boolean.valueOf(object.toString());
                }
            }
            a2.put(fieldInfo, object);
        }
        a2.a(feature.getGeometry());
        return a2;
    }

    public void downloadDataset(final String string, final Datasource datasource) {
        if (this.isDataServiceRunning) {
            Message message = new Message();
            message.what = 165;
            message.obj = "\u6b63\u5728\u4e0b\u8f7d\u6570\u636e\u96c6\uff0c\u4e0b\u8f7d\u7ed3\u675f\u540e\u53ef\u4ee5\u66f4\u65b0\u6570\u636e\u96c6";
            this.mHandle.sendMessage(message);
        } else {
            this.isDataServiceRunning = true;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Message message = null;
                    message = DataDownloadService.this.downloadDatasetFromServer(string, datasource);
                    DataDownloadService.this.mHandle.sendMessage(message);
                    ServiceBase.a.a().b(this);
                    DataDownloadService.this.isDataServiceRunning = false;
                }
            };
            ServiceBase.a.a().a(runnable);
        }
    }

    public void updateDataset(final String string, final DatasetVector datasetVector) {
        if (this.isDataServiceRunning) {
            Message message = new Message();
            message.what = 165;
            message.obj = "\u6b63\u5728\u4e0b\u8f7d\u6216\u66f4\u65b0\u6570\u636e\u96c6\uff0c\u8bf7\u5728\u7ed3\u675f\u540e\u518d\u6b21\u66f4\u65b0";
            this.mHandle.sendMessage(message);
        } else {
            this.isDataServiceRunning = true;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Message message = null;
                    message = DataDownloadService.this.updateDatasetFromServer(string, datasetVector);
                    DataDownloadService.this.mHandle.sendMessage(message);
                    ServiceBase.a.a().b(this);
                    DataDownloadService.this.isDataServiceRunning = false;
                }
            };
            ServiceBase.a.a().a(runnable);
        }
    }

    protected Message downloadDatasetFromServer(String string, Datasource datasource) {
        Message message = new Message();
        if (string == null || datasource == null) {
            message.what = 163;
            message.obj = new String("IllegalArguments : urlDataset or datasource are null, when downloading dataset");
            return message;
        }
        try {
            boolean bl;
            boolean bl2 = this.isUrlDatasetExisted(string, message);
            if (!bl2) {
                return message;
            }
            ServiceBase.NamesInUrl namesInUrl = new ServiceBase.NamesInUrl(this, string);
            String string2 = namesInUrl.getDatasetName();
            bl2 = this.isUrlDatasetExisted(string + "_Table", message);
            if (!bl2) {
                String string3 = namesInUrl.getDatasourceUrl();
                this.addDatasetOnServer(string3, string2 + "_Table", DatasetType.TABULAR, message);
            }
            if (!(bl = this.createLocalDataset(string, datasource, message))) {
                return message;
            }
            DatasetVector datasetVector = (DatasetVector)datasource.getDatasets().get(string2);
            QueryParameter queryParameter = new QueryParameter();
            String[] stringArray = new String[]{"MAX(SmUserID)"};
            queryParameter.setResultFields(stringArray);
            queryParameter.setCursorType(CursorType.STATIC);
            queryParameter.setHasGeometry(false);
            Recordset recordset = datasetVector.query(queryParameter);
            if (!recordset.isEOF()) {
                this.a = recordset.getInt32("MAX(SmUserID)");
            }
            recordset.dispose();
            queryParameter.dispose();
            boolean bl3 = this.downloadFeatureSet(string, datasetVector, message, true);
            if (!bl3) {
                return message;
            }
            message = this.mHandle.obtainMessage(165);
            message.obj = new String("Download Dataset successfully.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            message.what = 163;
            message.obj = exception;
        }
        return message;
    }

    protected Message updateDatasetFromServer(String string, DatasetVector datasetVector) {
        Message message = new Message();
        if (string == null || datasetVector == null) {
            message.what = 163;
            message.obj = new String("IllegalArguments: urlDataset or locDataset are null, when updeating dataset");
            return message;
        }
        try {
            int n;
            QueryParameter queryParameter;
            String string2;
            boolean bl = this.isUrlDatasetExisted(string, message);
            if (!bl) {
                return message;
            }
            JSONObject jSONObject = this.downloadJSONObject(string, "GET", message, null);
            JSONObject jSONObject2 = null;
            String string3 = null;
            jSONObject2 = jSONObject.getJSONObject("datasetInfo");
            string3 = jSONObject2.getString("type");
            DatasetType datasetType = this.getDatasetType(string3);
            if (!datasetVector.getType().equals((Object)datasetType)) {
                message.what = 163;
                message.obj = new String("Local dataset's type doesn't match with that of which dataset is on server.");
                return message;
            }
            ServiceBase.NamesInUrl namesInUrl = new ServiceBase.NamesInUrl(this, string);
            String string4 = namesInUrl.getDatasetName();
            bl = this.isUrlDatasetExisted(string + "_Table", message);
            if (!bl) {
                string2 = namesInUrl.getDatasourceUrl();
                this.addDatasetOnServer(string2, string4 + "_Table", DatasetType.TABULAR, message);
            }
            string2 = new DatasetVectorInfo();
            string2.setName(datasetVector.getName() + "_Table");
            string2.setEncodeType(EncodeType.NONE);
            string2.setType(DatasetType.TABULAR);
            DatasetVector datasetVector2 = null;
            datasetVector2 = (DatasetVector)datasetVector.getDatasource().getDatasets().get(datasetVector.getName() + "_Table");
            if (datasetVector2 == null) {
                datasetVector2 = datasetVector.getDatasource().getDatasets().create((DatasetVectorInfo)string2);
                queryParameter = new FieldInfo("SMInnerFeatureID", FieldType.INT32);
                queryParameter.setDefaultValue("0");
                datasetVector2.getFieldInfos().add((FieldInfo)queryParameter);
            }
            string2.dispose();
            queryParameter = new QueryParameter();
            String[] stringArray = new String[]{"MAX(SmUserID)"};
            queryParameter.setResultFields(stringArray);
            queryParameter.setCursorType(CursorType.STATIC);
            queryParameter.setHasGeometry(false);
            Recordset recordset = datasetVector.query(queryParameter);
            if (!recordset.isEOF()) {
                this.a = recordset.getInt32("MAX(SmUserID)");
            }
            recordset.dispose();
            recordset = datasetVector2.query(queryParameter);
            if (!recordset.isEOF()) {
                n = recordset.getInt32("MAX(SmUserID)");
                int n2 = this.a = this.a > n ? this.a : n;
            }
            if ((n = (int)(this.downloadFeatureSet(string, datasetVector, message, true) ? 1 : 0)) == 0) {
                return message;
            }
            recordset.dispose();
            stringArray[0] = "MAX(SmInnerFeatureID)";
            queryParameter.setResultFields(stringArray);
            queryParameter.setCursorType(CursorType.STATIC);
            queryParameter.setHasGeometry(false);
            recordset = datasetVector2.query(queryParameter);
            this.a = -1;
            if (!recordset.isEOF()) {
                this.a = recordset.getInt32("MAX(SmInnerFeatureID)");
            }
            recordset.dispose();
            queryParameter.dispose();
            n = this.downloadFeatureSet(string + "_Table", datasetVector2, message, false) ? 1 : 0;
            if (n == 0) {
                return message;
            }
            message = this.mHandle.obtainMessage(165);
            message.obj = new String("Update Dataset successfully.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            message.what = 163;
            message.obj = exception;
        }
        return message;
    }

    protected boolean createLocalDataset(String string, Datasource datasource, Message message) throws Exception {
        if (datasource == null || string == null) {
            message.what = 163;
            message.obj = new String("IllegalArguemts: urlDataset or datasource are null, when creating dataset");
            return false;
        }
        ServiceBase.NamesInUrl namesInUrl = new ServiceBase.NamesInUrl(this, string);
        String string2 = namesInUrl.getDatasetName();
        String string3 = string2 + "_Table";
        DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo();
        datasetVectorInfo.setName(string3);
        datasetVectorInfo.setEncodeType(EncodeType.NONE);
        datasetVectorInfo.setType(DatasetType.TABULAR);
        boolean bl = datasource.getDatasets().contains(string3);
        if (bl) {
            message.what = 163;
            message.obj = new String("The dataset named " + string3 + " already exists in local Datasource");
            datasetVectorInfo.dispose();
            return false;
        }
        JSONObject jSONObject = this.downloadJSONObject(string, "GET", message, null);
        JSONObject jSONObject2 = null;
        String string4 = null;
        jSONObject2 = jSONObject.getJSONObject("datasetInfo");
        string4 = jSONObject2.getString("type");
        String string5 = jSONObject2.getString("description");
        DatasetType datasetType = this.getDatasetType(string4);
        PrjCoordSysType prjCoordSysType = (PrjCoordSysType)PrjCoordSysType.parse(PrjCoordSysType.class, (String)jSONObject2.getJSONObject("prjCoordSys").getString("type"));
        PrjCoordSys prjCoordSys = new PrjCoordSys(prjCoordSysType);
        DatasetVectorInfo datasetVectorInfo2 = new DatasetVectorInfo();
        datasetVectorInfo2.setName(string2);
        datasetVectorInfo2.setType(datasetType);
        datasetVectorInfo2.setEncodeType(EncodeType.NONE);
        boolean bl2 = datasource.getDatasets().contains(string2);
        if (bl2) {
            message.what = 163;
            message.obj = new String("The dataset named " + string2 + " already exists in local Datasource");
            datasetVectorInfo.dispose();
            datasetVectorInfo2.dispose();
            return false;
        }
        DatasetVector datasetVector = datasource.getDatasets().create(datasetVectorInfo);
        FieldInfo fieldInfo = new FieldInfo("SmInnerFeatureID", FieldType.INT32);
        fieldInfo.setDefaultValue("0");
        datasetVector.getFieldInfos().add(fieldInfo);
        DatasetVector datasetVector2 = datasource.getDatasets().create(datasetVectorInfo2);
        datasetVector2.setDescription(string5);
        datasetVector2.setPrjCoordSys(prjCoordSys);
        prjCoordSys.dispose();
        datasetVectorInfo.dispose();
        datasetVectorInfo2.dispose();
        return true;
    }

    protected boolean downloadFeatureSet(String string, DatasetVector datasetVector, Message message, boolean bl) throws Exception {
        return this.downloadFeatureSet(string, datasetVector, message, 0, -1, bl);
    }

    protected boolean downloadFeatureSet(String string, DatasetVector datasetVector, Message message, int n, int n2, boolean bl) throws Exception {
        FieldInfo fieldInfo;
        String string2;
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        defaultHttpClient.getParams().setIntParameter("http.socket.timeout", 60000);
        defaultHttpClient.getParams().setIntParameter("http.connection.timeout", 25000);
        HttpGet httpGet = new HttpGet();
        FieldInfos fieldInfos = new FieldInfos();
        FeatureSet featureSet = new FeatureSet(fieldInfos);
        FieldInfos fieldInfos2 = featureSet.getFieldInfos();
        URI uRI = new URI(string + "/fields.json?" + "fromIndex=" + n + "&toIndex=" + n2);
        httpGet.setURI(uRI);
        HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
        String string3 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        JSONObject jSONObject = new JSONObject(string3);
        JSONArray jSONArray = jSONObject.getJSONArray("childUriList");
        for (int i = 0; i < jSONArray.length(); ++i) {
            if (jSONArray.get(i) == null) continue;
            string2 = jSONArray.get(i).toString();
            fieldInfo = this.a(string2);
            fieldInfos2.add(fieldInfo);
        }
        URI uRI2 = new URI(string + "/features.json?" + "fromIndex=" + n + "&toIndex=" + n2);
        httpGet.setURI(uRI2);
        httpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
        string3 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        string2 = new JSONObject(string3);
        fieldInfo = string2.getJSONArray("childUriList");
        for (int i = 0; i < fieldInfo.length(); ++i) {
            FeatureSet.a a2;
            if (fieldInfo.get(i) == null) continue;
            String string4 = fieldInfo.get(i).toString();
            Feature feature = this.a(string4, bl);
            if (bl) {
                if (feature == null) continue;
                a2 = this.a(feature, fieldInfos2);
                featureSet.a(a2);
                continue;
            }
            a2 = this.a(feature, fieldInfos2);
            featureSet = new FeatureSet(fieldInfos2);
            featureSet.a(a2);
            this.a(featureSet, datasetVector);
        }
        if (bl) {
            this.a(featureSet, datasetVector);
        }
        return true;
    }

    private Feature a(String string, boolean bl) throws Exception {
        DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
        defaultHttpClient.getParams().setIntParameter("http.socket.timeout", 60000);
        defaultHttpClient.getParams().setIntParameter("http.connection.timeout", 25000);
        HttpPost httpPost = new HttpPost();
        Feature feature = null;
        Geometry geometry = null;
        URI uRI = new URI(string + ".json?_method=GET");
        httpPost.setURI(uRI);
        HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
        String string2 = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        JSONObject jSONObject = new JSONObject(string2);
        JSONArray jSONArray = jSONObject.getJSONArray("fieldNames");
        String[] stringArray = new String[jSONArray.length()];
        for (int i = 0; i < jSONArray.length(); ++i) {
            if (jSONArray.get(i) == null) continue;
            stringArray[i] = jSONArray.get(i).toString();
        }
        JSONArray jSONArray2 = jSONObject.getJSONArray("fieldValues");
        String[] stringArray2 = new String[jSONArray2.length()];
        for (int i = 0; i < jSONArray2.length(); ++i) {
            if (jSONArray2.get(i) == null) continue;
            stringArray2[i] = jSONArray2.get(i).toString();
        }
        if (bl) {
            JSONObject jSONObject2 = jSONObject.getJSONObject("geometry");
            if (jSONObject2 != null && jSONObject2.has("type")) {
                String string3 = jSONObject2.getString("type");
                geometry = this.createGeoByType(string3);
            }
            if (geometry != null) {
                geometry.fromJson(jSONObject2.toString());
            }
        }
        feature = new Feature(stringArray, stringArray2, geometry);
        return feature;
    }

    private boolean a(FeatureSet featureSet, DatasetVector datasetVector) {
        String string;
        if (datasetVector == null || featureSet == null) {
            return false;
        }
        if (featureSet.isEOF()) {
            featureSet.dispose();
            return true;
        }
        String string2 = "SmUserID";
        if (datasetVector.getType().equals((Object)DatasetType.TABULAR)) {
            string2 = "SmInnerFeatureID";
        }
        FieldInfos fieldInfos = featureSet.getFieldInfos();
        int n = fieldInfos.getCount();
        for (int i = 0; i < n; ++i) {
            int n2;
            string = fieldInfos.get(i).getName();
            int n3 = datasetVector.getFieldInfos().indexOf(string);
            if (n3 != -1 || (n2 = datasetVector.getFieldInfos().add(fieldInfos.get(i))) != -1) continue;
            Log.w((String)"DataDownloadService", (String)("\u5b57\u6bb5 \u201c" + string + "\u201d\u6dfb\u52a0\u5931\u8d25"));
        }
        QueryParameter queryParameter = new QueryParameter();
        queryParameter.setAttributeFilter(string2 + ">0");
        queryParameter.setCursorType(CursorType.DYNAMIC);
        string = datasetVector.getRecordset(false, CursorType.DYNAMIC);
        if (!string.isEmpty() && !datasetVector.getType().equals((Object)DatasetType.TABULAR)) {
            string.dispose();
            string = datasetVector.query(queryParameter);
            if (!string.isEmpty()) {
                this.b((Recordset)string, featureSet);
            }
        }
        string.dispose();
        string = datasetVector.getRecordset(true, CursorType.DYNAMIC);
        this.a((Recordset)string, featureSet);
        string.dispose();
        featureSet.dispose();
        return true;
    }

    private void a(Recordset recordset, FeatureSet featureSet) {
        if (recordset == null || featureSet == null) {
            return;
        }
        Object var3_3 = null;
        FieldInfo fieldInfo = null;
        FieldInfo fieldInfo2 = null;
        FieldInfos fieldInfos = null;
        FieldInfos fieldInfos2 = null;
        Object object = null;
        String string = "SmUserID";
        String string2 = null;
        int n = featureSet.getFeatureCount();
        int n2 = 0;
        if (recordset.getDataset().getType().equals((Object)DatasetType.TABULAR)) {
            string = "SmInnerFeatureID";
        }
        fieldInfos = recordset.getFieldInfos();
        fieldInfos2 = featureSet.getFieldInfos();
        recordset.moveFirst();
        featureSet.moveFirst();
        Geometry geometry = null;
        Recordset.BatchEditor batchEditor = recordset.getBatch();
        recordset.addNew(null);
        batchEditor.begin();
        while (!featureSet.isEOF()) {
            n2 = featureSet.getInt32("SMID");
            if (n2 > this.a) {
                geometry = featureSet.getGeometry();
                n = recordset.getFieldCount() < featureSet.getFieldCount() ? recordset.getFieldCount() : featureSet.getFieldCount();
                recordset.addNew(geometry);
                for (int i = 0; i < n; ++i) {
                    fieldInfo = fieldInfos.get(i);
                    fieldInfo2 = fieldInfos2.get(i);
                    string2 = fieldInfo2.getName();
                    object = featureSet.getFieldValue(string2);
                    if (fieldInfo.isSystemField() && !string2.equals("SmID")) continue;
                    if (string2.equals("SmID")) {
                        recordset.setFieldValue(string, object);
                        continue;
                    }
                    if (fieldInfo.getName().equals(string) || object.toString().equals("")) continue;
                    recordset.setFieldValue(string2, object);
                }
                if (geometry != null) {
                    geometry.dispose();
                }
            }
            featureSet.moveNext();
        }
        batchEditor.update();
        recordset.update();
        batchEditor = null;
        fieldInfos = null;
        fieldInfos2 = null;
    }

    private void b(Recordset recordset, FeatureSet featureSet) {
        if (recordset == null || featureSet == null) {
            return;
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        String string = "SmUserID";
        if (recordset.getDataset().getType().equals((Object)DatasetType.TABULAR)) {
            string = "SmInnerFeatureID";
        }
        recordset.moveFirst();
        featureSet.moveFirst();
        while (!recordset.isEOF()) {
            n = recordset.getInt32(string);
            if (n == 0) continue;
            featureSet.moveFirst();
            bl = false;
            while (!featureSet.isEOF()) {
                n2 = featureSet.getInt32("SMID");
                if (n2 == n) {
                    bl = true;
                    break;
                }
                featureSet.moveNext();
            }
            if (!bl) {
                recordset.addNew(null);
                recordset.edit();
                recordset.delete();
                recordset.update();
                continue;
            }
            recordset.moveNext();
        }
    }
}

