/*
 * Decompiled with CFR 0.152.
 */
package com.supermap.track;

import android.content.Context;
import android.location.LocationManager;
import android.os.Handler;
import com.supermap.data.CursorType;
import com.supermap.data.Dataset;
import com.supermap.data.DatasetType;
import com.supermap.data.DatasetVector;
import com.supermap.data.DatasetVectorInfo;
import com.supermap.data.Datasets;
import com.supermap.data.Datasource;
import com.supermap.data.FieldInfo;
import com.supermap.data.FieldInfos;
import com.supermap.data.FieldType;
import com.supermap.data.GeoLine;
import com.supermap.data.GeoPoint;
import com.supermap.data.Geometry;
import com.supermap.data.InternalHandle;
import com.supermap.data.Point2D;
import com.supermap.data.PrjCoordSys;
import com.supermap.data.PrjCoordSysType;
import com.supermap.data.Recordset;
import com.supermap.data.Rectangle2D;
import com.supermap.data.Size2D;
import com.supermap.plugin.LocationChangedListener;
import com.supermap.plugin.LocationManagePlugin;
import com.supermap.track.TrackToolKitNative;
import com.supermap.track.a;
import java.util.List;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Track
extends a {
    private LocationManagePlugin.GPSData a;
    private LocationManagePlugin.GPSData b;
    private List<LocationManagePlugin.GPSData> a;
    private long a;
    private long b;
    private Datasets a;
    private Dataset a;
    private int a;
    private int b;
    private double a;
    boolean a;
    private Recordset a;
    private LocationManagePlugin a;
    private LocationChangedListener a;
    private LocationManager a;
    private boolean b = 0;
    private boolean c = false;
    private Handler a;
    private Runnable a = null;

    public Track(Context context) {
        this.a = (LocationManager)context.getSystemService("location");
        this.a = new LocationManagePlugin();
        this.a = new LocationChangedListener(){

            public void locationChanged(LocationManagePlugin.GPSData gPSData, LocationManagePlugin.GPSData gPSData2, boolean bl) {
            }

            public void locationChanged(LocationManagePlugin.GPSData gPSData, LocationManagePlugin.GPSData gPSData2) {
                if (Track.this.a > 0 && Track.this.b < 2) {
                    Track.this.b++;
                    return;
                }
                Track.this.a(gPSData2);
            }
        };
        this.a.addLocationChangedListener(this.a);
    }

    void a(LocationManagePlugin.GPSData gPSData) {
        LocationManagePlugin.GPSData gPSData2 = new LocationManagePlugin.GPSData();
        gPSData2.dAltitude = gPSData.dAltitude;
        gPSData2.dBearing = gPSData.dBearing;
        gPSData2.dLatitude = gPSData.dLatitude;
        gPSData2.dLongitude = gPSData.dLongitude;
        gPSData2.dSpeed = gPSData.dSpeed;
        gPSData2.lTime = gPSData.lTime;
        this.b(gPSData2);
    }

    public void setCustomLocation(boolean bl) {
        this.a = bl;
    }

    public boolean getCustomLocation() {
        return this.a;
    }

    public void setGPSData(LocationManagePlugin.GPSData gPSData) {
        if (gPSData != null) {
            this.a(gPSData);
        }
    }

    public DatasetVector createDataset(Datasource datasource, String string) {
        DatasetVector datasetVector = null;
        if (datasource != null) {
            DatasetVectorInfo datasetVectorInfo = new DatasetVectorInfo();
            datasetVectorInfo.setType(DatasetType.POINT);
            string = datasource.getDatasets().getAvailableDatasetName(string);
            datasetVectorInfo.setName(string);
            datasetVector = datasource.getDatasets().create(datasetVectorInfo);
            PrjCoordSys prjCoordSys = new PrjCoordSys();
            prjCoordSys.setType(PrjCoordSysType.PCS_EARTH_LONGITUDE_LATITUDE);
            datasetVector.setPrjCoordSys(prjCoordSys);
            FieldInfos fieldInfos = datasetVector.getFieldInfos();
            FieldInfo fieldInfo = new FieldInfo();
            fieldInfo.setType(FieldType.DOUBLE);
            fieldInfo.setName("Altitude");
            fieldInfo.setCaption("Altitude");
            fieldInfo.setDefaultValue("0");
            fieldInfos.add(fieldInfo);
            fieldInfo.setType(FieldType.DOUBLE);
            fieldInfo.setName("Speed");
            fieldInfo.setCaption("Speed");
            fieldInfo.setDefaultValue("0");
            fieldInfos.add(fieldInfo);
            fieldInfo.setType(FieldType.DOUBLE);
            fieldInfo.setName("Bearing");
            fieldInfo.setCaption("Bearing");
            fieldInfo.setDefaultValue("0");
            fieldInfos.add(fieldInfo);
            fieldInfo.setType(FieldType.INT64);
            fieldInfo.setName("Time");
            fieldInfo.setCaption("Time");
            fieldInfo.setDefaultValue("0");
            fieldInfos.add(fieldInfo);
        }
        return datasetVector;
    }

    public void setDataset(Dataset dataset) {
        this.a = dataset;
    }

    public Dataset getDataset() {
        return this.a;
    }

    private boolean a(Dataset dataset) {
        DatasetVector datasetVector;
        FieldInfos fieldInfos;
        boolean bl = false;
        if (dataset != null && DatasetType.POINT == dataset.getType() && (fieldInfos = (datasetVector = (DatasetVector)dataset).getFieldInfos()).indexOf("Altitude") != -1 && fieldInfos.indexOf("Speed") != -1 && fieldInfos.indexOf("Bearing") != -1 && fieldInfos.indexOf("Time") != -1) {
            bl = true;
        }
        return bl;
    }

    public void setMatchDatasets(Datasets datasets) {
        this.a = datasets;
    }

    public Datasets getMatchDatasets() {
        return this.a;
    }

    public boolean startTrack() {
        boolean bl = this.a(this.a);
        if (bl) {
            this.a = ((DatasetVector)this.a).getRecordset(false, CursorType.DYNAMIC);
            if (this.a > 0) {
                this.a.postDelayed(this.a, (long)(this.a * 1000));
            }
            if (!this.a) {
                this.a.openGpsDevice(this.a);
            }
            this.c = true;
        }
        return bl;
    }

    public void stopTrack() {
        if (this.a != null) {
            this.a.closeGpsDevice();
        }
        if (this.a != null) {
            this.a.clear();
        }
        if (this.a != null) {
            this.a.removeCallbacks(this.a);
        }
        if (this.a != null) {
            this.a.dispose();
            this.a = null;
        }
        this.b = -1L;
        this.a = 0L;
        this.a = new LocationManagePlugin.GPSData();
        this.b = 0;
    }

    private void b(LocationManagePlugin.GPSData gPSData) {
        if (this.c) {
            this.c = false;
            if (gPSData.dLongitude == 0.0 || gPSData.dLatitude == 0.0) {
                return;
            }
        } else if (gPSData.dLongitude == 0.0 || gPSData.dLatitude == 0.0 || gPSData.dSpeed <= 0.0) {
            return;
        }
        if (this.a()) {
            if (this.a(gPSData)) {
                return;
            }
            int n = this.a(gPSData);
            if (this.a(n)) {
                this.c(gPSData);
            } else if (this.b(n)) {
                this.a(gPSData, n);
            } else {
                this.b(gPSData, n);
            }
        } else {
            this.c(gPSData);
            if (this.a > 0) {
                this.a.closeGpsDevice();
                this.b = 0;
            }
        }
    }

    private boolean a() {
        return this.a <= 0 && !(this.a > 70.0) && this.a != null && this.a.getCount() >= 1;
    }

    public void setTimeInterval(int n) {
        this.a = n > 20 ? n : 0;
    }

    public int getTimeInterval() {
        return this.a;
    }

    public void setDistanceInterval(double d) {
        this.a = d < 3.0 ? 3.0 : d;
    }

    public double getDistanceInterval() {
        return this.a;
    }

    private void c(LocationManagePlugin.GPSData gPSData) {
        double d = TrackToolKitNative.jni_GetSpheroidDistance(gPSData.dLongitude, gPSData.dLatitude, this.a.dLongitude, this.a.dLatitude);
        if (this.b) {
            if (this.a(gPSData, d)) {
                this.a = gPSData;
                this.d(gPSData);
            }
        } else if (d > this.a) {
            this.a = gPSData;
            this.d(gPSData);
        }
    }

    private void d(LocationManagePlugin.GPSData gPSData) {
        if (this.a != null) {
            GeoPoint geoPoint = new GeoPoint(gPSData.dLongitude, gPSData.dLatitude);
            this.a.addNew((Geometry)geoPoint);
            this.a.setFieldValue("Altitude", (Object)gPSData.dAltitude);
            this.a.setFieldValue("Speed", (Object)gPSData.dSpeed);
            this.a.setFieldValue("Bearing", (Object)gPSData.dBearing);
            this.a.setFieldValue("Time", (Object)gPSData.lTime);
            this.a.update();
        }
    }

    public void setSpeedDirectionEnable(boolean bl) {
        this.b = bl;
        this.a = 0;
        this.a = 3.0;
    }

    public boolean isSpeedDirectionEnable() {
        return this.b;
    }

    private boolean a(LocationManagePlugin.GPSData gPSData, double d) {
        if (d > 150.0) {
            return false;
        }
        if (gPSData.dSpeed <= 0.1) {
            return false;
        }
        double d2 = gPSData.dBearing;
        boolean bl = false;
        bl = this.a(d2) && d > 2.5 ? true : (gPSData.dSpeed <= 6.0 && d > 6.0 ? true : (gPSData.dSpeed > 6.0 && gPSData.dSpeed <= 10.0 && d > 12.0 ? true : (gPSData.dSpeed > 10.0 && gPSData.dSpeed <= 15.0 && d > 20.0 ? true : (gPSData.dSpeed > 15.0 && gPSData.dSpeed <= 25.0 && d > 30.0 ? true : gPSData.dSpeed >= 25.0 && gPSData.dSpeed < 50.0 && d > 50.0))));
        return bl;
    }

    private boolean a(double d) {
        double d2 = Math.abs(d - this.a.dBearing);
        return d2 > 8.0;
    }

    private boolean a(LocationManagePlugin.GPSData gPSData) {
        boolean bl = false;
        if (this.b != null) {
            double d = TrackToolKitNative.jni_GetSpheroidDistance(gPSData.dLongitude, gPSData.dLatitude, this.b.dLongitude, this.b.dLatitude);
            if (d > 150.0) {
                this.b = gPSData;
                bl = true;
            }
        } else {
            this.b = gPSData;
        }
        return bl;
    }

    private int a(LocationManagePlugin.GPSData gPSData) {
        Point2D point2D = new Point2D(gPSData.dLongitude, gPSData.dLatitude);
        Size2D size2D = new Size2D(2.341384503227386E-4, 1.801250067546878E-4);
        Rectangle2D rectangle2D = new Rectangle2D(point2D, size2D);
        double d = 10000.0;
        Point2D point2D2 = new Point2D(0.0, 0.0);
        int n = -1;
        for (int i = 0; i < this.a.getCount(); ++i) {
            DatasetVector datasetVector = (DatasetVector)this.a.get(i);
            Recordset recordset = datasetVector.query(rectangle2D, CursorType.STATIC);
            recordset.moveFirst();
            while (!recordset.isEOF()) {
                GeoLine geoLine = (GeoLine)recordset.getGeometry();
                if (geoLine != null) {
                    double[] dArray = new double[3];
                    if (TrackToolKitNative.jni_NearestPointToVertex(point2D.getX(), point2D.getY(), com.supermap.track.a.getHandle((InternalHandle)geoLine), dArray) && dArray[2] < d) {
                        d = dArray[2];
                        point2D2.setX(dArray[0]);
                        point2D2.setY(dArray[1]);
                        n = geoLine.getID();
                    }
                }
                recordset.moveNext();
            }
            recordset.dispose();
        }
        if (n != -1) {
            gPSData.dLongitude = point2D2.getX();
            gPSData.dLatitude = point2D2.getY();
        }
        return n;
    }

    private boolean a(int n) {
        return (long)n == this.a;
    }

    private boolean b(int n) {
        return (long)n == this.b;
    }

    private void a(LocationManagePlugin.GPSData gPSData, int n) {
        this.a.add(gPSData);
        if (this.a.size() == 3) {
            for (LocationManagePlugin.GPSData gPSData2 : this.a) {
                this.d(gPSData2);
            }
            this.a = gPSData;
            this.a = n;
            this.a();
        }
    }

    private void a() {
        this.a.clear();
        this.b = 0L;
    }

    private void b(LocationManagePlugin.GPSData gPSData, int n) {
        this.a();
        this.a.add(gPSData);
        this.b = n;
    }
}

