/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.text.DateFormat;
import java.util.Date;
import java.util.concurrent.Callable;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class ExecSQLCallable
implements Callable<String> {
    private Connection conn;
    private DateFormat df;
    private SQLRequest request;

    public ExecSQLCallable(Connection conn, DateFormat df, SQLRequest request) {
        this.conn = conn;
        this.df = df;
        this.request = request;
    }

    @Override
    public String call() throws Exception {
        String result = this.execSQLJsonSimple();
        System.out.println(result);
        return result;
    }

    public String execSQLJsonSimple() {
        JSONObject response = new JSONObject();
        response.put((Object)"msgId", (Object)this.request.msgId);
        JSONArray rss = new JSONArray();
        response.put((Object)"result", (Object)rss);
        try {
            Statement stmt = this.conn.createStatement();
            boolean isRS = stmt.execute(this.request.sql);
            while (isRS || stmt.getUpdateCount() != -1) {
                if (!isRS) {
                    isRS = stmt.getMoreResults();
                    continue;
                }
                ResultSet rs = stmt.getResultSet();
                ResultSetMetaData meta = rs.getMetaData();
                int colCount = meta.getColumnCount();
                String[] columns = new String[colCount + 1];
                for (int c = 1; c < colCount + 1; ++c) {
                    columns[c] = meta.getColumnLabel(c);
                }
                JSONArray jsonRS = new JSONArray();
                rss.add((Object)jsonRS);
                while (rs.next()) {
                    JSONObject row = new JSONObject();
                    jsonRS.add((Object)row);
                    block8: for (int c = 1; c < colCount + 1; ++c) {
                        Object val = rs.getObject(c);
                        if (val == null) continue;
                        int dataType = meta.getColumnType(c);
                        switch (dataType) {
                            case 91: 
                            case 93: {
                                String my8601formattedDate = this.df.format(new Date(rs.getTimestamp(c).getTime()));
                                row.put((Object)columns[c], (Object)my8601formattedDate);
                                continue block8;
                            }
                            default: {
                                row.put((Object)columns[c], rs.getObject(c));
                            }
                        }
                    }
                }
                rs.close();
                isRS = stmt.getMoreResults();
            }
            stmt.close();
        }
        catch (Exception ex) {
            response.put((Object)"error", (Object)ex.getMessage());
        }
        response.put((Object)"javaStartTime", (Object)this.request.javaStartTime);
        long beforeParse = System.currentTimeMillis();
        response.put((Object)"javaEndTime", (Object)beforeParse);
        String jsonResult = response.toJSONString();
        return jsonResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void safePrintln(String s) {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            System.out.println(s);
        }
    }
}

