/*
 * Decompiled with CFR 0.152.
 */
import java.util.Properties;

public class Main
implements SQLRequestListener {
    String host;
    Integer port;
    String dbname;
    String username;
    String password;
    SybaseDB db;
    StdInputReader input;
    Properties properties;

    public static void main(String[] args) {
        if (args.length < 5) {
            System.err.println("Esperando os argumentos: host, port, dbname, username, password, [CHAVE=VALOR ...]");
            System.exit(1);
        }
        String host = args[0];
        Integer port = Integer.parseInt(args[1]);
        String dbname = args[2];
        String username = args[3];
        String password = args[4];
        Properties props = new Properties();
        if (args.length > 5) {
            for (int i = 5; i < args.length; ++i) {
                String[] keyValue = args[i].split("=", 2);
                if (keyValue.length != 2) {
                    System.err.println("Formato inv\u00e1lido para propriedade: " + args[i] + ". Utilize o formato CHAVE=VALOR.");
                    System.exit(1);
                }
                props.setProperty(keyValue[0], keyValue[1]);
            }
        }
        new Main(host, port, dbname, username, password, props);
    }

    public Main(String host, Integer port, String dbname, String username, String password, Properties props) {
        this.host = host;
        this.port = port;
        this.dbname = dbname;
        this.username = username;
        this.password = password;
        this.properties = props;
        this.input = new StdInputReader();
        this.input.addListener(this);
        this.db = new SybaseDB(host, port, dbname, username, password, this.properties);
        if (!this.db.connect()) {
            System.exit(1);
        }
        System.out.println("connected");
        this.input.startReadLoop();
    }

    @Override
    public void sqlRequest(SQLRequest request) {
        this.db.execSQL(request);
    }
}

