/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.utils;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.utils.SybInterfacesEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public class SybSqlIniParser {
    protected Vector<String> _lines;
    protected Vector<String> _subjects;
    protected Vector<Vector<String>> _variables;
    protected Vector<Vector<Object>> _values;
    protected Vector<Vector<Object>> _haValues;
    protected Vector<Vector<Object>> _kerbValues;
    protected String _fileName;
    protected SybInterfacesEntry _entry;
    public static final String[] cTypesSet = new String[]{"master", "query", "hafailover", "win3_query", "dos_query", "console", "debug", "commit", "secmech", "$base"};
    public static final String[] PROTOCOL_TABLE = new String[]{"tcp", "tli", "nlwnsck"};

    private void load(String string) throws IOException, MalformedURLException, SQLException, IllegalArgumentException, NoSuchElementException {
        this._fileName = string;
        try {
            URL uRL = new URL(string);
            if (!this.probe(uRL)) {
                this._fileName = null;
                ErrorMessage.raiseError("JZ022", uRL.getFile());
            }
            this.loadFile(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            if (!new File(string).exists()) {
                this._fileName = null;
                ErrorMessage.raiseError("JZ021", string);
            }
            this.loadFile();
        }
        this.parseLines();
    }

    public void loadFile(URL uRL) throws IOException {
        this.resetVectors();
        InputStream inputStream = uRL.openStream();
        this.loadFile(inputStream);
    }

    public void loadFile() throws IOException {
        this.resetVectors();
        this.loadFile(new FileInputStream(this._fileName));
    }

    public void loadFile(InputStream inputStream) throws IOException {
        this.resetVectors();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = "";
        while ((string = bufferedReader.readLine()) != null) {
            if (this.isBlankLine(string) && this.isCommentLine(string)) continue;
            this._lines.addElement(string);
        }
        bufferedReader.close();
    }

    private String getSubject(String string) {
        return string.substring(1, string.length() - 1);
    }

    private boolean isBlankLine(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().length() == 0;
    }

    private boolean isCommentLine(String string) {
        return this.isBlankLine(string) ? false : string.startsWith(";") || string.startsWith("#");
    }

    private void resetVectors() {
        this._lines = new Vector();
        this._subjects = new Vector();
        this._variables = new Vector();
        this._values = new Vector();
        this._haValues = new Vector();
        this._kerbValues = new Vector();
    }

    private void fetch(String string) {
        String[] stringArray = this.getVariables(string);
        this._entry = new SybInterfacesEntry(string);
        int n = this._subjects.indexOf(string);
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            Vector<Object> vector;
            if (stringArray[i].equalsIgnoreCase("query")) {
                vector = this._values.elementAt(n);
                for (int j = 0; j < vector.size(); ++j) {
                    String string3 = this.getValue(string, j).trim();
                    if (string3.equals("")) continue;
                    this._entry._query.addElement(string3);
                }
                continue;
            }
            if (stringArray[i].equalsIgnoreCase("hafailover")) {
                vector = this._haValues.elementAt(n);
                String string4 = this.getEntryValues(vector);
                if (string4.equals("")) continue;
                this._entry._haFailover = string4;
                continue;
            }
            if (!stringArray[i].equalsIgnoreCase("secmech") || (string2 = this.getEntryValues(vector = this._kerbValues.elementAt(n))).equals("")) continue;
            this._entry._kerberos = string2;
        }
    }

    public SybInterfacesEntry getEntry(String string) {
        this.fetch(string);
        return this._entry;
    }

    public void open(String string) throws IOException, SQLException, MalformedURLException, IllegalArgumentException, NoSuchElementException {
        this.load(string);
    }

    private void parseLines() {
        String string = null;
        String string2 = null;
        for (int i = 0; i < this._lines.size(); ++i) {
            String string3;
            int n;
            string = this._lines.elementAt(i);
            if (this.isBlankLine(string) || this.isCommentLine(string) || (n = (string = this.convertUnixInterfacesFile(string)).indexOf("=")) != -1 && (string3 = string.substring(0, n)).equalsIgnoreCase("master")) continue;
            if (this.isaSubject(string)) {
                string2 = this.getSubject(string);
                continue;
            }
            if (!this.isanAssignment(string)) continue;
            string3 = string.trim();
            this.addAttributes(string2, string3);
        }
    }

    private String convertUnixInterfacesFile(String string) {
        if (string.indexOf("=") == -1) {
            int n;
            int n2;
            Object object;
            if ((string = this.replaceWhiteSpaces(string)).startsWith("[") && string.endsWith("]")) {
                return string;
            }
            int n3 = string.lastIndexOf("]");
            if (n3 != -1) {
                string = string.substring(0, n3 + 1);
                return string;
            }
            boolean bl = false;
            n3 = string.indexOf(",");
            if (n3 == -1) {
                object = string.toCharArray();
                for (int i = 0; i < ((char[])object).length; ++i) {
                    if (!Character.isWhitespace(object[i])) continue;
                    if (!Character.isDigit(object[i + 1])) {
                        bl = true;
                        break;
                    }
                    n2 = string.indexOf(object[i]);
                    string = string.substring(0, n2);
                    break;
                }
                if (!bl) {
                    return "[" + string + "]";
                }
            }
            char[] cArray = string.toCharArray();
            Vector<String> vector = new Vector<String>();
            object = null;
            String string2 = null;
            n2 = -1;
            for (n = 0; n < cArray.length; ++n) {
                if (!Character.isWhitespace(cArray[n])) continue;
                if (string2 == null) {
                    n2 = string.indexOf(cArray[n]);
                    string2 = string.substring(0, n2);
                }
                if (string2.equalsIgnoreCase("secmech")) {
                    vector.addElement(string2);
                    string = string.substring(n2, string.length()).trim();
                    n2 = string.indexOf(",");
                    while (n2 != -1) {
                        string2 = string.substring(0, n2);
                        vector.addElement(string2);
                        string2 = string = string.substring(n2 + 1, string.length()).trim();
                        object = string;
                        n2 = string.indexOf(",");
                    }
                    if (vector.contains(string2)) break;
                    vector.addElement(string2);
                    break;
                }
                if (object == null) {
                    int n4 = string.lastIndexOf(cArray[n]);
                    object = string.substring(n4, string.length()).trim();
                }
                if (!((string2 = string.substring(0, n2 = string.indexOf(cArray[n]))).equalsIgnoreCase("ether") || string2.equalsIgnoreCase("sun-ether") || string2.equalsIgnoreCase("/dev/tcp") || vector.contains(string2))) {
                    vector.addElement(string2);
                }
                if (!((String)object).equalsIgnoreCase(string = string.substring(n2, string.length()).trim())) continue;
                vector.addElement(string);
                break;
            }
            if (vector.size() == 0) {
                return "[" + string + "]";
            }
            string = (String)vector.elementAt(0) + "=";
            for (n = 1; n < vector.size(); ++n) {
                String string3 = (String)vector.elementAt(n);
                string = string3.equalsIgnoreCase((String)object) ? string + string3 : string + string3 + ",";
            }
        }
        return string.trim();
    }

    private boolean addAttributes(String string, String string2) {
        String[] stringArray = new String[2];
        if (this.addAttributes(string, string2, stringArray)) {
            return this.addValue(string, stringArray[0], stringArray[1], false);
        }
        return false;
    }

    private boolean addAttributes(String string, String string2, String[] stringArray) {
        int n = string2.indexOf("=");
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n + 1, string2.length());
        string4 = this.removeWhiteSpaceCharacters(string4);
        if (string3.equalsIgnoreCase("query")) {
            string4 = this.checkSSL(string4);
            string4 = this.checkTLI(string4);
        }
        if (string4.length() == 0 || string3.length() == 0) {
            return false;
        }
        stringArray[0] = string3.toLowerCase();
        stringArray[1] = string4;
        return true;
    }

    private String checkTLI(String string) {
        int n = string.indexOf(",");
        String string2 = string.substring(0, n);
        if (string2.equalsIgnoreCase("tli")) {
            n = string.lastIndexOf(",");
            if ((n = (string = string.substring(n + 1, string.length())).indexOf(92)) >= 0 && string.charAt(n + 1) == 'x') {
                string = string.substring(n + 6, string.length());
                String string3 = this.hexToDecimal(string.substring(0, 4));
                String string4 = string.substring(4, 12);
                String[] stringArray = new String[4];
                for (int i = 0; i <= string4.length() + 1; ++i) {
                    String string5 = string4.substring(0, 2);
                    string4 = string4.substring(string5.length(), string4.length());
                    stringArray[i] = this.hexToDecimal(string5);
                }
                string = "TCP," + stringArray[0] + "." + stringArray[1] + "." + stringArray[2] + "." + stringArray[3] + "," + string3;
            }
        }
        return string;
    }

    private String hexToDecimal(String string) {
        Integer n = new Integer(Integer.parseInt(string, 16));
        string = n.toString();
        return string;
    }

    private String checkSSL(String string) {
        int n = string.lastIndexOf(",");
        if (string.substring(n + 1, string.length()).equalsIgnoreCase("ssl")) {
            string = string.substring(0, n);
        }
        return string;
    }

    private boolean addValue(String string, String string2, String string3, boolean bl) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        if (!this._subjects.contains(string)) {
            this._subjects.addElement(string);
            this._variables.addElement(new Vector());
            this._values.addElement(new Vector());
            this._haValues.addElement(new Vector());
            this._kerbValues.addElement(new Vector());
        }
        int n = this._subjects.indexOf(string);
        Vector<String> vector = this._variables.elementAt(n);
        Vector<Object> vector2 = this._values.elementAt(n);
        Vector<Object> vector3 = this._haValues.elementAt(n);
        Vector<Object> vector4 = this._kerbValues.elementAt(n);
        if (!vector.contains(string2)) {
            vector.addElement(string2);
        }
        int n2 = vector2.size();
        vector2.addElement(this._values);
        vector3.addElement(this._haValues);
        vector4.addElement(this._kerbValues);
        if (string2.equalsIgnoreCase("query")) {
            vector2.setElementAt(string3, n2);
            this.setEmptyString(vector3, vector4, "", n2);
        } else if (string2.equalsIgnoreCase("hafailover")) {
            vector3.setElementAt(string3, n2);
            this.setEmptyString(vector2, vector4, "", n2);
        } else if (string2.equalsIgnoreCase("secmech")) {
            vector4.setElementAt(string3, n2);
            this.setEmptyString(vector2, vector3, "", n2);
        }
        return true;
    }

    private void setEmptyString(Vector<Object> vector, Vector<Object> vector2, String string, int n) {
        vector.setElementAt(string, n);
        vector2.setElementAt(string, n);
    }

    private boolean isaSubject(String string) {
        return string != null && !this.isCommentLine(string) && (string = string.trim()).length() > 0 && string.startsWith("[") && string.endsWith("]");
    }

    private String refineSubject(String string) {
        return string.startsWith("[") && string.endsWith("]") ? string : "[" + string + "]";
    }

    private boolean isEndOfSubject(String string) {
        if (string == null) {
            return true;
        }
        if (this.isBlankLine(string)) {
            return true;
        }
        if (this.isCommentLine(string)) {
            return true;
        }
        return !this.startsWith(string, cTypesSet);
    }

    private String replaceWhiteSpaces(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t ");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + stringTokenizer.nextToken().trim() + " ";
        }
        return string2.trim();
    }

    private String removeWhiteSpaceCharacters(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t ");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + stringTokenizer.nextToken().trim();
        }
        return string2;
    }

    private boolean isanAssignment(String string) {
        return this.isAttributes(string);
    }

    public Vector<?> getLines() {
        return (Vector)this._lines.clone();
    }

    public String[] getVariables(String string) {
        int n = this._subjects.indexOf(string.trim());
        if (n != -1) {
            Vector<String> vector = this._variables.elementAt(n);
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        String[] stringArray = new String[]{};
        return stringArray;
    }

    public String[] getSubjects() {
        Object[] objectArray = new String[this._subjects.size()];
        this._subjects.copyInto(objectArray);
        return objectArray;
    }

    public String getValue(String string, int n) {
        int n2 = this._subjects.indexOf(string);
        if (n2 == -1) {
            return "";
        }
        Vector<Object> vector = this._values.elementAt(n2);
        return (String)vector.elementAt(n);
    }

    public String getEntryValues(Vector<Object> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            if (string.equals("")) continue;
            return string;
        }
        return "";
    }

    private boolean probe(URL uRL) throws IOException, IllegalArgumentException, NoSuchElementException, SQLException {
        InputStream inputStream = uRL.openStream();
        this._fileName = uRL.getFile();
        return this.probe(inputStream);
    }

    private boolean probe(InputStream inputStream) throws IOException, IllegalArgumentException, NoSuchElementException, SQLException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        bufferedReader.mark(1);
        if (-1 == bufferedReader.read()) {
            bufferedReader.close();
            ErrorMessage.raiseError("JZ022", this._fileName);
        }
        bufferedReader.reset();
        Enumeration<String> enumeration = this.nextSubject(bufferedReader);
        while (enumeration != null && enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (this.isAttributes(string)) continue;
            bufferedReader.close();
            return false;
        }
        bufferedReader.close();
        return enumeration != null;
    }

    private Enumeration<String> nextSubject(BufferedReader bufferedReader) throws IOException {
        Vector<String> vector = new Vector<String>();
        String string = bufferedReader.readLine();
        if (string == null) {
            return null;
        }
        string = string.trim();
        while (!this.isaSubject(string)) {
            string = bufferedReader.readLine();
            if (string == null) {
                return null;
            }
            string = string.trim();
        }
        string = this.refineSubject(string);
        boolean bl = false;
        while (!bl) {
            string = bufferedReader.readLine();
            if (string != null) {
                string = string.trim();
            }
            if (!this.isEndOfSubject(string)) {
                if (this.isBlankLine(string) || this.isCommentLine(string)) continue;
                vector.addElement(string);
                continue;
            }
            bl = true;
        }
        return !vector.isEmpty() ? vector.elements() : null;
    }

    private boolean isAttributes(String string) {
        return string != null && string.length() > 0 && (string = string.trim()).indexOf("=") != -1 && !string.startsWith(";") && this.startsWith(string, cTypesSet);
    }

    private boolean startsWith(String string, String[] stringArray) {
        string = string.toLowerCase(Locale.ENGLISH);
        String[] stringArray2 = stringArray;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!string.startsWith(stringArray2[i])) continue;
            return true;
        }
        return false;
    }
}

