/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.jdbc.Convert;
import com.sybase.jdbc4.jdbc.DateObject;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.MdaManager;
import com.sybase.jdbc4.jdbc.Param;
import com.sybase.jdbc4.jdbc.ParamManager;
import com.sybase.jdbc4.jdbc.SybPreparedStatement;
import com.sybase.jdbc4.tds.TdsConst;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;

public class SybBCP
implements TdsConst {
    private SybPreparedStatement _sybStmt;
    private int _numberVarColumns;
    private int _numberVarColumnSAVE;
    private int _columnCount = 0;
    private int _fixedColLenTotal;
    protected String _columnName = null;
    private String _columnDefault = null;
    protected ArrayList<String> _columnDefination = null;
    private int _columnId = 0;
    private int _datatype = 0;
    private int _usertype = 0;
    private int _identityCol = 0;
    private int _columnLength = 0;
    private int _precision = 0;
    private int _scale = 0;
    private int _isColumnNull = 0;
    private int _table_lock_scheme = -1;
    private int _sqlType = -999;
    private int[] _colId = null;
    private int _pageSize = 0;
    private String _dbName = null;
    private String _tableName = null;
    private String _tableOwner = null;
    private boolean _userDefinedIdentity = false;
    private int _encryptedCol = 0;
    private boolean _encrypted = false;
    private boolean _setValuesAsCiphertext = false;
    private boolean _isLastColText = false;
    public int _lastVarColumn = 0;
    private String _functionStr = null;
    private int _maxRowLength = 0;
    private int _textimageCount = 0;
    private int _enableBCP = 1;
    private boolean _bcpInitialized = false;
    private Object[] _objectDefaults = null;
    private int[] _typesDefaults = null;
    private int[] _scaleDefaults = null;
    private boolean _wideDOLSupported = false;
    private int _colOffset = 0;
    private boolean _oldMdaInUse = false;
    private int _isInRow = 0;
    private int _inRowLobCount = 0;
    private boolean[] _droppedColumns = null;
    private boolean _hasDroppedColumn = false;
    private int[] _intTypeMetadata = null;
    private String[] _stringTypeMetadata = null;
    public static final int COL_ID_IDX = 0;
    public static final int COL_DATATYPE_IDX = 1;
    public static final int COL_USERTYPE_IDX = 2;
    public static final int COL_LEN_IDX = 3;
    public static final int COL_PRECISION_IDX = 4;
    public static final int COL_SCALE_IDX = 5;
    public static final int COL_ISNULL_IDX = 6;
    public static final int COL_ISIDENTITY_IDX = 7;
    public static final int COL_SQLTYPE_IDX = 8;
    public static final int COL_OFFSET_IDX = 9;
    public static final int COL_TRUNC_VARBINARY_IDX = 10;
    public static final int COL_IS_INROWLOB_IDX = 11;
    public static final int COL_INROWLOB_LEN_IDX = 12;
    public static final int COL_IS_VARIABLE_IDX = 13;
    public static final int COL_IS_ENCRYPTED_IDX = 14;
    public static final int COL_NAME_IDX = 0;
    public static final int COL_DEFAULT_IDX = 1;
    public static final int INT_MDA_COUNT = 15;
    public static final int STR_MDA_COUNT = 2;
    public static final int APL = 0;
    public static final int DOL = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SybBCP(SybPreparedStatement sybPreparedStatement, int n) throws SQLException {
        this._enableBCP = n;
        this._sybStmt = sybPreparedStatement;
        this._dbName = this._sybStmt.getDbName();
        if (this._sybStmt._table == null) {
            this._sybStmt.processEscapes(this._sybStmt._query);
        }
        this._tableName = this._sybStmt._table;
        String[] stringArray = this._tableName.split("\\.");
        int n2 = 0;
        switch (stringArray.length) {
            case 3: {
                this._dbName = stringArray[n2++];
            }
            case 2: {
                this._tableOwner = stringArray[n2++];
                if (this._tableOwner.length() == 0) {
                    this._tableOwner = null;
                }
            }
            case 1: {
                this._tableName = stringArray[n2];
            }
        }
        this._setValuesAsCiphertext = this._sybStmt._context._conn._props.getBoolean(99);
        MdaManager mdaManager = this._sybStmt._context._conn.getMDA(this._sybStmt._context);
        PreparedStatement preparedStatement = mdaManager.getMetaDataAccessor("BULK_INSERT", this._sybStmt._context);
        if (this._tableName != null && this._tableName.startsWith("\"") && this._tableName.endsWith("\"")) {
            this._tableName = this._tableName.substring(1, this._tableName.length() - 1);
        }
        preparedStatement.setString(1, this._tableName);
        preparedStatement.setString(2, this._tableOwner);
        preparedStatement.setString(3, this._dbName);
        ResultSet resultSet = null;
        try {
            resultSet = preparedStatement.executeQuery();
            resultSet.next();
            this._columnCount = resultSet.getInt(1);
            this._dbName = resultSet.getString(2);
            if (this._columnCount == 0) {
                return;
            }
            this._droppedColumns = new boolean[this._columnCount];
            while (!preparedStatement.getMoreResults() && preparedStatement.getUpdateCount() != -1) {
            }
            resultSet = preparedStatement.getResultSet();
            this.addResults(resultSet, this._columnCount);
            this._objectDefaults = new Object[this._columnCount];
            this._typesDefaults = new int[this._columnCount];
            this._scaleDefaults = new int[this._columnCount];
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
                resultSet = null;
            }
            if (preparedStatement != null) {
                preparedStatement.close();
                preparedStatement = null;
            }
        }
        this.getColumnDef();
    }

    public ParamManager getParamManager() {
        return this._sybStmt._paramMgr;
    }

    private void getColumnDef() {
        this._columnDefination = new ArrayList(this._columnCount);
        int n = 0;
        String string = this._sybStmt._query;
        int n2 = string.indexOf("(");
        if (n2 != -1) {
            int n3;
            if ((n2 = (string = string.substring(n2 + 1, string.indexOf(")"))).indexOf("?")) == -1) {
                n2 = string.indexOf(",");
                if (n2 != -1) {
                    String string2 = null;
                    string2 = string.substring(0, n2).trim();
                    this._columnDefination.add(n, string2);
                    string = string.substring(n2 + 1, string.length());
                    n2 = string.indexOf(",");
                    if (n2 == -1) {
                        this._columnDefination.add(++n, string.trim());
                    }
                    while (n2 != -1) {
                        string2 = string.substring(0, n2).trim();
                        this._columnDefination.add(++n, string2);
                        n2 = string.indexOf(",");
                        if (n2 != -1) {
                            if ((n2 = (string = string.substring(n2 + 1, string.length())).indexOf(",")) != -1) continue;
                            this._columnDefination.add(++n, string.trim());
                            continue;
                        }
                        break;
                    }
                } else {
                    this._columnDefination.add(n, string.trim());
                }
            }
            if ((n3 = this._columnDefination.size()) == 0) {
                n3 = this._columnCount;
            }
            this._colId = new int[n3];
        }
    }

    protected void setColumnIdList(int n, boolean bl) {
        int n2 = this._columnDefination.size();
        if (n2 == 0) {
            this._colId[n] = this.getColumnId();
            this.setUserDefinedIdentity();
            return;
        }
        String string = null;
        for (int i = 0; i < n2; ++i) {
            string = this._columnDefination.get(i);
            if (string.startsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
            if ((!bl || this._columnName == null || !this._columnName.equalsIgnoreCase(string)) && (bl || this._columnId == 0 || this._columnId != Integer.parseInt(string))) continue;
            this._colId[i] = this.getColumnId();
            this.setUserDefinedIdentity();
            break;
        }
    }

    private void setUserDefinedIdentity() {
        if (this.getIdentityColumn() == 1) {
            this._userDefinedIdentity = true;
        }
    }

    private void setLastColumn() {
        if (this._table_lock_scheme == 1) {
            this._lastVarColumn = this._datatype;
        }
    }

    private void checkDefaultFunction() {
        String string = this._columnDefault.substring(0, 1);
        try {
            int n = Integer.valueOf(string);
            if (n >= 0 || n < 0) {
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (this._functionStr == null) {
                this._functionStr = "";
            }
            this._functionStr = this._functionStr.concat(" select " + this._columnDefault);
            this._columnDefault = "SYBASEFUNCTION";
        }
    }

    private void getDefaultFunctionValue() throws SQLException {
        Statement statement = this._sybStmt._context._conn.createStatement();
        ResultSet resultSet = statement.executeQuery(this._functionStr);
        this.findNReplace(resultSet);
        while (statement.getMoreResults()) {
            resultSet = statement.getResultSet();
            this.findNReplace(resultSet);
        }
    }

    private void findNReplace(ResultSet resultSet) throws SQLException {
        resultSet.next();
        for (int i = 1; i <= this._stringTypeMetadata.length; i += 2) {
            if (this._stringTypeMetadata[i] == null || !this._stringTypeMetadata[i].equalsIgnoreCase("SYBASEFUNCTION")) continue;
            this._stringTypeMetadata[i] = resultSet.getString(1);
            break;
        }
    }

    private void addResults(ResultSet resultSet, int n) throws SQLException {
        this._intTypeMetadata = new int[n * 15];
        this._stringTypeMetadata = new String[n * 2];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl = true;
        while (resultSet.next()) {
            int n5 = resultSet.getInt("COLID");
            this._intTypeMetadata[0 + n2] = n5;
            n4 = n5;
            this._stringTypeMetadata[0 + n3] = resultSet.getString("COLUMN_NAME");
            this._droppedColumns[n4 - 1] = resultSet.getString("COLUMN_NAME").equals(" ");
            if (!this._hasDroppedColumn && resultSet.getString("COLUMN_NAME").equals(" ")) {
                this._hasDroppedColumn = true;
            }
            this._datatype = resultSet.getInt("DATA_TYPE");
            this._usertype = resultSet.getInt("USERTYPE");
            this._isColumnNull = resultSet.getInt("NULLABLE");
            this.setUniDataType();
            if (bl) {
                try {
                    if (this._setValuesAsCiphertext && resultSet.getInt("ENCRYPTED_COL") == 1) {
                        this._datatype = 37;
                        this._intTypeMetadata[14 + n2] = 1;
                    }
                }
                catch (SQLException sQLException) {
                    bl = false;
                    this._oldMdaInUse = true;
                }
            }
            this._intTypeMetadata[1 + n2] = this._datatype;
            this._intTypeMetadata[2 + n2] = this._usertype;
            int n6 = resultSet.getInt("COLUMN_SIZE");
            this._intTypeMetadata[3 + n2] = n6;
            this._columnLength = n6;
            this._intTypeMetadata[4 + n2] = resultSet.getInt("PRECISION");
            this._intTypeMetadata[5 + n2] = resultSet.getInt("SCALE");
            this._intTypeMetadata[6 + n2] = this._isColumnNull;
            int n7 = this._sybStmt._literalIdxList.indexOf(n4);
            this._columnDefault = n7 != -1 ? (String)this._sybStmt._literalValueList.elementAt(n7) : resultSet.getString("COLUMN_DEF");
            this._stringTypeMetadata[1 + n3] = this.checkColumnDefault();
            this._intTypeMetadata[7 + n2] = resultSet.getInt("IDENTITY_COL");
            if (this._table_lock_scheme < 0) {
                this._table_lock_scheme = resultSet.getInt("TABLE_LOCK_SCHEME");
            }
            switch (this._datatype) {
                case 34: 
                case 35: 
                case 174: {
                    ++this._textimageCount;
                }
                case 37: 
                case 38: 
                case 39: 
                case 106: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 123: 
                case 147: 
                case 187: 
                case 188: {
                    this.setLastColumn();
                    break;
                }
                case 49: 
                case 51: 
                case 55: 
                case 56: 
                case 60: 
                case 61: 
                case 62: 
                case 63: {
                    if (this._enableBCP != 3 || !this._hasDroppedColumn) break;
                    this.setLastColumn();
                }
            }
            if (this._pageSize == 0) {
                this._pageSize = resultSet.getInt("PAGESIZE");
            }
            if (bl) {
                try {
                    this._wideDOLSupported = resultSet.getBoolean("ALLOW_WIDE_DOL");
                    if (this._maxRowLength == 0) {
                        this._maxRowLength = resultSet.getInt("MAX_ROWLEN");
                    }
                    int n8 = resultSet.getInt("COL_OFFSET");
                    this._intTypeMetadata[9 + n2] = n8;
                    this._colOffset = n8;
                    int n9 = resultSet.getInt("IS_INROWLOB");
                    this._intTypeMetadata[11 + n2] = n9;
                    this._isInRow = n9;
                    if (this._isInRow != 0) {
                        ++this._inRowLobCount;
                    }
                    this._intTypeMetadata[10 + n2] = resultSet.getInt("TRUNCATE_VARBINARY_ZEROS");
                    this._intTypeMetadata[12 + n2] = resultSet.getInt("INROWLOB_LEN");
                    if (!this._setValuesAsCiphertext && resultSet.getInt("ENCRYPTED_COL") == 1) {
                        this._intTypeMetadata[9 + n2] = -999;
                        this._colOffset = -999;
                    }
                }
                catch (SQLException sQLException) {
                    bl = false;
                    this.useOldMDA(n2);
                }
            } else {
                this.useOldMDA(n2);
            }
            if (this.isVariableColumn()) {
                ++this._numberVarColumns;
                this._intTypeMetadata[13 + n2] = 1;
                if (!this._setValuesAsCiphertext) {
                    int n10 = 0 - this._numberVarColumns;
                    this._intTypeMetadata[9 + n2] = n10;
                    this._colOffset = n10;
                }
            } else {
                this._intTypeMetadata[13 + n2] = 0;
                this._fixedColLenTotal += this._columnLength;
            }
            this._intTypeMetadata[8 + n2] = this.setSQLTypes();
            n2 += 15;
            n3 += 2;
        }
        if (this._functionStr != null) {
            this.getDefaultFunctionValue();
        }
    }

    private void useOldMDA(int n) {
        this._oldMdaInUse = true;
        this._intTypeMetadata[9 + n] = -999;
        this._colOffset = -999;
        this._intTypeMetadata[10 + n] = 1;
        this._maxRowLength += this._columnLength;
    }

    private boolean isVariableColumn() {
        boolean bl = false;
        if (this._colOffset == -999) {
            if (this.isColumnNull() == 1 || this.getNullableDatatype(this._datatype)) {
                bl = true;
            }
        } else if (this._colOffset < 0) {
            bl = true;
        }
        return bl;
    }

    protected int getId(int n) {
        if (this._sybStmt._literalIdxList == null || this._sybStmt._literalIdxList.size() == 0) {
            return this._colId[n - 1];
        }
        int n2 = 1;
        int n3 = 0;
        for (n3 = 0; n3 < this._colId.length && (this._stringTypeMetadata[n3 * 2 + 1] != null || n2++ != n); ++n3) {
        }
        return this._colId[n3];
    }

    private int setSQLTypes() {
        int n = -999;
        block0 : switch (this._datatype) {
            case 48: 
            case 50: {
                n = -6;
                break;
            }
            case 52: 
            case 65: {
                n = 5;
                break;
            }
            case 56: 
            case 66: {
                n = 4;
                break;
            }
            case 191: {
                n = -5;
                break;
            }
            case 38: {
                switch (this._columnLength) {
                    case 1: {
                        n = -6;
                        break;
                    }
                    case 2: {
                        n = 5;
                        break;
                    }
                    case 4: {
                        n = 4;
                        break;
                    }
                    case 8: {
                        n = -5;
                    }
                }
                break;
            }
            case 59: {
                n = 7;
                break;
            }
            case 62: {
                n = 6;
                break;
            }
            case 109: {
                switch (this._columnLength) {
                    case 4: {
                        n = 7;
                        break;
                    }
                    case 8: {
                        n = 6;
                    }
                }
                break;
            }
            case 39: 
            case 47: {
                n = 12;
                break;
            }
            case 55: 
            case 60: 
            case 63: 
            case 67: 
            case 106: 
            case 108: 
            case 110: 
            case 122: {
                n = 2;
                break;
            }
            case 49: 
            case 123: {
                n = 91;
                break;
            }
            case 51: 
            case 147: {
                n = 92;
                break;
            }
            case 58: 
            case 61: 
            case 111: 
            case 187: 
            case 188: {
                n = 93;
                break;
            }
            case 34: 
            case 37: 
            case 45: {
                n = -4;
                break;
            }
            case 35: 
            case 174: {
                n = -1;
                break;
            }
            case 175: 
            case 225: {
                n = 1;
                break;
            }
            default: {
                switch (this._usertype) {
                    case 34: 
                    case 35: {
                        n = -1;
                        break block0;
                    }
                    case 24: {
                        n = 1;
                        break block0;
                    }
                    case 25: {
                        n = 12;
                    }
                }
            }
        }
        return n;
    }

    public String getTableName() {
        return this._tableName;
    }

    public String getDbName() {
        return this._dbName;
    }

    protected void bcpInit() throws SQLException, IOException {
        SQLException sQLException;
        if (this._enableBCP == 3 && !this._sybStmt._context._conn.getAutoCommit()) {
            ErrorMessage.raiseError("JZBK5");
        }
        this._sybStmt.getProtocol().checkAndStartExplicitTransaction();
        StringBuffer stringBuffer = new StringBuffer();
        if (this._userDefinedIdentity) {
            stringBuffer.append("set identity_insert ").append(this._dbName);
            stringBuffer.append(this._tableOwner != null ? "." + this._tableOwner : ".");
            stringBuffer.append(".").append(this.getTableName()).append(" on ");
        }
        if (this._setValuesAsCiphertext && this._encrypted) {
            stringBuffer.append("set ciphertext on ");
        }
        stringBuffer.append(" insert bulk ").append(this._dbName);
        stringBuffer.append(this._tableOwner != null ? "." + this._tableOwner : ".");
        stringBuffer.append(".").append(this.getTableName()).append(" with nodescribe");
        if (this._enableBCP != 3) {
            stringBuffer.append(" ,arrayinsert");
        }
        if ((sQLException = this._sybStmt.getProtocol().initBCP(this, stringBuffer.toString(), this._enableBCP)) != null) {
            this._sybStmt.handleSQLE(sQLException);
        }
    }

    public SybPreparedStatement getStatement() {
        return this._sybStmt;
    }

    public boolean getNullableDatatype(int n) {
        switch (n) {
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 174: 
            case 225: {
                return true;
            }
        }
        return false;
    }

    public void getColumnMetaDataAll(int n, int n2) {
        this._columnId = this._intTypeMetadata[0 + n];
        this._datatype = this._intTypeMetadata[1 + n];
        this._usertype = this._intTypeMetadata[2 + n];
        this._columnLength = this._intTypeMetadata[3 + n];
        this._precision = this._intTypeMetadata[4 + n];
        this._scale = this._intTypeMetadata[5 + n];
        this._isColumnNull = this._intTypeMetadata[6 + n];
        this._identityCol = this._intTypeMetadata[7 + n];
        this._sqlType = this._intTypeMetadata[8 + n];
        this._columnName = this._stringTypeMetadata[0 + n2];
        this._columnDefault = this._stringTypeMetadata[1 + n2];
        this._encryptedCol = this._intTypeMetadata[14 + n];
    }

    public int getColumnId() {
        return this._columnId;
    }

    public String getColumnName() {
        return this._columnName;
    }

    public int getDatatype() {
        return this._datatype;
    }

    public int getUsertype() {
        return this._usertype;
    }

    public int getColumnLength() {
        return this._columnLength;
    }

    public int getPrecision() {
        return this._precision;
    }

    public int getScale() {
        return this._scale;
    }

    public int isColumnNull() {
        return this._isColumnNull;
    }

    public String checkColumnDefault() {
        if (this._columnDefault == null) {
            return this._columnDefault;
        }
        this._columnDefault = this._columnDefault.trim();
        if (!this.isDateType()) {
            int n = this._columnDefault.indexOf("'");
            if (n != -1) {
                this._columnDefault = this._columnDefault.substring(n + 1, this._columnDefault.lastIndexOf("'"));
            } else {
                n = this._columnDefault.indexOf("\"");
                if (n != -1) {
                    this._columnDefault = this._columnDefault.substring(n + 1, this._columnDefault.lastIndexOf("\""));
                } else {
                    this._columnDefault = this._columnDefault.substring(this._columnDefault.lastIndexOf(32) + 1);
                    this.checkDefaultFunction();
                }
            }
        }
        return this._columnDefault;
    }

    private boolean isDateType() {
        int n;
        String string = null;
        switch (this._datatype) {
            case 61: {
                string = "datetime";
                break;
            }
            case 111: {
                string = "datetime";
                break;
            }
            case 188: {
                string = "bigtime";
                break;
            }
            case 187: {
                string = "bigdatetime";
                break;
            }
            default: {
                return false;
            }
        }
        if (this._columnDefault.contains("\"")) {
            this._columnDefault = this._columnDefault.replace("\"", "'");
        }
        if ((n = this._columnDefault.indexOf(39)) != -1) {
            this._columnDefault = this._columnDefault.substring(n);
        } else {
            int n2 = this._columnDefault.lastIndexOf(32);
            if (n2 != -1) {
                this._columnDefault = this._columnDefault.substring(n2 + 1);
            }
        }
        if (this._functionStr == null) {
            this._functionStr = "";
        }
        this._functionStr = this._functionStr + " select convert(" + string + ", " + this._columnDefault + ")";
        this._columnDefault = "SYBASEFUNCTION";
        return true;
    }

    public String getColumnDefault() {
        return this._columnDefault;
    }

    public int getIdentityColumn() {
        if (this._userDefinedIdentity && this._identityCol == 1) {
            this._identityCol = 0;
        }
        return this._identityCol;
    }

    public int getTableLockScheme() {
        return this._table_lock_scheme;
    }

    public int getSQLType() {
        return this._sqlType;
    }

    public int getPageSize() {
        return this._pageSize;
    }

    protected Param findDefaults(Param param, int n) throws SQLException {
        if (this._columnDefination.size() == 0) {
            if (this.getColumnId() == this._colId[n]) {
                param = this.setDefaults(param, this.getDatatype(), this.getColumnLength());
            }
        } else {
            param = this.setDefaults(param, this.getDatatype(), this.getColumnLength());
        }
        this._objectDefaults[n] = param._inValue;
        this._typesDefaults[n] = param._sqlType;
        this._scaleDefaults[n] = param._scale;
        return param;
    }

    public Object getObjectDefaults(int n) {
        return this._objectDefaults[n];
    }

    public int getTypesDefaults(int n) {
        return this._typesDefaults[n];
    }

    public int getScaleDefaults(int n) {
        return this._scaleDefaults[n];
    }

    protected Param setDefaults(Param param, int n, int n2) throws SQLException {
        Object object = null;
        switch (n) {
            case 35: 
            case 39: 
            case 47: 
            case 175: {
                object = new String(this.getColumnDefault());
                break;
            }
            case 48: 
            case 50: 
            case 52: 
            case 56: 
            case 65: {
                object = new Integer(this.getColumnDefault());
                break;
            }
            case 66: {
                object = new Long(this.getColumnDefault());
                break;
            }
            case 67: {
                object = new BigDecimal(this.getColumnDefault());
                break;
            }
            case 191: {
                object = new BigInteger(this.getColumnDefault());
                break;
            }
            case 38: 
            case 68: {
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 4: {
                        if (n == 68) {
                            object = new Long(this.getColumnDefault());
                            break;
                        }
                        object = new Integer(this.getColumnDefault());
                        break;
                    }
                    case 8: {
                        object = n == 68 ? new BigDecimal(this.getColumnDefault()) : new BigInteger(this.getColumnDefault());
                    }
                }
                break;
            }
            case 59: {
                object = Convert.objectToFloat(this.getColumnDefault());
                break;
            }
            case 62: {
                object = Convert.objectToDouble(this.getColumnDefault());
                break;
            }
            case 109: {
                switch (n2) {
                    case 4: {
                        object = Convert.objectToFloat(this.getColumnDefault());
                        break;
                    }
                    case 8: {
                        object = Convert.objectToDouble(this.getColumnDefault());
                    }
                }
                break;
            }
            case 60: 
            case 63: 
            case 108: 
            case 110: {
                if (this.getIdentityColumn() != 0) break;
                object = new BigDecimal(this.getColumnDefault());
                break;
            }
            case 51: 
            case 147: {
                object = Time.valueOf(this._columnDefault.substring(11, 19));
                object = new DateObject(object);
                break;
            }
            case 49: 
            case 58: 
            case 123: {
                object = Date.valueOf(this._columnDefault.substring(0, 10));
                object = new DateObject(object);
                break;
            }
            case 61: 
            case 111: 
            case 187: 
            case 188: {
                object = Timestamp.valueOf(this.getColumnDefault());
                object = new DateObject(object);
                break;
            }
            case 45: {
                object = Convert.objectToBytes(this.getColumnDefault());
            }
        }
        param._inValue = object;
        param._sqlType = this.getSQLType();
        return param;
    }

    public int bcpDone() throws IOException, SQLException {
        Statement statement = null;
        int n = 0;
        if (this._enableBCP >= 2) {
            n = this._sybStmt.getProtocol().flushBCP(true, true);
        }
        if (this._userDefinedIdentity) {
            StringBuffer stringBuffer = new StringBuffer("");
            stringBuffer.append("set identity_insert ").append(this.getDbName());
            stringBuffer.append(this._tableOwner != null ? "." + this._tableOwner : ".");
            stringBuffer.append(".").append(this.getTableName()).append(" off ");
            statement = this._sybStmt._context._conn.createStatement();
            statement.execute(stringBuffer.toString());
        }
        if (this._setValuesAsCiphertext && this._encrypted) {
            statement = this._sybStmt._context._conn.createStatement();
            statement.execute("set ciphertext off ");
        }
        return n;
    }

    private void bcpSendCommon() throws SQLException, IOException {
        this._numberVarColumnSAVE = this._numberVarColumns;
        if (!this._bcpInitialized) {
            this.bcpInit();
            this._bcpInitialized = true;
        }
    }

    protected int bcpSendRow(Object[] objectArray, int[] nArray, int[] nArray2, Calendar[] calendarArray) throws SQLException, IOException {
        int n = 0;
        try {
            this.bcpSendCommon();
            n = this._sybStmt.getProtocol().sendBulkData(objectArray, nArray, nArray2, calendarArray);
        }
        catch (SQLException sQLException) {
            this._sybStmt.getProtocol().flushBCP(false, false);
            this._sybStmt.handleSQLE(sQLException);
        }
        return n;
    }

    protected int bcpSendRow(LinkedList<Object[]> linkedList, LinkedList<int[]> linkedList2, LinkedList<int[]> linkedList3, LinkedList<Calendar[]> linkedList4) throws SQLException, IOException {
        int n = 0;
        try {
            this.bcpSendCommon();
            n = this._sybStmt.getProtocol().sendBulkData(linkedList, linkedList2, linkedList3, linkedList4);
        }
        catch (SQLException sQLException) {
            this._sybStmt.getProtocol().flushBCP(false, false);
            this._sybStmt.handleSQLE(sQLException);
        }
        return n;
    }

    public int getColumnCount() {
        return this._columnCount;
    }

    public int getFixedColumnLengthTotal() {
        return this._fixedColLenTotal;
    }

    public void resetNumberVarColumns() {
        this._numberVarColumns = this._numberVarColumnSAVE;
    }

    public int getNumberVarColumns() {
        return this._numberVarColumns;
    }

    public void setNumberVarColumns(int n) {
        this._numberVarColumns = n;
    }

    public int[] getIntMDA() {
        return this._intTypeMetadata;
    }

    public String[] getStrMDA() {
        return this._stringTypeMetadata;
    }

    public boolean isLastColumnText() {
        if (this.getTableLockScheme() == 0) {
            this._isLastColText = false;
        }
        return this._isLastColText;
    }

    private void setUniDataType() {
        if (this._usertype == 34 && this._isColumnNull == 0) {
            this._datatype = 47;
        } else if (this._usertype == 35 || this._usertype == 34 && this._isColumnNull == 1) {
            this._datatype = 39;
        }
    }

    public int getMaxRowLength() {
        return this._maxRowLength;
    }

    public int getTextImageCount() {
        return this._textimageCount;
    }

    protected void resetBCPInit() {
        this._bcpInitialized = false;
    }

    public boolean getUserDefinedIdentity() {
        return this._userDefinedIdentity;
    }

    public boolean wideRowDOLSupported() {
        return this._wideDOLSupported;
    }

    public int getInRowLobCount() {
        return this._inRowLobCount;
    }

    public boolean isOldMdaInUse() {
        return this._oldMdaInUse;
    }

    public boolean hasDroppedColumns() {
        return this._hasDroppedColumn;
    }

    public int getDroppedColumnCountBeforeColumnIndex(int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this._droppedColumns[i]) continue;
            ++n2;
        }
        return n2;
    }

    public int getEncryptedColumn() {
        if (this._encrypted && this._encryptedCol == 1) {
            this._encryptedCol = 0;
        }
        return this._encryptedCol;
    }

    public void setEncrypted() {
        if (this.getEncryptedColumn() == 1) {
            this._encrypted = true;
        }
    }
}

