/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.jdbc;

import com.sybase.jdbc4.IConstants;
import com.sybase.jdbc4.jdbc.Dialect;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.MdaManager;
import com.sybase.jdbc4.jdbc.Param;
import com.sybase.jdbc4.jdbc.Protocol;
import com.sybase.jdbc4.jdbc.ProtocolContext;
import com.sybase.jdbc4.jdbc.SybBinaryClientLob;
import com.sybase.jdbc4.jdbc.SybCallableStatement;
import com.sybase.jdbc4.jdbc.SybCallableStatementCopy;
import com.sybase.jdbc4.jdbc.SybCharClientLob;
import com.sybase.jdbc4.jdbc.SybDatabaseMetaData;
import com.sybase.jdbc4.jdbc.SybLob;
import com.sybase.jdbc4.jdbc.SybPreparedStatement;
import com.sybase.jdbc4.jdbc.SybPreparedStatementBulkWithRTrim;
import com.sybase.jdbc4.jdbc.SybPreparedStatementCopy;
import com.sybase.jdbc4.jdbc.SybProperty;
import com.sybase.jdbc4.jdbc.SybResultSet;
import com.sybase.jdbc4.jdbc.SybSQLException;
import com.sybase.jdbc4.jdbc.SybSavepoint;
import com.sybase.jdbc4.jdbc.SybStatement;
import com.sybase.jdbc4.jdbc.SybUrlProvider;
import com.sybase.jdbc4.tds.SecLoginContext;
import com.sybase.jdbc4.tds.Tds;
import com.sybase.jdbc4.tds.TdsConst;
import com.sybase.jdbc4.utils.CacheManager;
import com.sybase.jdbc4.utils.LogUtil;
import com.sybase.jdbc4.utils.SybInputPassword;
import com.sybase.jdbcx.Capture;
import com.sybase.jdbcx.EedInfo;
import com.sybase.jdbcx.SybEventHandler;
import com.sybase.jdbcx.SybMessageHandler;
import java.io.IOException;
import java.net.SocketException;
import java.security.Provider;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;

public class SybConnection
implements com.sybase.jdbcx.SybConnection {
    private static final int RECURSION_DEPTH = 25;
    private static final Logger LOG = Logger.getLogger(SybConnection.class.getName());
    private AtomicLong _apiCount = new AtomicLong(0L);
    private static volatile long _logIdCounter = 0L;
    protected String _logId = null;
    static final int TRANSACTION_NONE = 0;
    static final int TRANSACTION_READ_UNCOMMITTED = 1;
    static final int TRANSACTION_READ_COMMITTED = 2;
    static final int TRANSACTION_REPEATABLE_READ = 4;
    static final int TRANSACTION_SERIALIZABLE = 8;
    static final String HADR_CURRENT_STATE = "HADR_CURRENT_STATE";
    private MdaManager _mda = null;
    protected SybDatabaseMetaData _sybDBMD = null;
    private SQLWarning _warning = null;
    protected Protocol _protocol;
    protected ProtocolContext _pc;
    private ProtocolContext _sharedPc;
    private CacheManager _sharedCm;
    protected SybProperty _props;
    protected boolean _dynamicPrepare;
    protected String _dbName;
    protected String _dbProductName;
    protected String _dbProductVersion;
    protected String _url = null;
    private int _loginTimeout;
    private long _loginStartTime;
    private IConstants.CONNECTION_STATE _state = IConstants.CONNECTION_STATE.NEW;
    private int _dynStmtNum = 100;
    private Hashtable<String, ResultSet> _cursors;
    private Vector<String> _hostPortList = null;
    private Vector<String> _secondaryHostPortList = null;
    private int _haLoginStatus = 0;
    private int _haState = -1;
    private boolean _wasConnected = false;
    private String _currentHostPort;
    private boolean _inClose = false;
    private boolean _duringConnect = false;
    private Capture _capture = null;
    boolean _batchSBPIInitialized = false;
    private Vector<SybSavepoint> _savepoints = null;
    private int _savepointId = 1;
    private int _defaultQueryTimeout = 0;
    private int _internalQueryTimeout = 0;
    protected Vector<SybStatement> _stmtList = null;
    protected int _rsHoldability;
    private Properties _clientInfoProperties = new Properties();
    protected Blob _nullBlob = null;
    protected Clob _nullClob = null;
    protected NClob _nullNClob = null;
    private int _tranIsolationLevel = -1;
    private Boolean _readOnly = null;
    private TdsConst.HADR_STATE _hadrState = TdsConst.HADR_STATE.ACTIVE;
    private Boolean _isClosedTestInternal = null;
    private CallableStatement _csIsClosed = null;
    private PreparedStatement _pstmtIsClosed = null;
    private int _recursionDepth = 0;
    private Dialect _dialect = Dialect.TSQL;
    private boolean _isDialectSupported = false;
    private boolean _isDataTypeInfoCached = false;
    protected boolean _encryptCommand;
    private SecLoginContext _secLoginContext;

    public SybConnection(String string, SybUrlProvider sybUrlProvider, String string2) throws SQLException {
        this(string, sybUrlProvider, string2, DriverManager.getLoginTimeout());
    }

    protected SybConnection(String string, SybUrlProvider sybUrlProvider, String string2, int n) throws SQLException {
        this._logId = string + "_Co" + _logIdCounter++;
        this._url = string2;
        this._protocol = sybUrlProvider.getProtocol();
        this._props = sybUrlProvider.getSybProperty();
        this._hostPortList = sybUrlProvider.getHostPortList();
        this._dbName = sybUrlProvider.getDatabaseName();
        this._dynamicPrepare = this.isPropertySet(25);
        this._loginTimeout = n;
        this._haState = -1;
        this._duringConnect = true;
        this._savepoints = new Vector();
        this._defaultQueryTimeout = this._props.getInteger(62);
        this._internalQueryTimeout = this._props.getInteger(61);
        this._stmtList = new Vector();
        this._rsHoldability = 1;
        if (this.isPropertySet(100)) {
            this._props.setProperty(31, "com.sybase.jdbc4.jdbc.SybSSLSocketFactory");
        }
        this._props.setProperty(71, this._props.getBoolean(98));
        try {
            boolean bl;
            String string3 = this._props.getString(96);
            boolean bl2 = bl = string3 != null && string3.equalsIgnoreCase("RECONNECT");
            if (bl) {
                this._props.setProperty(34, "true");
            }
            if (this.isPropertySet(34)) {
                String string4 = this._props.getString(45);
                if (string4 != null) {
                    this._secondaryHostPortList = new Vector();
                    this._secondaryHostPortList.addElement(string4);
                } else {
                    this._secondaryHostPortList = sybUrlProvider.getSecondaryHostPortList();
                }
                this.setHALoginStatus(1);
                this.handleHAFailover();
                if ((this._secondaryHostPortList == null || this._secondaryHostPortList.size() == 0) && this._haState != 8) {
                    ErrorMessage.raiseError("JZ0F1");
                }
            } else if (this.isPropertySet(72)) {
                this.setHALoginStatus(0);
                this.handleHAFailover();
            } else {
                this.regularConnect();
            }
        }
        catch (SQLException sQLException) {
            this._protocol.abort();
            throw sQLException;
        }
        finally {
            this._duringConnect = false;
        }
    }

    private void regularConnect() throws SQLException {
        if (this._dynamicPrepare && this.isPropertySet(15)) {
            this.handleSQLE(ErrorMessage.createWarning("010PO"));
        }
        this.tryLogin(this._hostPortList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryLogin(Vector<String> vector) throws SQLException {
        String string;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = this.isPropertySet(26);
        if (this._haState == 9) {
            bl2 = false;
        }
        int n = 200;
        int n2 = 1;
        int n3 = 0;
        boolean bl4 = false;
        int n4 = this._props.getInteger(110);
        int n5 = this._props.getInteger(109);
        int n6 = this._props.getInteger(111);
        Enumeration<String> enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this._loginStartTime = System.currentTimeMillis();
            try {
                String string2;
                this._currentHostPort = string2 = enumeration.nextElement();
                bl = this._props.getBoolean(76);
                if (bl) {
                    this._props.setProperty(76, false);
                }
                if (this._props.getBoolean(34)) {
                    this.clearWarnings();
                    if (bl4) {
                        try {
                            if (n4 > 0) {
                                n4 -= n6;
                            } else {
                                int n7 = n - n3;
                                n6 = n5 / n7;
                            }
                            Thread.sleep(n6 * 1000);
                            ++n3;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                this._protocol.login(string2, this._props, this, true);
                Object object = this._props.getObject(66);
                boolean bl5 = this._props.getBoolean(104);
                string = null;
                if (!bl5 || object == null) break;
                if (object instanceof Provider) {
                    string = ((Provider)object).getName();
                } else if (object instanceof String) {
                    string = (String)object;
                }
                if (string.equals("com.rsa.jsafe.provider.JsafeJCE")) break;
                ErrorMessage.raiseWarning("010FI", string);
                break;
            }
            catch (SQLWarning sQLWarning) {
                this.chainWarnings(sQLWarning);
                break;
            }
            catch (SQLException sQLException) {
                if (this._protocol.getRedirectImmed()) {
                    if (this._protocol.isHADRSupported() && this._props.getBoolean(34)) {
                        if (++n2 > vector.size()) {
                            bl4 = true;
                        }
                    } else {
                        this._haLoginStatus &= 0xFFFFFFF7;
                    }
                    this._hostPortList = this._protocol.getRedirectionHostPort();
                    enumeration = this._hostPortList.elements();
                    this._protocol.setRedirectImmed(false);
                }
                if (bl3 && enumeration.hasMoreElements()) {
                    this.chainWarnings(sQLException);
                    try {
                        ErrorMessage.raiseWarning("010SQ");
                    }
                    catch (SQLWarning sQLWarning) {
                        this.chainWarnings(sQLWarning);
                    }
                    continue;
                }
                if (bl3 && "JZ00L".equals(sQLException.getSQLState()) && sQLException.getNextException() != null && sQLException.getNextException().getErrorCode() == 9668) {
                    this.markDead(false);
                    this.handleSQLE(sQLException);
                    continue;
                }
                if (this.isPropertySet(34) && this.getHAState() == 10 || this.isPropertySet(72) && this.getHAState() == 9) {
                    this.markDead(false);
                    this.handleSQLE(sQLException);
                    continue;
                }
                if (this.isPropertySet(34) && ("JZ006".equals(sQLException.getSQLState()) || "JZ00L".equals(sQLException.getSQLState()) || "JZ00M".equals(sQLException.getSQLState())) && this.getHAState() != 1 && this.getHAState() != 6) {
                    this.handleHAFailover();
                    bl2 = false;
                    break;
                }
                if ("JZ0F2".equals(sQLException.getSQLState())) {
                    this.handleSQLE(sQLException);
                    continue;
                }
                this.markDead(false);
                this.handleSQLE(sQLException);
            }
            finally {
                if (!bl) continue;
                this._props.setProperty(76, bl);
            }
        }
        if (bl2) {
            this._state = IConstants.CONNECTION_STATE.IDLE;
            this._encryptCommand = this._props.getBoolean(113) && this._protocol.isOnDemandEncryptionSupported();
            this._pc = this.initProtocol();
            long l = this.getLoginTimeRemaining();
            if (l < 0L) {
                ErrorMessage.raiseError("JZ00M");
            }
            try {
                if (this._warning != null && "01ZZZ".equals(this._warning.getSQLState()) && this._warning.getErrorCode() == 4022) {
                    try {
                        CallableStatement callableStatement = this.prepareCall("{call sp_password(?,?)}");
                        string = this._props.getString(4);
                        String string3 = this._props.getString(69);
                        if (this._props.getBoolean(70)) {
                            SybInputPassword sybInputPassword = new SybInputPassword(string, string3);
                            char[] cArray = sybInputPassword.getNewCred();
                            string = String.valueOf(sybInputPassword.getOldCred());
                            if (cArray != null) {
                                string3 = sybInputPassword.isChangeCancelled() ? null : String.valueOf(cArray);
                                Arrays.fill(cArray, '0');
                            }
                        } else {
                            string3 = this._props.getString(69);
                        }
                        if (string3 != null) {
                            callableStatement.setString(1, string);
                            callableStatement.setString(2, string3);
                            callableStatement.executeUpdate();
                            this._props.setProperty(4, string3);
                            this._props.setProperty(69, null);
                            this._warning = null;
                        } else {
                            ErrorMessage.raiseError("01ZZZ", this._warning.getErrorCode());
                        }
                    }
                    catch (SQLException sQLException) {
                        this.handleSQLE(sQLException);
                    }
                }
                this.init();
            }
            catch (SQLWarning sQLWarning) {
                this.chainWarnings(sQLWarning);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void init() throws SQLException {
        var1_1 = null;
        var2_2 = this._props;
        var3_3 = this._dbName;
        var4_4 = false;
        if (var2_2.getBoolean(6)) {
            try {
                this.checkMDA(this._pc);
                this.determineCharset();
                var4_4 = true;
                this._protocol.setOption(null, 11, false);
                if (this._props.getInteger(107) != -1) {
                    this._protocol.setOption(null, 52, this._props.getInteger(107));
                }
                if (var3_3 == null || var3_3.length() <= 0) ** GOTO lbl92
                try {
                    this.setCatalog(var3_3);
                }
                catch (SQLException var5_5) {
                    this.checkForHAException(var5_5);
                    this.handleSQLE(ErrorMessage.createWarning("010DF", var5_5.getMessage()));
                }
            }
            catch (Exception var5_6) {
                this.checkForHAException(var5_6);
                this.checkForHADRFailure(var5_6);
                this.checkUnsupportedCharsetException(var5_6);
                this.checkForLoginTimeout(var5_6);
                if (!var4_4) {
                    try {
                        this.determineCharset();
                    }
                    catch (SQLException var6_8) {
                        this.checkUnsupportedCharsetException(var6_8);
                        this.checkForHAException(var6_8);
                    }
                }
                try {
                    ErrorMessage.raiseWarning("010MX", var5_6.toString());
                }
                catch (SQLWarning var6_9) {
                    var7_21 = null;
                    try {
                        if (var3_3 == null || var3_3.length() <= 0) ** GOTO lbl92
                        var7_21 = this.prepareInternalStatement("use ?");
                        var7_21.setString(1, var3_3);
                        var7_21.executeUpdate();
                    }
                    catch (SQLException var8_24) {
                        this.checkForHAException(var8_24);
                        this.handleSQLE(ErrorMessage.createWarning("010UF", var8_24.getMessage()));
                    }
                    finally {
                        if (var7_21 != null) {
                            try {
                                var7_21.close();
                                var7_21 = null;
                            }
                            catch (SQLException var8_25) {
                                var7_21 = null;
                                this.handleSQLE(var8_25);
                            }
                            catch (RuntimeException var8_26) {
                                var7_21 = null;
                                throw var8_26;
                            }
                        }
                        this.handleSQLE(var6_9);
                    }
                }
            }
        } else {
            this.determineCharset();
            var5_7 = null;
            try {
                if (var3_3 != null && var3_3.length() > 0) {
                    var5_7 = this.prepareInternalStatement("use ?");
                    var5_7.setString(1, var3_3);
                    var5_7.executeUpdate();
                }
            }
            catch (SQLException var6_13) {
                this.checkForHAException(var6_13);
                this.handleSQLE(ErrorMessage.createWarning("010SK", var6_13.getMessage()));
            }
            finally {
                if (var5_7 != null) {
                    try {
                        var5_7.close();
                        var5_7 = null;
                    }
                    catch (SQLException var6_14) {
                        var5_7 = null;
                        this.handleSQLE(var6_14);
                    }
                    catch (RuntimeException var6_15) {
                        var5_7 = null;
                        throw var6_15;
                    }
                }
            }
        }
        var5_7 = var2_2.getString(18);
        if (var5_7 != null && var5_7.length() > 0) {
            try {
                var1_1 = this.createInternalStatement();
                var1_1.executeUpdate((String)var5_7);
            }
            catch (SQLException var6_18) {
                this.handleSQLE(var6_18);
            }
            finally {
                if (var1_1 != null) {
                    try {
                        var1_1.close();
                        var1_1 = null;
                    }
                    catch (SQLException var6_19) {
                        var1_1 = null;
                        this.handleSQLE(var6_19);
                    }
                    catch (RuntimeException var6_20) {
                        var1_1 = null;
                        throw var6_20;
                    }
                }
            }
        }
        this._state = IConstants.CONNECTION_STATE.NEW;
        var6_10 = (String[])this._props.getObject(38);
        if (var6_10 != null) {
            var7_21 = this._protocol.getClassLoader();
            if (var7_21 == null) {
                ErrorMessage.raiseError("JZ0CL");
            } else {
                try {
                    var7_21.preloadJars(var6_10);
                }
                catch (SQLException var8_28) {
                    this.chainWarnings(var8_28);
                    try {
                        ErrorMessage.raiseWarning("010PF");
                    }
                    catch (SQLWarning var9_30) {
                        this.chainWarnings(var9_30);
                    }
                }
            }
        }
        this.resetNullLobs();
        if (!this._isDataTypeInfoCached) {
            this.cacheDataTypeInfo();
        }
        this._isDataTypeInfoCached = false;
    }

    private void checkForHADRFailure(Exception exception) throws SQLException {
        int n;
        if (exception instanceof SQLException && ((n = ((SQLException)exception).getErrorCode()) == TdsConst.HADR_STATE.DEACTIVATING.getState() || n == TdsConst.HADR_STATE.DEACTIVATED.getState())) {
            if (this._state == IConstants.CONNECTION_STATE.INITIALIZING) {
                this._state = IConstants.CONNECTION_STATE.UNINITIALIZED;
                throw (SQLException)exception;
            }
            this._state = IConstants.CONNECTION_STATE.UNINITIALIZED;
            if (this._wasConnected) {
                this._haState = 8;
                ErrorMessage.raiseError("JZ0F2", (SQLException)exception);
            } else {
                ErrorMessage.raiseWarning("010DF", exception.getMessage());
            }
        }
    }

    private boolean isSurrogateProcessingDisabled() throws SQLException {
        boolean bl = false;
        Statement statement = this.createInternalStatement();
        ResultSet resultSet = statement.executeQuery("select value2 from master.dbo.syscurconfigs where config = (select config from master.dbo.sysconfigures where name='enable surrogate processing' and parent != 19 and config != 19)");
        if (resultSet.next()) {
            bl = resultSet.getInt(1) == 1;
        }
        resultSet.close();
        statement.close();
        resultSet = null;
        statement = null;
        return bl;
    }

    private void cacheDataTypeInfo() {
        if (this._mda != null) {
            try {
                CallableStatement callableStatement = (CallableStatement)this._mda.getMetaDataAccessor("COLUMNTYPENAMES", this._pc);
                callableStatement.setInt(1, 0);
                callableStatement.setInt(2, 0);
                callableStatement.setInt(3, 1);
                SybResultSet sybResultSet = (SybResultSet)callableStatement.executeQuery();
                while (sybResultSet.next()) {
                    this._protocol.cacheSystemDataTypeInfo(sybResultSet.getString(1), sybResultSet.getInt(2), sybResultSet.getInt(3));
                }
                sybResultSet.close();
                callableStatement.close();
                SybDatabaseMetaData sybDatabaseMetaData = (SybDatabaseMetaData)this.getMetaData();
                sybDatabaseMetaData.isCaseSensitive();
                if (this._props.getBoolean(103)) {
                    ((Tds)this._protocol).isTypeSearchable(1);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private boolean isSurrogateProcessingDisabledOnServer() throws SQLException {
        if (!this._props.getBoolean(6)) {
            return this.isSurrogateProcessingDisabled();
        }
        boolean bl = false;
        if (this._mda != null) {
            try {
                PreparedStatement preparedStatement = this._mda.getMetaDataAccessor("SURROGATEPROCESS", this._pc);
                SybResultSet sybResultSet = (SybResultSet)preparedStatement.executeQuery();
                if (sybResultSet.next()) {
                    bl = sybResultSet.getInt(1) == 0;
                }
                sybResultSet.close();
                preparedStatement.close();
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equals("JZ0SJ")) {
                    return this.isSurrogateProcessingDisabled();
                }
                throw sQLException;
            }
        }
        return bl;
    }

    public boolean okToThrowLoginTimeoutException() {
        switch (this._haState) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                return false;
            }
        }
        return this._duringConnect;
    }

    public int getLoginTimeout() {
        return this._loginTimeout;
    }

    protected long getLoginTimeRemaining() {
        int n = this._loginTimeout * 1000;
        if (n == 0) {
            return 0L;
        }
        long l = 0L;
        switch (this._haState) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                return 0L;
            }
        }
        l = (long)n - (System.currentTimeMillis() - this._loginStartTime);
        if (l == 0L) {
            l = -1L;
        }
        return l;
    }

    private void determineCharset() throws SQLException {
        String string;
        String string2 = this._props.getString(8);
        if (string2 == null) {
            string2 = this.getDefaultServerCharset();
            if (string2 == null) {
                string2 = "ascii_7";
                try {
                    ErrorMessage.raiseWarning("010TQ");
                }
                catch (SQLException sQLException) {
                    this.handleSQLE(sQLException);
                }
            }
            this._protocol.setOption(null, 6, string2);
        }
        if (string2.equalsIgnoreCase("utf8") && this._protocol.isAse() && this.isSurrogateProcessingDisabledOnServer() && (string = this._props.getString(77)) == null) {
            this._props.setProperty(77, "x-SybUTF8");
            this._protocol.setOption(null, 6, string2);
        }
    }

    public void checkForHAException(Exception exception) throws SQLException {
        SQLException sQLException;
        if (exception instanceof SQLException && "JZ0F2".equals((sQLException = (SQLException)exception).getSQLState())) {
            throw sQLException;
        }
    }

    public void checkForLoginTimeout(Exception exception) throws SQLException {
        boolean bl = false;
        SQLException sQLException = null;
        if (exception instanceof SQLException) {
            for (sQLException = (SQLException)exception; sQLException != null; sQLException = sQLException.getNextException()) {
                if (!"JZ00M".equals(sQLException.getSQLState())) continue;
                bl = true;
                try {
                    this.close();
                }
                catch (SQLException sQLException2) {}
                break;
            }
            if (bl) {
                throw sQLException;
            }
        }
    }

    public void checkUnsupportedCharsetException(Exception exception) throws SQLException {
        boolean bl = false;
        SQLException sQLException = null;
        if (exception instanceof SQLException) {
            for (sQLException = (SQLException)exception; sQLException != null; sQLException = sQLException.getNextException()) {
                if (!"JZ0IB".equals(sQLException.getSQLState())) continue;
                bl = true;
                try {
                    this.close();
                }
                catch (SQLException sQLException2) {}
                break;
            }
            if (bl) {
                throw sQLException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement() throws SQLException {
        SybStatement sybStatement;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            SybStatement sybStatement2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                this.checkConnection();
                sybStatement2 = new SybStatement(this._logId, this.initProtocol());
                sybStatement2.setQueryTimeout(this._defaultQueryTimeout);
                sybStatement2.setResultSetHoldability(this._rsHoldability);
                sybStatement = sybStatement2;
                if (!bl) break block4;
                LogUtil.logEnd(LOG, "Statement", sybStatement2 != null ? sybStatement2._logId : "_", this._logId, "createStatement", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, "Statement", sybStatement2 != null ? sybStatement2._logId : "_", this._logId, "createStatement", null, null, l);
                }
                throw throwable;
            }
        }
        return sybStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string) throws SQLException {
        SybPreparedStatement sybPreparedStatement;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            SybPreparedStatement sybPreparedStatement2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                sybPreparedStatement = sybPreparedStatement2 = (SybPreparedStatement)this.prepareStatement(string, 2);
                if (!bl) break block4;
                LogUtil.logEnd(LOG, "PreparedStatement", sybPreparedStatement2 != null ? sybPreparedStatement2._logId : "_", this._logId, "prepareStatement", "String", new Object[]{string}, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, "PreparedStatement", sybPreparedStatement2 != null ? sybPreparedStatement2._logId : "_", this._logId, "prepareStatement", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
        }
        return sybPreparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        SybPreparedStatement sybPreparedStatement;
        block8: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            SybPreparedStatement sybPreparedStatement2 = null;
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                sybPreparedStatement = sybPreparedStatement2 = (SybPreparedStatement)this.prepareStatement(string, this._dynamicPrepare, n);
                if (!bl) break block8;
                LogUtil.logEnd(LOG, "PreparedStatement", sybPreparedStatement2 != null ? sybPreparedStatement2._logId : "_", this._logId, "prepareStatement", "String, int", new Object[]{string, n}, l);
            }
            catch (SQLException sQLException) {
                block9: {
                    SybPreparedStatement sybPreparedStatement3;
                    block10: {
                        try {
                            if ("JZ0F2".equals(sQLException.getSQLState())) {
                                throw sQLException;
                            }
                            if (!this._dynamicPrepare || this.isPropertySet(108)) break block9;
                            sybPreparedStatement3 = sybPreparedStatement2 = (SybPreparedStatement)this.prepareStatement(string, false, n);
                            if (!bl) break block10;
                            LogUtil.logEnd(LOG, "PreparedStatement", sybPreparedStatement2 != null ? sybPreparedStatement2._logId : "_", this._logId, "prepareStatement", "String, int", new Object[]{string, n}, l);
                        }
                        catch (Throwable throwable) {
                            if (bl) {
                                LogUtil.logEnd(LOG, "PreparedStatement", sybPreparedStatement2 != null ? sybPreparedStatement2._logId : "_", this._logId, "prepareStatement", "String, int", new Object[]{string, n}, l);
                            }
                            throw throwable;
                        }
                    }
                    return sybPreparedStatement3;
                }
                throw sQLException;
            }
        }
        return sybPreparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        SybPreparedStatement sybPreparedStatement;
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        SybPreparedStatement sybPreparedStatement2 = null;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (nArray == null || nArray.length != 1) {
                ErrorMessage.raiseError("JZ0GK", "columnIndexes");
            }
            sybPreparedStatement = sybPreparedStatement2 = (SybPreparedStatement)this.prepareStatement(string, 1);
            LogUtil.logEnd(LOG, "PreparedStatement", sybPreparedStatement2 != null ? sybPreparedStatement2._logId : "_", this._logId, "prepareStatement", "String, int[]", new Object[]{string, nArray}, l);
        }
        catch (Throwable throwable) {
            LogUtil.logEnd(LOG, "PreparedStatement", sybPreparedStatement2 != null ? sybPreparedStatement2._logId : "_", this._logId, "prepareStatement", "String, int[]", new Object[]{string, nArray}, l);
            throw throwable;
        }
        return sybPreparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        SybPreparedStatement sybPreparedStatement;
        block5: {
            SybPreparedStatement sybPreparedStatement2 = null;
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                if (stringArray == null || stringArray.length != 1) {
                    ErrorMessage.raiseError("JZ0GK", "columnNames");
                }
                sybPreparedStatement = sybPreparedStatement2 = (SybPreparedStatement)this.prepareStatement(string, 1);
                if (!bl) break block5;
                LogUtil.logEnd(LOG, "PreparedStatement", sybPreparedStatement2 != null ? sybPreparedStatement2._logId : "_", this._logId, "createStatement", "String, String[]", new Object[]{string, stringArray}, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, "PreparedStatement", sybPreparedStatement2 != null ? sybPreparedStatement2._logId : "_", this._logId, "createStatement", "String, String[]", new Object[]{string, stringArray}, l);
                }
                throw throwable;
            }
        }
        return sybPreparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String string, boolean bl) throws SQLException {
        return this.prepareStatement(string, bl, 2);
    }

    private PreparedStatement prepareStatement(String string, boolean bl, int n) throws SQLException {
        this.checkConnection();
        String string2 = this._props.getString(68);
        SybPreparedStatement sybPreparedStatement = string2 == null || string2.equalsIgnoreCase("NONE") || string2.equalsIgnoreCase("FALSE") ? this.createSybPreparedStatement(string, bl, n) : (this._props.getBoolean(105) ? (bl ? new SybPreparedStatementBulkWithRTrim(this._logId, this.initProtocol(), string, this._dynStmtNum++, n) : new SybPreparedStatementBulkWithRTrim(this._logId, this.initProtocol(), string, n)) : this.createSybPreparedStatement(string, bl, n));
        if (bl && !this._protocol.isAse() && !this._protocol.isLOBSupportedAsParameterToSproc() && sybPreparedStatement._paramMgr != null && sybPreparedStatement._paramMgr._params != null) {
            for (Param param : sybPreparedStatement._paramMgr._params) {
                if (param._targetType != 2004 && param._targetType != 2005 && param._targetType != 2011 && param._targetType != -4 && param._targetType != -1 && param._targetType != -16) continue;
                ErrorMessage.raiseError("JZ0NS");
            }
        }
        sybPreparedStatement.setQueryTimeout(this._defaultQueryTimeout);
        sybPreparedStatement.setResultSetHoldability(this._rsHoldability);
        return sybPreparedStatement;
    }

    private SybPreparedStatement createSybPreparedStatement(String string, boolean bl, int n) throws SQLException {
        if (bl) {
            return new SybPreparedStatement(this._logId, this.initProtocol(), string, this._dynStmtNum++, n);
        }
        return new SybPreparedStatement(this._logId, this.initProtocol(), string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String string) throws SQLException {
        SybCallableStatement sybCallableStatement;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            SybCallableStatement sybCallableStatement2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                this.checkConnection();
                sybCallableStatement2 = new SybCallableStatement(this._logId, this.initProtocol(), string);
                sybCallableStatement2.setQueryTimeout(this._defaultQueryTimeout);
                sybCallableStatement2.setResultSetHoldability(this._rsHoldability);
                sybCallableStatement = sybCallableStatement2;
                if (!bl) break block4;
                LogUtil.logEnd(LOG, "CallableStatement", sybCallableStatement2 != null ? sybCallableStatement2._logId : "_", this._logId, "prepareCall", "String", new Object[]{string}, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, "CallableStatement", sybCallableStatement2 != null ? sybCallableStatement2._logId : "_", this._logId, "prepareCall", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
        }
        return sybCallableStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String nativeSQL(String string) throws SQLException {
        String string2;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                this.checkConnection();
                SybStatement sybStatement = (SybStatement)this.createStatement();
                string2 = sybStatement.processEscapes(string);
                if (!bl) break block4;
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "nativeSQL", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "nativeSQL", "String", new Object[]{string}, l);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setAutoCommit(boolean bl) throws SQLException {
        boolean bl2 = LogUtil.isLoggingEnabled(LOG);
        long l = bl2 ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl2) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkConnection();
            try {
                this._protocol.setOption(null, 1, bl);
                if (this.isPropertySet(79)) {
                    this._protocol.setOption(null, 13, !bl);
                }
                this.resetNullLobs();
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
            }
            if (!bl2) return;
        }
        catch (Throwable throwable) {
            if (!bl2) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setAutoCommit", "boolean", new Object[]{bl}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setAutoCommit", "boolean", new Object[]{bl}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetNullLobs() throws SQLException {
        if (!this.canUseLocators()) {
            this._nullClob = new SybCharClientLob(this._logId, this._pc, new StringBuilder(), SybLob.LOB_TYPE.TEXT);
            this._nullBlob = new SybBinaryClientLob(this._logId, this._pc, new byte[0]);
        } else {
            PreparedStatement preparedStatement = null;
            SybResultSet sybResultSet = null;
            try {
                preparedStatement = this._mda.getMetaDataAccessor("INIT_NULL_LOBS", this._pc);
                sybResultSet = (SybResultSet)preparedStatement.executeQuery();
                if (sybResultSet.next()) {
                    this._nullBlob = sybResultSet.getInitializedBlob(1);
                    this._nullClob = sybResultSet.getInitializedClob(2);
                }
            }
            finally {
                if (sybResultSet != null) {
                    sybResultSet.close();
                    sybResultSet = null;
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                    preparedStatement = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getAutoCommit() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkConnection();
            boolean bl2 = false;
            try {
                bl2 = this._protocol.getBoolOption(null, 1);
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
            }
            boolean bl3 = bl2;
            return bl3;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getAutoCommit", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkConnection();
            try {
                this._protocol.endTransaction(true);
                if (!this._stmtList.isEmpty()) {
                    Enumeration<SybStatement> enumeration = this._stmtList.elements();
                    while (enumeration.hasMoreElements()) {
                        enumeration.nextElement().cancel();
                    }
                }
                this._savepoints.clear();
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
            }
            this.resetNullLobs();
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "commit", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkConnection();
            try {
                this._protocol.endTransaction(false);
                this._savepoints.clear();
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
            }
            this.resetNullLobs();
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "rollback", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkConnection();
            int n = this.getSavepointIdx(savepoint);
            if (n == -1) {
                ErrorMessage.raiseError("JZ017");
            }
            PreparedStatement preparedStatement = this._mda.getMetaDataAccessor("ROLL_TO_SAVEPOINT", " " + ((SybSavepoint)savepoint)._name, this._pc);
            preparedStatement.executeUpdate();
            preparedStatement.close();
            this._savepoints.subList(n + 1, this._savepoints.size()).clear();
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "rollback", "Savepoint", new Object[]{(SybSavepoint)savepoint}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "rollback", "Savepoint", new Object[]{(SybSavepoint)savepoint}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Savepoint setSavepoint() throws SQLException {
        SybSavepoint sybSavepoint;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            SybSavepoint sybSavepoint2 = null;
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                sybSavepoint2 = (SybSavepoint)this.setSavepoint("jConn_autogen_svpt" + this._savepointId);
                sybSavepoint2._id = this._savepointId++;
                sybSavepoint2._isNamed = false;
                sybSavepoint = sybSavepoint2;
                if (!bl) break block4;
                LogUtil.logEnd(LOG, "Savepoint", sybSavepoint2 != null ? sybSavepoint2._logId : "_", this._logId, "setSavepoint", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, "Savepoint", sybSavepoint2 != null ? sybSavepoint2._logId : "_", this._logId, "setSavepoint", null, null, l);
                }
                throw throwable;
            }
        }
        return sybSavepoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Savepoint setSavepoint(String string) throws SQLException {
        SybSavepoint sybSavepoint;
        block5: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            SybSavepoint sybSavepoint2 = null;
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                this.checkConnection();
                PreparedStatement preparedStatement = this._mda.getMetaDataAccessor("SAVEPOINT", " " + string, this._pc);
                preparedStatement.executeUpdate();
                preparedStatement.close();
                sybSavepoint2 = new SybSavepoint(this._logId, string);
                sybSavepoint2._isNamed = true;
                int n = this.getSavepointIdx(sybSavepoint2);
                if (n != -1) {
                    this._savepoints.removeElementAt(n);
                }
                this._savepoints.addElement(sybSavepoint2);
                sybSavepoint = sybSavepoint2;
                if (!bl) break block5;
                LogUtil.logEnd(LOG, "Savepoint", sybSavepoint2 != null ? sybSavepoint2._logId : "_", this._logId, "setSavepoint", "String", new Object[]{string}, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, "Savepoint", sybSavepoint2 != null ? sybSavepoint2._logId : "_", this._logId, "setSavepoint", "String", new Object[]{string}, l);
                }
                throw throwable;
            }
        }
        return sybSavepoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            int n;
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if ((n = this.getSavepointIdx(savepoint)) == -1) {
                ErrorMessage.raiseError("JZ017");
            }
            this._savepoints.removeElementAt(n);
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "releaseSavepoint", "Savepoint", new Object[]{savepoint}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "releaseSavepoint", "Savepoint", new Object[]{savepoint}, l);
    }

    private int getSavepointIdx(Savepoint savepoint) throws SQLException {
        int n = -1;
        for (int i = 0; i < this._savepoints.size(); ++i) {
            SybSavepoint sybSavepoint = this._savepoints.get(i);
            if (!sybSavepoint._name.equals(((SybSavepoint)savepoint)._name)) continue;
            n = i;
            break;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (this._state == IConstants.CONNECTION_STATE.DEAD) {
                return;
            }
            this._inClose = true;
            if (this._cursors != null) {
                Enumeration<String> enumeration = this._cursors.keys();
                try {
                    while (true) {
                        String string = enumeration.nextElement();
                        this._cursors.remove(string);
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            if (this._pstmtIsClosed != null) {
                this._pstmtIsClosed.close();
            }
            if (this._csIsClosed != null) {
                this._csIsClosed.close();
            }
            this.markDead(false);
            try {
                this._protocol.logout();
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
            }
            finally {
                this._pc.drop();
                if (this._sharedPc != null) {
                    this._sharedPc.drop();
                }
                this._inClose = false;
            }
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "close", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() throws SQLException {
        boolean bl = true;
        boolean bl2 = LogUtil.isLoggingEnabled(LOG);
        long l = bl2 ? this._apiCount.incrementAndGet() : 0L;
        try {
            block24: {
                if (bl2) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                if (this._state != IConstants.CONNECTION_STATE.DEAD) {
                    try {
                        Object object;
                        if (this._isClosedTestInternal == null) {
                            object = this._props.getString(36);
                            if (object != null && ((String)object).equals("INTERNAL")) {
                                this._isClosedTestInternal = true;
                            } else {
                                this._isClosedTestInternal = false;
                                if (object != null) {
                                    this._pstmtIsClosed = this.prepareInternalStatement((String)object);
                                } else {
                                    block23: {
                                        try {
                                            if (this._mda != null) {
                                                this._pstmtIsClosed = this._mda.getMetaDataAccessor("IS_CLOSED_TEST", this._pc);
                                            }
                                        }
                                        catch (SQLException sQLException) {
                                            if ("JZ0SJ".equals(sQLException.getSQLState())) break block23;
                                            throw sQLException;
                                        }
                                    }
                                    if (this._pstmtIsClosed == null) {
                                        this._csIsClosed = this.prepareInternalCall("{call sp_mda(?,?)}");
                                        this._csIsClosed.setInt(1, 0);
                                        this._csIsClosed.setInt(2, 9);
                                    }
                                }
                            }
                        }
                        if (this._isClosedTestInternal.booleanValue()) {
                            bl = this._protocol.isSocketClosed();
                        } else {
                            object = null;
                            if (this._pstmtIsClosed != null) {
                                object = this._pstmtIsClosed.executeQuery();
                            } else if (this._mda != null) {
                                object = this._csIsClosed.executeQuery();
                            }
                            if (object != null && !object.isClosed()) {
                                object.close();
                            }
                        }
                        bl = this._state == IConstants.CONNECTION_STATE.DEAD;
                    }
                    catch (SQLException sQLException) {
                        if (!"JZ0F2".equals(sQLException.getSQLState())) break block24;
                        throw sQLException;
                    }
                }
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            if (bl2) {
                LogUtil.logEnd(LOG, null, null, this._logId, "isClosed", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        SybDatabaseMetaData sybDatabaseMetaData;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                this.checkConnection();
                this.checkDBMD();
                sybDatabaseMetaData = this._sybDBMD;
                if (!bl) break block4;
                LogUtil.logEnd(LOG, "ResultSet", this._sybDBMD != null ? this._sybDBMD._logId : "_", this._logId, "getMetaData", null, null, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, "ResultSet", this._sybDBMD != null ? this._sybDBMD._logId : "_", this._logId, "getMetaData", null, null, l);
                }
                throw throwable;
            }
        }
        return sybDatabaseMetaData;
    }

    protected String getDatabaseProductName() throws SQLException {
        return this._dbProductName;
    }

    protected synchronized void setDatabaseProductName(String string) throws SQLException {
        this._dbProductName = string;
    }

    protected String getDatabaseProductVersion() throws SQLException {
        return this._dbProductVersion;
    }

    protected synchronized void setDatabaseProductVersion(String string) throws SQLException {
        this._dbProductVersion = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setReadOnly(boolean bl) throws SQLException {
        block6: {
            boolean bl2 = LogUtil.isLoggingEnabled(LOG);
            long l = bl2 ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl2) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                try {
                    this.checkConnection();
                    this._protocol.setOption(null, 3, bl);
                }
                catch (SQLException sQLException) {
                    this.handleSQLE(sQLException);
                }
                this._readOnly = bl;
                if (!bl2) break block6;
            }
            catch (Throwable throwable) {
                if (bl2) {
                    LogUtil.logEnd(LOG, null, null, this._logId, "setReadOnly", "boolean", new Object[]{bl}, l);
                }
                throw throwable;
            }
            LogUtil.logEnd(LOG, null, null, this._logId, "setReadOnly", "boolean", new Object[]{bl}, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isReadOnly() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (this._readOnly == null) {
                this.checkConnection();
                try {
                    this._readOnly = this._protocol.getBoolOption(null, 3);
                }
                catch (SQLException sQLException) {
                    this.handleSQLE(sQLException);
                }
            }
            boolean bl2 = this._readOnly;
            return bl2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "isReadOnly", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setCatalog(String string) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkConnection();
            try {
                if (this._isDialectSupported) {
                    Dialect dialect = this._dialect;
                    CallableStatement callableStatement = this.prepareInternalCall("{call sp_drv_getdbtype(?)}");
                    callableStatement.setString(1, string);
                    SybResultSet sybResultSet = (SybResultSet)callableStatement.executeQuery();
                    sybResultSet.next();
                    String string2 = sybResultSet.getString(1);
                    sybResultSet.close();
                    callableStatement.close();
                    this._protocol.setOption(null, 9, string);
                    this._dialect = Dialect.getDialectUsingCode(string2);
                    if (this._dialect.isDialectChanged(dialect)) {
                        this._mda = null;
                        this._sybDBMD = null;
                        this.checkMDA(this._pc);
                        this._protocol.flushSystemDataTypeInfo();
                        this.cacheDataTypeInfo();
                        this._isDataTypeInfoCached = true;
                    }
                } else {
                    this._protocol.setOption(null, 9, string);
                }
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setCatalog", "String", new Object[]{string}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setCatalog", "String", new Object[]{string}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCatalog() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkConnection();
            String string = null;
            try {
                string = this._protocol.getStringOption(null, 9, null);
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getCatalog", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactionIsolation(int n) throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkConnection();
            try {
                this._protocol.setOption(null, 2, n);
            }
            catch (SQLException sQLException) {
                this.handleSQLE(sQLException);
            }
            this._tranIsolationLevel = n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "setTransactionIsolation", "int", null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTransactionIsolation() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (this._tranIsolationLevel == -1) {
                this.checkConnection();
                try {
                    this._tranIsolationLevel = this._protocol.getIntOption(null, 2);
                }
                catch (SQLException sQLException) {
                    this.handleSQLE(sQLException);
                }
            }
            int n = this._tranIsolationLevel;
            return n;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getTransactionIsolation", null, null, l);
            }
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this._warning;
    }

    public SQLWarning getWarningsNoCheckConnection() throws SQLException {
        return this._warning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearWarnings() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            this.checkConnection();
            this._warning = null;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "clearWarnings", null, null, l);
            }
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        return this._rsHoldability;
    }

    @Override
    public void setHoldability(int n) throws SQLException {
        if (n != 1 && n != 2) {
            ErrorMessage.raiseError("JZ0SW", String.valueOf(n));
        }
        this._rsHoldability = n;
    }

    @Override
    public String getSessionID() throws SQLException {
        return this._protocol.getStringOption(null, 5, null);
    }

    @Override
    public void regWatch(String string, SybEventHandler sybEventHandler, int n) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.makeEventContext(string, sybEventHandler, n);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    @Override
    public void regNoWatch(String string) throws SQLException {
        this.checkConnection();
        try {
            this._protocol.killEventContext(string);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
    }

    @Override
    public Capture createCapture() throws SQLException {
        this._capture = (Capture)this._protocol.getObjectOption(this._pc, 8);
        return this._capture;
    }

    public Capture getCapture() {
        return this._capture;
    }

    public Object getEndpoint() throws SQLException {
        return this._protocol.getObjectOption(this._pc, 7);
    }

    @Override
    public void cancel() throws SQLException {
        this._protocol.cancel(this._pc, true);
    }

    public void markDead() {
        try {
            this.markDead(true);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void markDead(boolean bl) throws SQLException {
        this._state = IConstants.CONNECTION_STATE.DEAD;
        if (bl) {
            this.checkConnection();
        }
    }

    public void markDeadTryHA() throws IOException {
        SQLException sQLException = null;
        boolean bl = false;
        try {
            bl = this.isPropertySet(34) || this.isPropertySet(72);
        }
        catch (SQLException sQLException2) {
            sQLException = sQLException2;
        }
        try {
            this.markDead(true);
        }
        catch (SQLException sQLException3) {
            if ("JZ0F2".equals(sQLException3.getSQLState())) {
                ErrorMessage.raiseHAException("JZ0F2", sQLException3);
            }
            SocketException socketException = new SocketException(sQLException3.getMessage());
            IOException iOException = new IOException(sQLException3.getMessage(), socketException);
            ErrorMessage.raiseSybConnectionDeadException(iOException);
        }
        if (bl) {
            ErrorMessage.raiseHAException("JZ0F2", sQLException);
        }
    }

    public String getDefaultServerCharset() throws SQLException {
        this.checkConnection();
        String string = null;
        try {
            if (!this.isPropertySet(6) && !this._protocol.isAse()) {
                return null;
            }
            string = this._protocol.getStringOption(null, 6, null);
        }
        catch (SQLException sQLException) {
            this.handleSQLE(sQLException);
        }
        return string;
    }

    protected void handleSQLE(SQLException sQLException) throws SQLException {
        boolean bl = SybConnection.thisChainHasAnException(sQLException);
        SQLWarning sQLWarning = null;
        if (!bl) {
            sQLWarning = (SQLWarning)sQLException;
        } else if (this._props.getBoolean(76)) {
            sQLException = SybConnection.getAllExceptions(sQLException);
        } else {
            sQLWarning = SybConnection.getAllTheWarnings(sQLException);
        }
        if (sQLWarning != null) {
            if (this._warning == null) {
                this._warning = sQLWarning;
            } else {
                this._warning.setNextWarning(sQLWarning);
            }
        }
        if (bl && this._props != null) {
            throw sQLException;
        }
    }

    public int getHALoginStatus() {
        return this._haLoginStatus;
    }

    protected int getHAState() {
        return this._haState;
    }

    public void setHAState(int n) {
        this._haState = n;
    }

    protected void setHALoginStatus(int n) {
        this._haLoginStatus = n;
        try {
            if (this.isPropertySet(71)) {
                this._haLoginStatus |= 8;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected boolean isDead() {
        return this._state == IConstants.CONNECTION_STATE.DEAD;
    }

    public static SQLWarning getAllTheWarnings(SQLException sQLException) {
        SQLWarning sQLWarning = null;
        for (SQLException sQLException2 = sQLException; sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
            if (!(sQLException2 instanceof SQLWarning)) continue;
            if (sQLWarning == null) {
                sQLWarning = new SQLWarning(sQLException2.getMessage(), sQLException2.getSQLState(), sQLException2.getErrorCode());
                continue;
            }
            sQLWarning.setNextWarning(new SQLWarning(sQLException2.getMessage(), sQLException2.getSQLState(), sQLException2.getErrorCode()));
        }
        sQLException = null;
        return sQLWarning;
    }

    public static SQLException getAllExceptions(SQLException sQLException) {
        SQLException sQLException2 = null;
        for (SQLException sQLException3 = sQLException; sQLException3 != null; sQLException3 = sQLException3.getNextException()) {
            if (sQLException3 instanceof SQLWarning) continue;
            if (sQLException2 == null) {
                if (sQLException3 instanceof EedInfo) {
                    sQLException2 = new SybSQLException(sQLException3.getMessage(), sQLException3.getSQLState(), sQLException3.getErrorCode(), ((EedInfo)((Object)sQLException3)).getState(), ((EedInfo)((Object)sQLException3)).getSeverity(), ((EedInfo)((Object)sQLException3)).getServerName(), ((EedInfo)((Object)sQLException3)).getProcedureName(), ((EedInfo)((Object)sQLException3)).getLineNumber(), ((EedInfo)((Object)sQLException3)).getEedParams(), ((EedInfo)((Object)sQLException3)).getTranState(), ((EedInfo)((Object)sQLException3)).getState());
                } else {
                    sQLException2 = new SQLException(sQLException3.getMessage(), sQLException3.getSQLState(), sQLException3.getErrorCode());
                    if (sQLException2.getCause() == null && sQLException.getCause() != null) {
                        sQLException2.initCause(sQLException.getCause());
                    }
                }
            } else if (sQLException3 instanceof EedInfo) {
                sQLException2.setNextException(new SybSQLException(sQLException3.getMessage(), sQLException3.getSQLState(), sQLException3.getErrorCode(), ((EedInfo)((Object)sQLException3)).getState(), ((EedInfo)((Object)sQLException3)).getSeverity(), ((EedInfo)((Object)sQLException3)).getServerName(), ((EedInfo)((Object)sQLException3)).getProcedureName(), ((EedInfo)((Object)sQLException3)).getLineNumber(), ((EedInfo)((Object)sQLException3)).getEedParams(), ((EedInfo)((Object)sQLException3)).getTranState(), ((EedInfo)((Object)sQLException3)).getState()));
            } else {
                sQLException2.setNextException(new SQLException(sQLException3.getMessage(), sQLException3.getSQLState(), sQLException3.getErrorCode()));
                if (sQLException2.getCause() == null && sQLException.getCause() != null) {
                    sQLException2.initCause(sQLException.getCause());
                }
            }
            sQLException2.setStackTrace(sQLException3.getStackTrace());
        }
        sQLException = null;
        return sQLException2;
    }

    public static SQLWarning convertToWarnings(SQLException sQLException) {
        SQLWarning sQLWarning = null;
        for (SQLException sQLException2 = sQLException; sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
            SQLWarning sQLWarning2 = new SQLWarning(sQLException2.getMessage(), sQLException2.getSQLState(), sQLException2.getErrorCode());
            if (sQLWarning == null) {
                sQLWarning = sQLWarning2;
                continue;
            }
            sQLWarning.setNextWarning(sQLWarning2);
        }
        return sQLWarning;
    }

    public void chainWarnings(SQLException sQLException) {
        SQLWarning sQLWarning = SybConnection.convertToWarnings(sQLException);
        if (this._warning == null) {
            this._warning = sQLWarning;
        } else {
            this._warning.setNextWarning(sQLWarning);
        }
    }

    public static boolean thisChainHasAnException(SQLException sQLException) {
        boolean bl = false;
        for (SQLException sQLException2 = sQLException; sQLException2 != null; sQLException2 = sQLException2.getNextException()) {
            if (sQLException2 instanceof SQLWarning) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public void setSybMessageHandler(SybMessageHandler sybMessageHandler) {
        this._pc.setMessageHandler(sybMessageHandler);
    }

    @Override
    public SybMessageHandler getSybMessageHandler() {
        if (this._pc != null) {
            return this._pc.getMessageHandler();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int n, int n2) throws SQLException {
        SybStatement sybStatement;
        block4: {
            SybStatement sybStatement2 = null;
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                sybStatement2 = (SybStatement)this.createStatement();
                sybStatement2.setResultSetParams(n, n2);
                sybStatement = sybStatement2;
                if (!bl) break block4;
                LogUtil.logEnd(LOG, "ResultSet", sybStatement2 != null ? sybStatement2._logId : "_", this._logId, "createStatement", "int, int", new Object[]{n, n2}, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, "ResultSet", sybStatement2 != null ? sybStatement2._logId : "_", this._logId, "createStatement", "int, int", new Object[]{n, n2}, l);
                }
                throw throwable;
            }
        }
        return sybStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        SybStatement sybStatement;
        block4: {
            SybStatement sybStatement2 = null;
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                sybStatement2 = (SybStatement)this.createStatement(n, n2);
                sybStatement2.setResultSetHoldability(n3);
                sybStatement = sybStatement2;
                if (!bl) break block4;
                LogUtil.logEnd(LOG, "Statement", sybStatement2 != null ? sybStatement2._logId : "_", this._logId, "createStatement", "int, int, int", new Object[]{n, n2, n3}, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, "Statement", sybStatement2 != null ? sybStatement2._logId : "_", this._logId, "createStatement", "int, int, int", new Object[]{n, n2, n3}, l);
                }
                throw throwable;
            }
        }
        return sybStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        SybPreparedStatement sybPreparedStatement;
        block4: {
            SybPreparedStatement sybPreparedStatement2 = null;
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                sybPreparedStatement2 = (SybPreparedStatement)this.prepareStatement(string);
                sybPreparedStatement2.setResultSetParams(n, n2);
                sybPreparedStatement = sybPreparedStatement2;
                if (!bl) break block4;
                LogUtil.logEnd(LOG, "PreparedStatement", sybPreparedStatement2 != null ? sybPreparedStatement2._logId : "_", this._logId, "prepareStatement", "String, int, int", new Object[]{string, n, n2}, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, "PreparedStatement", sybPreparedStatement2 != null ? sybPreparedStatement2._logId : "_", this._logId, "prepareStatement", "String, int, int", new Object[]{string, n, n2}, l);
                }
                throw throwable;
            }
        }
        return sybPreparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        SybPreparedStatement sybPreparedStatement;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            SybPreparedStatement sybPreparedStatement2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                sybPreparedStatement2 = (SybPreparedStatement)this.prepareStatement(string, n, n2);
                sybPreparedStatement2.setResultSetHoldability(n3);
                sybPreparedStatement = sybPreparedStatement2;
                if (!bl) break block4;
                LogUtil.logEnd(LOG, "PreparedStatement", sybPreparedStatement2 != null ? sybPreparedStatement2._logId : "_", this._logId, "prepareStatement", "String, int, int, int", new Object[]{string, n, n2, n3}, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, "PreparedStatement", sybPreparedStatement2 != null ? sybPreparedStatement2._logId : "_", this._logId, "prepareStatement", "String, int, int, int", new Object[]{string, n, n2, n3}, l);
                }
                throw throwable;
            }
        }
        return sybPreparedStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        SybCallableStatement sybCallableStatement;
        block4: {
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            SybCallableStatement sybCallableStatement2 = null;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                sybCallableStatement2 = (SybCallableStatement)this.prepareCall(string);
                sybCallableStatement2.setResultSetParams(n, n2);
                sybCallableStatement = sybCallableStatement2;
                if (!bl) break block4;
                LogUtil.logEnd(LOG, "CallableStatement", sybCallableStatement2 != null ? sybCallableStatement2._logId : "_", this._logId, "prepareCall", "String, int, int", new Object[]{string, n, n2}, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, "CallableStatement", sybCallableStatement2 != null ? sybCallableStatement2._logId : "_", this._logId, "prepareCall", "String, int, int", new Object[]{string, n, n2}, l);
                }
                throw throwable;
            }
        }
        return sybCallableStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        SybCallableStatement sybCallableStatement;
        block4: {
            SybCallableStatement sybCallableStatement2 = null;
            boolean bl = LogUtil.isLoggingEnabled(LOG);
            long l = bl ? this._apiCount.incrementAndGet() : 0L;
            try {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                sybCallableStatement2 = (SybCallableStatement)this.prepareCall(string, n, n2);
                sybCallableStatement2.setResultSetHoldability(n3);
                sybCallableStatement = sybCallableStatement2;
                if (!bl) break block4;
                LogUtil.logEnd(LOG, "CallableStatement", sybCallableStatement2 != null ? sybCallableStatement2._logId : "_", this._logId, "prepareCall", "String, int, int, int", new Object[]{string, n, n2, n3}, l);
            }
            catch (Throwable throwable) {
                if (bl) {
                    LogUtil.logEnd(LOG, "CallableStatement", sybCallableStatement2 != null ? sybCallableStatement2._logId : "_", this._logId, "prepareCall", "String, int, int, int", new Object[]{string, n, n2, n3}, l);
                }
                throw throwable;
            }
        }
        return sybCallableStatement;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "setTypeMap(java.util.Map)");
    }

    protected ProtocolContext initProtocol() throws SQLException {
        ProtocolContext protocolContext = this._protocol.getProtocolContext(this._props);
        protocolContext._protocol = this._protocol;
        protocolContext._conn = this;
        if (this._pc != null) {
            protocolContext._msgHandler = this._pc._msgHandler;
        }
        return protocolContext;
    }

    public MdaManager getMDA(ProtocolContext protocolContext) throws SQLException {
        this.checkMDA(protocolContext);
        return this._mda;
    }

    private void handleHADRFailOver() throws SQLException {
        Vector<String> vector = new Vector<String>();
        vector.add(this._protocol.getHadrLatestPrimaryHostPort());
        this.setHAState(-1);
        this.tryLogin(vector);
        this._wasConnected = true;
        this.resetVariableAfterHADRFailover();
        ErrorMessage.raiseError("JZ0F2");
    }

    protected void handleHAFailover() throws SQLException {
        this.nextHAState();
        switch (this.getHAState()) {
            case 0: {
                if (this.isPropertySet(34)) {
                    this.setHALoginStatus(1);
                }
                this.tryLogin(this._hostPortList);
                this._wasConnected = true;
                if (this._haState == 7) {
                    this.setHAState(8);
                    break;
                }
                this.setHAState(2);
                break;
            }
            case 4: {
                this.setHALoginStatus(3);
                this.tryLogin(this._hostPortList);
                this._wasConnected = true;
                this.setHAState(2);
                break;
            }
            case 5: {
                this.setHALoginStatus(3);
                this.tryLogin(this._hostPortList);
                this._wasConnected = true;
                this.setHAState(2);
                break;
            }
            case 1: {
                if (this._secondaryHostPortList == null || this._secondaryHostPortList.size() == 0) {
                    ErrorMessage.raiseError("JZ0F1");
                }
                this.setHALoginStatus(5);
                this.tryLogin(this._secondaryHostPortList);
                this._wasConnected = true;
                this.setHAState(3);
                break;
            }
            case 6: {
                this.setHALoginStatus(7);
                this.tryLogin(this._secondaryHostPortList);
                this._wasConnected = true;
                this.setHAState(3);
                break;
            }
            case 7: {
                this.setHALoginStatus(1);
                this.handleRecursion("TRY_CLUSTER_NODE_CONNECT");
                this.tryLogin(this._hostPortList);
                this._wasConnected = true;
                this.setHAState(8);
                if (this._props.getString(96) == null || this._props.getString(96).equals("NONE") || !this._protocol.isHADRSupported()) break;
                this.resetVariableAfterHADRFailover();
                break;
            }
            case 10: {
                this.setHALoginStatus(3);
                if (this._protocol.getRedirectionHostPort() != null) {
                    this._hostPortList = this._protocol.getRedirectionHostPort();
                }
                this.handleRecursion("TRY_CLUSTER_NODE_FAILOVER");
                this.tryLogin(this._hostPortList);
                this._recursionDepth = 0;
                this._wasConnected = true;
                this.setHAState(8);
                if (this._props.getString(96) == null || this._props.getString(96).equals("NONE") || !this._protocol.isHADRSupported()) break;
                this.resetVariableAfterHADRFailover();
                break;
            }
            case 9: {
                if (this.isPropertySet(34)) {
                    this.setHALoginStatus(17);
                } else {
                    this.setHALoginStatus(16);
                }
                this.tryLogin(this._protocol.getRedirectionHostPort());
                this._wasConnected = true;
                this.setHAState(8);
                break;
            }
        }
    }

    private void handleRecursion(String string) throws SQLException {
        int n;
        int n2 = n = this._hostPortList != null ? this._hostPortList.size() : 1;
        if (this._recursionDepth++ > n * 25) {
            ErrorMessage.raiseError("JZRTD", string);
        }
    }

    private void nextHAState() {
        if (!this._wasConnected) {
            switch (this._haState) {
                case -1: {
                    this._haState = 0;
                    break;
                }
                case 0: {
                    this._haState = 1;
                    break;
                }
                case 7: {
                    break;
                }
            }
        } else {
            switch (this._haState) {
                case 2: {
                    this._haState = 4;
                    break;
                }
                case 4: 
                case 5: {
                    this._haState = 6;
                    break;
                }
                case 3: {
                    this._haState = 5;
                    break;
                }
                case 8: {
                    this._haState = 10;
                    break;
                }
                case 9: {
                    break;
                }
            }
        }
    }

    protected void checkConnection() throws SQLException {
        if (this._state == IConstants.CONNECTION_STATE.DEAD) {
            String string = this._props.getString(96);
            if (string != null && string.compareToIgnoreCase("RECONNECT") == 0 && this._hadrState.equals((Object)TdsConst.HADR_STATE.FAILOVER)) {
                this._state = IConstants.CONNECTION_STATE.NEW;
                this.handleHADRFailOver();
            } else if (this.isPropertySet(34) && !this._inClose && this.getHAState() != 1 && this.getHAState() != 6) {
                this._state = IConstants.CONNECTION_STATE.NEW;
                this.handleHAFailover();
            } else if (this.isPropertySet(72) && !this._inClose && this.getHAState() == 9) {
                this._state = IConstants.CONNECTION_STATE.NEW;
                this.handleHAFailover();
            } else {
                this._protocol.abort();
                ErrorMessage.raiseError("JZ0C0");
            }
        }
        if (this._state == IConstants.CONNECTION_STATE.UNINITIALIZED) {
            this._state = IConstants.CONNECTION_STATE.INITIALIZING;
            this.init();
        }
    }

    protected ResultSet getCursorResultSet(String string) {
        if (this._cursors == null) {
            return null;
        }
        return this._cursors.get(string);
    }

    protected void addCursorResultSet(String string, ResultSet resultSet) {
        if (this._cursors == null) {
            this._cursors = new Hashtable();
        }
        this._cursors.put(string, resultSet);
    }

    public void removeCursorResultSet(String string) {
        if (this._cursors == null) {
            return;
        }
        try {
            this._cursors.remove(string);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Override
    public com.sybase.jdbcx.SybPreparedStatement copyPreparedStatement(com.sybase.jdbcx.SybPreparedStatement sybPreparedStatement) throws SQLException {
        SybPreparedStatementCopy sybPreparedStatementCopy = new SybPreparedStatementCopy(this.getSharedProtocolContext(), (SybPreparedStatement)sybPreparedStatement);
        sybPreparedStatementCopy.setMaxRows(0);
        return sybPreparedStatementCopy;
    }

    @Override
    public com.sybase.jdbcx.SybCallableStatement copyCallableStatement(com.sybase.jdbcx.SybCallableStatement sybCallableStatement) throws SQLException {
        SybCallableStatementCopy sybCallableStatementCopy = new SybCallableStatementCopy(this.getSharedProtocolContext(), (SybCallableStatement)sybCallableStatement);
        sybCallableStatementCopy.setMaxRows(0);
        return sybCallableStatementCopy;
    }

    protected synchronized ProtocolContext getSharedProtocolContext() throws SQLException {
        if (this._sharedPc == null) {
            this._sharedPc = this.initProtocol();
        }
        return this._sharedPc;
    }

    protected synchronized CacheManager getSharedCacheManager() {
        return this._sharedCm;
    }

    protected synchronized void setSharedCacheManager(CacheManager cacheManager) {
        this._sharedCm = cacheManager;
    }

    protected int getDynStmtNum() {
        return this._dynStmtNum;
    }

    protected void setDynStmtNum(int n) {
        this._dynStmtNum = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMDA(ProtocolContext protocolContext) throws SQLException {
        block7: {
            if (this._mda == null) {
                try {
                    if (protocolContext == null) {
                        SybConnection sybConnection = this;
                        synchronized (sybConnection) {
                            this._mda = new MdaManager(this._logId, this, this._pc);
                            break block7;
                        }
                    }
                    this._mda = new MdaManager(this._logId, this, protocolContext);
                }
                catch (SQLException sQLException) {
                    this.handleSQLE(sQLException);
                }
            }
        }
    }

    private void checkDBMD() throws SQLException {
        this.checkMDA(null);
        if (this._sybDBMD == null) {
            this._sybDBMD = new SybDatabaseMetaData(this._logId, this);
        }
    }

    public Statement createInternalStatement() throws SQLException {
        Statement statement = this.createStatement();
        statement.setQueryTimeout(this._internalQueryTimeout);
        return statement;
    }

    public PreparedStatement prepareInternalStatement(String string) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(string);
        preparedStatement.setQueryTimeout(this._internalQueryTimeout);
        return preparedStatement;
    }

    public PreparedStatement prepareInternalStatement(String string, boolean bl) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(string, bl);
        preparedStatement.setQueryTimeout(this._internalQueryTimeout);
        return preparedStatement;
    }

    public CallableStatement prepareInternalCall(String string) throws SQLException {
        CallableStatement callableStatement = this.prepareCall(string);
        callableStatement.setQueryTimeout(this._internalQueryTimeout);
        return callableStatement;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isValid(int var1_1) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob createBlob() throws SQLException {
        Blob blob = null;
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (!this.canUseLocators()) {
                SybBinaryClientLob sybBinaryClientLob = blob = new SybBinaryClientLob(this._logId, this._pc, new byte[0]);
                return sybBinaryClientLob;
            }
            if (this._batchSBPIInitialized) {
                ErrorMessage.raiseError("JZ044");
            }
            PreparedStatement preparedStatement = this._mda.getMetaDataAccessor("INIT_IMAGELOCATOR", this._pc);
            SybResultSet sybResultSet = (SybResultSet)preparedStatement.executeQuery();
            blob = null;
            if (sybResultSet.next()) {
                blob = sybResultSet.getInitializedBlob(1);
            }
            SybBinaryClientLob sybBinaryClientLob = blob;
            return sybBinaryClientLob;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "createBlob", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob createClob() throws SQLException {
        Clob clob = null;
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            PreparedStatement preparedStatement;
            SybResultSet sybResultSet;
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (!this.canUseLocators()) {
                SybCharClientLob sybCharClientLob = clob = new SybCharClientLob(this._logId, this._pc, new StringBuilder(), SybLob.LOB_TYPE.TEXT);
                return sybCharClientLob;
            }
            if (this._batchSBPIInitialized) {
                ErrorMessage.raiseError("JZ044");
            }
            if ((sybResultSet = (SybResultSet)(preparedStatement = this._mda.getMetaDataAccessor("INIT_TEXTLOCATOR", this._pc)).executeQuery()).next()) {
                clob = sybResultSet.getInitializedClob(1);
            }
            SybCharClientLob sybCharClientLob = clob;
            return sybCharClientLob;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "createClob", null, null, l);
            }
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "createNClob()");
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "public SQLXML createSQLXML()");
        return null;
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        ErrorMessage.raiseMethodNotSupportedException(this, "public Struct createStruct(String arg0, Object[] arg1)");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Properties getClientInfo() throws SQLException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            Object object;
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            if (this._clientInfoProperties.size() == 0) {
                if (this._state == IConstants.CONNECTION_STATE.DEAD) {
                    this._clientInfoProperties.put("ApplicationName", "");
                    this._clientInfoProperties.put("ClientUser", "");
                    this._clientInfoProperties.put("ClientHostname", "");
                } else {
                    this.checkConnection();
                    object = this._mda.getMetaDataAccessor("GET_CLIENT_INFO", this._pc);
                    object.execute();
                    ResultSet resultSet = object.getResultSet();
                    if (resultSet.next()) {
                        this._clientInfoProperties.put("ApplicationName", resultSet.getString(1));
                        this._clientInfoProperties.put("ClientUser", resultSet.getString(2));
                        this._clientInfoProperties.put("ClientHostname", resultSet.getString(3));
                    }
                }
            }
            this._clientInfoProperties.put("HADR_LISTMAP", this._protocol.getHADRListMap());
            object = this._clientInfoProperties;
            return object;
        }
        finally {
            if (bl) {
                LogUtil.logEnd(LOG, null, null, this._logId, "getClientInfo", null, null, l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClientInfo(String string) throws SQLException {
        String string2;
        block25: {
            Object object;
            long l;
            boolean bl;
            block23: {
                String string3;
                block24: {
                    block21: {
                        String string4;
                        block22: {
                            block19: {
                                String string5;
                                block20: {
                                    block17: {
                                        String string6;
                                        block18: {
                                            block15: {
                                                String string7;
                                                block16: {
                                                    block13: {
                                                        String string8;
                                                        block14: {
                                                            boolean bl2;
                                                            block11: {
                                                                String string9;
                                                                block12: {
                                                                    bl = LogUtil.isLoggingEnabled(LOG);
                                                                    bl2 = this._props.getString(115) != null;
                                                                    l = bl ? this._apiCount.incrementAndGet() : 0L;
                                                                    try {
                                                                        if (bl) {
                                                                            LogUtil.logBegin(LOG, this._logId, l);
                                                                        }
                                                                        if (!string.equalsIgnoreCase("DIALECT")) break block11;
                                                                        string9 = this.getDialect().getDialectCode();
                                                                        if (!bl) break block12;
                                                                    }
                                                                    catch (Throwable throwable) {
                                                                        if (bl) {
                                                                            LogUtil.logEnd(LOG, null, null, this._logId, "getClientInfo", "String", new Object[]{string}, l);
                                                                        }
                                                                        throw throwable;
                                                                    }
                                                                    LogUtil.logEnd(LOG, null, null, this._logId, "getClientInfo", "String", new Object[]{string}, l);
                                                                }
                                                                return string9;
                                                            }
                                                            if (!bl2 || !string.equalsIgnoreCase("PASSWORD")) break block13;
                                                            string8 = null;
                                                            if (!bl) break block14;
                                                            LogUtil.logEnd(LOG, null, null, this._logId, "getClientInfo", "String", new Object[]{string}, l);
                                                        }
                                                        return string8;
                                                    }
                                                    if (!string.equalsIgnoreCase(HADR_CURRENT_STATE)) break block15;
                                                    string7 = this.getHADRCurrentState();
                                                    if (!bl) break block16;
                                                    LogUtil.logEnd(LOG, null, null, this._logId, "getClientInfo", "String", new Object[]{string}, l);
                                                }
                                                return string7;
                                            }
                                            if (!string.equalsIgnoreCase("ENCRYPT_COMMAND")) break block17;
                                            string6 = this._encryptCommand + "";
                                            if (!bl) break block18;
                                            LogUtil.logEnd(LOG, null, null, this._logId, "getClientInfo", "String", new Object[]{string}, l);
                                        }
                                        return string6;
                                    }
                                    this.checkConnection();
                                    this.getClientInfo();
                                    Object object2 = this._clientInfoProperties.get(string);
                                    if (object2 == null) break block19;
                                    string5 = object2.toString();
                                    if (!bl) break block20;
                                    LogUtil.logEnd(LOG, null, null, this._logId, "getClientInfo", "String", new Object[]{string}, l);
                                }
                                return string5;
                            }
                            if (!string.equalsIgnoreCase("ENABLE_FUNCTIONALITY_GROUP")) break block21;
                            string4 = null;
                            if (!bl) break block22;
                            LogUtil.logEnd(LOG, null, null, this._logId, "getClientInfo", "String", new Object[]{string}, l);
                        }
                        return string4;
                    }
                    object = this._props.getConnProperty(string);
                    if (object != null && !object.toString().equalsIgnoreCase("null")) break block23;
                    string3 = null;
                    if (!bl) break block24;
                    LogUtil.logEnd(LOG, null, null, this._logId, "getClientInfo", "String", new Object[]{string}, l);
                }
                return string3;
            }
            string2 = object.toString();
            if (!bl) break block25;
            LogUtil.logEnd(LOG, null, null, this._logId, "getClientInfo", "String", new Object[]{string}, l);
        }
        return string2;
    }

    private String getHADRCurrentState() throws SQLException {
        if (this._props.getString(96) != null && this._protocol.isHADRSupported()) {
            TdsConst.HADR_STATE hADR_STATE = this._hadrState;
            this._protocol.checkAndUpdateCurrentHADRState();
            this._hadrState = this._hadrState.getCurrentState(hADR_STATE);
        } else {
            this._hadrState = TdsConst.HADR_STATE.NONE;
        }
        return this._hadrState.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            if (bl) {
                LogUtil.logBegin(LOG, this._logId, l);
            }
            HashMap<String, ClientInfoStatus> hashMap = new HashMap<String, ClientInfoStatus>();
            String string = null;
            Set<Object> set = properties.keySet();
            SQLException sQLException = null;
            ClientInfoStatus clientInfoStatus = ClientInfoStatus.REASON_UNKNOWN;
            try {
                this.checkConnection();
            }
            catch (SQLException sQLException2) {
                throw new SQLClientInfoException(hashMap, (Throwable)sQLException2);
            }
            for (Object object : set) {
                string = object.toString();
                if (string.equalsIgnoreCase("HADR_LISTMAP") || string.equalsIgnoreCase(HADR_CURRENT_STATE)) continue;
                Object object2 = properties.get(string);
                try {
                    CLIENT_INFO cLIENT_INFO = CLIENT_INFO.getValue(string);
                    if (cLIENT_INFO == null) throw new SQLException();
                    PreparedStatement preparedStatement = this._mda.getMetaDataAccessor("SET_CLIENT_INFO", this._pc);
                    preparedStatement.setString(1, cLIENT_INFO.getValue());
                    preparedStatement.setString(2, object2.toString());
                    preparedStatement.executeUpdate();
                    this._clientInfoProperties.put(string, object2.toString());
                }
                catch (SQLException sQLException3) {
                    if (sQLException == null) {
                        sQLException = sQLException3;
                    } else {
                        sQLException.setNextException(sQLException3);
                    }
                    hashMap.put(string, clientInfoStatus);
                }
            }
            if (!hashMap.isEmpty()) {
                SQLClientInfoException sQLClientInfoException = sQLException != null ? new SQLClientInfoException(hashMap, sQLException) : new SQLClientInfoException(hashMap);
                throw sQLClientInfoException;
            }
            if (!bl) return;
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setClientInfo", "Properties", new Object[]{properties}, l);
            throw throwable;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setClientInfo", "Properties", new Object[]{properties}, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        HashMap<String, ClientInfoStatus> hashMap;
        boolean bl = LogUtil.isLoggingEnabled(LOG);
        long l = bl ? this._apiCount.incrementAndGet() : 0L;
        try {
            SQLException sQLException;
            ClientInfoStatus clientInfoStatus;
            String string3;
            block18: {
                if (bl) {
                    LogUtil.logBegin(LOG, this._logId, l);
                }
                hashMap = new HashMap<String, ClientInfoStatus>();
                try {
                    this.checkConnection();
                }
                catch (SQLException sQLException2) {
                    throw new SQLClientInfoException(hashMap, (Throwable)sQLException2);
                }
                string3 = string;
                clientInfoStatus = ClientInfoStatus.REASON_UNKNOWN;
                sQLException = null;
                CLIENT_INFO cLIENT_INFO = CLIENT_INFO.getValue(string3);
                if (cLIENT_INFO == null) break block18;
                PreparedStatement preparedStatement = this._mda.getMetaDataAccessor("SET_CLIENT_INFO", this._pc);
                preparedStatement.setString(1, cLIENT_INFO.getValue());
                preparedStatement.setString(2, string2);
                preparedStatement.executeUpdate();
                this._clientInfoProperties.put(string3, string2);
                if (!bl) return;
                LogUtil.logEnd(LOG, null, null, this._logId, "setClientInfo", "String, String", new Object[]{string, string2}, l);
                return;
            }
            try {
                int n = this._props.getKey(string3);
                if (n == -1) {
                    hashMap.put(string3, clientInfoStatus);
                } else if (string2 == null || string2.isEmpty() || string2.equalsIgnoreCase("null")) {
                    clientInfoStatus = ClientInfoStatus.REASON_VALUE_INVALID;
                    this._props.setConnProperty(string3, null, true, false);
                } else {
                    clientInfoStatus = ClientInfoStatus.REASON_VALUE_INVALID;
                    if (string3.equalsIgnoreCase("ISOLATION_MODE")) {
                        this._protocol.setOption(null, 52, Integer.parseInt(string2));
                    }
                    this._props.setConnProperty(string3, string2, true, false);
                }
                if (string3.equalsIgnoreCase("DYNAMIC_PREPARE")) {
                    this._dynamicPrepare = this.isPropertySet(n);
                }
                if (string3.equalsIgnoreCase("DEFAULT_QUERY_TIMEOUT")) {
                    this._defaultQueryTimeout = this._props.getInteger(62);
                }
                if (string3.equalsIgnoreCase("INTERNAL_QUERY_TIMEOUT")) {
                    this._internalQueryTimeout = this._props.getInteger(61);
                }
                if (string3.equalsIgnoreCase("ENCRYPT_COMMAND")) {
                    this._encryptCommand = this._props.getBoolean(113) && this._protocol.isOnDemandEncryptionSupported();
                }
            }
            catch (SQLException sQLException3) {
                sQLException = sQLException3;
                hashMap.put(string3, clientInfoStatus);
            }
            if (hashMap.isEmpty()) break block19;
            if (sQLException == null) break block20;
            SQLClientInfoException sQLClientInfoException = new SQLClientInfoException(hashMap, (Throwable)sQLException);
        }
        catch (Throwable throwable) {
            if (!bl) throw throwable;
            LogUtil.logEnd(LOG, null, null, this._logId, "setClientInfo", "String, String", new Object[]{string, string2}, l);
            throw throwable;
        }
        {
            block19: {
                void var11_15;
                block20: {
                    throw var11_15;
                }
                SQLClientInfoException sQLClientInfoException = new SQLClientInfoException(hashMap);
                throw var11_15;
            }
            if (!bl) return;
        }
        LogUtil.logEnd(LOG, null, null, this._logId, "setClientInfo", "String, String", new Object[]{string, string2}, l);
    }

    protected boolean isLobLocatorSupported() throws SQLException {
        return this._protocol.isLocatorSupported();
    }

    public boolean canUseLocators() throws SQLException {
        return this.isLobLocatorSupported() && this.isLOBLocatorEnabled() && !this.getAutoCommit();
    }

    public boolean isPropertySet(int n) throws SQLException {
        return this._props.getBoolean(n);
    }

    public boolean isLOBLocatorEnabled() throws SQLException {
        return this.isPropertySet(79);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        T t = null;
        try {
            t = clazz.cast(this);
        }
        catch (ClassCastException classCastException) {
            ErrorMessage.raiseError("JZ031", clazz.getName(), classCastException);
        }
        return t;
    }

    public void setHADRState(TdsConst.HADR_STATE hADR_STATE) {
        this._hadrState = hADR_STATE;
    }

    public TdsConst.HADR_STATE getHADRState() {
        return this._hadrState;
    }

    private void resetVariableAfterHADRFailover() {
        this._hadrState = TdsConst.HADR_STATE.ACTIVE;
        this._protocol.resetTransactionStateWhenHADRFailoverOccurs();
    }

    public Dialect getDialect() {
        return this._dialect;
    }

    public boolean isDialectSupported() {
        return this._isDialectSupported;
    }

    public void setIsDialectSupported(boolean bl) {
        this._isDialectSupported = bl;
    }

    public void setSecLoginContext(SecLoginContext secLoginContext) {
        this._secLoginContext = secLoginContext;
    }

    public SecLoginContext getSecLoginContext() {
        return this._secLoginContext;
    }

    public Clob getNullClob() {
        return this._nullClob;
    }

    private static enum CLIENT_INFO {
        ApplicationName("ApplicationName", "clientapplname"),
        ClientHostname("ClientHostname", "clienthostname"),
        ClientUser("ClientUser", "clientname");

        private final String key;
        private final String value;

        private CLIENT_INFO(String string2, String string3) {
            this.key = string2;
            this.value = string3;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public static CLIENT_INFO getValue(String string) {
            if (string.equals(CLIENT_INFO.ApplicationName.key)) {
                return ApplicationName;
            }
            if (string.equals(CLIENT_INFO.ClientHostname.key)) {
                return ClientHostname;
            }
            if (string.equals(CLIENT_INFO.ClientUser.key)) {
                return ClientUser;
            }
            return null;
        }
    }
}

