/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.jdbc.Protocol;
import com.sybase.jdbc4.jdbc.SybCallableStatement;
import com.sybase.jdbc4.tds.EventThread;
import com.sybase.jdbc4.tds.EventToken;
import com.sybase.jdbc4.tds.TdsProtocolContext;
import com.sybase.jdbc4.timedio.InStreamMgr;
import com.sybase.jdbc4.timedio.OutStreamMgr;
import com.sybase.jdbcx.SybEventHandler;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.Hashtable;

public class TdsEventContext
extends TdsProtocolContext {
    private Thread _runner = null;
    private EventThread _evtThrd = null;
    private Hashtable<String, SybEventHandler> _events;

    public TdsEventContext(Protocol protocol, InStreamMgr inStreamMgr, OutStreamMgr outStreamMgr) throws SQLException {
        super(null, protocol, inStreamMgr, outStreamMgr);
        this._event = true;
        inStreamMgr.setEventContext(this);
    }

    protected void addHandler(String string, SybEventHandler sybEventHandler, int n) throws SQLException {
        this.checkEventTable();
        this._events.put(string, sybEventHandler);
        SybCallableStatement sybCallableStatement = (SybCallableStatement)this._conn.prepareInternalCall("{call sp_regwatch(?, ?)}");
        sybCallableStatement.setString(1, string);
        short s = (short)(n | 0x40);
        sybCallableStatement.setShort(2, s);
        sybCallableStatement.executeUpdate();
        sybCallableStatement.close();
    }

    protected void dropHandler(String string) throws SQLException {
        this.checkEventTable();
        CallableStatement callableStatement = this._conn.prepareInternalCall("{call sp_regnowatch(?)}");
        callableStatement.setString(1, string);
        callableStatement.executeUpdate();
        this._events.remove(string);
    }

    private synchronized void checkEventTable() throws SQLException {
        if (this._events == null) {
            this._evtThrd = new EventThread(this);
            this._runner = new Thread(this._evtThrd);
            try {
                this._runner.start();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                ErrorMessage.raiseError("JZ0H0", illegalThreadStateException.toString(), illegalThreadStateException);
            }
            this._events = new Hashtable();
        }
    }

    @Override
    protected boolean checkBufStat(int n) {
        if ((n & 8) == 0) {
            this._pduState = 4;
            return true;
        }
        return false;
    }

    protected String getProcName() throws SQLException {
        String string = null;
        int n = this._protocol.nextResult(this);
        if (this._lastTds == 162) {
            try {
                EventToken eventToken = new EventToken(this._in);
                string = eventToken._name;
                this._lastResult = -1;
            }
            catch (IOException iOException) {
                ErrorMessage.raiseErrorCheckDead(iOException);
            }
        } else {
            this._protocol.ungetResult(this, this._lastTds);
            ErrorMessage.raiseError("JZ0P4");
        }
        return string;
    }

    protected SybEventHandler getHandler(String string) throws SQLException {
        this.checkEventTable();
        SybEventHandler sybEventHandler = this._events.get(string);
        if (sybEventHandler == null) {
            this.close(false);
            ErrorMessage.raiseError("JZ0H1", string);
        }
        return sybEventHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int responseState() {
        if (this._pduState == 0) {
            if (this._evtThrd != null) {
                EventThread eventThread = this._evtThrd;
                synchronized (eventThread) {
                    ++this._evtThrd._eventCount;
                    if (this._evtThrd._threadState) {
                        this._evtThrd.notifyAll();
                    }
                }
            }
            this._pduState = 6;
        }
        return this._pduState;
    }

    @Override
    public void drop() {
        if (this._runner != null) {
            this._evtThrd.stop();
            this._runner.interrupt();
            try {
                this._runner.join(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        super.drop();
    }

    @Override
    public void beginRequest() {
        this.close(false);
        this.setState(2);
    }
}

