/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.jdbc.Convert;
import com.sybase.jdbc4.jdbc.ErrorMessage;
import com.sybase.jdbc4.tds.CachedTdsInt;
import com.sybase.jdbc4.tds.TdsDataObject;
import com.sybase.jdbc4.tds.TdsProtocolContext;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.SQLWarning;

public class TdsInt
extends TdsDataObject {
    long _value;
    byte[] _valueAsBytes;

    public TdsInt(TdsProtocolContext tdsProtocolContext) throws IOException {
        super(tdsProtocolContext);
    }

    @Override
    protected TdsDataObject createCachedCopy() throws IOException, SQLException {
        return new CachedTdsInt(this);
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        this.doRead();
        BigDecimal bigDecimal = null;
        if (!this._isNull) {
            bigDecimal = new BigDecimal(this._value);
        }
        bigDecimal = Convert.setScale(bigDecimal, n);
        return bigDecimal;
    }

    @Override
    public boolean getBoolean() throws SQLException {
        this.doRead();
        return 0L != this._value;
    }

    @Override
    public byte getByte() throws SQLException {
        this.doRead();
        Convert.checkByteOflo(this._value);
        return (byte)this._value;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        this.doReadAsBytes();
        return this._valueAsBytes;
    }

    @Override
    public double getDouble() throws SQLException {
        this.doRead();
        return this._value;
    }

    @Override
    public float getFloat() throws SQLException {
        this.doRead();
        return this._value;
    }

    @Override
    public int getInt() throws SQLException {
        this.doRead();
        Convert.checkIntOflo(this._value);
        return (int)this._value;
    }

    @Override
    public long getLong() throws SQLException {
        this.doRead();
        return this._value;
    }

    @Override
    public short getShort() throws SQLException {
        this.doRead();
        Convert.checkShortOflo(this._value);
        return (short)this._value;
    }

    @Override
    public Object getObject() throws SQLException {
        this.doRead();
        Number number = null;
        if (!this._isNull) {
            number = this._dataLength == 8 ? (Number)new Long(this._value) : (Number)new Integer((int)this._value);
        }
        return number;
    }

    @Override
    public String getString() throws SQLException {
        this.doRead();
        String string = null;
        if (!this._isNull) {
            string = String.valueOf(this._value);
        }
        return string;
    }

    @Override
    public void cache() throws IOException {
        this.beginRead();
    }

    @Override
    public void clear() throws IOException {
        if (this._state == 0) {
            this.getSize();
            this.skip(this._dataLength);
        }
        this.initialize();
    }

    @Override
    protected void beginReadAsBytes() throws IOException {
        this.startRead();
        switch (this._state) {
            case 1: {
                if (this._isNull) {
                    this._valueAsBytes = null;
                } else {
                    switch (this._dataFmt._datatype) {
                        case 48: {
                            this._valueAsBytes = this.readBytesForAllTypes(1);
                            break;
                        }
                        case 52: {
                            this._valueAsBytes = this.readBytesForAllTypes(2);
                            break;
                        }
                        case 65: {
                            this._valueAsBytes = this.readBytesForAllTypes(2);
                            break;
                        }
                        case 56: {
                            this._valueAsBytes = this.readBytesForAllTypes(4);
                            break;
                        }
                        case 66: {
                            this._valueAsBytes = this.readBytesForAllTypes(4);
                            break;
                        }
                        case 191: {
                            this._valueAsBytes = this.readBytesForAllTypes(8);
                            break;
                        }
                        case 68: {
                            this._valueAsBytes = this.readUINTNAsBytes();
                            break;
                        }
                        case 38: {
                            this._valueAsBytes = this.readINTNAsBytes();
                            break;
                        }
                        default: {
                            ErrorMessage.raiseIOException("JZ0TC");
                        }
                    }
                }
                this._state = 4;
            }
        }
    }

    @Override
    protected void beginRead() throws IOException {
        this.startRead();
        switch (this._state) {
            case 1: {
                if (this._isNull) {
                    this._value = 0L;
                } else {
                    switch (this._dataFmt._datatype) {
                        case 48: {
                            this._value = this.readUnsignedByte();
                            break;
                        }
                        case 52: {
                            this._value = this.readShort();
                            break;
                        }
                        case 65: {
                            this._value = this.readUnsignedShortAsInt();
                            break;
                        }
                        case 56: {
                            this._value = this.readInt();
                            break;
                        }
                        case 66: {
                            this._value = this.readUnsignedIntAsLong();
                            break;
                        }
                        case 191: {
                            this._value = this.readLong();
                            break;
                        }
                        case 68: {
                            this._value = this.readUINTN();
                            break;
                        }
                        case 38: {
                            this._value = this.readINTN();
                            break;
                        }
                        default: {
                            ErrorMessage.raiseIOException("JZ0TC");
                        }
                    }
                }
                this._state = 3;
                break;
            }
            case 4: {
                if (this._isNull) {
                    this._value = 0L;
                } else {
                    try {
                        switch (this._dataFmt._datatype) {
                            case 38: 
                            case 48: 
                            case 52: 
                            case 56: 
                            case 65: 
                            case 66: 
                            case 68: 
                            case 191: {
                                this._value = Convert.bufToLong(this._valueAsBytes);
                                break;
                            }
                            default: {
                                ErrorMessage.raiseIOException("JZ0TC");
                                break;
                            }
                        }
                    }
                    catch (SQLException sQLException) {
                        ErrorMessage.raiseIOException("JZ0TC", sQLException.getMessage(), sQLException.getCause());
                    }
                }
                this._state = 3;
                break;
            }
        }
    }

    @Override
    public NClob getInitializedNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLWarning getWarning() throws SQLException {
        return super.getWarning();
    }

    @Override
    public void clearWarning() throws SQLException {
        super.clearWarning();
    }
}

