/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.Host;
import io.mola.galimatias.URL;
import io.mola.galimatias.URLParsingSettings;
import io.mola.galimatias.URLUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

final class URLParser {
    private final URL base;
    private final String input;
    private final URL url;
    private final ParseURLState stateOverride;
    private URLParsingSettings settings;
    private int startIdx;
    private int endIdx;
    private int idx;
    private boolean isEOF;
    private int c;

    public URLParser(String input) {
        this(null, input, null, null);
    }

    public URLParser(URL base, String input) {
        this(base, input, null, null);
    }

    public URLParser(String input, URL url, ParseURLState stateOverride) {
        this(null, input, url, stateOverride);
    }

    public URLParser(URL base, String input, URL url, ParseURLState stateOverride) {
        this.base = base;
        this.input = input;
        this.url = url;
        this.stateOverride = stateOverride;
        this.settings = URLParsingSettings.create();
    }

    public URLParser settings(URLParsingSettings settings) {
        this.settings = settings;
        return this;
    }

    private void setIdx(int i) {
        this.idx = i;
        this.isEOF = i >= this.endIdx;
        this.c = this.isEOF || this.idx < this.startIdx ? 0 : this.input.codePointAt(i);
    }

    private void incIdx() {
        int charCount = Character.charCount(this.c);
        this.setIdx(this.idx + charCount);
    }

    private void decrIdx() {
        if (this.idx <= this.startIdx) {
            this.setIdx(this.idx - 1);
            return;
        }
        int charCount = Character.charCount(this.input.codePointBefore(this.idx));
        this.setIdx(this.idx - charCount);
    }

    private char at(int i) {
        if (i >= this.endIdx) {
            return '\u0000';
        }
        return this.input.charAt(i);
    }

    private void error(String message, int pos) throws GalimatiasParseException {
        this.settings.errorHandler().error(new GalimatiasParseException(message, pos));
    }

    private void fatalError(String message, int pos) throws GalimatiasParseException {
        GalimatiasParseException exception = new GalimatiasParseException(message, pos);
        this.settings.errorHandler().fatalError(exception);
        throw exception;
    }

    private void fatalError(String message, int pos, Exception cause) throws GalimatiasParseException {
        GalimatiasParseException exception = new GalimatiasParseException(message, pos, cause);
        this.settings.errorHandler().fatalError(exception);
        throw exception;
    }

    public URL parse() throws GalimatiasParseException {
        if (this.input == null) {
            throw new NullPointerException("null input");
        }
        StringBuilder buffer = new StringBuilder(this.input.length() * 2);
        String encodingOverride = "utf-8";
        String scheme = this.url == null ? null : this.url.scheme();
        StringBuilder schemeData = this.url == null ? new StringBuilder() : new StringBuilder(this.url.schemeData());
        String username = this.url == null ? null : this.url.username();
        String password = this.url == null ? null : this.url.password();
        Host host = this.url == null ? null : this.url.host();
        int port = this.url == null ? -1 : this.url.port();
        boolean relativeFlag = this.url != null && this.url.isHierarchical();
        boolean atFlag = false;
        boolean bracketsFlag = false;
        List<String> pathSegments = this.url == null || this.stateOverride == ParseURLState.RELATIVE_PATH_START ? new ArrayList<String>() : this.url.pathSegments();
        StringBuilder query = this.url == null || this.url.query() == null || this.stateOverride == ParseURLState.QUERY ? null : new StringBuilder(this.url.query());
        StringBuilder fragment = this.url == null || this.url.fragment() == null || this.stateOverride == ParseURLState.FRAGMENT ? null : new StringBuilder(this.url.fragment());
        StringBuilder usernameBuffer = new StringBuilder(buffer.length());
        StringBuilder passwordBuffer = null;
        this.endIdx = this.input.length();
        this.setIdx(this.startIdx);
        while (Character.isWhitespace(this.c)) {
            this.incIdx();
            ++this.startIdx;
        }
        while (this.endIdx > this.startIdx && Character.isWhitespace(this.input.charAt(this.endIdx - 1))) {
            --this.endIdx;
        }
        ParseURLState state = this.stateOverride == null ? ParseURLState.SCHEME_START : this.stateOverride;
        boolean terminate = false;
        while (!terminate && this.idx <= this.endIdx) {
            switch (state) {
                case SCHEME_START: {
                    if (URLUtils.isASCIIAlpha(this.c)) {
                        buffer.appendCodePoint(Character.toLowerCase(this.c));
                        state = ParseURLState.SCHEME;
                        break;
                    }
                    if (this.stateOverride == null) {
                        state = ParseURLState.NO_SCHEME;
                        this.decrIdx();
                        break;
                    }
                    this.fatalError("Scheme must start with alpha character.", this.idx);
                    break;
                }
                case SCHEME: {
                    if (URLUtils.isASCIIAlphanumeric(this.c) || this.c == 43 || this.c == 45 || this.c == 46) {
                        buffer.appendCodePoint(Character.toLowerCase(this.c));
                        break;
                    }
                    if (this.c == 58) {
                        scheme = buffer.toString();
                        buffer.setLength(0);
                        if (this.stateOverride != null) {
                            terminate = true;
                            break;
                        }
                        relativeFlag = URLUtils.isRelativeScheme(scheme);
                        if ("file".equals(scheme)) {
                            state = ParseURLState.RELATIVE;
                            break;
                        }
                        if (relativeFlag && this.base != null && this.base.scheme().equals(scheme)) {
                            state = ParseURLState.RELATIVE_OR_AUTHORITY;
                            break;
                        }
                        if (relativeFlag) {
                            state = ParseURLState.AUTHORITY_FIRST_SLASH;
                            break;
                        }
                        state = ParseURLState.SCHEME_DATA;
                        break;
                    }
                    if (this.stateOverride == null) {
                        buffer.setLength(0);
                        state = ParseURLState.NO_SCHEME;
                        this.idx = -1;
                        break;
                    }
                    if (this.isEOF) {
                        terminate = true;
                        break;
                    }
                    this.fatalError("Illegal character in scheme", this.idx);
                    break;
                }
                case SCHEME_DATA: {
                    if (this.c == 63) {
                        query = new StringBuilder();
                        state = ParseURLState.QUERY;
                        break;
                    }
                    if (this.c == 35) {
                        fragment = new StringBuilder();
                        state = ParseURLState.FRAGMENT;
                        break;
                    }
                    if (!this.isEOF && this.c != 37 && !URLUtils.isURLCodePoint(this.c)) {
                        this.error("Illegal character in scheme data: not a URL code point", this.idx);
                    }
                    if (this.c == 37) {
                        if (!URLUtils.isASCIIHexDigit(this.at(this.idx + 1)) || !URLUtils.isASCIIHexDigit(this.at(this.idx + 2))) {
                            this.error("Percentage (\"%\") is not followed by two hexadecimal digits", this.idx);
                        } else {
                            schemeData.append((char)this.c).append(Character.toUpperCase(this.input.charAt(this.idx + 1))).append(Character.toUpperCase(this.input.charAt(this.idx + 2)));
                            this.setIdx(this.idx + 2);
                            break;
                        }
                    }
                    if (this.isEOF || this.c == 9 || this.c == 10 || this.c == 13) break;
                    this.utf8PercentEncode(this.c, EncodeSet.SIMPLE, schemeData);
                    break;
                }
                case NO_SCHEME: {
                    if (this.base == null || !URLUtils.isRelativeScheme(this.base.scheme())) {
                        this.fatalError("Missing scheme", this.idx);
                    }
                    state = ParseURLState.RELATIVE;
                    --this.idx;
                    break;
                }
                case RELATIVE_OR_AUTHORITY: {
                    if (this.c == 47 && this.at(this.idx + 1) == '/') {
                        state = ParseURLState.AUTHORITY_IGNORE_SLASHES;
                        ++this.idx;
                        break;
                    }
                    this.error("Relative scheme (" + scheme + ") is not followed by \"://\"", this.idx);
                    state = ParseURLState.RELATIVE;
                    --this.idx;
                    break;
                }
                case RELATIVE: {
                    relativeFlag = true;
                    if (!"file".equals(scheme)) {
                        String string = scheme = this.base == null ? null : this.base.scheme();
                    }
                    if (this.isEOF) {
                        host = this.base == null ? null : this.base.host();
                        port = this.base == null || this.base.port() == this.base.defaultPort() ? -1 : this.base.port();
                        pathSegments = this.base == null ? null : this.base.pathSegments();
                        query = this.base == null || this.base.query() == null ? null : new StringBuilder(this.base.query());
                        break;
                    }
                    if (this.c == 47 || this.c == 92) {
                        if (this.c == 92) {
                            this.error("Backslash (\"\\\") used as path segment delimiter", this.idx);
                        }
                        state = ParseURLState.RELATIVE_SLASH;
                        break;
                    }
                    if (this.c == 63) {
                        host = this.base == null ? null : this.base.host();
                        port = this.base == null || this.base.port() == this.base.defaultPort() ? -1 : this.base.port();
                        pathSegments = this.base == null ? null : this.base.pathSegments();
                        query = new StringBuilder();
                        state = ParseURLState.QUERY;
                        break;
                    }
                    if (this.c == 35) {
                        host = this.base == null ? null : this.base.host();
                        port = this.base == null || this.base.port() == this.base.defaultPort() ? -1 : this.base.port();
                        pathSegments = this.base == null ? null : this.base.pathSegments();
                        query = this.base == null || this.base.query() == null ? null : new StringBuilder(this.base.query());
                        fragment = new StringBuilder();
                        state = ParseURLState.FRAGMENT;
                        break;
                    }
                    if (!"file".equals(scheme) || !URLUtils.isASCIIAlpha(this.c) || this.at(this.idx + 1) != ':' && this.at(this.idx + 1) != '|' || this.idx + 1 == this.endIdx - 1 || this.idx + 2 < this.endIdx && this.at(this.idx + 2) != '/' && this.at(this.idx + 2) != '\\' && this.at(this.idx + 2) != '?' && this.at(this.idx + 2) != '#') {
                        host = this.base == null ? null : this.base.host();
                        port = this.base == null || this.base.port() == this.base.defaultPort() ? -1 : this.base.port();
                        List<Object> list = pathSegments = this.base == null ? new ArrayList() : this.base.pathSegments();
                        if (!pathSegments.isEmpty()) {
                            pathSegments.remove(pathSegments.size() - 1);
                        }
                    }
                    state = ParseURLState.RELATIVE_PATH;
                    --this.idx;
                    break;
                }
                case RELATIVE_SLASH: {
                    if (this.c == 47 || this.c == 92) {
                        if (this.c == 92) {
                            this.error("Backslash (\"\\\") used as path segment delimiter", this.idx);
                        }
                        if ("file".equals(scheme)) {
                            state = ParseURLState.FILE_HOST;
                            break;
                        }
                        state = ParseURLState.AUTHORITY_IGNORE_SLASHES;
                        break;
                    }
                    if (!"file".equals(scheme)) {
                        host = this.base == null ? null : this.base.host();
                        port = this.base == null || this.base.port() == this.base.defaultPort() ? -1 : this.base.port();
                    }
                    state = ParseURLState.RELATIVE_PATH;
                    --this.idx;
                    break;
                }
                case AUTHORITY_FIRST_SLASH: {
                    if (this.c == 47) {
                        state = ParseURLState.AUTHORITY_SECOND_SLASH;
                        break;
                    }
                    this.error("Expected a slash (\"/\")", this.idx);
                    state = ParseURLState.AUTHORITY_IGNORE_SLASHES;
                    this.decrIdx();
                    break;
                }
                case AUTHORITY_SECOND_SLASH: {
                    if (this.c == 47) {
                        state = ParseURLState.AUTHORITY_IGNORE_SLASHES;
                        break;
                    }
                    this.error("Expected a slash (\"/\")", this.idx);
                    state = ParseURLState.AUTHORITY_IGNORE_SLASHES;
                    this.decrIdx();
                    break;
                }
                case AUTHORITY_IGNORE_SLASHES: {
                    if (this.c != 47 && this.c != 92) {
                        state = ParseURLState.AUTHORITY;
                        this.decrIdx();
                        break;
                    }
                    this.error("Unexpected slash or backslash", this.idx);
                    break;
                }
                case AUTHORITY: {
                    if (this.c == 64) {
                        if (atFlag) {
                            this.error("User or password contains an at symbol (\"@\") not percent-encoded", this.idx);
                            buffer.insert(0, "%40");
                        }
                        atFlag = true;
                        for (int i = 0; i < buffer.length(); ++i) {
                            char otherChar = buffer.charAt(i);
                            if (otherChar == '\t' || otherChar == '\n' || otherChar == '\r') {
                                this.error("Tab, new line or carriage return found", this.idx);
                                continue;
                            }
                            if (!URLUtils.isURLCodePoint(otherChar) && otherChar != '%') {
                                this.error("Illegal character in user or password: not a URL code point", this.idx);
                            }
                            if (otherChar == '%') {
                                if (i + 2 >= buffer.length() || !URLUtils.isASCIIHexDigit(buffer.charAt(i + 1)) || !URLUtils.isASCIIHexDigit(buffer.charAt(i + 2))) {
                                    this.error("Percentage (\"%\") is not followed by two hexadecimal digits", this.idx);
                                } else if (URLUtils.isASCIIHexDigit(buffer.charAt(i + 1)) && URLUtils.isASCIIHexDigit(buffer.charAt(i + 2))) {
                                    buffer.setCharAt(i + 1, Character.toUpperCase(buffer.charAt(i + 1)));
                                    buffer.setCharAt(i + 2, Character.toUpperCase(buffer.charAt(i + 2)));
                                }
                            }
                            if (otherChar == ':' && passwordBuffer == null) {
                                passwordBuffer = new StringBuilder(buffer.length() - i);
                                continue;
                            }
                            if (passwordBuffer != null) {
                                this.utf8PercentEncode(otherChar, EncodeSet.DEFAULT, passwordBuffer);
                                continue;
                            }
                            this.utf8PercentEncode(otherChar, EncodeSet.DEFAULT, usernameBuffer);
                        }
                        buffer.setLength(0);
                        break;
                    }
                    if (this.isEOF || this.c == 47 || this.c == 92 || this.c == 63 || this.c == 35) {
                        this.setIdx(this.idx - buffer.length() - 1);
                        if (atFlag) {
                            username = usernameBuffer.toString();
                            if (passwordBuffer != null) {
                                password = passwordBuffer.toString();
                            }
                        }
                        buffer.setLength(0);
                        state = ParseURLState.HOST;
                        break;
                    }
                    buffer.appendCodePoint(this.c);
                    break;
                }
                case FILE_HOST: {
                    if (this.isEOF || this.c == 47 || this.c == 92 || this.c == 63 || this.c == 35) {
                        --this.idx;
                        if (buffer.length() == 2 && URLUtils.isASCIIAlpha(buffer.charAt(0)) && (buffer.charAt(1) == ':' || buffer.charAt(1) == '|')) {
                            state = ParseURLState.RELATIVE_PATH;
                            break;
                        }
                        if (buffer.length() == 0) {
                            state = ParseURLState.RELATIVE_PATH_START;
                            break;
                        }
                        try {
                            host = Host.parseHost(buffer.toString());
                        }
                        catch (GalimatiasParseException ex) {
                            this.fatalError("Invalid host: " + ex.getMessage(), this.idx, ex);
                        }
                        buffer.setLength(0);
                        state = ParseURLState.RELATIVE_PATH_START;
                        break;
                    }
                    if (this.c == 9 || this.c == 10 || this.c == 13) {
                        this.error("Tab, new line or carriage return found", this.idx);
                        break;
                    }
                    buffer.appendCodePoint(this.c);
                    break;
                }
                case HOST: {
                    if (this.c == 58 && !bracketsFlag) {
                        try {
                            host = Host.parseHost(buffer.toString());
                        }
                        catch (GalimatiasParseException ex) {
                            this.fatalError("Invalid host: " + ex.getMessage(), this.idx, ex);
                        }
                        buffer.setLength(0);
                        state = ParseURLState.PORT;
                        if (this.stateOverride != ParseURLState.HOST) break;
                        terminate = true;
                        break;
                    }
                    if (this.isEOF || this.c == 47 || this.c == 92 || this.c == 63 || this.c == 35) {
                        this.decrIdx();
                        try {
                            host = Host.parseHost(buffer.toString());
                        }
                        catch (GalimatiasParseException ex) {
                            this.fatalError("Invalid host: " + ex.getMessage(), this.idx, ex);
                        }
                        buffer.setLength(0);
                        state = ParseURLState.RELATIVE_PATH_START;
                        if (this.stateOverride == null) break;
                        terminate = true;
                        break;
                    }
                    if (this.c == 9 || this.c == 10 || this.c == 13) {
                        this.error("Tab, new line or carriage return found", this.idx);
                        break;
                    }
                    if (this.c == 91) {
                        bracketsFlag = true;
                    } else if (this.c == 93) {
                        bracketsFlag = false;
                    }
                    buffer.appendCodePoint(this.c);
                    break;
                }
                case PORT: {
                    if (URLUtils.isASCIIDigit(this.c)) {
                        buffer.appendCodePoint(this.c);
                        break;
                    }
                    if (this.isEOF || this.c == 47 || this.c == 92 || this.c == 63 || this.c == 35) {
                        while (buffer.length() > 0 && buffer.charAt(0) == '0' && buffer.length() > 1) {
                            buffer.deleteCharAt(0);
                        }
                        if (buffer.toString().equals(URLUtils.getDefaultPortForScheme(scheme))) {
                            buffer.setLength(0);
                        }
                        port = buffer.length() == 0 ? -1 : Integer.parseInt(buffer.toString());
                        if (this.stateOverride != null) {
                            terminate = true;
                            break;
                        }
                        buffer.setLength(0);
                        state = ParseURLState.RELATIVE_PATH_START;
                        --this.idx;
                        break;
                    }
                    if (this.c == 9 || this.c == 10 || this.c == 13) {
                        this.error("Tab, new line or carriage return found", this.idx);
                        break;
                    }
                    this.fatalError("Illegal character in port", this.idx);
                    break;
                }
                case RELATIVE_PATH_START: {
                    if (this.c == 92) {
                        this.error("Backslash (\"\\\") used as path segment delimiter", this.idx);
                    }
                    state = ParseURLState.RELATIVE_PATH;
                    if (this.c == 47 || this.c == 92) break;
                    this.decrIdx();
                    break;
                }
                case RELATIVE_PATH: {
                    if (this.isEOF || this.c == 47 || this.c == 92 || this.stateOverride == null && (this.c == 63 || this.c == 35)) {
                        String lowerCasedBuffer;
                        if (this.c == 92) {
                            this.error("Backslash (\"\\\") used as path segment delimiter", this.idx);
                        }
                        if ("%2e".equals(lowerCasedBuffer = buffer.toString().toLowerCase(Locale.ENGLISH))) {
                            buffer.setLength(0);
                            buffer.append('.');
                        } else if (".%2e".equals(lowerCasedBuffer) || "%2e.".equals(lowerCasedBuffer) || "%2e%2e".equals(lowerCasedBuffer)) {
                            buffer.setLength(0);
                            buffer.append("..");
                        }
                        if ("..".equals(buffer.toString())) {
                            if (!pathSegments.isEmpty()) {
                                pathSegments.remove(pathSegments.size() - 1);
                            }
                            if (this.c != 47 && this.c != 92) {
                                pathSegments.add("");
                            }
                        } else if (".".equals(buffer.toString()) && this.c != 47 && this.c != 92) {
                            pathSegments.add("");
                        } else if (!".".equals(buffer.toString())) {
                            if ("file".equals(scheme) && pathSegments.isEmpty() && buffer.length() == 2 && URLUtils.isASCIIAlpha(buffer.charAt(0)) && buffer.charAt(1) == '|') {
                                buffer.setCharAt(1, ':');
                            }
                            pathSegments.add(buffer.toString());
                        }
                        buffer.setLength(0);
                        if (this.c == 63) {
                            query = new StringBuilder();
                            state = ParseURLState.QUERY;
                            break;
                        }
                        if (this.c != 35) break;
                        fragment = new StringBuilder();
                        state = ParseURLState.FRAGMENT;
                        break;
                    }
                    if (this.c == 9 || this.c == 10 || this.c == 13) {
                        this.error("Tab, new line or carriage return found", this.idx);
                        break;
                    }
                    if (!URLUtils.isURLCodePoint(this.c) && this.c != 37) {
                        this.error("Illegal character in path segment: not a URL code point", this.idx);
                    }
                    if (this.c == 37) {
                        if (!URLUtils.isASCIIHexDigit(this.at(this.idx + 1)) || !URLUtils.isASCIIHexDigit(this.at(this.idx + 2))) {
                            this.error("Percentage (\"%\") is not followed by two hexadecimal digits", this.idx);
                        } else {
                            buffer.append((char)this.c).append(Character.toUpperCase(this.input.charAt(this.idx + 1))).append(Character.toUpperCase(this.input.charAt(this.idx + 2)));
                            this.setIdx(this.idx + 2);
                            break;
                        }
                    }
                    this.utf8PercentEncode(this.c, EncodeSet.DEFAULT, buffer);
                    break;
                }
                case QUERY: {
                    if (query == null) {
                        query = new StringBuilder();
                    }
                    if (this.isEOF || this.stateOverride == null && this.c == 35) {
                        if (relativeFlag) {
                            encodingOverride = "utf-8";
                        }
                        byte[] bytes = buffer.toString().getBytes(URLUtils.UTF_8);
                        for (int i = 0; i < bytes.length; ++i) {
                            byte b = bytes[i];
                            if (b < 33 || b > 126 || b == 34 || b == 35 || b == 60 || b == 62 || b == 96) {
                                URLUtils.percentEncode(b, query);
                                continue;
                            }
                            query.append((char)b);
                        }
                        buffer.setLength(0);
                        if (this.c != 35) break;
                        fragment = new StringBuilder();
                        state = ParseURLState.FRAGMENT;
                        break;
                    }
                    if (this.c == 9 || this.c == 10 || this.c == 13) {
                        this.error("Tab, new line or carriage return found", this.idx);
                        break;
                    }
                    if (!URLUtils.isURLCodePoint(this.c) && this.c != 37) {
                        this.error("Illegal character in query: not a URL code point", this.idx);
                    }
                    if (this.c == 37) {
                        if (!URLUtils.isASCIIHexDigit(this.at(this.idx + 1)) || !URLUtils.isASCIIHexDigit(this.at(this.idx + 2))) {
                            this.error("Percentage (\"%\") is not followed by two hexadecimal digits", this.idx);
                        } else {
                            buffer.append((char)this.c).append(Character.toUpperCase(this.input.charAt(this.idx + 1))).append(Character.toUpperCase(this.input.charAt(this.idx + 2)));
                            this.setIdx(this.idx + 2);
                            break;
                        }
                    }
                    buffer.appendCodePoint(this.c);
                    break;
                }
                case FRAGMENT: {
                    if (fragment == null) {
                        fragment = new StringBuilder();
                    }
                    if (this.isEOF) break;
                    if (this.c == 9 || this.c == 10 || this.c == 13) {
                        this.error("Tab, new line or carriage return found", this.idx);
                        break;
                    }
                    if (!URLUtils.isURLCodePoint(this.c) && this.c != 37) {
                        this.error("Illegal character in fragment: not a URL code point", this.idx);
                    }
                    if (this.c == 37) {
                        if (!URLUtils.isASCIIHexDigit(this.at(this.idx + 1)) || !URLUtils.isASCIIHexDigit(this.at(this.idx + 2))) {
                            this.error("Percentage (\"%\") is not followed by two hexadecimal digits", this.idx);
                        } else {
                            fragment.append((char)this.c).append(Character.toUpperCase(this.input.charAt(this.idx + 1))).append(Character.toUpperCase(this.input.charAt(this.idx + 2)));
                            this.setIdx(this.idx + 2);
                            break;
                        }
                    }
                    this.utf8PercentEncode(this.c, EncodeSet.SIMPLE, fragment);
                }
            }
            if (this.idx == -1) {
                this.setIdx(this.startIdx);
                continue;
            }
            this.incIdx();
        }
        return new URL(scheme, schemeData.toString(), username, password, host, port, pathSegments, query == null ? null : query.toString(), fragment == null ? null : fragment.toString(), relativeFlag);
    }

    String parseUsername() {
        StringBuilder buffer = new StringBuilder(this.input.length() * 2);
        this.startIdx = 0;
        this.endIdx = this.input.length();
        this.setIdx(0);
        while (!this.isEOF) {
            this.utf8PercentEncode(this.c, EncodeSet.USERNAME, buffer);
            this.incIdx();
        }
        return buffer.toString();
    }

    String parsePassword() {
        StringBuilder buffer = new StringBuilder(this.input.length() * 2);
        this.startIdx = 0;
        this.endIdx = this.input.length();
        this.setIdx(0);
        while (!this.isEOF) {
            this.utf8PercentEncode(this.c, EncodeSet.PASSWORD, buffer);
            this.incIdx();
        }
        return buffer.toString();
    }

    private void utf8PercentEncode(int c, EncodeSet encodeSet, StringBuilder buffer) {
        byte[] bytes;
        if (encodeSet != null) {
            switch (encodeSet) {
                case SIMPLE: {
                    if (this.isInSimpleEncodeSet(c)) break;
                    buffer.appendCodePoint(c);
                    return;
                }
                case DEFAULT: {
                    if (this.isInDefaultEncodeSet(c)) break;
                    buffer.appendCodePoint(c);
                    return;
                }
                case PASSWORD: {
                    if (this.isInPasswordEncodeSet(c)) break;
                    buffer.appendCodePoint(c);
                    return;
                }
                case USERNAME: {
                    if (this.isInUsernameEncodeSet(c)) break;
                    buffer.appendCodePoint(c);
                    return;
                }
            }
        }
        for (byte b : bytes = new String(Character.toChars(c)).getBytes(URLUtils.UTF_8)) {
            URLUtils.percentEncode(b, buffer);
        }
    }

    private boolean isInSimpleEncodeSet(int c) {
        return c < 32 || c > 126;
    }

    private boolean isInDefaultEncodeSet(int c) {
        return this.isInSimpleEncodeSet(c) || c == 32 || c == 34 || c == 35 || c == 60 || c == 62 || c == 63 || c == 96;
    }

    private boolean isInPasswordEncodeSet(int c) {
        return this.isInDefaultEncodeSet(c) || c == 47 || c == 64 || c == 92;
    }

    private boolean isInUsernameEncodeSet(int c) {
        return this.isInPasswordEncodeSet(c) || c == 58;
    }

    private static enum EncodeSet {
        SIMPLE,
        DEFAULT,
        PASSWORD,
        USERNAME;

    }

    public static enum ParseURLState {
        SCHEME_START,
        SCHEME,
        SCHEME_DATA,
        NO_SCHEME,
        RELATIVE_OR_AUTHORITY,
        RELATIVE,
        RELATIVE_SLASH,
        AUTHORITY_FIRST_SLASH,
        AUTHORITY_SECOND_SLASH,
        AUTHORITY_IGNORE_SLASHES,
        AUTHORITY,
        FILE_HOST,
        HOST,
        PORT,
        RELATIVE_PATH_START,
        RELATIVE_PATH,
        QUERY,
        FRAGMENT;

    }
}

