/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias.canonicalize;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.URL;
import io.mola.galimatias.URLUtils;
import io.mola.galimatias.canonicalize.URLCanonicalizer;

public class RFC3986Canonicalizer
implements URLCanonicalizer {
    @Override
    public URL canonicalize(URL input) throws GalimatiasParseException {
        String fragment;
        String query;
        String path;
        String pass;
        URL result = input;
        String user = input.username();
        if (user != null && !user.isEmpty()) {
            int c;
            StringBuilder newUser = new StringBuilder();
            int length = user.length();
            for (int offset = 0; offset < length; offset += Character.charCount(c)) {
                byte[] bytes;
                c = user.codePointAt(offset);
                if (c == 37 && user.length() > offset + 2 && URLUtils.isASCIIHexDigit(user.charAt(offset + 1)) && URLUtils.isASCIIHexDigit(user.charAt(offset + 2))) {
                    newUser.append((char)c);
                    continue;
                }
                if (this.isUserInfo(c)) {
                    newUser.append((char)c);
                    continue;
                }
                for (byte b : bytes = new String(Character.toChars(c)).getBytes(URLUtils.UTF_8)) {
                    URLUtils.percentEncode(b, newUser);
                }
            }
            result = input.withUsername(newUser.toString());
        }
        if ((pass = input.password()) != null && !pass.isEmpty()) {
            int c;
            StringBuilder newPass = new StringBuilder();
            int length = pass.length();
            for (int offset = 0; offset < length; offset += Character.charCount(c)) {
                byte[] bytes;
                c = pass.codePointAt(offset);
                if (c == 37 && pass.length() > offset + 2 && URLUtils.isASCIIHexDigit(pass.charAt(offset + 1)) && URLUtils.isASCIIHexDigit(pass.charAt(offset + 2))) {
                    newPass.append((char)c);
                    continue;
                }
                if (this.isUserInfo(c)) {
                    newPass.append((char)c);
                    continue;
                }
                for (byte b : bytes = new String(Character.toChars(c)).getBytes(URLUtils.UTF_8)) {
                    URLUtils.percentEncode(b, newPass);
                }
            }
            result = input.withPassword(newPass.toString());
        }
        if ((path = input.path()) != null) {
            int c;
            StringBuilder newPath = new StringBuilder();
            int length = path.length();
            for (int offset = 0; offset < length; offset += Character.charCount(c)) {
                byte[] bytes;
                c = path.codePointAt(offset);
                if (c == 37 && path.length() > offset + 2 && URLUtils.isASCIIHexDigit(path.charAt(offset + 1)) && URLUtils.isASCIIHexDigit(path.charAt(offset + 2))) {
                    newPath.append((char)c);
                    continue;
                }
                if (this.isPChar(c) || c == 47) {
                    newPath.append((char)c);
                    continue;
                }
                for (byte b : bytes = new String(Character.toChars(c)).getBytes(URLUtils.UTF_8)) {
                    URLUtils.percentEncode(b, newPath);
                }
            }
            result = input.withPath(newPath.toString());
        }
        if ((query = input.query()) != null) {
            int c;
            StringBuilder newQuery = new StringBuilder();
            int length = query.length();
            for (int offset = 0; offset < length; offset += Character.charCount(c)) {
                byte[] bytes;
                c = query.codePointAt(offset);
                if (c == 37 && query.length() > offset + 2 && URLUtils.isASCIIHexDigit(query.charAt(offset + 1)) && URLUtils.isASCIIHexDigit(query.charAt(offset + 2))) {
                    newQuery.append((char)c);
                    continue;
                }
                if (this.isPChar(c) || c == 47 || c == 63) {
                    newQuery.append((char)c);
                    continue;
                }
                for (byte b : bytes = new String(Character.toChars(c)).getBytes(URLUtils.UTF_8)) {
                    URLUtils.percentEncode(b, newQuery);
                }
            }
            result = input.withQuery(newQuery.toString());
        }
        if ((fragment = input.fragment()) != null) {
            int c;
            StringBuilder newFragment = new StringBuilder();
            int length = fragment.length();
            for (int offset = 0; offset < length; offset += Character.charCount(c)) {
                byte[] bytes;
                c = fragment.codePointAt(offset);
                if (c == 37 && fragment.length() > offset + 2 && URLUtils.isASCIIHexDigit(fragment.charAt(offset + 1)) && URLUtils.isASCIIHexDigit(fragment.charAt(offset + 2))) {
                    newFragment.append((char)c);
                    continue;
                }
                if (this.isPChar(c) || c == 47 || c == 63) {
                    newFragment.append((char)c);
                    continue;
                }
                for (byte b : bytes = new String(Character.toChars(c)).getBytes(URLUtils.UTF_8)) {
                    URLUtils.percentEncode(b, newFragment);
                }
            }
            result = input.withFragment(newFragment.toString());
        }
        return result;
    }

    private boolean isUnreserved(int c) {
        return URLUtils.isASCIIAlphanumeric(c) || c == 45 || c == 46 || c == 95 || c == 126;
    }

    private boolean isSubdelim(int c) {
        return c == 33 || c == 36 || c == 38 || c == 39 || c == 40 || c == 41 || c == 42 || c == 43 || c == 44 || c == 59 || c == 61;
    }

    private boolean isPChar(int c) {
        return this.isUnreserved(c) || this.isSubdelim(c) || c == 58 || c == 64;
    }

    private boolean isUserInfo(int c) {
        return this.isUnreserved(c) || this.isSubdelim(c);
    }
}

