/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker.schematronequiv;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import nu.validator.checker.AttributeUtil;
import nu.validator.checker.Checker;
import nu.validator.checker.LocatorImpl;
import nu.validator.checker.TaintableLocatorImpl;
import nu.validator.checker.VnuBadAttrValueException;
import nu.validator.datatype.Html5DatatypeException;
import nu.validator.datatype.ImageCandidateStrings;
import nu.validator.datatype.ImageCandidateStringsWidthRequired;
import nu.validator.datatype.ImageCandidateURL;
import org.relaxng.datatype.DatatypeException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class Assertions
extends Checker {
    private static boolean followW3Cspec = "1".equals(System.getProperty("nu.validator.servlet.follow-w3c-spec"));
    private static final Map<String, String[]> INPUT_ATTRIBUTES = new HashMap<String, String[]>();
    private static final Map<String, String> OBSOLETE_ELEMENTS;
    private static final Map<String, String[]> OBSOLETE_ATTRIBUTES;
    private static final Map<String, String> OBSOLETE_ATTRIBUTES_MSG;
    private static final Map<String, String[]> OBSOLETE_STYLE_ATTRS;
    private static final String[] SPECIAL_ANCESTORS;
    private static Map<String, Integer> ANCESTOR_MASK_BY_DESCENDANT;
    private static final int A_BUTTON_MASK;
    private static final int FIGCAPTION_MASK;
    private static final int FIGURE_MASK;
    private static final int H1_MASK;
    private static final int H2_MASK;
    private static final int H3_MASK;
    private static final int H4_MASK;
    private static final int H5_MASK;
    private static final int H6_MASK;
    private static final int MAP_MASK;
    private static final int HREF_MASK = 0x40000000;
    private static final int LABEL_FOR_MASK = 0x10000000;
    private static final Map<String, Set<String>> REQUIRED_ROLE_ANCESTOR_BY_DESCENDANT;
    private static final Map<String, Set<String>> ariaOwnsIdsByRole;
    private static final Set<String> MUST_NOT_DANGLE_IDREFS;
    private static final String h1WarningMessage = "Consider using the \u201ch1\u201d element as a top-level heading only (all \u201ch1\u201d elements are treated as top-level headings by many screen readers and other tools).";
    private StackNode[] stack;
    private int currentPtr;
    private int currentSectioningDepth;
    private Map<StackNode, Locator> openSingleSelects = new HashMap<StackNode, Locator>();
    private Map<StackNode, Locator> openLabels = new HashMap<StackNode, Locator>();
    private Map<StackNode, TaintableLocatorImpl> openMediaElements = new HashMap<StackNode, TaintableLocatorImpl>();
    private Map<StackNode, Locator> openActiveDescendants = new HashMap<StackNode, Locator>();
    private LinkedHashSet<IdrefLocator> contextmenuReferences = new LinkedHashSet();
    private Set<String> menuIds = new HashSet<String>();
    private LinkedHashSet<IdrefLocator> formControlReferences = new LinkedHashSet();
    private LinkedHashSet<IdrefLocator> formElementReferences = new LinkedHashSet();
    private LinkedHashSet<IdrefLocator> needsAriaOwner = new LinkedHashSet();
    private Set<String> formControlIds = new HashSet<String>();
    private Set<String> formElementIds = new HashSet<String>();
    private LinkedHashSet<IdrefLocator> listReferences = new LinkedHashSet();
    private Set<String> listIds = new HashSet<String>();
    private LinkedHashSet<IdrefLocator> ariaReferences = new LinkedHashSet();
    private Set<String> allIds = new HashSet<String>();
    private int currentFigurePtr;
    private int currentHeadingPtr;
    private int currentSectioningElementPtr;
    private boolean hasMain;
    private boolean hasAutofocus;
    private boolean hasTopLevelH1;
    private Set<Locator> secondLevelH1s = new HashSet<Locator>();
    private Map<Locator, Map<String, String>> siblingSources = new ConcurrentHashMap<Locator, Map<String, String>>();

    private static boolean lowerCaseLiteralEqualsIgnoreAsciiCaseString(String lowerCaseLiteral, String string) {
        if (string == null) {
            return false;
        }
        if (lowerCaseLiteral.length() != string.length()) {
            return false;
        }
        for (int i = 0; i < lowerCaseLiteral.length(); ++i) {
            char c0 = lowerCaseLiteral.charAt(i);
            char c1 = string.charAt(i);
            if (c1 >= 'A' && c1 <= 'Z') {
                c1 = (char)(c1 + 32);
            }
            if (c0 == c1) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsIgnoreAsciiCase(String one, String other) {
        if (other == null) {
            return one == null;
        }
        if (one.length() != other.length()) {
            return false;
        }
        for (int i = 0; i < one.length(); ++i) {
            char c0 = one.charAt(i);
            char c1 = other.charAt(i);
            if (c0 >= 'A' && c0 <= 'Z') {
                c0 = (char)(c0 + 32);
            }
            if (c1 >= 'A' && c1 <= 'Z') {
                c1 = (char)(c1 + 32);
            }
            if (c0 == c1) continue;
            return false;
        }
        return true;
    }

    private static final String trimSpaces(String str) {
        return Assertions.trimLeadingSpaces(Assertions.trimTrailingSpaces(str));
    }

    private static final String trimLeadingSpaces(String str) {
        if (str == null) {
            return null;
        }
        for (int i = str.length(); i > 0; --i) {
            char c = str.charAt(str.length() - i);
            if (' ' == c || '\t' == c || '\n' == c || '\f' == c || '\r' == c) continue;
            return str.substring(str.length() - i, str.length());
        }
        return "";
    }

    private static final String trimTrailingSpaces(String str) {
        if (str == null) {
            return null;
        }
        for (int i = str.length() - 1; i >= 0; --i) {
            char c = str.charAt(i);
            if (' ' == c || '\t' == c || '\n' == c || '\f' == c || '\r' == c) continue;
            return str.substring(0, i + 1);
        }
        return "";
    }

    private static int specialAncestorNumber(String name) {
        for (int i = 0; i < SPECIAL_ANCESTORS.length; ++i) {
            if (name != SPECIAL_ANCESTORS[i]) continue;
            return i;
        }
        return -1;
    }

    private static void registerProhibitedAncestor(String ancestor, String descendant) {
        int number = Assertions.specialAncestorNumber(ancestor);
        if (number == -1) {
            throw new IllegalStateException("Ancestor not found in array: " + ancestor);
        }
        Integer maskAsObject = ANCESTOR_MASK_BY_DESCENDANT.get(descendant);
        int mask = 0;
        if (maskAsObject != null) {
            mask = maskAsObject;
        }
        ANCESTOR_MASK_BY_DESCENDANT.put(descendant, new Integer(mask |= 1 << number));
    }

    private static void registerRequiredAncestorRole(String parent, String child) {
        Set<String> parents = REQUIRED_ROLE_ANCESTOR_BY_DESCENDANT.get(child);
        if (parents == null) {
            parents = new HashSet<String>();
        }
        parents.add(parent);
        REQUIRED_ROLE_ANCESTOR_BY_DESCENDANT.put(child, parents);
    }

    private void push(StackNode node) {
        ++this.currentPtr;
        if (this.currentPtr == this.stack.length) {
            StackNode[] newStack = new StackNode[this.stack.length + 64];
            System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
            this.stack = newStack;
        }
        this.stack[this.currentPtr] = node;
    }

    private StackNode pop() {
        return this.stack[this.currentPtr--];
    }

    private StackNode peek() {
        return this.stack[this.currentPtr];
    }

    private final void errContainedInOrOwnedBy(String role, Locator locator) throws SAXException {
        this.err("An element with \u201crole=" + role + "\u201d" + " must be contained in, or owned by, an element with " + this.renderRoleSet(REQUIRED_ROLE_ANCESTOR_BY_DESCENDANT.get(role)) + ".", locator);
    }

    private final void errObsoleteAttribute(String attribute, String element, String suggestion) throws SAXException {
        this.err("The \u201c" + attribute + "\u201d attribute on the \u201c" + element + "\u201d element is obsolete." + suggestion);
    }

    private final void warnPresentationalAttribute(String attribute, String element, String suggestion) throws SAXException {
        this.warn("The \u201c" + attribute + "\u201d attribute on the \u201c" + element + "\u201d element is presentational markup." + " Consider using CSS instead." + suggestion);
    }

    private boolean currentElementHasRequiredAncestorRole(Set<String> requiredAncestorRoles) {
        for (String role : requiredAncestorRoles) {
            for (int i = 0; i < this.currentPtr; ++i) {
                if (!role.equals(this.stack[this.currentPtr - i].getRole())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void endDocument() throws SAXException {
        for (IdrefLocator idrefLocator : this.contextmenuReferences) {
            if (this.menuIds.contains(idrefLocator.getIdref())) continue;
            this.err("The \u201ccontextmenu\u201d attribute must refer to a \u201cmenu\u201d element.", idrefLocator.getLocator());
        }
        for (IdrefLocator idrefLocator : this.formControlReferences) {
            if (this.formControlIds.contains(idrefLocator.getIdref())) continue;
            this.err("The \u201cfor\u201d attribute of the \u201clabel\u201d element must refer to a form control.", idrefLocator.getLocator());
        }
        for (IdrefLocator idrefLocator : this.formElementReferences) {
            if (this.formElementIds.contains(idrefLocator.getIdref())) continue;
            this.err("The \u201cform\u201d attribute must refer to a form element.", idrefLocator.getLocator());
        }
        for (IdrefLocator idrefLocator : this.listReferences) {
            if (this.listIds.contains(idrefLocator.getIdref())) continue;
            this.err("The \u201clist\u201d attribute of the \u201cinput\u201d element must refer to a \u201cdatalist\u201d element.", idrefLocator.getLocator());
        }
        for (IdrefLocator idrefLocator : this.ariaReferences) {
            if (this.allIds.contains(idrefLocator.getIdref())) continue;
            this.err("The \u201c" + idrefLocator.getAdditional() + "\u201d attribute must point to an element in the same document.", idrefLocator.getLocator());
        }
        for (IdrefLocator idrefLocator : this.needsAriaOwner) {
            boolean foundOwner = false;
            String role = idrefLocator.getAdditional();
            for (String ownerRole : REQUIRED_ROLE_ANCESTOR_BY_DESCENDANT.get(role)) {
                if (ariaOwnsIdsByRole.size() == 0 || ariaOwnsIdsByRole.get(ownerRole) == null || !ariaOwnsIdsByRole.get(ownerRole).contains(idrefLocator.getIdref())) continue;
                foundOwner = true;
                break;
            }
            if (foundOwner) continue;
            this.errContainedInOrOwnedBy(role, idrefLocator.getLocator());
        }
        if (this.hasTopLevelH1) {
            for (Locator locator : this.secondLevelH1s) {
                this.warn(h1WarningMessage, locator);
            }
        }
        this.reset();
        this.stack = null;
    }

    private static double getDoubleAttribute(Attributes atts, String name) {
        String str = atts.getValue("", name);
        if (str == null) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        StackNode node = this.pop();
        Locator locator = null;
        this.openSingleSelects.remove(node);
        this.openLabels.remove(node);
        this.openMediaElements.remove(node);
        if ("http://www.w3.org/1999/xhtml" == uri) {
            if ("figure" == localName) {
                if (node.needsFigcaption() && !node.hasFigcaptionContent() || node.hasTextNode() || node.hasEmbeddedContent()) {
                    for (Locator imgLocator : node.getImagesLackingAlt()) {
                        this.err("An \u201cimg\u201d element must have an \u201calt\u201d attribute, except under certain conditions. For details, consult guidance on providing text alternatives for images.", imgLocator);
                    }
                }
            } else if ("picture" == localName) {
                this.siblingSources.clear();
            } else if ("select" == localName && node.isOptionNeeded()) {
                if (!node.hasOption()) {
                    this.err("A \u201cselect\u201d element with a \u201crequired\u201d attribute, and without a \u201cmultiple\u201d attribute, and without a \u201csize\u201d attribute whose value is greater than \u201c1\u201d, must have a child \u201coption\u201d element.");
                }
                if (node.nonEmptyOptionLocator() != null) {
                    this.err("The first child \u201coption\u201d element of a \u201cselect\u201d element with a \u201crequired\u201d attribute, and without a \u201cmultiple\u201d attribute, and without a \u201csize\u201d attribute whose value is greater than \u201c1\u201d, must have either an empty \u201cvalue\u201d attribute, or must have no text content. Consider either adding a placeholder option label, or adding a \u201csize\u201d attribute with a value equal to the number of \u201coption\u201d elements.", node.nonEmptyOptionLocator());
                }
            } else if ("section" == localName && !node.hasHeading()) {
                this.warn("Section lacks heading. Consider using \u201ch2\u201d-\u201ch6\u201d elements to add identifying headings to all sections.", node.locator());
            } else if ("article" == localName && !node.hasHeading()) {
                this.warn("Article lacks heading. Consider using \u201ch2\u201d-\u201ch6\u201d elements to add identifying headings to all articles.", node.locator());
            } else if (!("h1" != localName && "h2" != localName && "h3" != localName && "h4" != localName && "h5" != localName && "h6" != localName || node.hasTextNode() || node.hasImg())) {
                this.warn("Empty heading.", node.locator());
            } else if ("option" == localName && !this.stack[this.currentPtr].hasOption()) {
                this.stack[this.currentPtr].setOptionFound();
            }
            if ("article" == localName || "aside" == localName || "nav" == localName || "section" == localName) {
                this.currentSectioningElementPtr = -1;
                --this.currentSectioningDepth;
            }
        }
        if ((locator = this.openActiveDescendants.remove(node)) != null) {
            this.warn("Attribute \u201caria-activedescendant\u201d value should either refer to a descendant element, or should be accompanied by attribute \u201caria-owns\u201d.", locator);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.reset();
        this.stack = new StackNode[32];
        this.currentPtr = 0;
        this.currentFigurePtr = -1;
        this.currentHeadingPtr = -1;
        this.currentSectioningElementPtr = -1;
        this.currentSectioningDepth = 0;
        this.stack[0] = null;
        this.hasMain = false;
        this.hasTopLevelH1 = false;
    }

    @Override
    public void reset() {
        this.openSingleSelects.clear();
        this.openLabels.clear();
        this.openMediaElements.clear();
        this.openActiveDescendants.clear();
        this.contextmenuReferences.clear();
        this.menuIds.clear();
        ariaOwnsIdsByRole.clear();
        this.needsAriaOwner.clear();
        this.formControlReferences.clear();
        this.formElementReferences.clear();
        this.formControlIds.clear();
        this.formElementIds.clear();
        this.listReferences.clear();
        this.listIds.clear();
        this.ariaReferences.clear();
        this.allIds.clear();
        this.siblingSources.clear();
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        HashSet<String> ids = new HashSet<String>();
        String role = null;
        String activeDescendant = null;
        String owns = null;
        String forAttr = null;
        boolean href = false;
        boolean activeDescendantWithAriaOwns = false;
        System.setProperty("nu.validator.checker.imageCandidateString.hasWidth", "0");
        StackNode parent = this.peek();
        int ancestorMask = 0;
        String parentRole = null;
        String parentName = null;
        if (parent != null) {
            ancestorMask = parent.getAncestorMask();
            parentName = parent.getName();
            parentRole = parent.getRole();
        }
        if ("http://www.w3.org/1999/xhtml" == uri) {
            String formVal;
            String forVal;
            Locator locator;
            StackNode node;
            int maskHit;
            boolean controls = false;
            boolean hidden = false;
            boolean toolbar = false;
            boolean usemap = false;
            boolean ismap = false;
            boolean selected = false;
            boolean itemid = false;
            boolean itemref = false;
            boolean itemscope = false;
            boolean itemtype = false;
            boolean languageJavaScript = false;
            boolean typeNotTextJavaScript = false;
            String xmlLang = null;
            String lang = null;
            String id = null;
            String contextmenu = null;
            String list = null;
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                String attVal;
                String attUri = atts.getURI(i);
                if (attUri.length() == 0) {
                    Object[] elementNames;
                    String attLocal = atts.getLocalName(i);
                    if ("href" == attLocal) {
                        href = true;
                    } else if ("controls" == attLocal) {
                        controls = true;
                    } else if ("type" == attLocal && "param" != localName && "ol" != localName && "ul" != localName && "li" != localName) {
                        String attValue = atts.getValue(i);
                        if (Assertions.lowerCaseLiteralEqualsIgnoreAsciiCaseString("hidden", attValue)) {
                            hidden = true;
                        } else if (Assertions.lowerCaseLiteralEqualsIgnoreAsciiCaseString("toolbar", attValue)) {
                            toolbar = true;
                        }
                        if (!Assertions.lowerCaseLiteralEqualsIgnoreAsciiCaseString("text/javascript", attValue)) {
                            typeNotTextJavaScript = true;
                        }
                    } else if ("role" == attLocal) {
                        role = atts.getValue(i);
                    } else if ("aria-activedescendant" == attLocal) {
                        activeDescendant = atts.getValue(i);
                    } else if ("aria-owns" == attLocal) {
                        owns = atts.getValue(i);
                    } else if ("list" == attLocal) {
                        list = atts.getValue(i);
                    } else if ("lang" == attLocal) {
                        lang = atts.getValue(i);
                    } else if ("id" == attLocal) {
                        id = atts.getValue(i);
                    } else if ("for" == attLocal && "label" == localName) {
                        forAttr = atts.getValue(i);
                        ancestorMask |= 0x10000000;
                    } else if ("contextmenu" == attLocal) {
                        contextmenu = atts.getValue(i);
                    } else if ("ismap" == attLocal) {
                        ismap = true;
                    } else if ("selected" == attLocal) {
                        selected = true;
                    } else if ("usemap" == attLocal && "input" != localName) {
                        usemap = true;
                    } else if ("itemid" == attLocal) {
                        itemid = true;
                    } else if ("itemref" == attLocal) {
                        itemref = true;
                    } else if ("itemscope" == attLocal) {
                        itemscope = true;
                    } else if ("itemtype" == attLocal) {
                        itemtype = true;
                    } else if ("language" == attLocal && Assertions.lowerCaseLiteralEqualsIgnoreAsciiCaseString("javascript", atts.getValue(i))) {
                        languageJavaScript = true;
                    } else if ("rev" == attLocal && !"1".equals(System.getProperty("nu.validator.schema.rdfa-full"))) {
                        this.errObsoleteAttribute("rev", localName, " Use the \u201crel\u201d attribute instead, with a term having the opposite meaning.");
                    } else if (OBSOLETE_ATTRIBUTES.containsKey(attLocal) && "ol" != localName && "ul" != localName && "li" != localName) {
                        elementNames = OBSOLETE_ATTRIBUTES.get(attLocal);
                        Arrays.sort(elementNames);
                        if (Arrays.binarySearch(elementNames, localName) >= 0) {
                            String suggestion = OBSOLETE_ATTRIBUTES_MSG.containsKey(attLocal) ? " " + OBSOLETE_ATTRIBUTES_MSG.get(attLocal) : "";
                            this.errObsoleteAttribute(attLocal, localName, suggestion);
                        }
                    } else if (OBSOLETE_STYLE_ATTRS.containsKey(attLocal)) {
                        elementNames = OBSOLETE_STYLE_ATTRS.get(attLocal);
                        Arrays.sort(elementNames);
                        if (Arrays.binarySearch(elementNames, localName) >= 0) {
                            this.errObsoleteAttribute(attLocal, localName, " Use CSS instead.");
                        }
                    } else if (INPUT_ATTRIBUTES.containsKey(attLocal) && "input" == localName) {
                        String typeVal = "text";
                        if (atts.getIndex("", "type") > -1) {
                            typeVal = atts.getValue("", "type");
                        }
                        Object[] allowedTypes = INPUT_ATTRIBUTES.get(attLocal);
                        Arrays.sort(allowedTypes);
                        if (Arrays.binarySearch(allowedTypes, typeVal) < 0) {
                            this.err("Attribute \u201c" + attLocal + "\u201d is only allowed when the input" + " type is " + this.renderTypeList((String[])allowedTypes) + ".");
                        }
                    } else if ("dropzone" == attLocal) {
                        Object[] tokens = atts.getValue(i).toString().split("[ \\t\\n\\f\\r]+");
                        Arrays.sort(tokens);
                        for (int j = 0; j < tokens.length; ++j) {
                            Object keyword = tokens[j];
                            if (j <= 0 || !((String)keyword).equals(tokens[j - 1])) continue;
                            this.err("Duplicate keyword " + (String)keyword + ". Each keyword must be unique.");
                        }
                    } else if ("autofocus" == attLocal) {
                        if (this.hasAutofocus) {
                            this.err("A document must not include more than one \u201cautofocus\u201d attribute.");
                        }
                        this.hasAutofocus = true;
                    }
                } else if ("http://www.w3.org/XML/1998/namespace" == attUri && "lang" == atts.getLocalName(i)) {
                    xmlLang = atts.getValue(i);
                }
                if (atts.getType(i) != "ID" && "id" != atts.getLocalName(i) || (attVal = atts.getValue(i)).length() == 0) continue;
                ids.add(attVal);
            }
            if ("img".equals(localName) || "source".equals(localName)) {
                if (atts.getIndex("", "srcset") > -1) {
                    String srcsetVal = atts.getValue("", "srcset");
                    try {
                        if (atts.getIndex("", "sizes") > -1) {
                            ImageCandidateStringsWidthRequired.THE_INSTANCE.checkValid(srcsetVal);
                        } else {
                            ImageCandidateStrings.THE_INSTANCE.checkValid(srcsetVal);
                        }
                        if ("1".equals(System.getProperty("nu.validator.checker.imageCandidateString.hasWidth")) && atts.getIndex("", "sizes") < 0) {
                            this.err("When the \u201csrcset\u201d attribute has any image candidate string with a width descriptor, the \u201csizes\u201d attribute must also be present.");
                        }
                    }
                    catch (DatatypeException e) {
                        Class<ImageCandidateStrings> datatypeClass = ImageCandidateStrings.class;
                        if (atts.getIndex("", "sizes") > -1) {
                            datatypeClass = ImageCandidateStringsWidthRequired.class;
                        }
                        try {
                            if (this.getErrorHandler() != null) {
                                Html5DatatypeException ex5;
                                String msg = e.getMessage();
                                if (e instanceof Html5DatatypeException && !(ex5 = (Html5DatatypeException)e).getDatatypeClass().equals(ImageCandidateURL.class)) {
                                    msg = msg.substring(msg.indexOf(": ") + 2);
                                }
                                VnuBadAttrValueException ex = new VnuBadAttrValueException(localName, uri, "srcset", srcsetVal, msg, this.getDocumentLocator(), datatypeClass, false);
                                this.getErrorHandler().error(ex);
                            }
                        }
                        catch (ClassNotFoundException ce) {
                            // empty catch block
                        }
                    }
                    if ("picture".equals(parentName) && !this.siblingSources.isEmpty()) {
                        for (Map.Entry<Locator, Map<String, String>> entry : this.siblingSources.entrySet()) {
                            Locator locator2 = entry.getKey();
                            Map<String, String> sourceAtts = entry.getValue();
                            String media = sourceAtts.get("media");
                            if (media == null && sourceAtts.get("type") == null) {
                                this.err("A \u201csource\u201d element that has a following sibling \u201csource\u201d element or \u201cimg\u201d element with a \u201csrcset\u201d attribute must have a \u201cmedia\u201d attribute and/or \u201ctype\u201d attribute.", locator2);
                                this.siblingSources.remove(locator2);
                                continue;
                            }
                            if (media == null || !Assertions.lowerCaseLiteralEqualsIgnoreAsciiCaseString("all", Assertions.trimSpaces(media))) continue;
                            this.err("Value of \u201cmedia\u201d attribute here must not be \u201call\u201d.", locator2);
                        }
                    }
                } else if (atts.getIndex("", "sizes") > -1) {
                    this.err("The \u201csizes\u201d attribute may be specified only if the \u201csrcset\u201d attribute is also present.");
                }
            }
            if ("picture".equals(parentName) && "source".equals(localName)) {
                HashMap<String, String> sourceAtts = new HashMap<String, String>();
                for (int i = 0; i < atts.getLength(); ++i) {
                    sourceAtts.put(atts.getLocalName(i), atts.getValue(i));
                }
                this.siblingSources.put(new LocatorImpl(this.getDocumentLocator()), sourceAtts);
            }
            if ("figure" == localName) {
                this.currentFigurePtr = this.currentPtr + 1;
            }
            if ((ancestorMask & FIGURE_MASK) != 0) {
                if ("img" == localName) {
                    if (this.stack[this.currentFigurePtr].hasImg()) {
                        this.stack[this.currentFigurePtr].setEmbeddedContentFound();
                    } else {
                        this.stack[this.currentFigurePtr].setImgFound();
                    }
                } else if ("audio" == localName || "canvas" == localName || "embed" == localName || "iframe" == localName || "math" == localName || "object" == localName || "svg" == localName || "video" == localName) {
                    this.stack[this.currentFigurePtr].setEmbeddedContentFound();
                }
            }
            if ("article" == localName || "aside" == localName || "nav" == localName || "section" == localName) {
                this.currentSectioningElementPtr = this.currentPtr + 1;
                ++this.currentSectioningDepth;
            }
            if ("h1" == localName || "h2" == localName || "h3" == localName || "h4" == localName || "h5" == localName || "h6" == localName) {
                this.currentHeadingPtr = this.currentPtr + 1;
                if (this.currentSectioningElementPtr > -1) {
                    this.stack[this.currentSectioningElementPtr].setHeadingFound();
                }
            }
            if (!((ancestorMask & H1_MASK) == 0 && (ancestorMask & H2_MASK) == 0 && (ancestorMask & H3_MASK) == 0 && (ancestorMask & H4_MASK) == 0 && (ancestorMask & H5_MASK) == 0 && (ancestorMask & H6_MASK) == 0 || "img" != localName || atts.getIndex("", "alt") <= -1 || "".equals(atts.getValue("", "alt")))) {
                this.stack[this.currentHeadingPtr].setImgFound();
            }
            if ("option" == localName && !parent.hasOption()) {
                if (atts.getIndex("", "value") < 0) {
                    parent.setNoValueOptionFound();
                } else if (atts.getIndex("", "value") > -1 && "".equals(atts.getValue("", "value"))) {
                    parent.setEmptyValueOptionFound();
                } else {
                    parent.setNonEmptyOption(new LocatorImpl(this.getDocumentLocator()));
                }
            }
            if (OBSOLETE_ELEMENTS.get(localName) != null) {
                this.err("The \u201c" + localName + "\u201d element is obsolete. " + OBSOLETE_ELEMENTS.get(localName));
            }
            int mask = 0;
            String descendantUiString = "";
            Integer maskAsObject = ANCESTOR_MASK_BY_DESCENDANT.get(localName);
            if (maskAsObject != null) {
                mask = maskAsObject;
                descendantUiString = localName;
            } else if ("video" == localName && controls) {
                mask = A_BUTTON_MASK;
                descendantUiString = "video\u201d with the attribute \u201ccontrols";
            } else if ("audio" == localName && controls) {
                mask = A_BUTTON_MASK;
                descendantUiString = "audio\u201d with the attribute \u201ccontrols";
            } else if ("menu" == localName && toolbar) {
                mask = A_BUTTON_MASK;
                descendantUiString = "menu\u201d with the attribute \u201ctype=toolbar";
            } else if ("img" == localName && usemap) {
                mask = A_BUTTON_MASK;
                descendantUiString = "img\u201d with the attribute \u201cusemap";
            } else if ("object" == localName && usemap) {
                mask = A_BUTTON_MASK;
                descendantUiString = "object\u201d with the attribute \u201cusemap";
            } else if ("input" == localName && !hidden) {
                mask = A_BUTTON_MASK;
                descendantUiString = "input";
            }
            if (mask != 0 && (maskHit = ancestorMask & mask) != 0) {
                for (int j = 0; j < SPECIAL_ANCESTORS.length; ++j) {
                    if ((maskHit & 1) != 0) {
                        this.err("The element \u201c" + descendantUiString + "\u201d must not appear as a descendant of the \u201c" + SPECIAL_ANCESTORS[j] + "\u201d element.");
                    }
                    maskHit >>= 1;
                }
            }
            if ("area" == localName && (ancestorMask & MAP_MASK) == 0) {
                this.err("The \u201carea\u201d element must have a \u201cmap\u201d ancestor.");
            } else if ("img" == localName) {
                String titleVal = atts.getValue("", "title");
                if (ismap && (ancestorMask & 0x40000000) == 0) {
                    this.err("The \u201cimg\u201d element with the \u201cismap\u201d attribute set must have an \u201ca\u201d ancestor with the \u201chref\u201d attribute.");
                }
                if (atts.getIndex("", "alt") < 0 && (followW3Cspec || titleVal == null || "".equals(titleVal))) {
                    if ((ancestorMask & FIGURE_MASK) == 0) {
                        this.err("An \u201cimg\u201d element must have an \u201calt\u201d attribute, except under certain conditions. For details, consult guidance on providing text alternatives for images.");
                    } else {
                        this.stack[this.currentFigurePtr].setFigcaptionNeeded();
                        this.stack[this.currentFigurePtr].addImageLackingAlt(new LocatorImpl(this.getDocumentLocator()));
                    }
                }
            } else if ("input" == localName || "button" == localName || "select" == localName || "textarea" == localName || "keygen" == localName) {
                for (Map.Entry<StackNode, Locator> entry : this.openLabels.entrySet()) {
                    node = entry.getKey();
                    locator = entry.getValue();
                    if (node.isLabeledDescendants()) {
                        this.err("The \u201clabel\u201d element may contain at most one \u201cinput\u201d, \u201cbutton\u201d, \u201cselect\u201d, \u201ctextarea\u201d, or \u201ckeygen\u201d descendant.");
                        this.warn("\u201clabel\u201d element with multiple labelable descendants.", locator);
                        continue;
                    }
                    node.setLabeledDescendants();
                }
                if ((ancestorMask & 0x10000000) != 0) {
                    boolean hasMatchingFor = false;
                    int i = 0;
                    while ((this.stack[this.currentPtr - i].getAncestorMask() & 0x10000000) != 0) {
                        String forVal2 = this.stack[this.currentPtr - i].getForAttr();
                        if (forVal2 != null && forVal2.equals(id)) {
                            hasMatchingFor = true;
                            break;
                        }
                        ++i;
                    }
                    if (id == null || !hasMatchingFor) {
                        this.err("Any \u201c" + localName + "\u201d descendant of a \u201clabel\u201d element with a \u201cfor\u201d attribute must have an ID value that matches that \u201cfor\u201d attribute.");
                    }
                }
            } else if ("table" == localName) {
                if (atts.getIndex("", "summary") >= 0) {
                    this.errObsoleteAttribute("summary", "table", " Consider describing the structure of the \u201ctable\u201d in a \u201ccaption\u201d  element or in a \u201cfigure\u201d element  containing the \u201ctable\u201d; or, simplify the structure of the \u201ctable\u201d so that no description is needed.");
                }
                if (atts.getIndex("", "border") > -1) {
                    if (followW3Cspec) {
                        if (atts.getIndex("", "border") > -1 && !"".equals(atts.getValue("", "border")) && !"1".equals(atts.getValue("", "border"))) {
                            this.errObsoleteAttribute("border", "table", " Use CSS instead.");
                        } else {
                            this.warnPresentationalAttribute("border", "table", " For example: \u201ctable, td, th { border: 1px solid gray }\u201d");
                        }
                    } else {
                        this.errObsoleteAttribute("border", "table", " Use CSS instead.");
                    }
                }
            } else if ("track" == localName && atts.getIndex("", "default") >= 0) {
                for (Map.Entry<StackNode, TaintableLocatorImpl> entry : this.openMediaElements.entrySet()) {
                    node = entry.getKey();
                    locator = entry.getValue();
                    if (node.isTrackDescendant()) {
                        this.err("The \u201cdefault\u201d attribute must not occur on more than one \u201ctrack\u201d element within the same \u201caudio\u201d or \u201cvideo\u201d element.");
                        if (((TaintableLocatorImpl)locator).isTainted()) continue;
                        this.warn("\u201caudio\u201d or \u201cvideo\u201d element has more than one \u201ctrack\u201d child element with a \u201cdefault\u201d attribute.", locator);
                        ((TaintableLocatorImpl)locator).markTainted();
                        continue;
                    }
                    node.setTrackDescendants();
                }
            } else if ("main" == localName) {
                if (this.hasMain) {
                    this.err("A document must not include more than one \u201cmain\u201d element.");
                }
                this.hasMain = true;
            } else if ("h1" == localName) {
                if (this.currentSectioningDepth > 1) {
                    this.warn(h1WarningMessage);
                } else if (this.currentSectioningDepth == 1) {
                    this.secondLevelH1s.add(new LocatorImpl(this.getDocumentLocator()));
                } else {
                    this.hasTopLevelH1 = true;
                }
            } else if ("progress" == localName) {
                double value = Assertions.getDoubleAttribute(atts, "value");
                if (!Double.isNaN(value)) {
                    double max = Assertions.getDoubleAttribute(atts, "max");
                    if (Double.isNaN(max)) {
                        if (!(value <= 1.0)) {
                            this.err("The value of the  \u201cvalue\u201d attribute must be less than or equal to one when the \u201cmax\u201d attribute is absent.");
                        }
                    } else if (!(value <= max)) {
                        this.err("The value of the  \u201cvalue\u201d attribute must be less than or equal to the value of the \u201cmax\u201d attribute.");
                    }
                }
            } else if ("meter" == localName) {
                double value = Assertions.getDoubleAttribute(atts, "value");
                double min = Assertions.getDoubleAttribute(atts, "min");
                double max = Assertions.getDoubleAttribute(atts, "max");
                double optimum = Assertions.getDoubleAttribute(atts, "optimum");
                double low = Assertions.getDoubleAttribute(atts, "low");
                double high = Assertions.getDoubleAttribute(atts, "high");
                if (!(Double.isNaN(min) || Double.isNaN(value) || min <= value)) {
                    this.err("The value of the \u201cmin\u201d attribute must be less than or equal to the value of the \u201cvalue\u201d attribute.");
                }
                if (Double.isNaN(min) && !Double.isNaN(value) && !(0.0 <= value)) {
                    this.err("The value of the \u201cvalue\u201d attribute must be greater than or equal to zero when the \u201cmin\u201d attribute is absent.");
                }
                if (!(Double.isNaN(value) || Double.isNaN(max) || value <= max)) {
                    this.err("The value of the \u201cvalue\u201d attribute must be less than or equal to the value of the \u201cmax\u201d attribute.");
                }
                if (!Double.isNaN(value) && Double.isNaN(max) && !(value <= 1.0)) {
                    this.err("The value of the \u201cvalue\u201d attribute must be less than or equal to one when the \u201cmax\u201d attribute is absent.");
                }
                if (!(Double.isNaN(min) || Double.isNaN(max) || min <= max)) {
                    this.err("The value of the \u201cmin\u201d attribute must be less than or equal to the value of the \u201cmax\u201d attribute.");
                }
                if (Double.isNaN(min) && !Double.isNaN(max) && !(0.0 <= max)) {
                    this.err("The value of the \u201cmax\u201d attribute must be greater than or equal to zero when the \u201cmin\u201d attribute is absent.");
                }
                if (!Double.isNaN(min) && Double.isNaN(max) && !(min <= 1.0)) {
                    this.err("The value of the \u201cmin\u201d attribute must be less than or equal to one when the \u201cmax\u201d attribute is absent.");
                }
                if (!(Double.isNaN(min) || Double.isNaN(low) || min <= low)) {
                    this.err("The value of the \u201cmin\u201d attribute must be less than or equal to the value of the \u201clow\u201d attribute.");
                }
                if (Double.isNaN(min) && !Double.isNaN(low) && !(0.0 <= low)) {
                    this.err("The value of the \u201clow\u201d attribute must be greater than or equal to zero when the \u201cmin\u201d attribute is absent.");
                }
                if (!(Double.isNaN(min) || Double.isNaN(high) || min <= high)) {
                    this.err("The value of the \u201cmin\u201d attribute must be less than or equal to the value of the \u201chigh\u201d attribute.");
                }
                if (Double.isNaN(min) && !Double.isNaN(high) && !(0.0 <= high)) {
                    this.err("The value of the \u201chigh\u201d attribute must be greater than or equal to zero when the \u201cmin\u201d attribute is absent.");
                }
                if (!(Double.isNaN(low) || Double.isNaN(high) || low <= high)) {
                    this.err("The value of the \u201clow\u201d attribute must be less than or equal to the value of the \u201chigh\u201d attribute.");
                }
                if (!(Double.isNaN(high) || Double.isNaN(max) || high <= max)) {
                    this.err("The value of the \u201chigh\u201d attribute must be less than or equal to the value of the \u201cmax\u201d attribute.");
                }
                if (!Double.isNaN(high) && Double.isNaN(max) && !(high <= 1.0)) {
                    this.err("The value of the \u201chigh\u201d attribute must be less than or equal to one when the \u201cmax\u201d attribute is absent.");
                }
                if (!(Double.isNaN(low) || Double.isNaN(max) || low <= max)) {
                    this.err("The value of the \u201clow\u201d attribute must be less than or equal to the value of the \u201cmax\u201d attribute.");
                }
                if (!Double.isNaN(low) && Double.isNaN(max) && !(low <= 1.0)) {
                    this.err("The value of the \u201clow\u201d attribute must be less than or equal to one when the \u201cmax\u201d attribute is absent.");
                }
                if (!(Double.isNaN(min) || Double.isNaN(optimum) || min <= optimum)) {
                    this.err("The value of the \u201cmin\u201d attribute must be less than or equal to the value of the \u201coptimum\u201d attribute.");
                }
                if (Double.isNaN(min) && !Double.isNaN(optimum) && !(0.0 <= optimum)) {
                    this.err("The value of the \u201coptimum\u201d attribute must be greater than or equal to zero when the \u201cmin\u201d attribute is absent.");
                }
                if (!(Double.isNaN(optimum) || Double.isNaN(max) || optimum <= max)) {
                    this.err("The value of the \u201coptimum\u201d attribute must be less than or equal to the value of the \u201cmax\u201d attribute.");
                }
                if (!Double.isNaN(optimum) && Double.isNaN(max) && !(optimum <= 1.0)) {
                    this.err("The value of the \u201coptimum\u201d attribute must be less than or equal to one when the \u201cmax\u201d attribute is absent.");
                }
            } else if ("map" == localName && id != null) {
                String nameVal = atts.getValue("", "name");
                if (nameVal != null && !nameVal.equals(id)) {
                    this.err("The \u201cid\u201d attribute on a \u201cmap\u201d element must have an the same value as the \u201cname\u201d attribute.");
                }
            } else if ("object" == localName) {
                if (atts.getIndex("", "typemustmatch") >= 0 && (atts.getIndex("", "data") < 0 || atts.getIndex("", "type") < 0)) {
                    this.err("Element \u201cobject\u201d must not have attribute \u201ctypemustmatch\u201d unless both attribute \u201cdata\u201d and attribute \u201csrc\u201d are also specified.");
                }
            } else if ("script" == localName) {
                if (languageJavaScript && typeNotTextJavaScript) {
                    this.err("A \u201cscript\u201d element with the \u201clanguage=\"JavaScript\"\u201d attribute set must not have a \u201ctype\u201d attribute whose value is not \u201ctext/javascript\u201d.");
                }
                if (atts.getIndex("", "src") < 0) {
                    if (atts.getIndex("", "charset") >= 0) {
                        this.err("Element \u201cscript\u201d must not have attribute \u201ccharset\u201d unless attribute \u201csrc\u201d is also specified.");
                    }
                    if (atts.getIndex("", "defer") >= 0) {
                        this.err("Element \u201cscript\u201d must not have attribute \u201cdefer\u201d unless attribute \u201csrc\u201d is also specified.");
                    }
                    if (atts.getIndex("", "async") >= 0) {
                        this.err("Element \u201cscript\u201d must not have attribute \u201casync\u201d unless attribute \u201csrc\u201d is also specified.");
                    }
                }
            } else if ("bdo" == localName && atts.getIndex("", "dir") < 0) {
                this.err("Element \u201cbdo\u201d must have attribute \u201cdir\u201d.");
            }
            if (lang != null && xmlLang != null && !Assertions.equalsIgnoreAsciiCase(lang, xmlLang)) {
                this.err("When the attribute \u201clang\u201d in no namespace and the attribute \u201clang\u201d in the XML namespace are both present, they must have the same value.");
            }
            if (contextmenu != null) {
                this.contextmenuReferences.add(new IdrefLocator(new LocatorImpl(this.getDocumentLocator()), contextmenu));
            }
            if ("menu" == localName) {
                this.menuIds.addAll(ids);
            }
            if (role != null && owns != null) {
                for (Set<String> value : REQUIRED_ROLE_ANCESTOR_BY_DESCENDANT.values()) {
                    if (!value.contains(role)) continue;
                    String[] ownedIds = AttributeUtil.split(owns);
                    for (int i = 0; i < ownedIds.length; ++i) {
                        Set<String> ownedIdsForThisRole = ariaOwnsIdsByRole.get(role);
                        if (ownedIdsForThisRole == null) {
                            ownedIdsForThisRole = new HashSet<String>();
                        }
                        ownedIdsForThisRole.add(ownedIds[i]);
                        ariaOwnsIdsByRole.put(role, ownedIdsForThisRole);
                    }
                }
            }
            if ("datalist" == localName) {
                this.listIds.addAll(ids);
            }
            if ("label" == localName && (forVal = atts.getValue("", "for")) != null) {
                this.formControlReferences.add(new IdrefLocator(new LocatorImpl(this.getDocumentLocator()), forVal));
            }
            if ("form" == localName) {
                this.formElementIds.addAll(ids);
            }
            if ("input" == localName && !hidden || "textarea" == localName || "select" == localName || "button" == localName || "keygen" == localName || "output" == localName) {
                this.formControlIds.addAll(ids);
            }
            if (("button" == localName || "fieldset" == localName || "input" == localName && !hidden || "keygen" == localName || "label" == localName || "object" == localName || "output" == localName || "select" == localName || "textarea" == localName) && (formVal = atts.getValue("", "form")) != null) {
                this.formElementReferences.add(new IdrefLocator(new LocatorImpl(this.getDocumentLocator()), formVal));
            }
            if ("input" == localName && list != null) {
                this.listReferences.add(new IdrefLocator(new LocatorImpl(this.getDocumentLocator()), list));
            }
            if ("input" == localName && Assertions.lowerCaseLiteralEqualsIgnoreAsciiCaseString("button", atts.getValue("", "type")) && (atts.getValue("", "value") == null || "".equals(atts.getValue("", "value")))) {
                this.err("Element \u201cinput\u201d with attribute \u201ctype\u201d whose value is \u201cbutton\u201d must have non-empty attribute \u201cvalue\u201d.");
            }
            if ("track" == localName && "".equals(atts.getValue("", "label"))) {
                this.err("Attribute \u201clabel\u201d for element \u201ctrack\u201d must have non-empty value.");
            }
            if ("option" == localName && selected) {
                for (Map.Entry<StackNode, Locator> entry : this.openSingleSelects.entrySet()) {
                    StackNode node2 = entry.getKey();
                    if (node2.isSelectedOptions()) {
                        this.err("The \u201cselect\u201d element cannot have more than one selected \u201coption\u201d descendant unless the \u201cmultiple\u201d attribute is specified.");
                        continue;
                    }
                    node2.setSelectedOptions();
                }
            }
            if ("meta" == localName) {
                if (Assertions.lowerCaseLiteralEqualsIgnoreAsciiCaseString("content-language", atts.getValue("", "http-equiv"))) {
                    this.err("Using the \u201cmeta\u201d element to specify the document-wide default language is obsolete. Consider specifying the language on the root element instead.");
                } else if (Assertions.lowerCaseLiteralEqualsIgnoreAsciiCaseString("x-ua-compatible", atts.getValue("", "http-equiv")) && !Assertions.lowerCaseLiteralEqualsIgnoreAsciiCaseString("ie=edge", atts.getValue("", "content"))) {
                    this.err("A \u201cmeta\u201d element with an \u201chttp-equiv\u201d attribute whose value is \u201cX-UA-Compatible\u201d must have a \u201ccontent\u201d attribute with the value \u201cIE=edge\u201d.");
                }
            }
            if (!(!itemid || itemscope && itemtype)) {
                this.err("The \u201citemid\u201d attribute must not be specified on elements that do not have both an \u201citemscope\u201d attribute and an \u201citemtype\u201d attribute specified.");
            }
            if (itemref && !itemscope) {
                this.err("The \u201citemref\u201d attribute must not be specified on elements that do not have an \u201citemscope\u201d attribute specified.");
            }
            if (itemtype && !itemscope) {
                this.err("The \u201citemtype\u201d attribute must not be specified on elements that do not have an \u201citemscope\u201d attribute specified.");
            }
        } else {
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                String attVal;
                if (atts.getType(i) == "ID" && (attVal = atts.getValue(i)).length() != 0) {
                    ids.add(attVal);
                }
                String attLocal = atts.getLocalName(i);
                if (atts.getURI(i).length() != 0) continue;
                if ("role" == attLocal) {
                    role = atts.getValue(i);
                    continue;
                }
                if ("aria-activedescendant" == attLocal) {
                    activeDescendant = atts.getValue(i);
                    continue;
                }
                if ("aria-owns" != attLocal) continue;
                owns = atts.getValue(i);
            }
            this.allIds.addAll(ids);
        }
        Set<String> requiredAncestorRoles = REQUIRED_ROLE_ANCESTOR_BY_DESCENDANT.get(role);
        if (!(requiredAncestorRoles == null || "presentation".equals(parentRole) || "tbody".equals(localName) || "tfoot".equals(localName) || "thead".equals(localName) || this.currentElementHasRequiredAncestorRole(requiredAncestorRoles))) {
            if (atts.getIndex("", "id") > -1 && !"".equals(atts.getValue("", "id"))) {
                this.needsAriaOwner.add(new IdrefLocator(new LocatorImpl(this.getDocumentLocator()), atts.getValue("", "id"), role));
            } else {
                this.errContainedInOrOwnedBy(role, this.getDocumentLocator());
            }
        }
        for (String att : MUST_NOT_DANGLE_IDREFS) {
            String attVal = atts.getValue("", att);
            if (attVal == null) continue;
            String[] tokens = AttributeUtil.split(attVal);
            for (int i = 0; i < tokens.length; ++i) {
                String token = tokens[i];
                this.ariaReferences.add(new IdrefLocator(this.getDocumentLocator(), token, att));
            }
        }
        this.allIds.addAll(ids);
        if (activeDescendant != null && !"".equals(activeDescendant) && owns != null && !"".equals(owns)) {
            activeDescendantWithAriaOwns = true;
        }
        Iterator<Map.Entry<StackNode, Locator>> iterator = this.openActiveDescendants.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<StackNode, Locator> entry = iterator.next();
            if (!ids.contains(entry.getKey().getActiveDescendant())) continue;
            iterator.remove();
        }
        if ("http://www.w3.org/1999/xhtml" == uri) {
            int number = Assertions.specialAncestorNumber(localName);
            if (number > -1) {
                ancestorMask |= 1 << number;
            }
            if ("a" == localName && href) {
                ancestorMask |= 0x40000000;
            }
            StackNode child = new StackNode(ancestorMask, localName, role, activeDescendant, forAttr);
            if (activeDescendant != null && !activeDescendantWithAriaOwns) {
                this.openActiveDescendants.put(child, new LocatorImpl(this.getDocumentLocator()));
            }
            if ("select" == localName && atts.getIndex("", "multiple") == -1) {
                this.openSingleSelects.put(child, this.getDocumentLocator());
            } else if ("label" == localName) {
                this.openLabels.put(child, new LocatorImpl(this.getDocumentLocator()));
            } else if ("video" == localName || "audio" == localName) {
                this.openMediaElements.put(child, new TaintableLocatorImpl(this.getDocumentLocator()));
            }
            this.push(child);
            if ("select" == localName && atts.getIndex("", "required") > -1 && atts.getIndex("", "multiple") < 0) {
                if (atts.getIndex("", "size") > -1) {
                    String size = Assertions.trimSpaces(atts.getValue("", "size"));
                    if (!"".equals(size)) {
                        try {
                            if (size.length() > 1 && size.charAt(0) == '+' && Integer.parseInt(size.substring(1)) == 1 || Integer.parseInt(size) == 1) {
                                child.setOptionNeeded();
                            }
                        }
                        catch (NumberFormatException e) {}
                    }
                } else {
                    child.setOptionNeeded();
                }
            }
        } else {
            StackNode child = new StackNode(ancestorMask, null, role, activeDescendant, forAttr);
            if (activeDescendant != null) {
                this.openActiveDescendants.put(child, new LocatorImpl(this.getDocumentLocator()));
            }
            this.push(child);
        }
        this.stack[this.currentPtr].setLocator(new LocatorImpl(this.getDocumentLocator()));
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        StackNode node = this.peek();
        block3: for (int i = start; i < start + length; ++i) {
            char c = ch[i];
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
                default: {
                    if ("h1".equals(node.name) || "h2".equals(node.name) || "h3".equals(node.name) || "h4".equals(node.name) || "h5".equals(node.name) || "h6".equals(node.name) || (node.ancestorMask & H1_MASK) != 0 || (node.ancestorMask & H2_MASK) != 0 || (node.ancestorMask & H3_MASK) != 0 || (node.ancestorMask & H4_MASK) != 0 || (node.ancestorMask & H5_MASK) != 0 || (node.ancestorMask & H6_MASK) != 0) {
                        this.stack[this.currentHeadingPtr].setTextNodeFound();
                    } else if ("figcaption".equals(node.name) || (node.ancestorMask & FIGCAPTION_MASK) != 0) {
                        if ((node.ancestorMask & FIGURE_MASK) != 0) {
                            this.stack[this.currentFigurePtr].setFigcaptionContentFound();
                        }
                        for (int j = 1; j < this.currentFigurePtr; ++j) {
                            if (!"figure".equals(this.stack[this.currentFigurePtr - j].getName())) continue;
                            this.stack[this.currentFigurePtr - j].setTextNodeFound();
                        }
                    } else if ("figure".equals(node.name) || (node.ancestorMask & FIGURE_MASK) != 0) {
                        this.stack[this.currentFigurePtr].setTextNodeFound();
                        for (int k = 1; k < this.currentFigurePtr; ++k) {
                            if (!"figure".equals(this.stack[this.currentFigurePtr - k].getName())) continue;
                            this.stack[this.currentFigurePtr - k].setTextNodeFound();
                        }
                    } else if ("option".equals(node.name) && !this.stack[this.currentPtr - 1].hasOption() && (!this.stack[this.currentPtr - 1].hasEmptyValueOption() || this.stack[this.currentPtr - 1].hasNoValueOption()) && this.stack[this.currentPtr - 1].nonEmptyOptionLocator() == null) {
                        this.stack[this.currentPtr - 1].setNonEmptyOption(new LocatorImpl(this.getDocumentLocator()));
                    }
                    return;
                }
            }
        }
    }

    private CharSequence renderTypeList(String[] types) {
        StringBuilder sb = new StringBuilder();
        int len = types.length;
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            if (i == len - 1) {
                sb.append("or ");
            }
            sb.append("\u201c");
            sb.append(types[i]);
            sb.append('\u201d');
        }
        return sb;
    }

    private CharSequence renderRoleSet(Set<String> roles) {
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (String role : roles) {
            if (first) {
                first = false;
            } else {
                sb.append(" or ");
            }
            sb.append("\u201crole=");
            sb.append(role);
            sb.append('\u201d');
        }
        return sb;
    }

    static {
        INPUT_ATTRIBUTES.put("autocomplete", new String[]{"text", "search", "url", "tel", "email", "password", "datetime", "date", "month", "week", "time", "datetime-local", "number", "range", "color"});
        INPUT_ATTRIBUTES.put("list", new String[]{"text", "search", "url", "tel", "email", "datetime", "date", "month", "week", "time", "datetime-local", "number", "range", "color"});
        INPUT_ATTRIBUTES.put("maxlength", new String[]{"text", "search", "url", "tel", "email", "password"});
        INPUT_ATTRIBUTES.put("pattern", new String[]{"text", "search", "url", "tel", "email", "password"});
        INPUT_ATTRIBUTES.put("placeholder", new String[]{"text", "search", "url", "tel", "email", "password", "number"});
        INPUT_ATTRIBUTES.put("readonly", new String[]{"text", "search", "url", "tel", "email", "password", "datetime", "date", "month", "week", "time", "datetime-local", "number"});
        INPUT_ATTRIBUTES.put("required", new String[]{"text", "search", "url", "tel", "email", "password", "datetime", "date", "month", "week", "time", "datetime-local", "number", "checkbox", "radio", "file"});
        INPUT_ATTRIBUTES.put("size", new String[]{"text", "search", "url", "tel", "email", "password"});
        OBSOLETE_ELEMENTS = new HashMap<String, String>();
        OBSOLETE_ELEMENTS.put("center", "Use CSS instead.");
        OBSOLETE_ELEMENTS.put("font", "Use CSS instead.");
        OBSOLETE_ELEMENTS.put("big", "Use CSS instead.");
        OBSOLETE_ELEMENTS.put("strike", "Use CSS instead.");
        OBSOLETE_ELEMENTS.put("tt", "Use CSS instead.");
        OBSOLETE_ELEMENTS.put("acronym", "Use the \u201cabbr\u201d element instead.");
        OBSOLETE_ELEMENTS.put("dir", "Use the \u201cul\u201d element instead.");
        OBSOLETE_ELEMENTS.put("applet", "Use the \u201cobject\u201d element instead.");
        OBSOLETE_ELEMENTS.put("basefont", "Use CSS instead.");
        OBSOLETE_ELEMENTS.put("frameset", "Use the \u201ciframe\u201d element and CSS instead, or use server-side includes.");
        OBSOLETE_ELEMENTS.put("noframes", "Use the \u201ciframe\u201d element and CSS instead, or use server-side includes.");
        if (followW3Cspec) {
            OBSOLETE_ELEMENTS.put("hgroup", "To mark up subheadings, consider either just putting the subheading into a \u201cp\u201d element after the \u201ch1\u201d-\u201ch6\u201d element containing the main heading, or else putting the subheading directly within the \u201ch1\u201d-\u201ch6\u201d element containing the main heading, but separated from the main heading by punctuation and/or within, for example, a \u201cspan class=\"subheading\"\u201d element with differentiated styling. To group headings and subheadings, alternative titles, or taglines, consider using the \u201cheader\u201d or \u201cdiv\u201d elements.");
        }
        OBSOLETE_ATTRIBUTES = new HashMap<String, String[]>();
        OBSOLETE_ATTRIBUTES.put("abbr", new String[]{"td", "th"});
        OBSOLETE_ATTRIBUTES.put("archive", new String[]{"object"});
        OBSOLETE_ATTRIBUTES.put("axis", new String[]{"td", "th"});
        OBSOLETE_ATTRIBUTES.put("charset", new String[]{"link", "a"});
        OBSOLETE_ATTRIBUTES.put("classid", new String[]{"object"});
        OBSOLETE_ATTRIBUTES.put("code", new String[]{"object"});
        OBSOLETE_ATTRIBUTES.put("codebase", new String[]{"object"});
        OBSOLETE_ATTRIBUTES.put("codetype", new String[]{"object"});
        OBSOLETE_ATTRIBUTES.put("coords", new String[]{"a"});
        OBSOLETE_ATTRIBUTES.put("datafld", new String[]{"span", "div", "object", "input", "select", "textarea", "button", "table"});
        OBSOLETE_ATTRIBUTES.put("dataformatas", new String[]{"span", "div", "object", "input", "select", "textarea", "button", "table"});
        OBSOLETE_ATTRIBUTES.put("datasrc", new String[]{"span", "div", "object", "input", "select", "textarea", "button", "table"});
        OBSOLETE_ATTRIBUTES.put("datapagesize", new String[]{"table"});
        OBSOLETE_ATTRIBUTES.put("declare", new String[]{"object"});
        OBSOLETE_ATTRIBUTES.put("event", new String[]{"script"});
        OBSOLETE_ATTRIBUTES.put("for", new String[]{"script"});
        OBSOLETE_ATTRIBUTES.put("language", new String[]{"script"});
        if (!followW3Cspec) {
            OBSOLETE_ATTRIBUTES.put("longdesc", new String[]{"img", "iframe"});
        }
        OBSOLETE_ATTRIBUTES.put("methods", new String[]{"link", "a"});
        OBSOLETE_ATTRIBUTES.put("name", new String[]{"img", "embed", "option"});
        OBSOLETE_ATTRIBUTES.put("nohref", new String[]{"area"});
        OBSOLETE_ATTRIBUTES.put("profile", new String[]{"head"});
        OBSOLETE_ATTRIBUTES.put("scheme", new String[]{"meta"});
        OBSOLETE_ATTRIBUTES.put("scope", new String[]{"td"});
        OBSOLETE_ATTRIBUTES.put("shape", new String[]{"a"});
        OBSOLETE_ATTRIBUTES.put("standby", new String[]{"object"});
        OBSOLETE_ATTRIBUTES.put("target", new String[]{"link"});
        OBSOLETE_ATTRIBUTES.put("type", new String[]{"param"});
        OBSOLETE_ATTRIBUTES.put("urn", new String[]{"a", "link"});
        OBSOLETE_ATTRIBUTES.put("usemap", new String[]{"input"});
        OBSOLETE_ATTRIBUTES.put("valuetype", new String[]{"param"});
        OBSOLETE_ATTRIBUTES.put("version", new String[]{"html"});
        OBSOLETE_ATTRIBUTES_MSG = new HashMap<String, String>();
        OBSOLETE_ATTRIBUTES_MSG.put("abbr", "Consider instead beginning the cell contents with concise text, followed by further elaboration if needed.");
        OBSOLETE_ATTRIBUTES_MSG.put("archive", "Use the \u201cdata\u201d and \u201ctype\u201d attributes to invoke plugins. To set a parameter with the name \u201carchive\u201d, use the \u201cparam\u201d element.");
        OBSOLETE_ATTRIBUTES_MSG.put("axis", "Use the \u201cscope\u201d attribute.");
        OBSOLETE_ATTRIBUTES_MSG.put("charset", "Use an HTTP Content-Type header on the linked resource instead.");
        OBSOLETE_ATTRIBUTES_MSG.put("classid", "Use the \u201cdata\u201d and \u201ctype\u201d attributes to invoke plugins. To set a parameter with the name \u201cclassid\u201d, use the \u201cparam\u201d element.");
        OBSOLETE_ATTRIBUTES_MSG.put("code", "Use the \u201cdata\u201d and \u201ctype\u201d attributes to invoke plugins. To set a parameter with the name \u201ccode\u201d, use the \u201cparam\u201d element.");
        OBSOLETE_ATTRIBUTES_MSG.put("codebase", "Use the \u201cdata\u201d and \u201ctype\u201d attributes to invoke plugins. To set a parameter with the name \u201ccodebase\u201d, use the \u201cparam\u201d element.");
        OBSOLETE_ATTRIBUTES_MSG.put("codetype", "Use the \u201cdata\u201d and \u201ctype\u201d attributes to invoke plugins. To set a parameter with the name \u201ccodetype\u201d, use the \u201cparam\u201d element.");
        OBSOLETE_ATTRIBUTES_MSG.put("coords", "Use \u201carea\u201d instead of \u201ca\u201d for image maps.");
        OBSOLETE_ATTRIBUTES_MSG.put("datapagesize", "You can safely omit it.");
        OBSOLETE_ATTRIBUTES_MSG.put("datafld", "Use script and a mechanism such as XMLHttpRequest to populate the page dynamically");
        OBSOLETE_ATTRIBUTES_MSG.put("dataformatas", "Use script and a mechanism such as XMLHttpRequest to populate the page dynamically");
        OBSOLETE_ATTRIBUTES_MSG.put("datasrc", "Use script and a mechanism such as XMLHttpRequest to populate the page dynamically");
        OBSOLETE_ATTRIBUTES_MSG.put("for", "Use DOM Events mechanisms to register event listeners.");
        OBSOLETE_ATTRIBUTES_MSG.put("event", "Use DOM Events mechanisms to register event listeners.");
        OBSOLETE_ATTRIBUTES_MSG.put("declare", "Repeat the \u201cobject\u201d element completely each time the resource is to be reused.");
        OBSOLETE_ATTRIBUTES_MSG.put("language", "Use the \u201ctype\u201d attribute instead.");
        if (!followW3Cspec) {
            OBSOLETE_ATTRIBUTES_MSG.put("longdesc", "Use a regular \u201ca\u201d element to link to the description.");
        }
        OBSOLETE_ATTRIBUTES_MSG.put("methods", "Use the HTTP OPTIONS feature instead.");
        OBSOLETE_ATTRIBUTES_MSG.put("name", "Use the \u201cid\u201d attribute instead.");
        OBSOLETE_ATTRIBUTES_MSG.put("nohref", "Omitting the \u201chref\u201d attribute is sufficient.");
        OBSOLETE_ATTRIBUTES_MSG.put("profile", "To declare which \u201cmeta\u201d terms are used in the document, instead register the names as meta extensions. To trigger specific UA behaviors, use a \u201clink\u201d element instead.");
        OBSOLETE_ATTRIBUTES_MSG.put("scheme", "Use only one scheme per field, or make the scheme declaration part of the value.");
        OBSOLETE_ATTRIBUTES_MSG.put("scope", "Use the \u201cscope\u201d attribute on a \u201cth\u201d element instead.");
        OBSOLETE_ATTRIBUTES_MSG.put("shape", "Use \u201carea\u201d instead of \u201ca\u201d for image maps.");
        OBSOLETE_ATTRIBUTES_MSG.put("standby", "Optimise the linked resource so that it loads quickly or, at least, incrementally.");
        OBSOLETE_ATTRIBUTES_MSG.put("target", "You can safely omit it.");
        OBSOLETE_ATTRIBUTES_MSG.put("type", "Use the \u201cname\u201d and \u201cvalue\u201d attributes without declaring value types.");
        OBSOLETE_ATTRIBUTES_MSG.put("urn", "Specify the preferred persistent identifier using the \u201chref\u201d attribute instead.");
        OBSOLETE_ATTRIBUTES_MSG.put("usemap", "Use the \u201cimg\u201d element instead of the \u201cinput\u201d element for image maps.");
        OBSOLETE_ATTRIBUTES_MSG.put("valuetype", "Use the \u201cname\u201d and \u201cvalue\u201d attributes without declaring value types.");
        OBSOLETE_ATTRIBUTES_MSG.put("version", "You can safely omit it.");
        OBSOLETE_STYLE_ATTRS = new HashMap<String, String[]>();
        OBSOLETE_STYLE_ATTRS.put("align", new String[]{"caption", "iframe", "img", "input", "object", "embed", "legend", "table", "hr", "div", "h1", "h2", "h3", "h4", "h5", "h6", "p", "col", "colgroup", "tbody", "td", "tfoot", "th", "thead", "tr"});
        OBSOLETE_STYLE_ATTRS.put("alink", new String[]{"body"});
        OBSOLETE_STYLE_ATTRS.put("allowtransparency", new String[]{"iframe"});
        OBSOLETE_STYLE_ATTRS.put("background", new String[]{"body"});
        OBSOLETE_STYLE_ATTRS.put("bgcolor", new String[]{"table", "tr", "td", "th", "body"});
        OBSOLETE_STYLE_ATTRS.put("cellpadding", new String[]{"table"});
        OBSOLETE_STYLE_ATTRS.put("cellspacing", new String[]{"table"});
        OBSOLETE_STYLE_ATTRS.put("char", new String[]{"col", "colgroup", "tbody", "td", "tfoot", "th", "thead", "tr"});
        OBSOLETE_STYLE_ATTRS.put("charoff", new String[]{"col", "colgroup", "tbody", "td", "tfoot", "th", "thead", "tr"});
        OBSOLETE_STYLE_ATTRS.put("clear", new String[]{"br"});
        OBSOLETE_STYLE_ATTRS.put("color", new String[]{"hr"});
        OBSOLETE_STYLE_ATTRS.put("compact", new String[]{"dl", "menu", "ol", "ul"});
        OBSOLETE_STYLE_ATTRS.put("frameborder", new String[]{"iframe"});
        OBSOLETE_STYLE_ATTRS.put("frame", new String[]{"table"});
        OBSOLETE_STYLE_ATTRS.put("height", new String[]{"td", "th"});
        OBSOLETE_STYLE_ATTRS.put("hspace", new String[]{"img", "object", "embed"});
        OBSOLETE_STYLE_ATTRS.put("link", new String[]{"body"});
        OBSOLETE_STYLE_ATTRS.put("marginbottom", new String[]{"body"});
        OBSOLETE_STYLE_ATTRS.put("marginheight", new String[]{"iframe", "body"});
        OBSOLETE_STYLE_ATTRS.put("marginleft", new String[]{"body"});
        OBSOLETE_STYLE_ATTRS.put("marginright", new String[]{"body"});
        OBSOLETE_STYLE_ATTRS.put("margintop", new String[]{"body"});
        OBSOLETE_STYLE_ATTRS.put("marginwidth", new String[]{"iframe", "body"});
        OBSOLETE_STYLE_ATTRS.put("noshade", new String[]{"hr"});
        OBSOLETE_STYLE_ATTRS.put("nowrap", new String[]{"td", "th"});
        OBSOLETE_STYLE_ATTRS.put("rules", new String[]{"table"});
        OBSOLETE_STYLE_ATTRS.put("scrolling", new String[]{"iframe"});
        OBSOLETE_STYLE_ATTRS.put("size", new String[]{"hr"});
        OBSOLETE_STYLE_ATTRS.put("text", new String[]{"body"});
        OBSOLETE_STYLE_ATTRS.put("type", new String[]{"li", "ul"});
        OBSOLETE_STYLE_ATTRS.put("valign", new String[]{"col", "colgroup", "tbody", "td", "tfoot", "th", "thead", "tr"});
        OBSOLETE_STYLE_ATTRS.put("vlink", new String[]{"body"});
        OBSOLETE_STYLE_ATTRS.put("vspace", new String[]{"img", "object", "embed"});
        OBSOLETE_STYLE_ATTRS.put("width", new String[]{"hr", "table", "td", "th", "col", "colgroup", "pre"});
        SPECIAL_ANCESTORS = new String[]{"a", "address", "button", "caption", "dfn", "dt", "figcaption", "figure", "footer", "form", "header", "label", "map", "noscript", "th", "time", "progress", "meter", "article", "section", "aside", "nav", "h1", "h2", "h3", "h4", "h5", "h6"};
        ANCESTOR_MASK_BY_DESCENDANT = new HashMap<String, Integer>();
        Assertions.registerProhibitedAncestor("form", "form");
        Assertions.registerProhibitedAncestor("time", "time");
        Assertions.registerProhibitedAncestor("progress", "progress");
        Assertions.registerProhibitedAncestor("meter", "meter");
        Assertions.registerProhibitedAncestor("dfn", "dfn");
        Assertions.registerProhibitedAncestor("noscript", "noscript");
        Assertions.registerProhibitedAncestor("label", "label");
        Assertions.registerProhibitedAncestor("address", "address");
        Assertions.registerProhibitedAncestor("address", "section");
        Assertions.registerProhibitedAncestor("address", "nav");
        Assertions.registerProhibitedAncestor("address", "article");
        Assertions.registerProhibitedAncestor("address", "aside");
        Assertions.registerProhibitedAncestor("header", "header");
        Assertions.registerProhibitedAncestor("footer", "header");
        Assertions.registerProhibitedAncestor("address", "header");
        Assertions.registerProhibitedAncestor("header", "footer");
        Assertions.registerProhibitedAncestor("footer", "footer");
        Assertions.registerProhibitedAncestor("dt", "header");
        Assertions.registerProhibitedAncestor("dt", "footer");
        Assertions.registerProhibitedAncestor("dt", "article");
        Assertions.registerProhibitedAncestor("dt", "aside");
        Assertions.registerProhibitedAncestor("dt", "nav");
        Assertions.registerProhibitedAncestor("dt", "section");
        Assertions.registerProhibitedAncestor("dt", "h1");
        Assertions.registerProhibitedAncestor("dt", "h2");
        Assertions.registerProhibitedAncestor("dt", "h2");
        Assertions.registerProhibitedAncestor("dt", "h3");
        Assertions.registerProhibitedAncestor("dt", "h4");
        Assertions.registerProhibitedAncestor("dt", "h5");
        Assertions.registerProhibitedAncestor("dt", "h6");
        Assertions.registerProhibitedAncestor("dt", "hgroup");
        Assertions.registerProhibitedAncestor("th", "header");
        Assertions.registerProhibitedAncestor("th", "footer");
        Assertions.registerProhibitedAncestor("th", "article");
        Assertions.registerProhibitedAncestor("th", "aside");
        Assertions.registerProhibitedAncestor("th", "nav");
        Assertions.registerProhibitedAncestor("th", "section");
        Assertions.registerProhibitedAncestor("th", "h1");
        Assertions.registerProhibitedAncestor("th", "h2");
        Assertions.registerProhibitedAncestor("th", "h2");
        Assertions.registerProhibitedAncestor("th", "h3");
        Assertions.registerProhibitedAncestor("th", "h4");
        Assertions.registerProhibitedAncestor("th", "h5");
        Assertions.registerProhibitedAncestor("th", "h6");
        Assertions.registerProhibitedAncestor("th", "hgroup");
        Assertions.registerProhibitedAncestor("address", "footer");
        Assertions.registerProhibitedAncestor("address", "h1");
        Assertions.registerProhibitedAncestor("address", "h2");
        Assertions.registerProhibitedAncestor("address", "h3");
        Assertions.registerProhibitedAncestor("address", "h4");
        Assertions.registerProhibitedAncestor("address", "h5");
        Assertions.registerProhibitedAncestor("address", "h6");
        Assertions.registerProhibitedAncestor("a", "a");
        Assertions.registerProhibitedAncestor("button", "a");
        Assertions.registerProhibitedAncestor("a", "details");
        Assertions.registerProhibitedAncestor("button", "details");
        Assertions.registerProhibitedAncestor("a", "button");
        Assertions.registerProhibitedAncestor("button", "button");
        Assertions.registerProhibitedAncestor("a", "textarea");
        Assertions.registerProhibitedAncestor("button", "textarea");
        Assertions.registerProhibitedAncestor("a", "select");
        Assertions.registerProhibitedAncestor("button", "select");
        Assertions.registerProhibitedAncestor("a", "keygen");
        Assertions.registerProhibitedAncestor("button", "keygen");
        Assertions.registerProhibitedAncestor("a", "embed");
        Assertions.registerProhibitedAncestor("button", "embed");
        Assertions.registerProhibitedAncestor("a", "iframe");
        Assertions.registerProhibitedAncestor("button", "iframe");
        Assertions.registerProhibitedAncestor("a", "label");
        Assertions.registerProhibitedAncestor("button", "label");
        Assertions.registerProhibitedAncestor("caption", "table");
        Assertions.registerProhibitedAncestor("article", "main");
        Assertions.registerProhibitedAncestor("aside", "main");
        Assertions.registerProhibitedAncestor("header", "main");
        Assertions.registerProhibitedAncestor("footer", "main");
        Assertions.registerProhibitedAncestor("nav", "main");
        A_BUTTON_MASK = 1 << Assertions.specialAncestorNumber("a") | 1 << Assertions.specialAncestorNumber("button");
        FIGCAPTION_MASK = 1 << Assertions.specialAncestorNumber("figcaption");
        FIGURE_MASK = 1 << Assertions.specialAncestorNumber("figure");
        H1_MASK = 1 << Assertions.specialAncestorNumber("h1");
        H2_MASK = 1 << Assertions.specialAncestorNumber("h2");
        H3_MASK = 1 << Assertions.specialAncestorNumber("h3");
        H4_MASK = 1 << Assertions.specialAncestorNumber("h4");
        H5_MASK = 1 << Assertions.specialAncestorNumber("h5");
        H6_MASK = 1 << Assertions.specialAncestorNumber("h6");
        MAP_MASK = 1 << Assertions.specialAncestorNumber("map");
        REQUIRED_ROLE_ANCESTOR_BY_DESCENDANT = new HashMap<String, Set<String>>();
        ariaOwnsIdsByRole = new HashMap<String, Set<String>>();
        Assertions.registerRequiredAncestorRole("combobox", "option");
        Assertions.registerRequiredAncestorRole("listbox", "option");
        Assertions.registerRequiredAncestorRole("radiogroup", "option");
        Assertions.registerRequiredAncestorRole("menu", "option");
        Assertions.registerRequiredAncestorRole("menu", "menuitem");
        Assertions.registerRequiredAncestorRole("menu", "menuitemcheckbox");
        Assertions.registerRequiredAncestorRole("menu", "menuitemradio");
        Assertions.registerRequiredAncestorRole("menubar", "menuitem");
        Assertions.registerRequiredAncestorRole("menubar", "menuitemcheckbox");
        Assertions.registerRequiredAncestorRole("menubar", "menuitemradio");
        Assertions.registerRequiredAncestorRole("tablist", "tab");
        Assertions.registerRequiredAncestorRole("tree", "treeitem");
        Assertions.registerRequiredAncestorRole("tree", "option");
        Assertions.registerRequiredAncestorRole("group", "treeitem");
        Assertions.registerRequiredAncestorRole("group", "listitem");
        Assertions.registerRequiredAncestorRole("group", "menuitemradio");
        Assertions.registerRequiredAncestorRole("list", "listitem");
        Assertions.registerRequiredAncestorRole("row", "gridcell");
        Assertions.registerRequiredAncestorRole("row", "columnheader");
        Assertions.registerRequiredAncestorRole("row", "rowheader");
        Assertions.registerRequiredAncestorRole("grid", "row");
        Assertions.registerRequiredAncestorRole("grid", "rowgroup");
        Assertions.registerRequiredAncestorRole("rowgroup", "row");
        Assertions.registerRequiredAncestorRole("treegrid", "row");
        MUST_NOT_DANGLE_IDREFS = new HashSet<String>();
        MUST_NOT_DANGLE_IDREFS.add("aria-controls");
        MUST_NOT_DANGLE_IDREFS.add("aria-describedby");
        MUST_NOT_DANGLE_IDREFS.add("aria-flowto");
        MUST_NOT_DANGLE_IDREFS.add("aria-labelledby");
        MUST_NOT_DANGLE_IDREFS.add("aria-owns");
    }

    private class StackNode {
        private final int ancestorMask;
        private final String name;
        private final String role;
        private final String activeDescendant;
        private final String forAttr;
        private Set<Locator> imagesLackingAlt = new HashSet<Locator>();
        private Locator nonEmptyOption = null;
        private Locator locator = null;
        private boolean selectedOptions = false;
        private boolean labeledDescendants = false;
        private boolean trackDescendants = false;
        private boolean textNodeFound = false;
        private boolean imgFound = false;
        private boolean embeddedContentFound = false;
        private boolean figcaptionNeeded = false;
        private boolean figcaptionContentFound = false;
        private boolean headingFound = false;
        private boolean optionNeeded = false;
        private boolean optionFound = false;
        private boolean noValueOptionFound = false;
        private boolean emptyValueOptionFound = false;

        public StackNode(int ancestorMask, String name, String role, String activeDescendant, String forAttr) {
            this.ancestorMask = ancestorMask;
            this.name = name;
            this.role = role;
            this.activeDescendant = activeDescendant;
            this.forAttr = forAttr;
        }

        public int getAncestorMask() {
            return this.ancestorMask;
        }

        public String getName() {
            return this.name;
        }

        public boolean isSelectedOptions() {
            return this.selectedOptions;
        }

        public void setSelectedOptions() {
            this.selectedOptions = true;
        }

        public boolean isLabeledDescendants() {
            return this.labeledDescendants;
        }

        public void setLabeledDescendants() {
            this.labeledDescendants = true;
        }

        public boolean isTrackDescendant() {
            return this.trackDescendants;
        }

        public void setTrackDescendants() {
            this.trackDescendants = true;
        }

        public String getRole() {
            return this.role;
        }

        public String getActiveDescendant() {
            return this.activeDescendant;
        }

        public String getForAttr() {
            return this.forAttr;
        }

        public boolean hasTextNode() {
            return this.textNodeFound;
        }

        public void setTextNodeFound() {
            this.textNodeFound = true;
        }

        public boolean hasImg() {
            return this.imgFound;
        }

        public void setImgFound() {
            this.imgFound = true;
        }

        public boolean hasEmbeddedContent() {
            return this.embeddedContentFound;
        }

        public void setEmbeddedContentFound() {
            this.embeddedContentFound = true;
        }

        public boolean needsFigcaption() {
            return this.figcaptionNeeded;
        }

        public void setFigcaptionNeeded() {
            this.figcaptionNeeded = true;
        }

        public boolean hasFigcaptionContent() {
            return this.figcaptionContentFound;
        }

        public void setFigcaptionContentFound() {
            this.figcaptionContentFound = true;
        }

        public boolean hasHeading() {
            return this.headingFound;
        }

        public void setHeadingFound() {
            this.headingFound = true;
        }

        public Set<Locator> getImagesLackingAlt() {
            return this.imagesLackingAlt;
        }

        public void addImageLackingAlt(Locator locator) {
            this.imagesLackingAlt.add(locator);
        }

        public boolean isOptionNeeded() {
            return this.optionNeeded;
        }

        public void setOptionNeeded() {
            this.optionNeeded = true;
        }

        public boolean hasOption() {
            return this.optionFound;
        }

        public void setOptionFound() {
            this.optionFound = true;
        }

        public boolean hasNoValueOption() {
            return this.noValueOptionFound;
        }

        public void setNoValueOptionFound() {
            this.noValueOptionFound = true;
        }

        public boolean hasEmptyValueOption() {
            return this.emptyValueOptionFound;
        }

        public void setEmptyValueOptionFound() {
            this.emptyValueOptionFound = true;
        }

        public Locator nonEmptyOptionLocator() {
            return this.nonEmptyOption;
        }

        public void setNonEmptyOption(Locator locator) {
            this.nonEmptyOption = locator;
        }

        public Locator locator() {
            return this.locator;
        }

        public void setLocator(Locator locator) {
            this.locator = locator;
        }
    }

    private class IdrefLocator {
        private final Locator locator;
        private final String idref;
        private final String additional;

        public IdrefLocator(Locator locator, String idref) {
            this.locator = new LocatorImpl(locator);
            this.idref = idref;
            this.additional = null;
        }

        public IdrefLocator(Locator locator, String idref, String additional) {
            this.locator = new LocatorImpl(locator);
            this.idref = idref;
            this.additional = additional;
        }

        public Locator getLocator() {
            return this.locator;
        }

        public String getIdref() {
            return this.idref;
        }

        public String getAdditional() {
            return this.additional;
        }
    }
}

