/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.client;

import com.thaiopensource.relaxng.exceptions.BadAttributeValueException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import nu.validator.datatype.Html5DatatypeException;
import nu.validator.validation.SimpleDocumentValidator;
import org.eclipse.jetty.util.ajax.JSON;
import org.relaxng.datatype.DatatypeException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TestRunner
implements ErrorHandler {
    private boolean inError = false;
    private boolean emitMessages = false;
    private boolean exceptionIsWarning = false;
    private boolean expectingError = false;
    private Exception exception = null;
    private SimpleDocumentValidator validator;
    private PrintWriter err;
    private PrintWriter out;
    private String schema = "http://s.validator.nu/html5-all.rnc";
    private boolean failed = false;
    private static File messagesFile;
    private static String[] ignoreList;
    private static boolean writeMessages;
    private static boolean verbose;
    private String baseDir = null;
    private Map<String, String> expectedMessages;
    private Map<String, String> reportedMessages = new LinkedHashMap<String, String>();

    public TestRunner() throws IOException {
        this.validator = new SimpleDocumentValidator();
        try {
            this.err = new PrintWriter(new OutputStreamWriter((OutputStream)System.err, "UTF-8"));
            this.out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void checkHtmlFile(File file) throws IOException, SAXException {
        if (!file.exists()) {
            if (verbose) {
                this.out.println(String.format("\"%s\": warning: File not found.", file.toURI().toURL().toString()));
                this.out.flush();
            }
            return;
        }
        if (verbose) {
            this.out.println(file);
            this.out.flush();
        }
        if (this.isHtml(file)) {
            this.validator.checkHtmlFile(file, true);
        } else if (this.isXhtml(file)) {
            this.validator.checkXmlFile(file);
        } else if (verbose) {
            this.out.println(String.format("\"%s\": warning: File was not checked. Files must have a .html, .xhtml, .htm, or .xht extension.", file.toURI().toURL().toString()));
            this.out.flush();
        }
    }

    private boolean isXhtml(File file) {
        String name = file.getName();
        return name.endsWith(".xhtml") || name.endsWith(".xht");
    }

    private boolean isHtml(File file) {
        String name = file.getName();
        return name.endsWith(".html") || name.endsWith(".htm");
    }

    private boolean isCheckableFile(File file) {
        return file.isFile() && (this.isHtml(file) || this.isXhtml(file));
    }

    private void recurseDirectory(File directory) throws SAXException, IOException {
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                this.recurseDirectory(file);
                continue;
            }
            this.checkHtmlFile(file);
        }
    }

    private boolean isIgnorable(File file) throws IOException {
        String testPathname = file.getAbsolutePath().substring(this.baseDir.length() + 1);
        if (ignoreList != null) {
            for (String substring : ignoreList) {
                if (!testPathname.contains(substring)) continue;
                if (verbose) {
                    this.out.println(String.format("\"%s\": warning: File ignored.", file.toURI().toURL().toString()));
                    this.out.flush();
                }
                return true;
            }
        }
        return false;
    }

    private void checkFiles(List<File> files) throws IOException {
        for (File file : files) {
            if (this.isIgnorable(file)) continue;
            this.reset();
            this.emitMessages = true;
            try {
                if (file.isDirectory()) {
                    this.recurseDirectory(file);
                } else {
                    this.checkHtmlFile(file);
                }
            }
            catch (IOException e) {
            }
            catch (SAXException e) {
                // empty catch block
            }
            if (!this.inError) continue;
            this.failed = true;
        }
    }

    private boolean messageMatches(String testFilename) {
        String messageReported = this.exception.getMessage().replaceAll("\\p{C}", "?");
        String messageExpected = this.expectedMessages.get(testFilename).replaceAll("\\p{C}", "?");
        Pattern p = Pattern.compile("(Bad datetime with timezone: .+) (Bad date: .+)");
        messageExpected = p.matcher(messageExpected).replaceAll("$2 $1");
        messageReported = p.matcher(messageReported).replaceAll("$2 $1");
        return messageReported.equals(messageExpected);
    }

    private void checkInvalidFiles(List<File> files) throws IOException {
        this.expectingError = true;
        for (File file : files) {
            if (this.isIgnorable(file)) continue;
            this.reset();
            try {
                if (file.isDirectory()) {
                    this.recurseDirectory(file);
                } else {
                    this.checkHtmlFile(file);
                }
            }
            catch (IOException e) {
            }
            catch (SAXException e) {
                // empty catch block
            }
            if (this.exception != null) {
                String testFilename = file.getAbsolutePath().substring(this.baseDir.length() + 1);
                if (writeMessages) {
                    this.reportedMessages.put(testFilename, this.exception.getMessage());
                } else {
                    if (this.expectedMessages != null && this.expectedMessages.get(testFilename) == null) {
                        try {
                            this.err.println(String.format("\"%s\": warning: No expected message in messages file.", file.toURI().toURL().toString()));
                            this.err.flush();
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (this.expectedMessages != null && !this.messageMatches(testFilename)) {
                        this.failed = true;
                        try {
                            this.err.println(String.format("\"%s\": error: Expected \"%s\" but instead encountered \"%s\".", file.toURI().toURL().toString(), this.expectedMessages.get(testFilename), this.exception.getMessage()));
                            this.err.flush();
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            if (this.inError) continue;
            this.failed = true;
            try {
                this.err.println(String.format("\"%s\": error: Expected an error but did not encounter any.", file.toURI().toURL().toString()));
                this.err.flush();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void checkHasWarningFiles(List<File> files) throws IOException {
        this.expectingError = false;
        for (File file : files) {
            if (this.isIgnorable(file)) continue;
            this.reset();
            try {
                if (file.isDirectory()) {
                    this.recurseDirectory(file);
                } else {
                    this.checkHtmlFile(file);
                }
            }
            catch (IOException e) {
            }
            catch (SAXException e) {
                // empty catch block
            }
            if (this.exception != null) {
                String testFilename = file.getAbsolutePath().substring(this.baseDir.length() + 1);
                if (writeMessages) {
                    this.reportedMessages.put(testFilename, this.exception.getMessage());
                } else {
                    if (this.expectedMessages != null && this.expectedMessages.get(testFilename) == null) {
                        try {
                            this.err.println(String.format("\"%s\": warning: No expected message in messages file.", file.toURI().toURL().toString()));
                            this.err.flush();
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (this.expectedMessages != null && !this.messageMatches(testFilename)) {
                        try {
                            this.err.println(String.format("\"%s\": error: Expected \"%s\" but instead encountered \"%s\".", file.toURI().toURL().toString(), this.expectedMessages.get(testFilename), this.exception.getMessage()));
                            this.err.flush();
                        }
                        catch (MalformedURLException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            if (this.inError) {
                this.failed = true;
                try {
                    this.err.println(String.format("\"%s\": error: Expected a warning but encountered an error first.", file.toURI().toURL().toString()));
                    this.err.flush();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!this.exceptionIsWarning) {
                try {
                    this.err.println(String.format("\"%s\": error: Expected a warning but did not encounter any.", file.toURI().toURL().toString()));
                    this.err.flush();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!this.inError) continue;
            this.failed = true;
            try {
                this.err.println(String.format("\"%s\": error: Expected a warning only but encountered at least one error.", file.toURI().toURL().toString()));
                this.err.flush();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void checkTestDirectoryAgainstSchema(File directory, String schemaUrl) throws SAXException, Exception {
        this.validator.setUpMainSchema(schemaUrl, this);
        this.checkTestFiles(directory, State.EXPECTING_ANYTHING);
    }

    private void checkTestFiles(File directory, State state) throws SAXException, IOException {
        File[] files = directory.listFiles();
        ArrayList<File> validFiles = new ArrayList<File>();
        ArrayList<File> invalidFiles = new ArrayList<File>();
        ArrayList<File> hasWarningFiles = new ArrayList<File>();
        if (files == null) {
            if (verbose) {
                try {
                    this.out.println(String.format("\"%s\": warning: No files found in directory.", directory.toURI().toURL().toString()));
                    this.out.flush();
                }
                catch (MalformedURLException mue) {
                    throw new RuntimeException(mue);
                }
            }
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                if (state != State.EXPECTING_ANYTHING) {
                    this.checkTestFiles(file, state);
                    continue;
                }
                if ("invalid".equals(file.getName())) {
                    this.checkTestFiles(file, State.EXPECTING_INVALID_FILES);
                    continue;
                }
                if ("valid".equals(file.getName())) {
                    this.checkTestFiles(file, State.EXPECTING_VALID_FILES);
                    continue;
                }
                this.checkTestFiles(file, State.EXPECTING_ANYTHING);
                continue;
            }
            if (!this.isCheckableFile(file)) continue;
            if (state == State.EXPECTING_INVALID_FILES) {
                invalidFiles.add(file);
                continue;
            }
            if (state == State.EXPECTING_VALID_FILES) {
                validFiles.add(file);
                continue;
            }
            if (file.getPath().indexOf("novalid") > 0) {
                invalidFiles.add(file);
                continue;
            }
            if (file.getPath().indexOf("haswarn") > 0) {
                hasWarningFiles.add(file);
                continue;
            }
            validFiles.add(file);
        }
        if (validFiles.size() > 0) {
            this.validator.setUpValidatorAndParsers(this, false, false);
            this.checkFiles(validFiles);
        }
        if (invalidFiles.size() > 0) {
            this.validator.setUpValidatorAndParsers(this, false, false);
            this.checkInvalidFiles(invalidFiles);
        }
        if (hasWarningFiles.size() > 0) {
            this.validator.setUpValidatorAndParsers(this, false, false);
            this.checkHasWarningFiles(hasWarningFiles);
        }
        if (writeMessages) {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(messagesFile), "utf-8");
            BufferedWriter bw = new BufferedWriter(out);
            bw.write(JSON.toString(this.reportedMessages));
            bw.close();
        }
    }

    public boolean runTestSuite() throws SAXException, Exception {
        if (messagesFile != null) {
            this.baseDir = messagesFile.getAbsoluteFile().getParent();
            FileInputStream fis = new FileInputStream(messagesFile);
            InputStreamReader reader = new InputStreamReader((InputStream)fis, "UTF-8");
            this.expectedMessages = (HashMap)JSON.parse(reader);
        } else {
            this.baseDir = System.getProperty("user.dir");
        }
        for (File directory : new File(this.baseDir).listFiles()) {
            if (!directory.isDirectory()) continue;
            if (directory.getName().contains("rdfalite")) {
                this.checkTestDirectoryAgainstSchema(directory, "http://s.validator.nu/html5-rdfalite.rnc");
                continue;
            }
            if (directory.getName().contains("xhtml")) {
                this.checkTestDirectoryAgainstSchema(directory, "http://s.validator.nu/xhtml5-all.rnc");
                continue;
            }
            this.checkTestDirectoryAgainstSchema(directory, this.schema);
        }
        if (verbose) {
            if (this.failed) {
                this.out.println("Failure!");
                this.out.flush();
            } else {
                this.out.println("Success!");
                this.out.flush();
            }
        }
        return !this.failed;
    }

    private void emitMessage(SAXParseException e, String messageType) {
        String systemId = e.getSystemId();
        this.err.write(systemId == null ? "" : '\"' + systemId + '\"');
        this.err.write(":");
        this.err.write(Integer.toString(e.getLineNumber()));
        this.err.write(":");
        this.err.write(Integer.toString(e.getColumnNumber()));
        this.err.write(": ");
        this.err.write(messageType);
        this.err.write(": ");
        this.err.write(e.getMessage());
        this.err.write("\n");
        this.err.flush();
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        if (this.emitMessages) {
            this.emitMessage(e, "warning");
        } else if (this.exception == null && !this.expectingError) {
            this.exception = e;
            this.exceptionIsWarning = true;
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (this.emitMessages) {
            this.emitMessage(e, "error");
        } else if (this.exception == null) {
            this.exception = e;
            if (e instanceof BadAttributeValueException) {
                BadAttributeValueException ex = (BadAttributeValueException)e;
                Map datatypeErrors = ex.getExceptions();
                for (Map.Entry entry : datatypeErrors.entrySet()) {
                    Html5DatatypeException ex5;
                    DatatypeException dex = (DatatypeException)entry.getValue();
                    if (!(dex instanceof Html5DatatypeException) || !(ex5 = (Html5DatatypeException)dex).isWarning()) continue;
                    this.exceptionIsWarning = true;
                    return;
                }
            }
        }
        this.inError = true;
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        this.inError = true;
        if (this.emitMessages) {
            this.emitMessage(e, "fatal error");
            return;
        }
        if (this.exception == null) {
            this.exception = e;
        }
    }

    public void reset() {
        this.exception = null;
        this.inError = false;
        this.emitMessages = false;
        this.exceptionIsWarning = false;
    }

    public static void main(String[] args) throws SAXException, Exception {
        if (args.length < 1) {
            TestRunner.usage();
            System.exit(0);
        }
        verbose = false;
        String messagesFilename = null;
        System.setProperty("nu.validator.datatype.warn", "true");
        for (int i = 0; i < args.length; ++i) {
            if ("--verbose".equals(args[i])) {
                verbose = true;
                continue;
            }
            if ("--errors-only".equals(args[i])) {
                System.setProperty("nu.validator.datatype.warn", "false");
                continue;
            }
            if ("--write-messages".equals(args[i])) {
                writeMessages = true;
                continue;
            }
            if (args[i].startsWith("--ignore=")) {
                ignoreList = args[i].substring(9, args[i].length()).split(",");
                continue;
            }
            if (args[i].startsWith("--")) {
                System.out.println(String.format("\nError: There is no option \"%s\".", args[i]));
                TestRunner.usage();
                System.exit(1);
                continue;
            }
            if (args[i].endsWith(".json")) {
                messagesFilename = args[i];
                continue;
            }
            System.out.println("\nError: Expected the name of a messages file with a .json extension.");
            TestRunner.usage();
            System.exit(1);
        }
        if (messagesFilename != null) {
            messagesFile = new File(messagesFilename);
            if (!messagesFile.exists()) {
                System.out.println("\nError: \"" + messagesFilename + "\" file not found.");
                System.exit(1);
            } else if (!messagesFile.isFile()) {
                System.out.println("\nError: \"" + messagesFilename + "\" is not a file.");
                System.exit(1);
            }
        } else if (writeMessages) {
            System.out.println("\nError: Expected the name of a messages file with a .json extension.");
            TestRunner.usage();
            System.exit(1);
        }
        TestRunner tr = new TestRunner();
        if (tr.runTestSuite()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    private static void usage() {
        System.out.println("\nUsage:");
        System.out.println("\n    java nu.validator.client.TestRunner [--errors-only] [--write-messages]");
        System.out.println("          [--verbose] [MESSAGES.json]");
        System.out.println("\n...where the MESSAGES.json file contains name/value pairs in which the name is");
        System.out.println("a pathname of a document to check and the value is the first error message or");
        System.out.println("warning message the validator is expected to report when checking that document.");
        System.out.println("Use the --write-messages option to create the file.");
    }

    static {
        ignoreList = null;
    }

    private static enum State {
        EXPECTING_INVALID_FILES,
        EXPECTING_VALID_FILES,
        EXPECTING_ANYTHING;

    }
}

