/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.gnu.xml.aelfred2;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import nu.validator.gnu.xml.aelfred2.XmlParser;
import nu.validator.htmlparser.common.CharacterHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.NamespaceSupport;

public final class SAXDriver
implements Locator2,
Attributes2,
XMLReader,
Parser,
AttributeList {
    private final DefaultHandler2 base = new DefaultHandler2();
    private XmlParser parser;
    private EntityResolver entityResolver = this.base;
    private EntityResolver2 resolver2 = null;
    private ContentHandler contentHandler = this.base;
    private DTDHandler dtdHandler = this.base;
    private ErrorHandler errorHandler = this.base;
    private DeclHandler declHandler = this.base;
    private LexicalHandler lexicalHandler = this.base;
    private String elementName;
    private Stack<String> entityStack;
    private List<Attribute> attributesList;
    private boolean namespaces = true;
    private boolean xmlNames = false;
    private boolean extGE = true;
    private boolean extPE = true;
    private boolean resolveAll = true;
    private boolean useResolver2 = true;
    boolean stringInterning = true;
    private int attributeCount;
    private boolean attributes;
    private String[] nsTemp;
    private NamespaceSupport prefixStack;
    boolean checkNormalization = false;
    private boolean errorHandlerLocked = false;
    CharacterHandler characterHandler = null;
    static final String FEATURE = "http://xml.org/sax/features/";
    static final String PROPERTY = "http://xml.org/sax/properties/";

    public SAXDriver() {
        this.reset();
    }

    private void reset() {
        this.elementName = null;
        this.entityStack = new Stack();
        this.attributesList = Collections.synchronizedList(new ArrayList());
        this.attributeCount = 0;
        this.attributes = false;
        this.nsTemp = new String[3];
        this.prefixStack = null;
    }

    @Override
    public void setLocale(Locale locale) throws SAXException {
        if ("en".equals(locale.getLanguage())) {
            return;
        }
        throw new SAXException("AElfred2 only supports English locales.");
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver == this.base ? null : this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.resolver2 = resolver instanceof EntityResolver2 ? (EntityResolver2)resolver : null;
        if (resolver == null) {
            resolver = this.base;
        }
        this.entityResolver = resolver;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler == this.base ? null : this.dtdHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        if (handler == null) {
            handler = this.base;
        }
        this.dtdHandler = handler;
    }

    @Override
    public void setDocumentHandler(DocumentHandler handler) {
        this.contentHandler = new Adapter(handler);
        this.xmlNames = true;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler == this.base ? null : this.contentHandler;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        if (handler == null) {
            handler = this.base;
        }
        this.contentHandler = handler;
    }

    public void lockErrorHandler() {
        this.errorHandlerLocked = true;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        if (this.errorHandlerLocked) {
            return;
        }
        if (handler == null) {
            handler = this.base;
        }
        this.errorHandler = handler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler == this.base ? null : this.errorHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputSource source) throws SAXException, IOException {
        DefaultHandler2 defaultHandler2 = this.base;
        synchronized (defaultHandler2) {
            this.parser = new XmlParser();
            if (this.namespaces) {
                this.prefixStack = new NamespaceSupport();
            } else if (!this.xmlNames) {
                throw new IllegalStateException();
            }
            this.parser.setHandler(this);
            try {
                Reader r = source.getCharacterStream();
                InputStream in = source.getByteStream();
                this.parser.doParse(source.getSystemId(), source.getPublicId(), r, in, source.getEncoding());
            }
            catch (SAXException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXParseException(e.getMessage(), this, e);
            }
            finally {
                this.contentHandler.endDocument();
                this.reset();
            }
        }
    }

    @Override
    public void parse(String systemId) throws SAXException, IOException {
        this.parse(new InputSource(systemId));
    }

    @Override
    public boolean getFeature(String featureId) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://xml.org/sax/features/validation".equals(featureId)) {
            return false;
        }
        if ("http://xml.org/sax/features/external-general-entities".equals(featureId)) {
            return this.extGE;
        }
        if ("http://xml.org/sax/features/external-parameter-entities".equals(featureId)) {
            return this.extPE;
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(featureId)) {
            return this.xmlNames;
        }
        if ("http://xml.org/sax/features/namespaces".equals(featureId)) {
            return this.namespaces;
        }
        if ("http://xml.org/sax/features/lexical-handler/parameter-entities".equals(featureId)) {
            return true;
        }
        if ("http://xml.org/sax/features/string-interning".equals(featureId)) {
            return this.stringInterning;
        }
        if ("http://xml.org/sax/features/use-attributes2".equals(featureId)) {
            return true;
        }
        if ("http://xml.org/sax/features/is-standalone".equals(featureId)) {
            if (this.parser == null) {
                throw new SAXNotSupportedException(featureId);
            }
            return this.parser.isStandalone();
        }
        if ("http://xml.org/sax/features/resolve-dtd-uris".equals(featureId)) {
            return this.resolveAll;
        }
        if ("http://xml.org/sax/features/use-entity-resolver2".equals(featureId)) {
            return this.useResolver2;
        }
        if ("http://xml.org/sax/features/unicode-normalization-checking".equals(featureId)) {
            return this.checkNormalization;
        }
        throw new SAXNotRecognizedException(featureId);
    }

    DeclHandler getDeclHandler() {
        return this.declHandler;
    }

    boolean resolveURIs() {
        return this.resolveAll;
    }

    @Override
    public Object getProperty(String propertyId) throws SAXNotRecognizedException {
        if ("http://xml.org/sax/properties/declaration-handler".equals(propertyId)) {
            return this.declHandler == this.base ? null : this.declHandler;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(propertyId)) {
            return this.lexicalHandler == this.base ? null : this.lexicalHandler;
        }
        throw new SAXNotRecognizedException(propertyId);
    }

    @Override
    public void setFeature(String featureId, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        boolean state = this.getFeature(featureId);
        if (state == value) {
            return;
        }
        if (this.parser != null) {
            throw new SAXNotSupportedException("not while parsing");
        }
        if ("http://xml.org/sax/features/namespace-prefixes".equals(featureId)) {
            this.xmlNames = value;
            if (!this.xmlNames) {
                this.namespaces = true;
            }
            return;
        }
        if ("http://xml.org/sax/features/namespaces".equals(featureId)) {
            this.namespaces = value;
            if (!this.namespaces) {
                this.xmlNames = true;
            }
            return;
        }
        if ("http://xml.org/sax/features/external-general-entities".equals(featureId)) {
            this.extGE = value;
            return;
        }
        if ("http://xml.org/sax/features/external-parameter-entities".equals(featureId)) {
            this.extPE = value;
            return;
        }
        if ("http://xml.org/sax/features/resolve-dtd-uris".equals(featureId)) {
            this.resolveAll = value;
            return;
        }
        if ("http://xml.org/sax/features/use-entity-resolver2".equals(featureId)) {
            this.useResolver2 = value;
            return;
        }
        if ("http://xml.org/sax/features/unicode-normalization-checking".equals(featureId)) {
            this.checkNormalization = value;
            return;
        }
        throw new SAXNotRecognizedException(featureId);
    }

    @Override
    public void setProperty(String propertyId, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.getProperty(propertyId);
        if ("http://xml.org/sax/properties/declaration-handler".equals(propertyId)) {
            if (value == null) {
                this.declHandler = this.base;
            } else {
                if (!(value instanceof DeclHandler)) {
                    throw new SAXNotSupportedException(propertyId);
                }
                this.declHandler = (DeclHandler)value;
            }
            return;
        }
        if ("http://xml.org/sax/properties/lexical-handler".equals(propertyId)) {
            if (value == null) {
                this.lexicalHandler = this.base;
            } else {
                if (!(value instanceof LexicalHandler)) {
                    throw new SAXNotSupportedException(propertyId);
                }
                this.lexicalHandler = (LexicalHandler)value;
            }
            return;
        }
        throw new SAXNotSupportedException(propertyId);
    }

    void startDocument() throws SAXException {
        this.contentHandler.setDocumentLocator(this);
        this.contentHandler.startDocument();
        this.attributesList.clear();
    }

    void skippedEntity(String name) throws SAXException {
        this.contentHandler.skippedEntity(name);
    }

    InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        if (this.resolver2 == null || !this.useResolver2 || !this.extPE) {
            return null;
        }
        return this.resolver2.getExternalSubset(name, baseURI);
    }

    InputSource resolveEntity(boolean isPE, String name, InputSource in, String baseURI) throws SAXException, IOException {
        InputSource source;
        if (isPE && !this.extPE) {
            return null;
        }
        if (!isPE && !this.extGE) {
            return null;
        }
        this.lexicalHandler.startEntity(name);
        if (this.resolver2 != null && this.useResolver2) {
            source = this.resolver2.resolveEntity(name, in.getPublicId(), baseURI, in.getSystemId());
            if (source == null) {
                in.setSystemId(this.absolutize(baseURI, in.getSystemId(), false));
                source = in;
            }
        } else {
            in.setSystemId(this.absolutize(baseURI, in.getSystemId(), false));
            source = this.entityResolver.resolveEntity(in.getPublicId(), in.getSystemId());
            if (source == null) {
                source = in;
            }
        }
        this.startExternalEntity(name, source.getSystemId(), true);
        return source;
    }

    String absolutize(String baseURI, String systemId, boolean nice) throws MalformedURLException, SAXException {
        try {
            if (baseURI == null) {
                if (XmlParser.uriWarnings) {
                    this.warn("No base URI; hope this SYSTEM id is absolute: " + systemId);
                }
                return new URL(systemId).toString();
            }
            return new URL(new URL(baseURI), systemId).toString();
        }
        catch (MalformedURLException e) {
            if (!nice) {
                throw e;
            }
            this.warn("Can't absolutize SYSTEM id: " + e.getMessage());
            return systemId;
        }
    }

    void startExternalEntity(String name, String systemId, boolean stackOnly) throws SAXException {
        if (!stackOnly) {
            this.lexicalHandler.startEntity(name);
        }
        this.entityStack.push(systemId);
    }

    void endExternalEntity(String name) throws SAXException {
        if (!"[document]".equals(name)) {
            this.lexicalHandler.endEntity(name);
        }
        this.entityStack.pop();
    }

    void startInternalEntity(String name) throws SAXException {
        this.lexicalHandler.startEntity(name);
    }

    void endInternalEntity(String name) throws SAXException {
        this.lexicalHandler.endEntity(name);
    }

    void doctypeDecl(String name, String publicId, String systemId) throws SAXException {
        this.lexicalHandler.startDTD(name, publicId, systemId);
    }

    void notationDecl(String name, String publicId, String systemId, String baseUri) throws SAXException {
        try {
            this.dtdHandler.notationDecl(name, publicId, this.resolveAll && systemId != null ? this.absolutize(baseUri, systemId, true) : systemId);
        }
        catch (IOException e) {
            throw new SAXParseException(e.getMessage(), this, e);
        }
    }

    void unparsedEntityDecl(String name, String publicId, String systemId, String baseUri, String notation) throws SAXException {
        try {
            this.dtdHandler.unparsedEntityDecl(name, publicId, this.resolveAll ? this.absolutize(baseUri, systemId, true) : systemId, notation);
        }
        catch (IOException e) {
            throw new SAXParseException(e.getMessage(), this, e);
        }
    }

    void endDoctype() throws SAXException {
        this.lexicalHandler.endDTD();
    }

    private void declarePrefix(String prefix, String uri) throws SAXException {
        int index = uri.indexOf(58);
        if (index < 1 && uri.length() != 0) {
            this.warn("relative URI for namespace: " + uri);
        }
        if (uri.length() != 0 && !this.isAlpha(uri.charAt(0))) {
            this.fatal("First character of the URI must be ascii alpha");
        }
        for (int i = 1; i < index; ++i) {
            if (this.isAlphanumericOrPlusMinusPoint(uri.charAt(i))) continue;
            this.fatal("Character " + i + " of the URI must be ascii alpha or in \"+-.\"");
        }
        boolean prefixEquality = prefix.equals("xml");
        boolean uriEquality = uri.equals("http://www.w3.org/XML/1998/namespace");
        if (!(!prefixEquality && !uriEquality || prefixEquality && uriEquality)) {
            this.fatal("xml is by definition bound to the namespace name http://www.w3.org/XML/1998/namespace");
        }
        if (prefixEquality && uriEquality) {
            return;
        }
        prefixEquality = prefix.equals("xmlns");
        uriEquality = uri.equals("http://www.w3.org/2000/xmlns/");
        if (!(!prefixEquality && !uriEquality || prefixEquality && uriEquality)) {
            this.fatal("http://www.w3.org/2000/xmlns/ is by definition bound to prefix xmlns");
        }
        if (prefixEquality && uriEquality) {
            this.fatal("declaring the xmlns prefix is illegal");
        }
        uri = uri.intern();
        this.prefixStack.declarePrefix(prefix, uri);
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    void attribute(String qname, String value, boolean isSpecified) throws SAXException {
        if (!this.attributes) {
            this.attributes = true;
            if (this.namespaces) {
                this.prefixStack.pushContext();
            }
        }
        if (this.namespaces) {
            if (this.stringInterning) {
                if ("xmlns" == qname) {
                    this.declarePrefix("", value);
                    if (!this.xmlNames) {
                        return;
                    }
                } else {
                    int index = qname.indexOf(58);
                    if (index == 5 && qname.startsWith("xmlns")) {
                        String prefix = qname.substring(6);
                        if (prefix.equals("")) {
                            this.fatal("missing prefix in namespace declaration attribute");
                        }
                        if (value.length() == 0) {
                            this.verror("missing URI in namespace declaration attribute: " + qname);
                        } else {
                            this.declarePrefix(prefix, value);
                        }
                        if (!this.xmlNames) {
                            return;
                        }
                    }
                }
            } else if ("xmlns".equals(qname)) {
                this.declarePrefix("", value);
                if (!this.xmlNames) {
                    return;
                }
            } else {
                int index = qname.indexOf(58);
                if (index == 5 && qname.startsWith("xmlns")) {
                    String prefix = qname.substring(6);
                    if (value.length() == 0) {
                        this.verror("missing URI in namespace decl attribute: " + qname);
                    } else {
                        this.declarePrefix(prefix, value);
                    }
                    if (!this.xmlNames) {
                        return;
                    }
                }
            }
        }
        ++this.attributeCount;
        this.attributesList.add(new Attribute(qname, value, isSpecified));
    }

    void startElement(String elname) throws SAXException {
        ContentHandler handler = this.contentHandler;
        if (!this.attributes) {
            if (this.namespaces) {
                this.prefixStack.pushContext();
            }
        } else if (this.namespaces) {
            for (Attribute attribute : this.attributesList) {
                int index;
                String qname = attribute.name;
                if (!this.stringInterning ? "xmlns".equals(qname) : "xmlns" == qname) continue;
                if (qname.equals(":")) {
                    this.fatal("namespace names consisting of a single colon character are invalid");
                }
                if ((index = qname.indexOf(58)) == 5 && qname.startsWith("xmlns")) continue;
                if (this.prefixStack.processName(qname, this.nsTemp, true) == null) {
                    this.fatal("undeclared attribute prefix in: " + qname);
                    continue;
                }
                attribute.nameSpace = this.nsTemp[0];
                attribute.localName = this.nsTemp[1];
            }
        }
        this.elementName = elname;
        if (this.namespaces) {
            if (this.prefixStack.processName(elname, this.nsTemp, false) == null) {
                this.fatal("undeclared element prefix in: " + elname);
                this.nsTemp[1] = "";
                this.nsTemp[0] = "";
            }
            handler.startElement(this.nsTemp[0], this.nsTemp[1], elname, this);
        } else {
            handler.startElement("", "", elname, this);
        }
        if (this.attributes) {
            this.attributesList.clear();
            this.attributeCount = 0;
            this.attributes = false;
        }
    }

    void endElement(String elname) throws SAXException {
        ContentHandler handler = this.contentHandler;
        if (!this.namespaces) {
            handler.endElement("", "", elname);
            return;
        }
        this.prefixStack.processName(elname, this.nsTemp, false);
        handler.endElement(this.nsTemp[0], this.nsTemp[1], elname);
        Enumeration prefixes = this.prefixStack.getDeclaredPrefixes();
        while (prefixes.hasMoreElements()) {
            handler.endPrefixMapping((String)prefixes.nextElement());
        }
        this.prefixStack.popContext();
    }

    void startCDATA() throws SAXException {
        this.lexicalHandler.startCDATA();
    }

    void charData(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.characters(ch, start, length);
    }

    void endCDATA() throws SAXException {
        this.lexicalHandler.endCDATA();
    }

    void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.contentHandler.ignorableWhitespace(ch, start, length);
    }

    void processingInstruction(String target, String data) throws SAXException {
        this.contentHandler.processingInstruction(target, data);
    }

    void comment(char[] ch, int start, int length) throws SAXException {
        if (this.lexicalHandler != this.base) {
            this.lexicalHandler.comment(ch, start, length);
        }
    }

    void fatal(String message) throws SAXException {
        SAXParseException fatal = new SAXParseException(message, this);
        this.errorHandler.fatalError(fatal);
        throw fatal;
    }

    void verror(String message) throws SAXException {
        SAXParseException err = new SAXParseException(message, this);
        this.errorHandler.error(err);
    }

    void warn(String message) throws SAXException {
        SAXParseException err = new SAXParseException(message, this);
        this.errorHandler.warning(err);
    }

    private boolean isAlpha(char character) {
        return character >= 'A' && character <= 'Z' || character >= 'a' && character <= 'z';
    }

    private boolean isAlphanumericOrPlusMinusPoint(char character) {
        return character >= 'A' && character <= 'Z' || character >= 'a' && character <= 'z' || character >= '0' && character <= '9' || character == '+' || character == '-' || character == '.';
    }

    @Override
    public int getLength() {
        return this.attributesList.size();
    }

    @Override
    public String getURI(int index) {
        if (index < 0 || index >= this.attributesList.size()) {
            return null;
        }
        return this.attributesList.get((int)index).nameSpace;
    }

    @Override
    public String getLocalName(int index) {
        if (index < 0 || index >= this.attributesList.size()) {
            return null;
        }
        Attribute attr = this.attributesList.get(index);
        if (this.namespaces && attr.localName == null) {
            int ci = attr.name.indexOf(58);
            attr.localName = ci == -1 ? attr.name : attr.name.substring(ci + 1);
        }
        return attr.localName == null ? "" : attr.localName;
    }

    @Override
    public String getQName(int index) {
        if (index < 0 || index >= this.attributesList.size()) {
            return null;
        }
        Attribute attr = this.attributesList.get(index);
        return attr.name == null ? "" : attr.name;
    }

    @Override
    public String getName(int index) {
        return this.getQName(index);
    }

    @Override
    public String getType(int index) {
        if (index < 0 || index >= this.attributesList.size()) {
            return null;
        }
        String type = this.parser.getAttributeType(this.elementName, this.getQName(index));
        if (type == null) {
            return "CDATA";
        }
        if (type == "ENUMERATION") {
            return "NMTOKEN";
        }
        return type;
    }

    @Override
    public String getValue(int index) {
        if (index < 0 || index >= this.attributesList.size()) {
            return null;
        }
        return this.attributesList.get((int)index).value;
    }

    @Override
    public int getIndex(String uri, String local) {
        int length = this.getLength();
        for (int i = 0; i < length; ++i) {
            if (!this.getURI(i).equals(uri) || !this.getLocalName(i).equals(local)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getIndex(String xmlName) {
        int length = this.getLength();
        for (int i = 0; i < length; ++i) {
            if (!this.getQName(i).equals(xmlName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getType(String uri, String local) {
        int index = this.getIndex(uri, local);
        if (index < 0) {
            return null;
        }
        return this.getType(index);
    }

    @Override
    public String getType(String xmlName) {
        int index = this.getIndex(xmlName);
        if (index < 0) {
            return null;
        }
        return this.getType(index);
    }

    @Override
    public String getValue(String uri, String local) {
        int index = this.getIndex(uri, local);
        if (index < 0) {
            return null;
        }
        return this.getValue(index);
    }

    @Override
    public String getValue(String xmlName) {
        int index = this.getIndex(xmlName);
        if (index < 0) {
            return null;
        }
        return this.getValue(index);
    }

    @Override
    public boolean isDeclared(int index) {
        if (index < 0 || index >= this.attributeCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        String type = this.parser.getAttributeType(this.elementName, this.getQName(index));
        return type != null;
    }

    @Override
    public boolean isDeclared(String qName) {
        int index = this.getIndex(qName);
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        String type = this.parser.getAttributeType(this.elementName, qName);
        return type != null;
    }

    @Override
    public boolean isDeclared(String uri, String localName) {
        int index = this.getIndex(uri, localName);
        return this.isDeclared(index);
    }

    @Override
    public boolean isSpecified(int index) {
        return this.attributesList.get((int)index).specified;
    }

    @Override
    public boolean isSpecified(String uri, String local) {
        int index = this.getIndex(uri, local);
        return this.isSpecified(index);
    }

    @Override
    public boolean isSpecified(String xmlName) {
        int index = this.getIndex(xmlName);
        return this.isSpecified(index);
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        if (this.entityStack.empty()) {
            return null;
        }
        return this.entityStack.peek();
    }

    @Override
    public int getLineNumber() {
        return this.parser.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.parser.getColumnNumber();
    }

    public void setCharacterHandler(CharacterHandler characterHandler) {
        this.characterHandler = characterHandler;
    }

    @Override
    public String getEncoding() {
        return this.parser.getEncoding();
    }

    @Override
    public String getXMLVersion() {
        return "1.0";
    }

    private static class Attribute {
        String name;
        String value;
        String nameSpace;
        String localName;
        boolean specified;

        Attribute(String name, String value, boolean specified) {
            this.name = name;
            this.value = value;
            this.nameSpace = "";
            this.specified = specified;
        }
    }

    private static class Adapter
    implements ContentHandler {
        private DocumentHandler docHandler;

        Adapter(DocumentHandler dh) {
            this.docHandler = dh;
        }

        @Override
        public void setDocumentLocator(Locator l) {
            this.docHandler.setDocumentLocator(l);
        }

        @Override
        public void startDocument() throws SAXException {
            this.docHandler.startDocument();
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.docHandler.processingInstruction(target, data);
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
        }

        @Override
        public void startElement(String namespace, String local, String name, Attributes attrs) throws SAXException {
            this.docHandler.startElement(name, (AttributeList)((Object)attrs));
        }

        @Override
        public void characters(char[] buf, int offset, int len) throws SAXException {
            this.docHandler.characters(buf, offset, len);
        }

        @Override
        public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
            this.docHandler.ignorableWhitespace(buf, offset, len);
        }

        @Override
        public void skippedEntity(String name) {
        }

        @Override
        public void endElement(String u, String l, String name) throws SAXException {
            this.docHandler.endElement(name);
        }

        @Override
        public void endPrefixMapping(String prefix) {
        }

        @Override
        public void endDocument() throws SAXException {
            this.docHandler.endDocument();
        }
    }
}

