/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.servlet;

import com.thaiopensource.validate.Validator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.validator.checker.AttributeUtil;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class CssDetector
implements Validator,
ContentHandler {
    private static final Pattern TEXT_CSS = Pattern.compile("^[tT][eE][xX][tT]/[cC][sS][sS]\\s*(?:;.*)?$");
    private boolean sawCss = false;

    public static boolean lowerCaseLiteralEqualsIgnoreAsciiCase(String lowerCaseLiteral, String string) {
        if (string == null) {
            return false;
        }
        if (lowerCaseLiteral.length() != string.length()) {
            return false;
        }
        for (int i = 0; i < lowerCaseLiteral.length(); ++i) {
            char c0 = lowerCaseLiteral.charAt(i);
            char c1 = string.charAt(i);
            if (c1 >= 'A' && c1 <= 'Z') {
                c1 = (char)(c1 + 32);
            }
            if (c0 == c1) continue;
            return false;
        }
        return true;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public void reset() {
        this.sawCss = false;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this.reset();
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        if ("http://www.w3.org/1999/xhtml" == uri) {
            if ("style" == localName) {
                this.checkType(atts);
                return;
            }
            if ("link" == localName) {
                String rel = atts.getValue("", "rel");
                if (rel != null) {
                    String[] tokens = AttributeUtil.split(rel);
                    for (int i = 0; i < tokens.length; ++i) {
                        String token = tokens[i];
                        if (!CssDetector.lowerCaseLiteralEqualsIgnoreAsciiCase("stylesheet", token)) continue;
                        this.checkType(atts);
                        return;
                    }
                }
            } else if (atts.getIndex("", "style") > -1) {
                this.sawCss = true;
            }
        }
    }

    private void checkType(Attributes atts) {
        String type = atts.getValue("", "type");
        if (type == null) {
            this.sawCss = true;
        } else {
            Matcher m = TEXT_CSS.matcher(type);
            if (m.matches()) {
                this.sawCss = true;
            }
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }
}

