/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.servlet;

import java.io.IOException;
import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public final class OutlineBuildingXMLReaderWrapper
implements XMLReader,
ContentHandler {
    private final XMLReader wrappedReader;
    private final HttpServletRequest request;
    private ContentHandler contentHandler;
    private static final int MAX_EXCERPT = 500;
    private static final String[] SECTIONING_CONTENT_ELEMENTS = new String[]{"article", "aside", "nav", "section"};
    private static final String[] SECTIONING_ROOT_ELEMENTS = new String[]{"blockquote", "body", "details", "fieldset", "figure", "td"};
    private static final String[] HEADING_CONTENT_ELEMENTS = new String[]{"h1", "h2", "h3", "h4", "h5", "h6", "hgroup"};
    private Deque<Section> outline;
    private int currentWalkDepth;
    private Element currentOutlinee;
    private Deque<Element> elementStack = new LinkedList<Element>();
    private Deque<Element> outlineStack = new LinkedList<Element>();
    private boolean inHeadingContentOrHiddenElement;
    private boolean needHeading;
    private boolean skipHeading;
    private Section currentSection;
    private boolean isWalkOver;
    private static final Pattern excerptPattern = Pattern.compile("\\W*\\S*$");
    private static final Pattern whitespacePattern = Pattern.compile("\\s+");

    public OutlineBuildingXMLReaderWrapper(XMLReader wrappedReader, HttpServletRequest request) {
        this.request = request;
        this.wrappedReader = wrappedReader;
        this.contentHandler = wrappedReader.getContentHandler();
        wrappedReader.setContentHandler(this);
    }

    public Deque<Section> getOutline() {
        return this.outline;
    }

    protected void setOutline(Deque<Section> outline) {
        this.outline = outline;
    }

    private boolean inHiddenSubtree() {
        for (Element element : this.elementStack) {
            if (!element.isHidden()) continue;
            return true;
        }
        return false;
    }

    private String excerpt(String str, int maxLength) {
        return str.length() > maxLength ? excerptPattern.matcher(str.substring(0, maxLength)).replaceFirst("&hellip;") : str;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        if (this.isWalkOver) {
            this.contentHandler.characters(ch, start, length);
            return;
        }
        if (this.inHeadingContentOrHiddenElement && !this.inHiddenSubtree()) {
            this.currentSection.getHeadingTextBuilder().append(ch, start, length);
        }
        this.contentHandler.characters(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.elementStack.pop();
        if ("hgroup".equals(localName)) {
            this.needHeading = false;
            this.skipHeading = false;
        }
        if (this.isWalkOver) {
            this.contentHandler.endElement(uri, localName, qName);
            return;
        }
        int depth = this.currentWalkDepth--;
        if (this.inHeadingContentOrHiddenElement) {
            Element topElement = this.outlineStack.peek();
            assert (topElement != null);
            if (topElement.equals(depth, localName)) {
                this.outlineStack.pop();
                this.inHeadingContentOrHiddenElement = false;
                if (this.currentSection != null) {
                    StringBuilder headingTextBuilder = this.currentSection.getHeadingTextBuilder();
                    String heading = this.excerpt(whitespacePattern.matcher(headingTextBuilder).replaceAll(" ").trim(), 500);
                    headingTextBuilder.setLength(0);
                    if (heading.length() > 0) {
                        headingTextBuilder.append(heading);
                    } else {
                        this.currentSection.createEmptyHeading();
                    }
                }
            }
            this.contentHandler.endElement(uri, localName, qName);
            return;
        }
        if (Arrays.binarySearch(SECTIONING_CONTENT_ELEMENTS, localName) > -1) {
            if (!this.outlineStack.isEmpty()) {
                if (this.currentSection != null && !this.currentSection.hasHeading()) {
                    this.currentSection.createImpliedHeading();
                }
                Element exitedSectioningContentElement = this.currentOutlinee;
                assert (exitedSectioningContentElement != null);
                this.currentOutlinee = this.outlineStack.pop();
                this.currentSection = this.currentOutlinee.getOutline().peekLast();
                assert (this.currentSection != null);
                for (Section section : exitedSectioningContentElement.outline) {
                    section.setParent(this.currentSection);
                    this.currentSection.sections.add(section);
                }
            }
        } else if (Arrays.binarySearch(SECTIONING_ROOT_ELEMENTS, localName) > -1) {
            if (!this.outlineStack.isEmpty()) {
                if (this.currentSection != null && !this.currentSection.hasHeading()) {
                    this.currentSection.createImpliedHeading();
                }
                this.currentOutlinee = this.outlineStack.pop();
                this.currentSection = this.currentOutlinee.getOutline().peekLast();
                while (!this.currentSection.sections.isEmpty()) {
                    this.currentSection = this.currentSection.sections.peekLast();
                }
            }
        } else {
            this.contentHandler.endElement(uri, localName, qName);
            return;
        }
        if (this.currentSection != null && !this.currentSection.hasHeading()) {
            this.currentSection.createImpliedHeading();
        }
        this.contentHandler.endElement(uri, localName, qName);
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.startDocument();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        if (this.isWalkOver) {
            this.contentHandler.startElement(uri, localName, qName, atts);
            return;
        }
        ++this.currentWalkDepth;
        boolean hidden = atts.getIndex("", "hidden") >= 0;
        this.elementStack.push(new Element(this.currentWalkDepth, localName, hidden));
        if (this.inHeadingContentOrHiddenElement) {
            if (!this.inHiddenSubtree() && "img".equals(localName) && atts.getIndex("", "alt") >= 0) {
                this.currentSection.getHeadingTextBuilder().append(atts.getValue("", "alt"));
            }
            this.contentHandler.startElement(uri, localName, qName, atts);
            return;
        }
        if (hidden) {
            this.outlineStack.push(new Element(this.currentWalkDepth, localName, hidden));
            this.inHeadingContentOrHiddenElement = true;
            this.contentHandler.startElement(uri, localName, qName, atts);
            return;
        }
        if (Arrays.binarySearch(SECTIONING_CONTENT_ELEMENTS, localName) > -1 || Arrays.binarySearch(SECTIONING_ROOT_ELEMENTS, localName) > -1) {
            if (this.currentOutlinee != null) {
                if (this.currentSection != null && !this.currentSection.hasHeading()) {
                    this.currentSection.createImpliedHeading();
                }
                this.outlineStack.push(this.currentOutlinee);
            }
            this.currentOutlinee = new Element(this.currentWalkDepth, localName, hidden);
            this.currentSection = new Section(localName);
            this.currentOutlinee.getOutline().add(this.currentSection);
            this.contentHandler.startElement(uri, localName, qName, atts);
            return;
        }
        if (Arrays.binarySearch(HEADING_CONTENT_ELEMENTS, localName) > -1 && this.currentOutlinee != null) {
            if ("hgroup".equals(localName)) {
                this.needHeading = true;
                this.skipHeading = false;
                this.contentHandler.startElement(uri, localName, qName, atts);
                return;
            }
            if (this.skipHeading) {
                this.contentHandler.startElement(uri, localName, qName, atts);
                return;
            }
            if (this.needHeading) {
                this.skipHeading = true;
                this.needHeading = false;
            }
            int rank = localName.charAt(1) - 48;
            if (this.currentSection != null && !this.currentSection.hasHeading()) {
                this.currentSection.setHeadingRank(rank);
            } else if (rank <= this.currentOutlinee.getLastSectionHeadingRank()) {
                this.currentSection = new Section(localName);
                this.currentOutlinee.getOutline().add(this.currentSection);
                this.currentSection.setHeadingRank(rank);
            } else {
                for (Section candidateSection = this.currentSection; candidateSection != null; candidateSection = candidateSection.getParent()) {
                    if (rank <= candidateSection.getHeadingRank()) continue;
                    this.currentSection = new Section(localName);
                    this.currentSection.setParent(candidateSection);
                    candidateSection.getSections().add(this.currentSection);
                    this.currentSection.setHeadingRank(rank);
                    break;
                }
            }
            this.outlineStack.push(new Element(this.currentWalkDepth, localName, hidden));
            this.inHeadingContentOrHiddenElement = true;
        }
        this.contentHandler.startElement(uri, localName, qName, atts);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.setDocumentLocator(locator);
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        if (this.currentOutlinee != null) {
            this.request.setAttribute("http://validator.nu/properties/document-outline", this.currentOutlinee.outline);
            this.setOutline(this.currentOutlinee.outline);
        }
        this.contentHandler.endDocument();
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.processingInstruction(target, data);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.skippedEntity(name);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (this.contentHandler == null) {
            return;
        }
        this.contentHandler.startPrefixMapping(prefix, uri);
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.wrappedReader.getDTDHandler();
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.wrappedReader.getEntityResolver();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.wrappedReader.getErrorHandler();
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.wrappedReader.getFeature(name);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.wrappedReader.getProperty(name);
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        this.wrappedReader.parse(input);
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        this.wrappedReader.parse(systemId);
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.wrappedReader.setDTDHandler(handler);
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.wrappedReader.setEntityResolver(resolver);
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.wrappedReader.setErrorHandler(handler);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.wrappedReader.setFeature(name, value);
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.wrappedReader.setProperty(name, value);
    }

    public class Section {
        private Section parent;
        final String elementName;
        private final StringBuilder headingTextBuilder = new StringBuilder();
        private boolean hasImpliedHeading;
        private boolean hasEmptyHeading;
        private int headingRank = Integer.MAX_VALUE;
        public final Deque<Section> sections = new LinkedList<Section>();

        public Section(String elementName) {
            this.elementName = elementName;
        }

        public Section getParent() {
            return this.parent;
        }

        public String getElementName() {
            return this.elementName;
        }

        public void setParent(Section parent) {
            this.parent = parent;
        }

        public StringBuilder getHeadingTextBuilder() {
            return this.headingTextBuilder;
        }

        public int getHeadingRank() {
            return this.headingRank;
        }

        public Deque<Section> getSections() {
            return this.sections;
        }

        public void setHeadingRank(int headingRank) {
            this.headingRank = headingRank;
        }

        public boolean hasHeading() {
            return this.headingRank < 7 || this.hasImpliedHeading;
        }

        public void createImpliedHeading() {
            this.hasImpliedHeading = true;
        }

        public void createEmptyHeading() {
            this.hasEmptyHeading = true;
        }

        public boolean hasEmptyHeading() {
            return this.hasEmptyHeading;
        }
    }

    private class Element {
        private final int depth;
        private final String name;
        private final boolean hidden;
        private final Deque<Section> outline = new LinkedList<Section>();

        public Element(int depth, String name, boolean hidden) {
            this.depth = depth;
            this.name = name;
            this.hidden = hidden;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public boolean equals(int depth, String name) {
            return this.depth == depth && this.name.equals(name);
        }

        public Deque<Section> getOutline() {
            return this.outline;
        }

        public int getLastSectionHeadingRank() {
            Section section = this.outline.peekLast();
            return section != null ? section.getHeadingRank() : -1;
        }
    }
}

