/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.servlet;

import java.io.IOException;
import java.text.DecimalFormat;
import javax.servlet.http.HttpServletResponse;
import nu.validator.htmlparser.sax.HtmlSerializer;
import nu.validator.xml.EmptyAttributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class Statistics {
    public static final Statistics STATISTICS;
    private static final char[] VALIDATOR_STATISTICS;
    private static final char[] COUNTER_NAME;
    private static final char[] COUNTER_VALUE;
    private static final char[] COUNTER_PROPORTION;
    private static final char[] TOTAL_VALIDATIONS;
    private static final char[] UPTIME_DAYS;
    private static final char[] VALIDATIONS_PER_SECOND;
    private final long startTime = System.currentTimeMillis();
    private long total = 0L;
    private final long[] counters = new long[Field.values().length];

    private Statistics() {
    }

    public void incrementTotal() {
        ++this.total;
    }

    public void incrementField(Field field) {
        int n = field.ordinal();
        this.counters[n] = this.counters[n] + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToResponse(HttpServletResponse response) throws IOException {
        try {
            long totalCopy;
            long[] countersCopy = new long[this.counters.length];
            Statistics statistics = this;
            synchronized (statistics) {
                totalCopy = this.total;
                System.arraycopy(this.counters, 0, countersCopy, 0, this.counters.length);
            }
            double totalDouble = totalCopy;
            double uptimeMillis = System.currentTimeMillis() - this.startTime;
            response.setContentType("text/html; charset=utf-8");
            HtmlSerializer ch = new HtmlSerializer(response.getOutputStream());
            try {
                ch.startDocument();
                this.startElement(ch, "html");
                this.startElement(ch, "head");
                this.startElement(ch, "title");
                this.characters((ContentHandler)ch, VALIDATOR_STATISTICS);
                this.endElement(ch, "title");
                this.endElement(ch, "head");
                this.startElement(ch, "body");
                this.startElement(ch, "h1");
                this.characters((ContentHandler)ch, VALIDATOR_STATISTICS);
                this.endElement(ch, "h1");
                this.startElement(ch, "dl");
                this.startElement(ch, "dt");
                this.characters((ContentHandler)ch, TOTAL_VALIDATIONS);
                this.endElement(ch, "dt");
                this.startElement(ch, "dd");
                this.characters((ContentHandler)ch, totalCopy);
                this.endElement(ch, "dd");
                this.startElement(ch, "dt");
                this.characters((ContentHandler)ch, UPTIME_DAYS);
                this.endElement(ch, "dt");
                this.startElement(ch, "dd");
                this.characters((ContentHandler)ch, uptimeMillis / 8.64E7);
                this.endElement(ch, "dd");
                this.startElement(ch, "dt");
                this.characters((ContentHandler)ch, VALIDATIONS_PER_SECOND);
                this.endElement(ch, "dt");
                this.startElement(ch, "dd");
                this.characters((ContentHandler)ch, totalDouble / (uptimeMillis / 1000.0));
                this.endElement(ch, "dd");
                this.endElement(ch, "dl");
                this.startElement(ch, "table");
                this.startElement(ch, "thead");
                this.startElement(ch, "tr");
                this.startElement(ch, "th");
                this.characters((ContentHandler)ch, COUNTER_NAME);
                this.endElement(ch, "th");
                this.startElement(ch, "th");
                this.characters((ContentHandler)ch, COUNTER_VALUE);
                this.endElement(ch, "th");
                this.startElement(ch, "th");
                this.characters((ContentHandler)ch, COUNTER_PROPORTION);
                this.endElement(ch, "th");
                this.endElement(ch, "tr");
                this.endElement(ch, "thead");
                this.startElement(ch, "tbody");
                for (int i = 0; i < countersCopy.length; ++i) {
                    long count = countersCopy[i];
                    this.startElement(ch, "tr");
                    this.startElement(ch, "td");
                    this.characters((ContentHandler)ch, Field.values()[i].toString());
                    this.endElement(ch, "td");
                    this.startElement(ch, "td");
                    this.characters((ContentHandler)ch, count);
                    this.endElement(ch, "td");
                    this.startElement(ch, "td");
                    this.characters((ContentHandler)ch, (double)count / totalDouble);
                    this.endElement(ch, "td");
                    this.endElement(ch, "tr");
                }
                this.endElement(ch, "tbody");
                this.endElement(ch, "table");
                this.endElement(ch, "body");
                this.endElement(ch, "html");
            }
            finally {
                ch.endDocument();
            }
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    private void characters(ContentHandler ch, double d) throws SAXException {
        DecimalFormat df = new DecimalFormat("#,###,##0.000000");
        this.characters(ch, df.format(d));
    }

    private void characters(ContentHandler ch, long l) throws SAXException {
        this.characters(ch, Long.toString(l));
    }

    private void characters(ContentHandler ch, String str) throws SAXException {
        this.characters(ch, str.toCharArray());
    }

    private void characters(ContentHandler ch, char[] cs) throws SAXException {
        ch.characters(cs, 0, cs.length);
    }

    private void endElement(ContentHandler ch, String name) throws SAXException {
        ch.endElement("http://www.w3.org/1999/xhtml", name, name);
    }

    private void startElement(ContentHandler ch, String name) throws SAXException {
        ch.startElement("http://www.w3.org/1999/xhtml", name, name, EmptyAttributes.EMPTY_ATTRIBUTES);
    }

    static {
        VALIDATOR_STATISTICS = "Validator statistics".toCharArray();
        COUNTER_NAME = "Counter".toCharArray();
        COUNTER_VALUE = "Value".toCharArray();
        COUNTER_PROPORTION = "Proportion".toCharArray();
        TOTAL_VALIDATIONS = "Total number of validations".toCharArray();
        UPTIME_DAYS = "Uptime in days".toCharArray();
        VALIDATIONS_PER_SECOND = "Validations per second".toCharArray();
        STATISTICS = "1".equals(System.getProperty("nu.validator.servlet.statistics")) ? new Statistics() : null;
    }

    public static enum Field {
        CUSTOM_ENC("Manually set character encoding"),
        AUTO_SCHEMA("Automatically chosen schema"),
        PRESET_SCHEMA("Preset schema"),
        BUILT_IN_NON_PRESET("Custom schema combined from built-ins"),
        HTML5_SCHEMA("(X)HTML5 schema"),
        HTML5_RDFA_LITE_SCHEMA("(X)HTML5+RDFa Lite schema"),
        HTML4_STRICT_SCHEMA("Legacy Strict schema"),
        HTML4_TRANSITIONAL_SCHEMA("Legacy Transitional schema"),
        HTML4_FRAMESET_SCHEMA("Legacy Frameset schema"),
        XHTML1_COMPOUND_SCHEMA("Legacy XHTML+SVG+MathML schema"),
        SVG_SCHEMA("SVG schema"),
        EXTERNAL_SCHEMA_NON_SCHEMATRON("non-Schematron custom schema"),
        EXTERNAL_SCHEMA_SCHEMATRON("Schematron custom schema"),
        LOGIC_ERROR("Logic errors in schema stats"),
        PARSER_XML_EXTERNAL("Parser set to XML with external entities"),
        PARSER_HTML4("Parser set to explicit HTML4 mode"),
        XMLNS_FILTER("XMLNS filter set"),
        LAX_TYPE("Being lax about HTTP content type"),
        IMAGE_REPORT("Image report"),
        SHOW_SOURCE("Show source"),
        SHOW_OUTLINE("Show outline"),
        INPUT_GET("GET-based input"),
        INPUT_POST("POST-based input"),
        INPUT_TEXT_FIELD("\u2514 Text-field input"),
        INPUT_FILE_UPLOAD("\u2514 File-upload input"),
        INPUT_ENTITY_BODY("\u2514 Entity-body input"),
        OUTPUT_HTML("HTML output"),
        OUTPUT_XHTML("XHTML output"),
        OUTPUT_XML("XML output"),
        OUTPUT_JSON("JSON output"),
        OUTPUT_GNU("GNU output"),
        OUTPUT_TEXT("Text output"),
        INPUT_HTML("HTML input"),
        INPUT_XML("XML input");

        private final String description;

        private Field(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

