/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.servlet;

import com.ibm.icu.text.Normalizer;
import com.thaiopensource.relaxng.impl.CombineValidator;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.SchemaResolver;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.validate.prop.wrap.WrapProperty;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nu.validator.checker.XmlPiChecker;
import nu.validator.checker.jing.CheckerSchema;
import nu.validator.gnu.xml.aelfred2.SAXDriver;
import nu.validator.htmlparser.common.DoctypeExpectation;
import nu.validator.htmlparser.common.DocumentMode;
import nu.validator.htmlparser.common.DocumentModeHandler;
import nu.validator.htmlparser.common.Heuristics;
import nu.validator.htmlparser.common.XmlViolationPolicy;
import nu.validator.htmlparser.sax.HtmlParser;
import nu.validator.htmlparser.sax.HtmlSerializer;
import nu.validator.htmlparser.sax.XmlSerializer;
import nu.validator.io.BoundedInputStream;
import nu.validator.io.DataUri;
import nu.validator.io.StreamBoundException;
import nu.validator.json.Serializer;
import nu.validator.localentities.LocalCacheEntityResolver;
import nu.validator.messages.GnuMessageEmitter;
import nu.validator.messages.JsonMessageEmitter;
import nu.validator.messages.MessageEmitterAdapter;
import nu.validator.messages.TextMessageEmitter;
import nu.validator.messages.TooManyErrorsException;
import nu.validator.messages.XhtmlMessageEmitter;
import nu.validator.messages.XmlMessageEmitter;
import nu.validator.servlet.BufferingRootNamespaceSniffer;
import nu.validator.servlet.CharsetEmitter;
import nu.validator.servlet.FormEmitter;
import nu.validator.servlet.NsFilterEmitter;
import nu.validator.servlet.OutlineBuildingXMLReaderWrapper;
import nu.validator.servlet.PageEmitter;
import nu.validator.servlet.ParserMode;
import nu.validator.servlet.RootNamespaceSniffer;
import nu.validator.servlet.Statistics;
import nu.validator.servlet.StatsEmitter;
import nu.validator.servlet.VerifierServlet;
import nu.validator.servlet.VerifierServletXMLReaderCreator;
import nu.validator.servlet.XhtmlOutlineEmitter;
import nu.validator.servlet.imagereview.ImageCollector;
import nu.validator.source.SourceCode;
import nu.validator.spec.Spec;
import nu.validator.spec.html5.Html5SpecBuilder;
import nu.validator.xml.AttributesImpl;
import nu.validator.xml.AttributesPermutingXMLReaderWrapper;
import nu.validator.xml.BaseUriTracker;
import nu.validator.xml.CharacterUtil;
import nu.validator.xml.CombineContentHandler;
import nu.validator.xml.ContentTypeParser;
import nu.validator.xml.DataUriEntityResolver;
import nu.validator.xml.IdFilter;
import nu.validator.xml.NamespaceDroppingXMLReaderWrapper;
import nu.validator.xml.NullEntityResolver;
import nu.validator.xml.PrudentHttpEntityResolver;
import nu.validator.xml.SystemErrErrorHandler;
import nu.validator.xml.TypedInputSource;
import nu.validator.xml.WiretapXMLReaderWrapper;
import nu.validator.xml.XhtmlSaxEmitter;
import nu.validator.xml.dataattributes.DataAttributeDroppingSchemaWrapper;
import nu.validator.xml.langattributes.XmlLangAttributeDroppingSchemaWrapper;
import nu.validator.xml.roleattributes.RoleAttributeFilteringSchemaWrapper;
import org.apache.log4j.Logger;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

class VerifierServletTransaction
implements DocumentModeHandler,
SchemaResolver {
    private static final Logger log4j = Logger.getLogger(VerifierServletTransaction.class);
    private static final Pattern SPACE = Pattern.compile("\\s+");
    private static final Pattern JS_IDENTIFIER = Pattern.compile("[\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}_\\$][\\p{Lu}\\p{Ll}\\p{Lt}\\p{Lm}\\p{Lo}\\p{Nl}_\\$\\p{Mn}\\p{Mc}\\p{Nd}\\p{Pc}]*");
    private static final String[] JS_RESERVED_WORDS = new String[]{"abstract", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "debugger", "default", "delete", "do", "double", "else", "enum", "export", "extends", "final", "finally", "float", "for", "function", "goto", "if", "implements", "import", "in", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "typeof", "var", "void", "volatile", "while", "with"};
    private static final String[] CHARSETS = new String[]{"UTF-8", "UTF-16", "Windows-1250", "Windows-1251", "Windows-1252", "Windows-1253", "Windows-1254", "Windows-1255", "Windows-1256", "Windows-1257", "Windows-1258", "ISO-8859-1", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-9", "ISO-8859-13", "ISO-8859-15", "KOI8-R", "TIS-620", "GBK", "GB18030", "Big5", "Big5-HKSCS", "Shift_JIS", "ISO-2022-JP", "EUC-JP", "ISO-2022-KR", "EUC-KR"};
    private static final char[][] CHARSET_DESCRIPTIONS = new char[][]{"UTF-8 (Global)".toCharArray(), "UTF-16 (Global)".toCharArray(), "Windows-1250 (Central European)".toCharArray(), "Windows-1251 (Cyrillic)".toCharArray(), "Windows-1252 (Western)".toCharArray(), "Windows-1253 (Greek)".toCharArray(), "Windows-1254 (Turkish)".toCharArray(), "Windows-1255 (Hebrew)".toCharArray(), "Windows-1256 (Arabic)".toCharArray(), "Windows-1257 (Baltic)".toCharArray(), "Windows-1258 (Vietnamese)".toCharArray(), "ISO-8859-1 (Western)".toCharArray(), "ISO-8859-2 (Central European)".toCharArray(), "ISO-8859-3 (South European)".toCharArray(), "ISO-8859-4 (Baltic)".toCharArray(), "ISO-8859-5 (Cyrillic)".toCharArray(), "ISO-8859-6 (Arabic)".toCharArray(), "ISO-8859-7 (Greek)".toCharArray(), "ISO-8859-8 (Hebrew)".toCharArray(), "ISO-8859-9 (Turkish)".toCharArray(), "ISO-8859-13 (Baltic)".toCharArray(), "ISO-8859-15 (Western)".toCharArray(), "KOI8-R (Russian)".toCharArray(), "TIS-620 (Thai)".toCharArray(), "GBK (Chinese, simplified)".toCharArray(), "GB18030 (Chinese, simplified)".toCharArray(), "Big5 (Chinese, traditional)".toCharArray(), "Big5-HKSCS (Chinese, traditional)".toCharArray(), "Shift_JIS (Japanese)".toCharArray(), "ISO-2022-JP (Japanese)".toCharArray(), "EUC-JP (Japanese)".toCharArray(), "ISO-2022-KR (Korean)".toCharArray(), "EUC-KR (Korean)".toCharArray()};
    protected static final int HTML5_SCHEMA = 3;
    protected static final int XHTML1STRICT_SCHEMA = 2;
    protected static final int XHTML1TRANSITIONAL_SCHEMA = 1;
    protected static final int XHTML5_SCHEMA = 7;
    private static final char[] SERVICE_TITLE;
    private static final char[] LIVING_VERSION;
    private static final char[] VERSION;
    private static final char[] RESULTS_TITLE;
    private static final char[] FOR;
    private static final char[] ABOUT_THIS_SERVICE;
    private static final char[] SIMPLE_UI;
    private static final String USER_AGENT;
    private static Spec html5spec;
    private static int[] presetDoctypes;
    private static String[] presetLabels;
    private static String[] presetUrls;
    private static String[] presetNamespaces;
    private static final String[] KNOWN_CONTENT_TYPES;
    private static final String[] NAMESPACES_FOR_KNOWN_CONTENT_TYPES;
    private static final String[] ALL_CHECKERS;
    private static final String[] ALL_CHECKERS_HTML4;
    private long start = System.currentTimeMillis();
    protected final HttpServletRequest request;
    private final HttpServletResponse response;
    protected String document = null;
    private ParserMode parser = ParserMode.AUTO;
    private String profile = "";
    private boolean laxType = false;
    protected ContentHandler contentHandler;
    protected XhtmlSaxEmitter emitter;
    protected MessageEmitterAdapter errorHandler;
    protected final AttributesImpl attrs = new AttributesImpl();
    private OutputStream out;
    private PropertyMap jingPropertyMap;
    protected LocalCacheEntityResolver entityResolver;
    private static long lastModified;
    private static String[] preloadedSchemaUrls;
    private static Schema[] preloadedSchemas;
    private static final String ABOUT_PAGE;
    private static final String HTML5_FACET;
    private static final String STYLE_SHEET;
    private static final String ICON;
    private static final String SCRIPT;
    private static final String[] LEGACY_HOSTS;
    private static final long SIZE_LIMIT;
    private String schemaUrls = null;
    protected Validator validator = null;
    private BufferingRootNamespaceSniffer bufferingRootNamespaceSniffer = null;
    private String contentType = null;
    protected HtmlParser htmlParser = null;
    protected SAXDriver xmlParser = null;
    protected XMLReader reader;
    protected TypedInputSource documentInput;
    protected PrudentHttpEntityResolver httpRes;
    protected DataUriEntityResolver dataRes;
    protected ContentTypeParser contentTypeParser;
    private Set<String> loadedValidatorUrls = new HashSet<String>();
    private boolean checkNormalization = false;
    private boolean rootNamespaceSeen = false;
    private OutputFormat outputFormat;
    private String postContentType;
    private boolean methodIsGet;
    private SourceCode sourceCode = new SourceCode();
    private Deque<OutlineBuildingXMLReaderWrapper.Section> outline;
    private boolean showSource;
    private boolean showOutline;
    private String userAgent;
    private BaseUriTracker baseUriTracker = null;
    private String charsetOverride = null;
    private Set<String> filteredNamespaces = new LinkedHashSet<String>();
    private LexicalHandler lexicalHandler;
    protected ImageCollector imageCollector;
    private boolean externalSchema = false;
    private boolean externalSchematron = false;
    private String schemaListForStats = null;

    protected static String scrub(CharSequence s) {
        return Normalizer.normalize(CharacterUtil.prudentlyScrubCharacterData(s), Normalizer.NFC);
    }

    private static boolean isDataAttributeDroppingSchema(String key) {
        return "http://s.validator.nu/xhtml5.rnc".equals(key) || "http://s.validator.nu/html5.rnc".equals(key) || "http://s.validator.nu/html5-all.rnc".equals(key) || "http://s.validator.nu/xhtml5-all.rnc".equals(key) || "http://s.validator.nu/html5-its.rnc".equals(key) || "http://s.validator.nu/xhtml5-rdfalite.rnc".equals(key) || "http://s.validator.nu/html5-rdfalite.rnc".equals(key);
    }

    private static boolean isXmlLangAllowingSchema(String key) {
        return "http://s.validator.nu/xhtml5.rnc".equals(key) || "http://s.validator.nu/html5.rnc".equals(key) || "http://s.validator.nu/html5-all.rnc".equals(key) || "http://s.validator.nu/xhtml5-all.rnc".equals(key) || "http://s.validator.nu/html5-its.rnc".equals(key) || "http://s.validator.nu/xhtml5-rdfalite.rnc".equals(key) || "http://s.validator.nu/html5-rdfalite.rnc".equals(key);
    }

    private static boolean isRoleAttributeFilteringSchema(String key) {
        return "http://s.validator.nu/xhtml5.rnc".equals(key) || "http://s.validator.nu/html5.rnc".equals(key) || "http://s.validator.nu/html5-all.rnc".equals(key) || "http://s.validator.nu/xhtml5-all.rnc".equals(key) || "http://s.validator.nu/html5-its.rnc".equals(key) || "http://s.validator.nu/xhtml5-rdfalite.rnc".equals(key) || "http://s.validator.nu/html5-rdfalite.rnc".equals(key);
    }

    private static boolean isCheckerUrl(String url) {
        if ("http://c.validator.nu/all/".equals(url) || "http://hsivonen.iki.fi/checkers/all/".equals(url)) {
            return true;
        }
        if ("http://c.validator.nu/all-html4/".equals(url) || "http://hsivonen.iki.fi/checkers/all-html4/".equals(url)) {
            return true;
        }
        if ("http://c.validator.nu/base/".equals(url)) {
            return true;
        }
        if ("http://c.validator.nu/rdfalite/".equals(url)) {
            return true;
        }
        for (int i = 0; i < ALL_CHECKERS.length; ++i) {
            if (!ALL_CHECKERS[i].equals(url)) continue;
            return true;
        }
        return false;
    }

    VerifierServletTransaction(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    protected boolean willValidate() {
        if (this.methodIsGet) {
            return this.document != null;
        }
        return true;
    }

    void service() throws ServletException, IOException {
        String nsfilter;
        String charset;
        String outFormat;
        this.methodIsGet = "GET".equals(this.request.getMethod()) || "HEAD".equals(this.request.getMethod());
        this.out = this.response.getOutputStream();
        System.setProperty("nu.validator.servlet.request.legacy", "false");
        if (Arrays.asList(LEGACY_HOSTS).contains(this.request.getRemoteHost())) {
            System.setProperty("nu.validator.servlet.request.legacy", "true");
        }
        try {
            this.request.setCharacterEncoding("utf-8");
        }
        catch (NoSuchMethodError e) {
            log4j.debug("Vintage Servlet API doesn't support setCharacterEncoding().", e);
        }
        if (!this.methodIsGet) {
            this.postContentType = this.request.getContentType();
            if (this.postContentType == null) {
                this.response.sendError(400, "Content-Type missing");
                return;
            }
            if (this.postContentType.trim().toLowerCase().startsWith("application/x-www-form-urlencoded")) {
                this.response.sendError(415, "application/x-www-form-urlencoded not supported. Please use multipart/form-data.");
                return;
            }
        }
        if ((outFormat = this.request.getParameter("out")) == null) {
            this.outputFormat = OutputFormat.HTML;
        } else if ("html".equals(outFormat)) {
            this.outputFormat = OutputFormat.HTML;
        } else if ("xhtml".equals(outFormat)) {
            this.outputFormat = OutputFormat.XHTML;
        } else if ("text".equals(outFormat)) {
            this.outputFormat = OutputFormat.TEXT;
        } else if ("gnu".equals(outFormat)) {
            this.outputFormat = OutputFormat.GNU;
        } else if ("xml".equals(outFormat)) {
            this.outputFormat = OutputFormat.XML;
        } else if ("json".equals(outFormat)) {
            this.outputFormat = OutputFormat.JSON;
        } else {
            this.response.sendError(400, "Unsupported output format");
            return;
        }
        if (!this.methodIsGet) {
            this.document = this.request.getHeader("Content-Location");
        }
        if (this.document == null) {
            this.document = this.request.getParameter("doc");
        }
        if (this.document == null) {
            this.document = this.request.getParameter("file");
        }
        this.document = "".equals(this.document) ? null : this.document;
        String callback = null;
        if (this.outputFormat == OutputFormat.JSON && (callback = this.request.getParameter("callback")) != null) {
            Matcher m = JS_IDENTIFIER.matcher(callback);
            if (m.matches()) {
                if (Arrays.binarySearch(JS_RESERVED_WORDS, callback) >= 0) {
                    this.response.sendError(400, "Callback is a reserved word.");
                    return;
                }
            } else {
                this.response.sendError(400, "Callback is not a valid ECMA 262 IdentifierName.");
                return;
            }
        }
        if (this.willValidate()) {
            this.response.setDateHeader("Expires", 0L);
            this.response.setHeader("Cache-Control", "no-cache");
        } else if (this.outputFormat == OutputFormat.HTML || this.outputFormat == OutputFormat.XHTML) {
            this.response.setDateHeader("Last-Modified", lastModified);
        } else {
            this.response.sendError(400, "No input document");
            return;
        }
        this.setup();
        this.userAgent = this.request.getParameter("useragent") != null ? VerifierServletTransaction.scrub(this.request.getParameter("useragent")) : USER_AGENT;
        this.showSource = this.request.getParameter("showsource") != null;
        boolean bl = this.showOutline = this.request.getParameter("showoutline") != null;
        if (this.request.getParameter("showimagereport") != null) {
            this.imageCollector = new ImageCollector(this.sourceCode);
        }
        if ((charset = this.request.getParameter("charset")) != null && !"".equals(charset = VerifierServletTransaction.scrub(charset.trim()))) {
            this.charsetOverride = charset;
        }
        if ((nsfilter = this.request.getParameter("nsfilter")) != null) {
            String[] nsfilterArr = SPACE.split(nsfilter);
            for (int i = 0; i < nsfilterArr.length; ++i) {
                String ns = nsfilterArr[i];
                if (ns.length() <= 0) continue;
                this.filteredNamespaces.add(ns);
            }
        }
        boolean errorsOnly = "error".equals(this.request.getParameter("level"));
        boolean asciiQuotes = this.request.getParameter("asciiquotes") != null;
        int lineOffset = 0;
        String lineOffsetStr = this.request.getParameter("lineoffset");
        if (lineOffsetStr != null) {
            try {
                lineOffset = Integer.parseInt(lineOffsetStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        try {
            if (this.outputFormat == OutputFormat.HTML || this.outputFormat == OutputFormat.XHTML) {
                if (this.outputFormat == OutputFormat.HTML) {
                    this.response.setContentType("text/html; charset=utf-8");
                    this.contentHandler = new HtmlSerializer(this.out);
                } else {
                    this.response.setContentType("application/xhtml+xml");
                    this.contentHandler = new XmlSerializer(this.out);
                }
                this.emitter = new XhtmlSaxEmitter(this.contentHandler);
                this.errorHandler = new MessageEmitterAdapter(this.sourceCode, this.showSource, this.imageCollector, lineOffset, false, new XhtmlMessageEmitter(this.contentHandler));
                PageEmitter.emit(this.contentHandler, this);
            } else {
                if (this.outputFormat == OutputFormat.TEXT) {
                    this.response.setContentType("text/plain; charset=utf-8");
                    this.errorHandler = new MessageEmitterAdapter(this.sourceCode, this.showSource, null, lineOffset, false, new TextMessageEmitter(this.out, asciiQuotes));
                } else if (this.outputFormat == OutputFormat.GNU) {
                    this.response.setContentType("text/plain; charset=utf-8");
                    this.errorHandler = new MessageEmitterAdapter(this.sourceCode, this.showSource, null, lineOffset, false, new GnuMessageEmitter(this.out, asciiQuotes));
                } else if (this.outputFormat == OutputFormat.XML) {
                    this.response.setContentType("application/xml");
                    this.errorHandler = new MessageEmitterAdapter(this.sourceCode, this.showSource, null, lineOffset, false, new XmlMessageEmitter(new XmlSerializer(this.out)));
                } else if (this.outputFormat == OutputFormat.JSON) {
                    if (callback == null) {
                        this.response.setContentType("application/json; charset=utf-8");
                    } else {
                        this.response.setContentType("application/javascript; charset=utf-8");
                    }
                    this.errorHandler = new MessageEmitterAdapter(this.sourceCode, this.showSource, null, lineOffset, false, new JsonMessageEmitter(new Serializer(this.out), callback));
                } else {
                    throw new RuntimeException("Unreachable.");
                }
                this.errorHandler.setErrorsOnly(errorsOnly);
                this.validate();
            }
        }
        catch (SAXException e) {
            throw new ServletException(e);
        }
    }

    protected void setup() throws ServletException {
        String parserStr;
        String preset = this.request.getParameter("preset");
        this.schemaUrls = preset != null && !"".equals(preset) ? preset : this.request.getParameter("schema");
        if (this.schemaUrls == null) {
            this.schemaUrls = "";
        }
        if ("html".equals(parserStr = this.request.getParameter("parser"))) {
            this.parser = ParserMode.HTML_AUTO;
        } else if ("xmldtd".equals(parserStr)) {
            this.parser = ParserMode.XML_EXTERNAL_ENTITIES_NO_VALIDATION;
        } else if ("xml".equals(parserStr)) {
            this.parser = ParserMode.XML_NO_EXTERNAL_ENTITIES;
        } else if ("html5".equals(parserStr)) {
            this.parser = ParserMode.HTML;
        } else if ("html4".equals(parserStr)) {
            this.parser = ParserMode.HTML401_STRICT;
        } else if ("html4tr".equals(parserStr)) {
            this.parser = ParserMode.HTML401_TRANSITIONAL;
        }
        this.laxType = this.request.getParameter("laxtype") != null;
    }

    private boolean useHtml5Schema() {
        if ("".equals(this.schemaUrls)) {
            return false;
        }
        return this.schemaUrls.contains("http://s.validator.nu/html5.rnc") || this.schemaUrls.contains("http://s.validator.nu/html5-all.rnc") || this.schemaUrls.contains("http://s.validator.nu/html5-its.rnc") || this.schemaUrls.contains("http://s.validator.nu/html5-rdfalite.rnc");
    }

    private boolean isHtmlUnsafePreset() {
        if ("".equals(this.schemaUrls)) {
            return false;
        }
        boolean preset = false;
        for (int i = 0; i < presetUrls.length; ++i) {
            if (!presetUrls[i].equals(this.schemaUrls)) continue;
            preset = true;
            break;
        }
        if (!preset) {
            return false;
        }
        return !this.schemaUrls.startsWith("http://s.validator.nu/xhtml10/xhtml-basic.rnc") && !this.schemaUrls.startsWith("http://s.validator.nu/xhtml10/xhtml-strict.rnc") && !this.schemaUrls.startsWith("http://s.validator.nu/xhtml10/xhtml-transitional.rnc") && !this.schemaUrls.startsWith("http://s.validator.nu/xhtml10/xhtml-frameset.rnc") && !this.schemaUrls.startsWith("http://s.validator.nu/html5.rnc") && !this.schemaUrls.startsWith("http://s.validator.nu/html5-all.rnc") && !this.schemaUrls.startsWith("http://s.validator.nu/html5-its.rnc") && !this.schemaUrls.startsWith("http://s.validator.nu/html5-rdfalite.rnc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validate() throws SAXException {
        boolean isHtmlOrXhtml;
        if (!this.willValidate()) {
            return;
        }
        boolean bl = isHtmlOrXhtml = this.outputFormat == OutputFormat.HTML || this.outputFormat == OutputFormat.XHTML;
        if (isHtmlOrXhtml) {
            try {
                this.out.flush();
            }
            catch (IOException e1) {
                throw new SAXException(e1);
            }
        }
        this.httpRes = new PrudentHttpEntityResolver(SIZE_LIMIT, this.laxType, this.errorHandler);
        this.httpRes.setUserAgent(this.userAgent);
        this.dataRes = new DataUriEntityResolver(this.httpRes, this.laxType, this.errorHandler);
        this.contentTypeParser = new ContentTypeParser(this.errorHandler, this.laxType);
        this.entityResolver = new LocalCacheEntityResolver(this.dataRes);
        this.setAllowRnc(true);
        try {
            this.errorHandler.start(this.document);
            PropertyMapBuilder pmb = new PropertyMapBuilder();
            pmb.put(ValidateProperty.ERROR_HANDLER, this.errorHandler);
            pmb.put(ValidateProperty.ENTITY_RESOLVER, this.entityResolver);
            pmb.put(ValidateProperty.XML_READER_CREATOR, new VerifierServletXMLReaderCreator(this.errorHandler, this.entityResolver));
            pmb.put(ValidateProperty.SCHEMA_RESOLVER, this);
            RngProperty.CHECK_ID_IDREF.add(pmb);
            this.jingPropertyMap = pmb.toPropertyMap();
            this.tryToSetupValidator();
            this.setAllowRnc(false);
            this.loadDocAndSetupParser();
            this.setErrorProfile();
            this.reader.setErrorHandler(this.errorHandler);
            this.contentType = this.documentInput.getType();
            this.sourceCode.initialize(this.documentInput);
            if (this.validator == null) {
                this.checkNormalization = true;
            }
            if (this.checkNormalization) {
                this.reader.setFeature("http://xml.org/sax/features/unicode-normalization-checking", true);
            }
            WiretapXMLReaderWrapper wiretap = new WiretapXMLReaderWrapper(this.reader);
            ContentHandler recorder = this.sourceCode.getLocationRecorder();
            if (this.baseUriTracker == null) {
                wiretap.setWiretapContentHander(recorder);
            } else {
                wiretap.setWiretapContentHander(new CombineContentHandler(recorder, this.baseUriTracker));
            }
            wiretap.setWiretapLexicalHandler((LexicalHandler)((Object)recorder));
            this.reader = wiretap;
            if (this.htmlParser != null) {
                this.htmlParser.addCharacterHandler(this.sourceCode);
                this.htmlParser.setMappingLangToXmlLang(true);
                this.htmlParser.setErrorHandler(this.errorHandler.getExactErrorHandler());
                this.htmlParser.setTreeBuilderErrorHandlerOverride(this.errorHandler);
                this.errorHandler.setHtml(true);
            } else if (this.xmlParser != null) {
                if (!this.filteredNamespaces.isEmpty()) {
                    this.reader = new NamespaceDroppingXMLReaderWrapper(this.reader, this.filteredNamespaces);
                }
                this.xmlParser.setErrorHandler(this.errorHandler.getExactErrorHandler());
                this.xmlParser.lockErrorHandler();
            } else {
                throw new RuntimeException("Bug. Unreachable.");
            }
            this.reader = new AttributesPermutingXMLReaderWrapper(this.reader);
            if (this.charsetOverride != null) {
                String charset = this.documentInput.getEncoding();
                if (charset == null) {
                    this.errorHandler.warning(new SAXParseException("Overriding document character encoding from none to \u201c" + this.charsetOverride + "\u201d.", null));
                } else {
                    this.errorHandler.warning(new SAXParseException("Overriding document character encoding from \u201c" + charset + "\u201d to \u201c" + this.charsetOverride + "\u201d.", null));
                }
                this.documentInput.setEncoding(this.charsetOverride);
            }
            if (this.showOutline) {
                this.reader = new OutlineBuildingXMLReaderWrapper(this.reader, this.request);
                this.reader.parse(this.documentInput);
                this.outline = (Deque)this.request.getAttribute("http://validator.nu/properties/document-outline");
            } else {
                this.reader.parse(this.documentInput);
            }
        }
        catch (TooManyErrorsException e) {
            log4j.debug("TooManyErrorsException", e);
            this.errorHandler.fatalError(e);
        }
        catch (SAXException e) {
            log4j.debug("SAXException", e);
        }
        catch (IOException e) {
            isHtmlOrXhtml = false;
            log4j.info("IOException", e);
            this.errorHandler.ioError(e);
        }
        catch (IncorrectSchemaException e) {
            log4j.debug("IncorrectSchemaException", e);
            this.errorHandler.schemaError(e);
        }
        catch (RuntimeException e) {
            isHtmlOrXhtml = false;
            log4j.error("RuntimeException, doc: " + this.document + " schema: " + this.schemaUrls + " lax: " + this.laxType, e);
            this.errorHandler.internalError(e, "Oops. That was not supposed to happen. A bug manifested itself in the application internals. Unable to continue. Sorry. The admin was notified.");
        }
        catch (Error e) {
            isHtmlOrXhtml = false;
            log4j.error("Error, doc: " + this.document + " schema: " + this.schemaUrls + " lax: " + this.laxType, e);
            this.errorHandler.internalError(e, "Oops. That was not supposed to happen. A bug manifested itself in the application internals. Unable to continue. Sorry. The admin was notified.");
        }
        finally {
            this.errorHandler.end(this.successMessage(), this.failureMessage());
            this.gatherStatistics();
        }
        if (isHtmlOrXhtml) {
            XhtmlOutlineEmitter outlineEmitter = new XhtmlOutlineEmitter(this.contentHandler, this.outline);
            outlineEmitter.emit();
            StatsEmitter.emit(this.contentHandler, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gatherStatistics() {
        Statistics stats = Statistics.STATISTICS;
        if (stats == null) {
            return;
        }
        Statistics statistics = stats;
        synchronized (statistics) {
            stats.incrementTotal();
            if (this.charsetOverride != null) {
                stats.incrementField(Statistics.Field.CUSTOM_ENC);
            }
            switch (this.parser) {
                case HTML401_STRICT: 
                case HTML401_TRANSITIONAL: {
                    stats.incrementField(Statistics.Field.PARSER_HTML4);
                    break;
                }
                case XML_EXTERNAL_ENTITIES_NO_VALIDATION: {
                    stats.incrementField(Statistics.Field.PARSER_XML_EXTERNAL);
                }
            }
            if (!this.filteredNamespaces.isEmpty()) {
                stats.incrementField(Statistics.Field.XMLNS_FILTER);
            }
            if (this.laxType) {
                stats.incrementField(Statistics.Field.LAX_TYPE);
            }
            if (this.imageCollector != null) {
                stats.incrementField(Statistics.Field.IMAGE_REPORT);
            }
            if (this.showSource) {
                stats.incrementField(Statistics.Field.SHOW_SOURCE);
            }
            if (this.showOutline) {
                stats.incrementField(Statistics.Field.SHOW_OUTLINE);
            }
            if (this.methodIsGet) {
                stats.incrementField(Statistics.Field.INPUT_GET);
            } else {
                stats.incrementField(Statistics.Field.INPUT_POST);
                Object inputType = this.request.getAttribute("nu.validator.servlet.MultipartFormDataFilter.type");
                if ("textarea".equals(inputType)) {
                    stats.incrementField(Statistics.Field.INPUT_TEXT_FIELD);
                } else if ("file".equals(inputType)) {
                    stats.incrementField(Statistics.Field.INPUT_FILE_UPLOAD);
                } else {
                    stats.incrementField(Statistics.Field.INPUT_ENTITY_BODY);
                }
            }
            if (this.htmlParser != null) {
                stats.incrementField(Statistics.Field.INPUT_HTML);
            }
            if (this.xmlParser != null) {
                stats.incrementField(Statistics.Field.INPUT_XML);
            }
            switch (this.outputFormat) {
                case GNU: {
                    stats.incrementField(Statistics.Field.OUTPUT_GNU);
                    break;
                }
                case HTML: {
                    stats.incrementField(Statistics.Field.OUTPUT_HTML);
                    break;
                }
                case JSON: {
                    stats.incrementField(Statistics.Field.OUTPUT_JSON);
                    break;
                }
                case TEXT: {
                    stats.incrementField(Statistics.Field.OUTPUT_TEXT);
                    break;
                }
                case XHTML: {
                    stats.incrementField(Statistics.Field.OUTPUT_XHTML);
                    break;
                }
                case XML: {
                    stats.incrementField(Statistics.Field.OUTPUT_XML);
                }
            }
            if (this.schemaListForStats == null) {
                stats.incrementField(Statistics.Field.LOGIC_ERROR);
            } else {
                boolean preset = false;
                for (int i = 0; i < presetUrls.length; ++i) {
                    if (!presetUrls[i].equals(this.schemaListForStats)) continue;
                    preset = true;
                    if (this.externalSchema || this.externalSchematron) {
                        stats.incrementField(Statistics.Field.LOGIC_ERROR);
                        break;
                    }
                    stats.incrementField(Statistics.Field.PRESET_SCHEMA);
                    switch (i) {
                        case 0: 
                        case 5: {
                            stats.incrementField(Statistics.Field.HTML5_SCHEMA);
                            break;
                        }
                        case 1: 
                        case 6: {
                            stats.incrementField(Statistics.Field.HTML5_RDFA_LITE_SCHEMA);
                            break;
                        }
                        case 2: {
                            stats.incrementField(Statistics.Field.HTML4_STRICT_SCHEMA);
                            break;
                        }
                        case 3: {
                            stats.incrementField(Statistics.Field.HTML4_TRANSITIONAL_SCHEMA);
                            break;
                        }
                        case 4: {
                            stats.incrementField(Statistics.Field.HTML4_FRAMESET_SCHEMA);
                            break;
                        }
                        case 7: {
                            stats.incrementField(Statistics.Field.XHTML1_COMPOUND_SCHEMA);
                            break;
                        }
                        case 8: {
                            stats.incrementField(Statistics.Field.SVG_SCHEMA);
                            break;
                        }
                        default: {
                            stats.incrementField(Statistics.Field.LOGIC_ERROR);
                            break;
                        }
                    }
                    break;
                }
                if (!preset && !this.externalSchema) {
                    stats.incrementField(Statistics.Field.BUILT_IN_NON_PRESET);
                }
            }
            if ("".equals(this.schemaUrls)) {
                stats.incrementField(Statistics.Field.AUTO_SCHEMA);
                if (this.externalSchema) {
                    stats.incrementField(Statistics.Field.LOGIC_ERROR);
                }
            } else if (this.externalSchema) {
                if (this.externalSchematron) {
                    stats.incrementField(Statistics.Field.EXTERNAL_SCHEMA_SCHEMATRON);
                } else {
                    stats.incrementField(Statistics.Field.EXTERNAL_SCHEMA_NON_SCHEMATRON);
                }
            } else if (this.externalSchematron) {
                stats.incrementField(Statistics.Field.LOGIC_ERROR);
            }
        }
    }

    protected String successMessage() throws SAXException {
        return "The document validates according to the specified schema(s) and to additional constraints checked by the validator.";
    }

    protected String failureMessage() throws SAXException {
        return "There were errors.";
    }

    protected void tryToSetupValidator() throws SAXException, IOException, IncorrectSchemaException {
        this.validator = this.validatorByUrls(this.schemaUrls);
    }

    protected void setErrorProfile() {
        this.profile = this.request.getParameter("profile");
        HashMap<String, String> profileMap = new HashMap<String, String>();
        if ("pedagogical".equals(this.profile)) {
            profileMap.put("xhtml1", "warn");
        } else if ("polyglot".equals(this.profile)) {
            profileMap.put("xhtml1", "warn");
            profileMap.put("xhtml2", "warn");
        } else {
            return;
        }
        this.htmlParser.setErrorProfile(profileMap);
    }

    protected void loadDocAndSetupParser() throws SAXException, IOException, IncorrectSchemaException, SAXNotRecognizedException, SAXNotSupportedException {
        switch (this.parser) {
            case HTML401_STRICT: 
            case HTML401_TRANSITIONAL: 
            case HTML: 
            case HTML_AUTO: {
                int schemaId;
                DoctypeExpectation doctypeExpectation;
                if (this.isHtmlUnsafePreset()) {
                    String message = "The chosen preset schema is not appropriate for HTML.";
                    SAXException se = new SAXException(message);
                    this.errorHandler.schemaError(se);
                    throw se;
                }
                this.setAllowGenericXml(false);
                this.setAllowHtml(true);
                this.setAcceptAllKnownXmlTypes(false);
                this.setAllowXhtml(false);
                this.loadDocumentInput();
                this.newHtmlParser();
                switch (this.parser) {
                    case HTML: {
                        doctypeExpectation = DoctypeExpectation.HTML;
                        schemaId = 3;
                        break;
                    }
                    case HTML401_STRICT: {
                        doctypeExpectation = DoctypeExpectation.HTML401_STRICT;
                        schemaId = 2;
                        break;
                    }
                    case HTML401_TRANSITIONAL: {
                        doctypeExpectation = DoctypeExpectation.HTML401_TRANSITIONAL;
                        schemaId = 1;
                        break;
                    }
                    default: {
                        doctypeExpectation = DoctypeExpectation.AUTO;
                        schemaId = 0;
                    }
                }
                this.htmlParser.setDoctypeExpectation(doctypeExpectation);
                this.htmlParser.setDocumentModeHandler(this);
                this.reader = this.htmlParser;
                if (this.validator == null) {
                    this.validator = this.validatorByDoctype(schemaId);
                }
                if (this.validator == null) break;
                this.reader.setContentHandler(this.validator.getContentHandler());
                break;
            }
            case XML_EXTERNAL_ENTITIES_NO_VALIDATION: 
            case XML_NO_EXTERNAL_ENTITIES: {
                this.setAllowGenericXml(true);
                this.setAllowHtml(false);
                this.setAcceptAllKnownXmlTypes(true);
                this.setAllowXhtml(true);
                this.loadDocumentInput();
                this.setupXmlParser();
                break;
            }
            default: {
                this.setAllowGenericXml(true);
                this.setAllowHtml(true);
                this.setAcceptAllKnownXmlTypes(true);
                this.setAllowXhtml(true);
                this.loadDocumentInput();
                String type = this.documentInput.getType();
                if ("text/html".equals(type) || "text/html-sandboxed".equals(type)) {
                    if (this.isHtmlUnsafePreset()) {
                        String message = "The Content-Type was \u201c" + type + "\u201d, but the chosen preset schema is not appropriate for HTML.";
                        SAXException se = new SAXException(message);
                        this.errorHandler.schemaError(se);
                        throw se;
                    }
                    this.errorHandler.info("The Content-Type was \u201c" + type + "\u201d. Using the HTML parser.");
                    this.newHtmlParser();
                    if (this.useHtml5Schema()) {
                        this.htmlParser.setDoctypeExpectation(DoctypeExpectation.HTML);
                    } else {
                        this.htmlParser.setDoctypeExpectation(DoctypeExpectation.AUTO);
                    }
                    this.htmlParser.setDocumentModeHandler(this);
                    this.reader = this.htmlParser;
                    if (this.validator == null) break;
                    this.reader.setContentHandler(this.validator.getContentHandler());
                    break;
                }
                this.errorHandler.info("The Content-Type was \u201c" + type + "\u201d. Using the XML parser (not resolving external entities).");
                this.setupXmlParser();
            }
        }
    }

    protected void newHtmlParser() {
        this.htmlParser = new HtmlParser();
        this.htmlParser.setCommentPolicy(XmlViolationPolicy.ALLOW);
        this.htmlParser.setContentNonXmlCharPolicy(XmlViolationPolicy.ALLOW);
        this.htmlParser.setContentSpacePolicy(XmlViolationPolicy.ALTER_INFOSET);
        this.htmlParser.setNamePolicy(XmlViolationPolicy.ALLOW);
        this.htmlParser.setStreamabilityViolationPolicy(XmlViolationPolicy.FATAL);
        this.htmlParser.setXmlnsPolicy(XmlViolationPolicy.ALTER_INFOSET);
        this.htmlParser.setMappingLangToXmlLang(true);
        this.htmlParser.setHtml4ModeCompatibleWithXhtml1Schemata(true);
        this.htmlParser.setHeuristics(Heuristics.ALL);
    }

    protected Validator validatorByDoctype(int schemaId) throws SAXException, IOException, IncorrectSchemaException {
        if (schemaId == 0) {
            return null;
        }
        for (int i = 0; i < presetDoctypes.length; ++i) {
            if (presetDoctypes[i] != schemaId) continue;
            return this.validatorByUrls(presetUrls[i]);
        }
        throw new RuntimeException("Doctype mappings not initialized properly.");
    }

    protected void setupXmlParser() throws SAXNotRecognizedException, SAXNotSupportedException {
        this.xmlParser = new SAXDriver();
        this.xmlParser.setCharacterHandler(this.sourceCode);
        if (this.lexicalHandler != null) {
            this.xmlParser.setProperty("http://xml.org/sax/properties/lexical-handler", this.lexicalHandler);
        }
        this.reader = new IdFilter(this.xmlParser);
        this.reader.setFeature("http://xml.org/sax/features/string-interning", true);
        this.reader.setFeature("http://xml.org/sax/features/external-general-entities", this.parser == ParserMode.XML_EXTERNAL_ENTITIES_NO_VALIDATION);
        this.reader.setFeature("http://xml.org/sax/features/external-parameter-entities", this.parser == ParserMode.XML_EXTERNAL_ENTITIES_NO_VALIDATION);
        if (this.parser == ParserMode.XML_EXTERNAL_ENTITIES_NO_VALIDATION) {
            this.reader.setEntityResolver(this.entityResolver);
        } else {
            this.reader.setEntityResolver(new NullEntityResolver());
        }
        if (this.validator == null) {
            this.bufferingRootNamespaceSniffer = new BufferingRootNamespaceSniffer(this);
            this.reader.setContentHandler(this.bufferingRootNamespaceSniffer);
        } else {
            this.reader.setContentHandler(new RootNamespaceSniffer(this, this.validator.getContentHandler()));
            this.reader.setDTDHandler(this.validator.getDTDHandler());
        }
    }

    private Validator validatorByUrls(String schemaList) throws SAXException, IOException, IncorrectSchemaException {
        System.setProperty("nu.validator.schema.rdfa-full", "0");
        this.schemaListForStats = schemaList;
        Validator v = null;
        String[] schemas = SPACE.split(schemaList);
        for (int i = schemas.length - 1; i > -1; --i) {
            int j;
            String url = schemas[i];
            if ("http://s.validator.nu/html5-all.rnc".equals(url)) {
                System.setProperty("nu.validator.schema.rdfa-full", "1");
            }
            if ("http://c.validator.nu/all/".equals(url) || "http://hsivonen.iki.fi/checkers/all/".equals(url)) {
                for (j = 0; j < ALL_CHECKERS.length; ++j) {
                    v = this.combineValidatorByUrl(v, ALL_CHECKERS[j]);
                }
                continue;
            }
            if ("http://c.validator.nu/all-html4/".equals(url) || "http://hsivonen.iki.fi/checkers/all-html4/".equals(url)) {
                for (j = 0; j < ALL_CHECKERS_HTML4.length; ++j) {
                    v = this.combineValidatorByUrl(v, ALL_CHECKERS_HTML4[j]);
                }
                continue;
            }
            v = this.combineValidatorByUrl(v, url);
        }
        if (this.imageCollector != null && v != null) {
            v = new CombineValidator(this.imageCollector, v);
        }
        return v;
    }

    private Validator combineValidatorByUrl(Validator val, String url) throws SAXException, IOException, IncorrectSchemaException {
        if (!"".equals(url)) {
            Validator v = this.validatorByUrl(url);
            val = val == null ? v : new CombineValidator(v, val);
        }
        return val;
    }

    private Validator validatorByUrl(String url) throws SAXException, IOException, IncorrectSchemaException {
        Schema sch;
        Validator validator;
        if (this.loadedValidatorUrls.contains(url)) {
            return null;
        }
        this.loadedValidatorUrls.add(url);
        if ("http://s.validator.nu/xhtml5.rnc".equals(url) || "http://s.validator.nu/html5.rnc".equals(url) || "http://s.validator.nu/html5-all.rnc".equals(url) || "http://s.validator.nu/xhtml5-all.rnc".equals(url) || "http://s.validator.nu/html5-its.rnc".equals(url) || "http://s.validator.nu/xhtml5-rdfalite.rnc".equals(url) || "http://s.validator.nu/html5-rdfalite.rnc".equals(url)) {
            this.errorHandler.setSpec(html5spec);
        }
        if ((validator = (sch = this.resolveSchema(url, this.jingPropertyMap)).createValidator(this.jingPropertyMap)).getContentHandler() instanceof XmlPiChecker) {
            this.lexicalHandler = (LexicalHandler)((Object)validator.getContentHandler());
        }
        return validator;
    }

    @Override
    public Schema resolveSchema(String url, PropertyMap options) throws SAXException, IOException, IncorrectSchemaException {
        int i = Arrays.binarySearch(preloadedSchemaUrls, url);
        if (i > -1) {
            Schema rv = preloadedSchemas[i];
            if (options.contains(WrapProperty.ATTRIBUTE_OWNER)) {
                if (rv instanceof CheckerSchema) {
                    this.errorHandler.error(new SAXParseException("A non-schema checker cannot be used as an attribute schema.", null, url, -1, -1));
                    throw new IncorrectSchemaException();
                }
            } else {
                return rv;
            }
        }
        this.externalSchema = true;
        TypedInputSource schemaInput = (TypedInputSource)this.entityResolver.resolveEntity(null, url);
        SchemaReader sr = null;
        sr = "application/relax-ng-compact-syntax".equals(schemaInput.getType()) ? CompactSchemaReader.getInstance() : new AutoSchemaReader();
        Schema sch = sr.createSchema(schemaInput, options);
        if (Statistics.STATISTICS != null && "com.thaiopensource.validate.schematron.SchemaImpl".equals(sch.getClass().getName())) {
            this.externalSchematron = true;
        }
        return sch;
    }

    private static Schema schemaByUrl(String url, EntityResolver resolver, PropertyMap pMap) throws SAXException, IOException, IncorrectSchemaException {
        TypedInputSource schemaInput;
        log4j.debug("Will load schema: " + url);
        try {
            schemaInput = (TypedInputSource)resolver.resolveEntity(null, url);
        }
        catch (ClassCastException e) {
            log4j.fatal(url, e);
            throw e;
        }
        SchemaReader sr = null;
        sr = "application/relax-ng-compact-syntax".equals(schemaInput.getType()) ? CompactSchemaReader.getInstance() : new AutoSchemaReader();
        Schema sch = sr.createSchema(schemaInput, pMap);
        return sch;
    }

    void emitTitle(boolean markupAllowed) throws SAXException {
        if (this.willValidate()) {
            this.emitter.characters(RESULTS_TITLE);
            this.emitter.characters(FOR);
            if (this.document != null && this.document.length() > 0) {
                this.emitter.characters(VerifierServletTransaction.scrub(this.shortenDataUri(this.document)));
            } else if (this.request.getAttribute("nu.validator.servlet.MultipartFormDataFilter.filename") != null) {
                this.emitter.characters("uploaded file " + VerifierServletTransaction.scrub(this.request.getAttribute("nu.validator.servlet.MultipartFormDataFilter.filename").toString()));
            } else {
                this.emitter.characters("contents of text-input area");
            }
        } else {
            this.emitter.characters(SERVICE_TITLE);
            if (markupAllowed && System.getProperty("nu.validator.servlet.service-name", "").equals("Validator.nu")) {
                this.emitter.startElement("span");
                this.emitter.characters(LIVING_VERSION);
                this.emitter.endElement("span");
            }
        }
    }

    protected String shortenDataUri(String uri) {
        if (DataUri.startsWithData(uri)) {
            return "data:\u2026";
        }
        return uri;
    }

    void emitForm() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("method", "get");
        if (this.isSimple()) {
            this.attrs.addAttribute("class", "simple");
        }
        this.emitter.startElement("form", this.attrs);
        this.emitFormContent();
        this.emitter.endElement("form");
    }

    protected boolean isSimple() {
        return false;
    }

    protected void emitFormContent() throws SAXException {
        FormEmitter.emit(this.contentHandler, this);
    }

    void emitSchemaField() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("name", "schema");
        this.attrs.addAttribute("id", "schema");
        this.attrs.addAttribute("pattern", "(?:(?:(?:https?://\\S+)|(?:data:\\S+))(?:\\s+(?:(?:https?://\\S+)|(?:data:\\S+)))*)?");
        this.attrs.addAttribute("title", "Space-separated list of schema IRIs. (Leave blank to let the service guess.)");
        if (this.schemaUrls != null) {
            this.attrs.addAttribute("value", VerifierServletTransaction.scrub(this.schemaUrls));
        }
        this.emitter.startElement("input", this.attrs);
        this.emitter.endElement("input");
    }

    void emitDocField() throws SAXException {
        Object att;
        this.attrs.clear();
        this.attrs.addAttribute("type", "url");
        this.attrs.addAttribute("name", "doc");
        this.attrs.addAttribute("id", "doc");
        this.attrs.addAttribute("pattern", "(?:(?:https?://.+)|(?:data:.+))?");
        this.attrs.addAttribute("title", "Absolute IRI (http, https or data only) of the document to be checked.");
        if (this.document != null) {
            this.attrs.addAttribute("value", VerifierServletTransaction.scrub(this.document));
        }
        if ((att = this.request.getAttribute("nu.validator.servlet.MultipartFormDataFilter.type")) != null) {
            this.attrs.addAttribute("class", att.toString());
        }
        this.emitter.startElement("input", this.attrs);
        this.emitter.endElement("input");
    }

    void emitSchemaDuration() throws SAXException {
    }

    void emitDocDuration() throws SAXException {
    }

    void emitTotalDuration() throws SAXException {
        this.emitter.characters("" + (System.currentTimeMillis() - this.start));
    }

    void emitPresetOptions() throws SAXException {
        for (int i = 0; i < presetUrls.length; ++i) {
            this.emitter.option(presetLabels[i], presetUrls[i], false);
        }
    }

    void emitParserOptions() throws SAXException {
        this.emitter.option("Automatically from Content-Type", "", this.parser == ParserMode.AUTO);
        this.emitter.option("XML; don\u2019t load external entities", "xml", this.parser == ParserMode.XML_NO_EXTERNAL_ENTITIES);
        this.emitter.option("XML; load external entities", "xmldtd", this.parser == ParserMode.XML_EXTERNAL_ENTITIES_NO_VALIDATION);
        this.emitter.option("HTML; flavor from doctype", "html", this.parser == ParserMode.HTML_AUTO);
        this.emitter.option("HTML5", "html5", this.parser == ParserMode.HTML);
        this.emitter.option("HTML 4.01 Strict", "html4", this.parser == ParserMode.HTML401_STRICT);
        this.emitter.option("HTML 4.01 Transitional", "html4tr", this.parser == ParserMode.HTML401_TRANSITIONAL);
    }

    void emitProfileOptions() throws SAXException {
        this.profile = this.request.getParameter("profile");
        this.emitter.option("Permissive: only what the spec requires", "", "".equals(this.profile));
        this.emitter.option("Pedagogical: suitable for teaching purposes", "pedagogical", "pedagogical".equals(this.profile));
        this.emitter.option("Polyglot: works both as HTML and as XML", "polyglot", "polyglot".equals(this.profile));
    }

    void emitLaxTypeField() throws SAXException {
        this.emitter.checkbox("laxtype", "yes", this.laxType);
    }

    void emitShowSourceField() throws SAXException {
        this.emitter.checkbox("showsource", "yes", this.showSource);
    }

    void emitShowOutlineField() throws SAXException {
        this.emitter.checkbox("showoutline", "yes", this.showOutline);
    }

    void emitShowImageReportField() throws SAXException {
        this.emitter.checkbox("showimagereport", "yes", this.imageCollector != null);
    }

    void rootNamespace(String namespace, Locator locator) throws SAXException {
        if (this.validator == null) {
            int index = -1;
            for (int i = 0; i < presetNamespaces.length; ++i) {
                if (!namespace.equals(presetNamespaces[i])) continue;
                index = i;
                break;
            }
            if (index == -1) {
                String message = "Cannot find preset schema for namespace: \u201c" + namespace + "\u201d.";
                SAXException se = new SAXException(message);
                this.errorHandler.schemaError(se);
                throw se;
            }
            String label = presetLabels[index];
            String urls = presetUrls[index];
            this.errorHandler.info("Using the preset for " + label + " based on the root namespace.");
            try {
                this.validator = this.validatorByUrls(urls);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            catch (IncorrectSchemaException e) {
                throw new RuntimeException(e);
            }
            if (this.bufferingRootNamespaceSniffer == null) {
                throw new RuntimeException("Bug! bufferingRootNamespaceSniffer was null.");
            }
            this.bufferingRootNamespaceSniffer.setContentHandler(this.validator.getContentHandler());
        }
        if (!this.rootNamespaceSeen) {
            int i;
            this.rootNamespaceSeen = true;
            if (this.contentType != null && (i = Arrays.binarySearch(KNOWN_CONTENT_TYPES, this.contentType)) > -1 && !NAMESPACES_FOR_KNOWN_CONTENT_TYPES[i].equals(namespace)) {
                String message = "".equals(namespace) ? "\u201c" + this.contentType + "\u201d is not an appropriate Content-Type for a document whose root element is not in a namespace." : "\u201c" + this.contentType + "\u201d is not an appropriate Content-Type for a document whose root namespace is \u201c" + namespace + "\u201d.";
                SAXParseException spe = new SAXParseException(message, locator);
                this.errorHandler.warning(spe);
            }
        }
    }

    @Override
    public void documentMode(DocumentMode mode, String publicIdentifier, String systemIdentifier, boolean html4SpecificAdditionalErrorChecks) throws SAXException {
        if (this.validator == null) {
            try {
                if ("yes".equals(this.request.getParameter("sniffdoctype"))) {
                    if ("-//W3C//DTD XHTML 1.0 Transitional//EN".equals(publicIdentifier)) {
                        this.errorHandler.info("XHTML 1.0 Transitional doctype seen. Appendix C is not supported. Proceeding anyway for your convenience. The parser is still an HTML parser, so namespace processing is not performed and \u201cxml:*\u201d attributes are not supported. Using the schema for " + this.getPresetLabel(1) + "." + (html4SpecificAdditionalErrorChecks ? " HTML4-specific tokenization errors are enabled." : ""));
                        this.validator = this.validatorByDoctype(1);
                    } else if ("-//W3C//DTD XHTML 1.0 Strict//EN".equals(publicIdentifier)) {
                        this.errorHandler.info("XHTML 1.0 Strict doctype seen. Appendix C is not supported. Proceeding anyway for your convenience. The parser is still an HTML parser, so namespace processing is not performed and \u201cxml:*\u201d attributes are not supported. Using the schema for " + this.getPresetLabel(2) + "." + (html4SpecificAdditionalErrorChecks ? " HTML4-specific tokenization errors are enabled." : ""));
                        this.validator = this.validatorByDoctype(2);
                    } else if ("-//W3C//DTD HTML 4.01 Transitional//EN".equals(publicIdentifier)) {
                        this.errorHandler.info("HTML 4.01 Transitional doctype seen. Using the schema for " + this.getPresetLabel(1) + "." + (html4SpecificAdditionalErrorChecks ? "" : " HTML4-specific tokenization errors are not enabled."));
                        this.validator = this.validatorByDoctype(1);
                    } else if ("-//W3C//DTD HTML 4.01//EN".equals(publicIdentifier)) {
                        this.errorHandler.info("HTML 4.01 Strict doctype seen. Using the schema for " + this.getPresetLabel(2) + "." + (html4SpecificAdditionalErrorChecks ? "" : " HTML4-specific tokenization errors are not enabled."));
                        this.validator = this.validatorByDoctype(2);
                    } else if ("-//W3C//DTD HTML 4.0 Transitional//EN".equals(publicIdentifier)) {
                        this.errorHandler.info("Legacy HTML 4.0 Transitional doctype seen.  Please consider using HTML 4.01 Transitional instead. Proceeding anyway for your convenience with the schema for " + this.getPresetLabel(1) + "." + (html4SpecificAdditionalErrorChecks ? "" : " HTML4-specific tokenization errors are not enabled."));
                        this.validator = this.validatorByDoctype(1);
                    } else if ("-//W3C//DTD HTML 4.0//EN".equals(publicIdentifier)) {
                        this.errorHandler.info("Legacy HTML 4.0 Strict doctype seen. Please consider using HTML 4.01 instead. Proceeding anyway for your convenience with the schema for " + this.getPresetLabel(2) + "." + (html4SpecificAdditionalErrorChecks ? "" : " HTML4-specific tokenization errors are not enabled."));
                        this.validator = this.validatorByDoctype(2);
                    }
                } else {
                    this.errorHandler.info("Using the schema for " + this.getPresetLabel(3) + "." + (html4SpecificAdditionalErrorChecks ? " HTML4-specific tokenization errors are enabled." : ""));
                    this.validator = this.validatorByDoctype(3);
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            catch (IncorrectSchemaException e) {
                throw new RuntimeException(e);
            }
            ContentHandler ch = this.validator.getContentHandler();
            ch.setDocumentLocator(this.htmlParser.getDocumentLocator());
            ch.startDocument();
            this.reader.setContentHandler(ch);
        } else if (html4SpecificAdditionalErrorChecks) {
            this.errorHandler.info("HTML4-specific tokenization errors are enabled.");
        }
    }

    private String getPresetLabel(int schemaId) {
        for (int i = 0; i < presetDoctypes.length; ++i) {
            if (presetDoctypes[i] != schemaId) continue;
            return presetLabels[i];
        }
        return "unknown";
    }

    protected void setAcceptAllKnownXmlTypes(boolean acceptAllKnownXmlTypes) {
        this.contentTypeParser.setAcceptAllKnownXmlTypes(acceptAllKnownXmlTypes);
        this.dataRes.setAcceptAllKnownXmlTypes(acceptAllKnownXmlTypes);
        this.httpRes.setAcceptAllKnownXmlTypes(acceptAllKnownXmlTypes);
    }

    protected void setAllowGenericXml(boolean allowGenericXml) {
        this.contentTypeParser.setAllowGenericXml(allowGenericXml);
        this.httpRes.setAllowGenericXml(allowGenericXml);
        this.dataRes.setAllowGenericXml(allowGenericXml);
    }

    protected void setAllowHtml(boolean allowHtml) {
        this.contentTypeParser.setAllowHtml(allowHtml);
        this.httpRes.setAllowHtml(allowHtml);
        this.dataRes.setAllowHtml(allowHtml);
    }

    protected void setAllowRnc(boolean allowRnc) {
        this.contentTypeParser.setAllowRnc(allowRnc);
        this.httpRes.setAllowRnc(allowRnc);
        this.dataRes.setAllowRnc(allowRnc);
        this.entityResolver.setAllowRnc(allowRnc);
    }

    protected void setAllowXhtml(boolean allowXhtml) {
        this.contentTypeParser.setAllowXhtml(allowXhtml);
        this.httpRes.setAllowXhtml(allowXhtml);
        this.dataRes.setAllowXhtml(allowXhtml);
    }

    protected void loadDocumentInput() throws SAXException, IOException {
        if (this.methodIsGet) {
            this.documentInput = (TypedInputSource)this.entityResolver.resolveEntity(null, this.document);
            this.errorHandler.setLoggingOk(true);
        } else {
            long len = this.request.getContentLength();
            if (len > SIZE_LIMIT) {
                throw new StreamBoundException("Resource size exceeds limit.");
            }
            this.documentInput = this.contentTypeParser.buildTypedInputSource(this.document, null, this.postContentType);
            this.documentInput.setByteStream(len < 0L ? new BoundedInputStream(this.request.getInputStream(), SIZE_LIMIT, this.document) : this.request.getInputStream());
            this.documentInput.setSystemId(this.request.getHeader("Content-Location"));
        }
        if (this.imageCollector != null) {
            this.baseUriTracker = new BaseUriTracker(this.documentInput.getSystemId(), this.documentInput.getLanguage());
            this.imageCollector.initializeContext(this.baseUriTracker);
        }
    }

    void emitStyle() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("href", STYLE_SHEET);
        this.attrs.addAttribute("rel", "stylesheet");
        this.emitter.startElement("link", this.attrs);
        this.emitter.endElement("link");
    }

    void emitIcon() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("href", ICON);
        this.attrs.addAttribute("rel", "icon");
        this.emitter.startElement("link", this.attrs);
        this.emitter.endElement("link");
    }

    void emitScript() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("src", SCRIPT);
        this.emitter.startElement("script", this.attrs);
        this.emitter.endElement("script");
    }

    void emitAbout() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("href", ABOUT_PAGE);
        this.emitter.startElement("a", this.attrs);
        this.emitter.characters(ABOUT_THIS_SERVICE);
        this.emitter.endElement("a");
    }

    void emitVersion() throws SAXException {
        this.emitter.characters(VERSION);
    }

    void emitUserAgentInput() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("name", "useragent");
        this.attrs.addAttribute("list", "useragents");
        this.attrs.addAttribute("value", this.userAgent);
        this.emitter.startElement("input", this.attrs);
        this.emitter.endElement("input");
    }

    void emitOtherFacetLink() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("href", HTML5_FACET);
        this.emitter.startElement("a", this.attrs);
        this.emitter.characters(SIMPLE_UI);
        this.emitter.endElement("a");
    }

    void emitNsfilterField() throws SAXException {
        this.attrs.clear();
        this.attrs.addAttribute("name", "nsfilter");
        this.attrs.addAttribute("id", "nsfilter");
        this.attrs.addAttribute("pattern", "(?:.+:.+(?:\\s+.+:.+)*)?");
        this.attrs.addAttribute("title", "Space-separated namespace URIs for vocabularies to be filtered out.");
        if (!this.filteredNamespaces.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String ns : this.filteredNamespaces) {
                if (!first) {
                    sb.append(' ');
                }
                sb.append(ns);
                first = false;
            }
            this.attrs.addAttribute("value", VerifierServletTransaction.scrub(sb));
        }
        this.emitter.startElement("input", this.attrs);
        this.emitter.endElement("input");
    }

    void maybeEmitNsfilterField() throws SAXException {
        NsFilterEmitter.emit(this.contentHandler, this);
    }

    void emitCharsetOptions() throws SAXException {
        boolean found = false;
        for (int i = 0; i < CHARSETS.length; ++i) {
            String charset = CHARSETS[i];
            boolean selected = charset.equalsIgnoreCase(this.charsetOverride);
            this.emitter.option(CHARSET_DESCRIPTIONS[i], charset, selected);
            if (!selected) continue;
            found = true;
        }
        if (!found && this.charsetOverride != null) {
            this.emitter.option(this.charsetOverride, this.charsetOverride, true);
        }
    }

    void maybeEmitCharsetField() throws SAXException {
        CharsetEmitter.emit(this.contentHandler, this);
    }

    static {
        LIVING_VERSION = "Living Validator".toCharArray();
        FOR = " for ".toCharArray();
        ABOUT_THIS_SERVICE = "About this Service".toCharArray();
        SIMPLE_UI = "Simplified Interface".toCharArray();
        KNOWN_CONTENT_TYPES = new String[]{"application/atom+xml", "application/docbook+xml", "application/xhtml+xml", "application/xv+xml", "image/svg+xml"};
        NAMESPACES_FOR_KNOWN_CONTENT_TYPES = new String[]{"http://www.w3.org/2005/Atom", "http://docbook.org/ns/docbook", "http://www.w3.org/1999/xhtml", "http://www.w3.org/1999/xhtml", "http://www.w3.org/2000/svg"};
        ALL_CHECKERS = new String[]{"http://c.validator.nu/table/", "http://c.validator.nu/nfc/", "http://c.validator.nu/text-content/", "http://c.validator.nu/unchecked/", "http://c.validator.nu/usemap/", "http://c.validator.nu/obsolete/", "http://c.validator.nu/xml-pi/", "http://c.validator.nu/unsupported/", "http://c.validator.nu/microdata/"};
        ALL_CHECKERS_HTML4 = new String[]{"http://c.validator.nu/table/", "http://c.validator.nu/nfc/", "http://c.validator.nu/unchecked/", "http://c.validator.nu/usemap/"};
        ABOUT_PAGE = System.getProperty("nu.validator.servlet.about-page", "https://about.validator.nu/");
        HTML5_FACET = (VerifierServlet.HTML5_HOST.isEmpty() ? "" : "//" + VerifierServlet.HTML5_HOST) + VerifierServlet.HTML5_PATH;
        STYLE_SHEET = System.getProperty("nu.validator.servlet.style-sheet", "style.css");
        ICON = System.getProperty("nu.validator.servlet.icon", "icon.png");
        SCRIPT = System.getProperty("nu.validator.servlet.script", "script.js");
        LEGACY_HOSTS = System.getProperty("nu.validator.servlet.host.legacy", "").split("\\s+");
        SIZE_LIMIT = Integer.parseInt(System.getProperty("nu.validator.servlet.max-file-size", "2097152"));
        try {
            int i;
            int i2;
            String line;
            log4j.debug("Starting static initializer.");
            lastModified = 0L;
            BufferedReader r = new BufferedReader(new InputStreamReader(LocalCacheEntityResolver.getPresetsAsStream(), "UTF-8"));
            LinkedList<String> doctypes = new LinkedList<String>();
            LinkedList<String> namespaces = new LinkedList<String>();
            LinkedList<String> labels = new LinkedList<String>();
            LinkedList<String> urls = new LinkedList<String>();
            Properties props = new Properties();
            log4j.debug("Reading miscellaneous properties.");
            props.load(VerifierServlet.class.getClassLoader().getResourceAsStream("nu/validator/localentities/files/misc.properties"));
            SERVICE_TITLE = (System.getProperty("nu.validator.servlet.service-name", props.getProperty("nu.validator.servlet.service-name", "Validator.nu")) + " ").toCharArray();
            RESULTS_TITLE = System.getProperty("nu.validator.servlet.results-title", props.getProperty("nu.validator.servlet.results-title", "Validation results")).toCharArray();
            VERSION = System.getProperty("nu.validator.servlet.version", props.getProperty("nu.validator.servlet.version", "Living Validator")).toCharArray();
            USER_AGENT = System.getProperty("nu.validator.servlet.user-agent", props.getProperty("nu.validator.servlet.user-agent", "Validator.nu/LV"));
            log4j.debug("Starting to loop over config file lines.");
            while ((line = r.readLine()) != null && !"".equals(line.trim())) {
                String[] s = line.split("\t");
                doctypes.add(s[0]);
                namespaces.add(s[1]);
                labels.add(s[2]);
                urls.add(s[3]);
            }
            log4j.debug("Finished reading config.");
            String[] presetDoctypesAsStrings = doctypes.toArray(new String[0]);
            presetNamespaces = namespaces.toArray(new String[0]);
            presetLabels = labels.toArray(new String[0]);
            presetUrls = urls.toArray(new String[0]);
            log4j.debug("Converted config to arrays.");
            for (i2 = 0; i2 < presetNamespaces.length; ++i2) {
                String str = presetNamespaces[i2];
                VerifierServletTransaction.presetNamespaces[i2] = "-".equals(str) ? null : presetNamespaces[i2].intern();
            }
            log4j.debug("Prepared namespace array.");
            presetDoctypes = new int[presetDoctypesAsStrings.length];
            for (i2 = 0; i2 < presetDoctypesAsStrings.length; ++i2) {
                VerifierServletTransaction.presetDoctypes[i2] = Integer.parseInt(presetDoctypesAsStrings[i2]);
            }
            log4j.debug("Parsed doctype numbers into ints.");
            String prefix = System.getProperty("nu.validator.servlet.cachepathprefix");
            log4j.debug("The cache path prefix is: " + prefix);
            SystemErrErrorHandler eh = new SystemErrErrorHandler();
            LocalCacheEntityResolver er = new LocalCacheEntityResolver(new NullEntityResolver());
            er.setAllowRnc(true);
            PropertyMapBuilder pmb = new PropertyMapBuilder();
            pmb.put(ValidateProperty.ERROR_HANDLER, eh);
            pmb.put(ValidateProperty.ENTITY_RESOLVER, er);
            pmb.put(ValidateProperty.XML_READER_CREATOR, new VerifierServletXMLReaderCreator(eh, er));
            RngProperty.CHECK_ID_IDREF.add(pmb);
            PropertyMap pMap = pmb.toPropertyMap();
            log4j.debug("Parsing set up. Starting to read schemas.");
            TreeMap<String, Schema> schemaMap = new TreeMap<String, Schema>();
            schemaMap.put("http://c.validator.nu/table/", CheckerSchema.TABLE_CHECKER);
            schemaMap.put("http://hsivonen.iki.fi/checkers/table/", CheckerSchema.TABLE_CHECKER);
            schemaMap.put("http://c.validator.nu/nfc/", CheckerSchema.NORMALIZATION_CHECKER);
            schemaMap.put("http://hsivonen.iki.fi/checkers/nfc/", CheckerSchema.NORMALIZATION_CHECKER);
            schemaMap.put("http://c.validator.nu/debug/", CheckerSchema.DEBUG_CHECKER);
            schemaMap.put("http://hsivonen.iki.fi/checkers/debug/", CheckerSchema.DEBUG_CHECKER);
            schemaMap.put("http://c.validator.nu/text-content/", CheckerSchema.TEXT_CONTENT_CHECKER);
            schemaMap.put("http://hsivonen.iki.fi/checkers/text-content/", CheckerSchema.TEXT_CONTENT_CHECKER);
            schemaMap.put("http://c.validator.nu/usemap/", CheckerSchema.USEMAP_CHECKER);
            schemaMap.put("http://n.validator.nu/checkers/usemap/", CheckerSchema.USEMAP_CHECKER);
            schemaMap.put("http://c.validator.nu/unchecked/", CheckerSchema.UNCHECKED_SUBTREE_WARNER);
            schemaMap.put("http://s.validator.nu/html5/assertions.sch", CheckerSchema.ASSERTION_SCH);
            schemaMap.put("http://s.validator.nu/html4/assertions.sch", CheckerSchema.HTML4ASSERTION_SCH);
            schemaMap.put("http://c.validator.nu/obsolete/", CheckerSchema.CONFORMING_BUT_OBSOLETE_WARNER);
            schemaMap.put("http://c.validator.nu/xml-pi/", CheckerSchema.XML_PI_CHECKER);
            schemaMap.put("http://c.validator.nu/unsupported/", CheckerSchema.UNSUPPORTED_CHECKER);
            schemaMap.put("http://c.validator.nu/microdata/", CheckerSchema.MICRODATA_CHECKER);
            schemaMap.put("http://c.validator.nu/rdfalite/", CheckerSchema.RDFALITE_CHECKER);
            for (i = 0; i < presetUrls.length; ++i) {
                String[] urls1 = SPACE.split(presetUrls[i]);
                for (int j = 0; j < urls1.length; ++j) {
                    String url = urls1[j];
                    if (schemaMap.get(url) != null || VerifierServletTransaction.isCheckerUrl(url)) continue;
                    Schema sch = VerifierServletTransaction.schemaByUrl(url, er, pMap);
                    schemaMap.put(url, sch);
                }
            }
            log4j.debug("Schemas read.");
            preloadedSchemaUrls = new String[schemaMap.size()];
            preloadedSchemas = new Schema[schemaMap.size()];
            i = 0;
            for (Map.Entry entry : schemaMap.entrySet()) {
                VerifierServletTransaction.preloadedSchemaUrls[i] = ((String)entry.getKey()).intern();
                Schema s = (Schema)entry.getValue();
                String u = (String)entry.getKey();
                if (VerifierServletTransaction.isDataAttributeDroppingSchema(u)) {
                    s = new DataAttributeDroppingSchemaWrapper(s);
                }
                if (VerifierServletTransaction.isXmlLangAllowingSchema(u)) {
                    s = new XmlLangAttributeDroppingSchemaWrapper(s);
                }
                if (VerifierServletTransaction.isRoleAttributeFilteringSchema(u)) {
                    s = new RoleAttributeFilteringSchemaWrapper(s);
                }
                VerifierServletTransaction.preloadedSchemas[i] = s;
                ++i;
            }
            log4j.debug("Reading spec.");
            html5spec = Html5SpecBuilder.parseSpec(LocalCacheEntityResolver.getHtml5SpecAsStream());
            log4j.debug("Spec read.");
            log4j.debug("Initialization complete.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static enum OutputFormat {
        HTML,
        XHTML,
        TEXT,
        XML,
        JSON,
        RELAXED,
        SOAP,
        UNICORN,
        GNU;

    }
}

