/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.servlet;

import java.io.IOException;
import java.util.Deque;
import nu.validator.servlet.OutlineBuildingXMLReaderWrapper;
import nu.validator.xml.AttributesImpl;
import nu.validator.xml.XhtmlSaxEmitter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XhtmlOutlineEmitter {
    private static final char[] OUTLINE = "Outline".toCharArray();
    private final Deque<OutlineBuildingXMLReaderWrapper.Section> outline;
    private final XhtmlSaxEmitter emitter;
    private final AttributesImpl attrs = new AttributesImpl();

    public XhtmlOutlineEmitter(ContentHandler contentHandler, Deque<OutlineBuildingXMLReaderWrapper.Section> outline) {
        this.emitter = new XhtmlSaxEmitter(contentHandler);
        this.outline = outline;
    }

    public void emit() throws SAXException {
        if (this.outline != null) {
            this.attrs.clear();
            this.attrs.addAttribute("id", "outline");
            this.emitter.startElement("section", this.attrs);
            this.emitter.startElement("h2");
            this.emitter.characters(OUTLINE);
            this.emitter.endElement("h2");
            try {
                this.emitOutline(this.outline, 0);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.emitter.endElement("section");
        }
    }

    protected void emitOutline(Deque<OutlineBuildingXMLReaderWrapper.Section> outline, int currentDepth) throws IOException, SAXException {
        this.emitter.startElement("ol");
        for (OutlineBuildingXMLReaderWrapper.Section section : outline) {
            this.emitter.startElement("li");
            StringBuilder headingText = section.getHeadingTextBuilder();
            if (headingText.length() > 0) {
                this.emitter.startElementWithClass("span", "heading");
                this.emitter.characters(headingText.toString().toCharArray());
                this.emitter.endElement("span");
            } else if (section.hasEmptyHeading()) {
                this.emitter.characters(("[" + section.getElementName() + " element with empty heading]").toCharArray());
            } else if ("h1".equals(section.getElementName()) || "h2".equals(section.getElementName()) || "h3".equals(section.getElementName()) || "h4".equals(section.getElementName()) || "h5".equals(section.getElementName()) || "h6".equals(section.getElementName())) {
                this.emitter.characters(("[section implied by empty " + section.getElementName() + " element]").toCharArray());
            } else {
                this.emitter.characters(("[" + section.getElementName() + " element with no heading]").toCharArray());
            }
            Deque<OutlineBuildingXMLReaderWrapper.Section> sections = section.sections;
            if (!sections.isEmpty()) {
                this.emitOutline(sections, currentDepth + 1);
            }
            this.emitter.endElement("li");
        }
        this.emitter.endElement("ol");
    }
}

